/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.internal.parser.AttributeToken;
import org.apache.tapestry5.internal.parser.ExpansionToken;
import org.apache.tapestry5.internal.services.AttributeExpansionBinding;
import org.apache.tapestry5.internal.services.PageElementFactory;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.services.StringProvider;
import org.apache.tapestry5.internal.structure.ExpansionPageElement;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.BindingSource;

public class PageElementFactoryImpl
implements PageElementFactory {
    private final TypeCoercer typeCoercer;
    private final BindingSource bindingSource;

    public PageElementFactoryImpl(TypeCoercer typeCoercer, BindingSource bindingSource) {
        this.typeCoercer = typeCoercer;
        this.bindingSource = bindingSource;
    }

    public RenderCommand newAttributeElement(ComponentResources componentResources, final AttributeToken token) {
        final StringProvider provider = this.parseAttributeExpansionExpression(token.value, componentResources, token.getLocation());
        return new RenderCommand(){

            public void render(MarkupWriter writer, RenderQueue queue) {
                writer.attributeNS(token.namespaceURI, token.name, provider.provideString());
            }

            public String toString() {
                return String.format("AttributeNS[%s %s \"%s\"]", token.namespaceURI, token.name, token.value);
            }
        };
    }

    private StringProvider parseAttributeExpansionExpression(String expression, ComponentResources resources, final Location location) {
        final List providers = CollectionFactory.newList();
        int startx = 0;
        while (true) {
            int endx;
            int expansionx;
            if ((expansionx = expression.indexOf("${", startx)) < 0) {
                if (startx >= expression.length()) break;
                providers.add(new LiteralStringProvider(expression.substring(startx)));
                break;
            }
            if (startx != expansionx) {
                providers.add(new LiteralStringProvider(expression.substring(startx, expansionx)));
            }
            if ((endx = expression.indexOf("}", expansionx)) < 0) {
                throw new TapestryException(ServicesMessages.unclosedAttributeExpression(expression), location, null);
            }
            String expansion = expression.substring(expansionx + 2, endx);
            final Binding binding = this.bindingSource.newBinding("attribute expansion", resources, resources, "prop", expansion, location);
            StringProvider provider = new StringProvider(){

                public String provideString() {
                    try {
                        Object raw = binding.get();
                        return (String)PageElementFactoryImpl.this.typeCoercer.coerce(raw, String.class);
                    }
                    catch (Exception ex) {
                        throw new TapestryException(ex.getMessage(), location, (Throwable)ex);
                    }
                }
            };
            providers.add(provider);
            startx = endx + 1;
        }
        if (providers.size() == 1) {
            return (StringProvider)providers.get(0);
        }
        return new StringProvider(){

            public String provideString() {
                StringBuilder builder = new StringBuilder();
                for (StringProvider provider : providers) {
                    builder.append(provider.provideString());
                }
                return builder.toString();
            }
        };
    }

    public RenderCommand newExpansionElement(ComponentResources componentResources, ExpansionToken token) {
        Binding binding = this.bindingSource.newBinding("expansion", componentResources, componentResources, "prop", token.getExpression(), token.getLocation());
        return new ExpansionPageElement(binding, this.typeCoercer);
    }

    public Binding newBinding(String parameterName, ComponentResources loadingComponentResources, ComponentResources embeddedComponentResources, String defaultBindingPrefix, String expression, Location location) {
        if (expression.contains("${")) {
            StringProvider provider = this.parseAttributeExpansionExpression(expression, loadingComponentResources, location);
            return new AttributeExpansionBinding(location, provider);
        }
        return this.bindingSource.newBinding(parameterName, loadingComponentResources, embeddedComponentResources, defaultBindingPrefix, expression, location);
    }

    private static class LiteralStringProvider
    implements StringProvider {
        private final String string;

        LiteralStringProvider(String string) {
            this.string = string;
        }

        public String provideString() {
            return this.string;
        }
    }
}

