/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.internal.services.PageRenderQueue;
import org.apache.tapestry5.internal.services.RenderQueueImpl;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.annotations.Scope;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.util.Stack;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;
import org.slf4j.Logger;

@Scope(value="perthread")
public class PageRenderQueueImpl
implements PageRenderQueue {
    private final LoggerSource loggerSource;
    private Page page;
    private boolean partialRenderInitialized;
    private final Stack<PartialMarkupRendererFilter> filters = CollectionFactory.newStack();
    private RenderQueueImpl queue;

    public PageRenderQueueImpl(LoggerSource loggerSource) {
        this.loggerSource = loggerSource;
    }

    public void initializeForCompletePage(Page page) {
        this.setRenderingPage(page);
        this.queue.push(page.getRootElement());
    }

    public void setRenderingPage(Page page) {
        assert (page != null);
        this.page = page;
        String name = "tapestry.render." + page.getLogger().getName();
        Logger logger = this.loggerSource.getLogger(name);
        this.queue = new RenderQueueImpl(logger);
    }

    public boolean isPartialRenderInitialized() {
        return this.partialRenderInitialized;
    }

    private void partialRenderInitialized() {
        if (this.page == null) {
            throw new IllegalStateException("Page must be specified before initializing for partial page render.");
        }
        this.partialRenderInitialized = true;
    }

    public void addPartialRenderer(RenderCommand renderer) {
        assert (renderer != null);
        this.partialRenderInitialized();
        this.queue.push(renderer);
    }

    public Page getRenderingPage() {
        return this.page;
    }

    public void render(MarkupWriter writer) {
        this.queue.run(writer);
    }

    public void addPartialMarkupRendererFilter(PartialMarkupRendererFilter filter) {
        assert (filter != null);
        this.partialRenderInitialized();
        this.filters.push((Object)filter);
    }

    public void renderPartial(MarkupWriter writer, JSONObject reply) {
        PartialMarkupRenderer terminator;
        PartialMarkupRenderer delegate = terminator = new PartialMarkupRenderer(){

            public void renderMarkup(MarkupWriter writer, JSONObject reply) {
                PageRenderQueueImpl.this.render(writer);
            }
        };
        while (!this.filters.isEmpty()) {
            PartialMarkupRendererFilter filter = (PartialMarkupRendererFilter)this.filters.pop();
            Bridge bridge = new Bridge(filter, delegate);
            delegate = bridge;
        }
        delegate.renderMarkup(writer, reply);
    }

    private static class Bridge
    implements PartialMarkupRenderer {
        private final PartialMarkupRendererFilter filter;
        private final PartialMarkupRenderer delegate;

        private Bridge(PartialMarkupRendererFilter filter, PartialMarkupRenderer delegate) {
            this.filter = filter;
            this.delegate = delegate;
        }

        public void renderMarkup(MarkupWriter writer, JSONObject reply) {
            this.filter.renderMarkup(writer, reply, this.delegate);
        }
    }
}

