/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Map;
import org.apache.tapestry5.internal.services.DocumentLinker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.InitializationPriority;
import org.apache.tapestry5.services.javascript.StylesheetLink;

public class PartialMarkupDocumentLinker
implements DocumentLinker {
    private final JSONArray scripts = new JSONArray();
    private final JSONArray stylesheets = new JSONArray();
    private final Map<InitializationPriority, JSONObject> priorityToInits = CollectionFactory.newMap();

    public void addScriptLink(String scriptURL) {
        this.scripts.put((Object)scriptURL);
    }

    public void addStylesheetLink(StylesheetLink stylesheet) {
        JSONObject object = new JSONObject(new String[]{"href", stylesheet.getURL(), "media", stylesheet.getOptions().media});
        this.stylesheets.put((Object)object);
    }

    public void addScript(InitializationPriority priority, String script) {
        throw new UnsupportedOperationException("DocumentLinker.addScript() is not implemented for partial page renders.");
    }

    public void setInitialization(InitializationPriority priority, JSONObject initialization) {
        this.priorityToInits.put(priority, initialization);
    }

    public void commit(JSONObject reply) {
        if (this.scripts.length() > 0) {
            reply.put("scripts", (Object)this.scripts);
        }
        if (this.stylesheets.length() > 0) {
            reply.put("stylesheets", (Object)this.stylesheets);
        }
        JSONArray inits = new JSONArray();
        for (InitializationPriority p : InitializationPriority.values()) {
            JSONObject init = this.priorityToInits.get((Object)p);
            if (init == null) continue;
            inits.put((Object)init);
        }
        if (inits.length() > 0) {
            reply.put("inits", (Object)inits);
        }
    }
}

