/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Asset;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.FieldFocusPriority;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.services.javascript.StylesheetLink;
import org.apache.tapestry5.services.javascript.StylesheetOptions;

public class RenderSupportImpl
implements RenderSupport {
    private final SymbolSource symbolSource;
    private final AssetSource assetSource;
    private final JavaScriptSupport javascriptSupport;

    public RenderSupportImpl(SymbolSource symbolSource, AssetSource assetSource, JavaScriptSupport javascriptSupport) {
        this.symbolSource = symbolSource;
        this.assetSource = assetSource;
        this.javascriptSupport = javascriptSupport;
    }

    public String allocateClientId(String id) {
        return this.javascriptSupport.allocateClientId(id);
    }

    public String allocateClientId(ComponentResources resources) {
        return this.javascriptSupport.allocateClientId(resources);
    }

    public void addScriptLink(Asset ... scriptAssets) {
        for (Asset asset : scriptAssets) {
            assert (asset != null);
            this.javascriptSupport.importJavaScriptLibrary(asset);
        }
    }

    public void addScriptLink(String ... scriptURLs) {
        for (String url : scriptURLs) {
            this.javascriptSupport.importJavaScriptLibrary(url);
        }
    }

    public void addClasspathScriptLink(String ... classpaths) {
        for (String path : classpaths) {
            this.addScriptLinkFromClasspath(path);
        }
    }

    private void addScriptLinkFromClasspath(String path) {
        String expanded = this.symbolSource.expandSymbols(path);
        Asset asset = this.assetSource.getAsset(null, expanded, null);
        this.addScriptLink(asset);
    }

    public void addScript(String script) {
        this.javascriptSupport.addScript(script, new Object[0]);
    }

    public void addScript(String format, Object ... arguments) {
        this.javascriptSupport.addScript(format, arguments);
    }

    public void addInit(String functionName, JSONArray parameterList) {
        this.javascriptSupport.addInitializerCall(functionName, parameterList);
    }

    public void addInit(String functionName, JSONObject parameter) {
        this.javascriptSupport.addInitializerCall(functionName, parameter);
    }

    public void addInit(String functionName, String ... parameters) {
        JSONArray array = new JSONArray();
        for (String parameter : parameters) {
            array.put((Object)parameter);
        }
        this.addInit(functionName, array);
    }

    public void autofocus(FieldFocusPriority priority, String fieldId) {
        this.javascriptSupport.autofocus(priority, fieldId);
    }

    public void addStylesheetLink(Asset stylesheet, String media) {
        this.javascriptSupport.importStylesheet(new StylesheetLink(stylesheet, new StylesheetOptions(media)));
    }

    public void addStylesheetLink(String stylesheetURL, String media) {
        this.javascriptSupport.importStylesheet(new StylesheetLink(stylesheetURL, new StylesheetOptions(media)));
    }
}

