/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.internal.services.TapestrySessionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestImpl
implements Request {
    static final String REQUESTED_WITH_HEADER = "X-Requested-With";
    static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    private final HttpServletRequest request;
    private final String requestEncoding;
    private final TapestrySessionFactory sessionFactory;
    private boolean encodingSet;
    Session session;

    public RequestImpl(HttpServletRequest request, String requestEncoding, TapestrySessionFactory sessionFactory) {
        this.request = request;
        this.requestEncoding = requestEncoding;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public List<String> getParameterNames() {
        this.setupEncoding();
        return InternalUtils.toList((Enumeration)this.request.getParameterNames());
    }

    @Override
    public List<String> getHeaderNames() {
        return InternalUtils.toList((Enumeration)this.request.getHeaderNames());
    }

    @Override
    public String getParameter(String name) {
        this.setupEncoding();
        return this.request.getParameter(name);
    }

    @Override
    public String[] getParameters(String name) {
        this.setupEncoding();
        return this.request.getParameterValues(name);
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public String getPath() {
        String pathInfo = this.request.getPathInfo();
        if (pathInfo == null) {
            return this.request.getServletPath();
        }
        return pathInfo.length() == 0 ? "/" : pathInfo;
    }

    @Override
    public String getContextPath() {
        return this.request.getContextPath();
    }

    @Override
    public Session getSession(boolean create) {
        if (this.session != null && this.session.isInvalidated()) {
            this.session = null;
        }
        if (this.session == null) {
            this.session = this.sessionFactory.getSession(create);
        }
        return this.session;
    }

    @Override
    public Locale getLocale() {
        return this.request.getLocale();
    }

    @Override
    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    private void setupEncoding() {
        if (this.encodingSet) {
            return;
        }
        try {
            this.request.setCharacterEncoding(this.requestEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        this.encodingSet = true;
    }

    @Override
    public boolean isXHR() {
        return XML_HTTP_REQUEST.equals(this.request.getHeader(REQUESTED_WITH_HEADER));
    }

    @Override
    public boolean isSecure() {
        return this.request.isSecure();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    @Override
    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.request.setAttribute(name, value);
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    @Override
    public int getServerPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }
}

