/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.internal.services.LinkSecurity;
import org.apache.tapestry5.internal.services.RequestSecurityManager;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ComponentEventLinkEncoder;
import org.apache.tapestry5.services.ComponentEventRequestParameters;
import org.apache.tapestry5.services.MetaDataLocator;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;

public class RequestSecurityManagerImpl
implements RequestSecurityManager {
    private final Request request;
    private final Response response;
    private final MetaDataLocator locator;
    private final boolean securityEnabled;
    private final ComponentEventLinkEncoder componentEventLinkEncoder;

    public RequestSecurityManagerImpl(Request request, Response response, ComponentEventLinkEncoder componentEventLinkEncoder, MetaDataLocator locator, @Symbol(value="tapestry.secure-enabled") boolean securityEnabled) {
        this.request = request;
        this.response = response;
        this.componentEventLinkEncoder = componentEventLinkEncoder;
        this.locator = locator;
        this.securityEnabled = securityEnabled;
    }

    public boolean checkForInsecureComponentEventRequest(ComponentEventRequestParameters parameters) throws IOException {
        if (!this.needsRedirect(parameters.getActivePageName())) {
            return false;
        }
        Link link = this.componentEventLinkEncoder.createComponentEventLink(parameters, false);
        this.response.sendRedirect(link);
        return true;
    }

    public boolean checkForInsecurePageRenderRequest(PageRenderRequestParameters parameters) throws IOException {
        if (!this.needsRedirect(parameters.getLogicalPageName())) {
            return false;
        }
        Link link = this.componentEventLinkEncoder.createPageRenderLink(parameters);
        this.response.sendRedirect(link);
        return true;
    }

    private boolean needsRedirect(String pageName) {
        if (!this.securityEnabled) {
            return false;
        }
        if (this.request.isSecure()) {
            return false;
        }
        return this.isSecure(pageName);
    }

    private boolean isSecure(String pageName) {
        return this.locator.findMeta("tapestry.secure-page", pageName, Boolean.class);
    }

    public LinkSecurity checkPageSecurity(String pageName) {
        if (!this.securityEnabled) {
            return this.request.isSecure() ? LinkSecurity.SECURE : LinkSecurity.INSECURE;
        }
        boolean securePage = this.isSecure(pageName);
        if (this.request.isSecure() == securePage) {
            return securePage ? LinkSecurity.SECURE : LinkSecurity.INSECURE;
        }
        return securePage ? LinkSecurity.FORCE_SECURE : LinkSecurity.FORCE_INSECURE;
    }
}

