/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.codec.binary.Hex;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.ResourceDigestGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDigestGeneratorImpl
implements ResourceDigestGenerator {
    private static final int BUFFER_SIZE = 5000;
    private final Set<String> digestExtensions;

    public ResourceDigestGeneratorImpl(Collection<String> configuration) {
        this.digestExtensions = CollectionFactory.newSet(configuration);
    }

    @Override
    public String generateDigest(URL url) {
        String string;
        BufferedInputStream stream = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            stream = new BufferedInputStream(url.openStream());
            this.digestStream(digest, stream);
            ((InputStream)stream).close();
            stream = null;
            byte[] bytes = digest.digest();
            char[] encoded = Hex.encodeHex((byte[])bytes);
            string = new String(encoded);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                InternalUtils.close(stream);
                throw throwable;
            }
        }
        InternalUtils.close((Closeable)stream);
        return string;
    }

    private void digestStream(MessageDigest digest, InputStream stream) throws IOException {
        byte[] buffer = new byte[5000];
        int length;
        while ((length = stream.read(buffer)) >= 0) {
            digest.update(buffer, 0, length);
        }
        return;
    }

    @Override
    public boolean requiresDigest(String path) {
        int dotx = path.lastIndexOf(46);
        String extension = path.substring(dotx + 1).toLowerCase();
        return this.digestExtensions.contains(extension);
    }
}

