/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.Response;

public class ResponseImpl
implements Response {
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public ResponseImpl(HttpServletRequest request, HttpServletResponse response) {
        assert (request != null);
        assert (response != null);
        this.request = request;
        this.response = response;
    }

    public PrintWriter getPrintWriter(String contentType) throws IOException {
        assert (InternalUtils.isNonBlank((String)contentType));
        OutputStream os = this.getOutputStream(contentType);
        OutputStreamWriter w = new OutputStreamWriter(os, this.response.getCharacterEncoding());
        return new PrintWriter(new BufferedWriter(w));
    }

    public String encodeURL(String URL2) {
        return this.response.encodeURL(URL2);
    }

    public String encodeRedirectURL(String URL2) {
        return this.response.encodeRedirectURL(URL2);
    }

    public void sendRedirect(String URL2) throws IOException {
        this.response.sendRedirect(URL2);
    }

    public void sendRedirect(Link link) throws IOException {
        assert (link != null);
        String redirectURL = this.encodeRedirectURL(link.toRedirectURI());
        this.sendRedirect(redirectURL);
    }

    public void setStatus(int sc) {
        this.response.setStatus(sc);
    }

    public OutputStream getOutputStream(String contentType) throws IOException {
        assert (InternalUtils.isNonBlank((String)contentType));
        this.response.setContentType(contentType);
        return this.response.getOutputStream();
    }

    public void sendError(int sc, String message) throws IOException {
        this.response.sendError(sc, message);
    }

    public void setContentLength(int length) {
        this.response.setContentLength(length);
    }

    public void setDateHeader(String name, long date) {
        this.response.setDateHeader(name, date);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.response.setIntHeader(name, value);
    }

    public boolean isCommitted() {
        return this.response.isCommitted();
    }

    public void disableCompression() {
        this.request.setAttribute("tapestry.supress-compression", (Object)true);
    }
}

