/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.IOException;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.internal.EmptyEventContext;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentRequestHandler;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.PageRenderRequestParameters;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;

public class RootPathDispatcher
implements Dispatcher {
    private static final EventContext EMPTY_CONTEXT = new EmptyEventContext();
    private final ComponentClassResolver componentClassResolver;
    private final ComponentRequestHandler handler;
    private final String startPageName;
    private final PageRenderRequestParameters parameters;
    private final LocalizationSetter localizationSetter;

    public RootPathDispatcher(ComponentClassResolver componentClassResolver, ComponentRequestHandler handler, @Symbol(value="tapestry.start-page-name") String startPageName, LocalizationSetter localizationSetter) {
        this.componentClassResolver = componentClassResolver;
        this.handler = handler;
        this.startPageName = startPageName;
        this.localizationSetter = localizationSetter;
        this.parameters = new PageRenderRequestParameters(this.startPageName, EMPTY_CONTEXT, false);
    }

    public boolean dispatch(Request request, Response response) throws IOException {
        if (request.getPath().equals("/") && this.componentClassResolver.isPageName(this.startPageName)) {
            this.localizationSetter.setNonPeristentLocaleFromLocaleName(request.getLocale().toString());
            this.handler.handlePageRender(this.parameters);
            return true;
        }
        return false;
    }
}

