/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements Session {
    private final HttpServletRequest request;
    private final HttpSession session;
    private boolean invalidated = false;

    public SessionImpl(HttpServletRequest request, HttpSession session) {
        this.request = request;
        this.session = session;
    }

    @Override
    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    @Override
    public List<String> getAttributeNames() {
        return InternalUtils.toList((Enumeration)this.session.getAttributeNames());
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    @Override
    public List<String> getAttributeNames(String prefix) {
        List result = CollectionFactory.newList();
        Enumeration e = this.session.getAttributeNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(prefix)) continue;
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    @Override
    public void invalidate() {
        this.invalidated = true;
        this.session.invalidate();
    }

    @Override
    public boolean isInvalidated() {
        if (this.invalidated) {
            return true;
        }
        this.invalidated = this.request.getSession(false) != this.session;
        return this.invalidated;
    }

    @Override
    public void setMaxInactiveInterval(int seconds) {
        this.session.setMaxInactiveInterval(seconds);
    }

    @Override
    public void restoreDirtyObjects() {
    }
}

