/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.services.StackTraceElementAnalyzer;

public class TapestryAOPStackFrameAnalyzer
implements StackTraceElementAnalyzer {
    private static final String[] SYNTHETIC_METHOD_PREFIXES = new String[]{"_$get_", "_$set_", "_$readaccess_", "_$writeaccess_"};

    public String classForFrame(StackTraceElement frame) {
        if (this.omit(frame)) {
            return "t-omitted-frame";
        }
        return null;
    }

    private boolean omit(StackTraceElement frame) {
        if (frame.getClassName().startsWith("$FieldAccess_")) {
            return true;
        }
        if (frame.getMethodName().equals("invoke") && frame.getClassName().contains("$MethodAccess_")) {
            return true;
        }
        if (frame.getMethodName().equals("invokeAdvisedMethod") && frame.getClassName().contains("$invocation_")) {
            return true;
        }
        for (String prefix : SYNTHETIC_METHOD_PREFIXES) {
            if (!frame.getMethodName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

