/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.net.URL;
import java.util.Map;
import org.apache.tapestry5.internal.parser.ComponentTemplate;
import org.apache.tapestry5.internal.services.SaxTemplateParser;
import org.apache.tapestry5.internal.services.ServicesMessages;
import org.apache.tapestry5.internal.services.TemplateParser;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParserImpl
implements TemplateParser {
    private final Map<String, URL> configuration;
    private final boolean defaultCompressWhitespace;
    private final OperationTracker tracker;

    public TemplateParserImpl(Map<String, URL> configuration, @Symbol(value="tapestry.compress-whitespace") boolean defaultCompressWhitespace, OperationTracker tracker) {
        this.configuration = configuration;
        this.defaultCompressWhitespace = defaultCompressWhitespace;
        this.tracker = tracker;
    }

    @Override
    public ComponentTemplate parseTemplate(final Resource templateResource) {
        if (!templateResource.exists()) {
            throw new RuntimeException(ServicesMessages.missingTemplateResource(templateResource));
        }
        return (ComponentTemplate)this.tracker.invoke("Parsing component template " + templateResource, (Invokable)new Invokable<ComponentTemplate>(){

            public ComponentTemplate invoke() {
                return new SaxTemplateParser(templateResource, TemplateParserImpl.this.configuration).parse(TemplateParserImpl.this.defaultCompressWhitespace);
            }
        });
    }

    @Override
    public Map<String, URL> getDTDURLMappings() {
        return this.configuration;
    }
}

