/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.BaseURLSource;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.assets.AssetPathConstructor;

public class AssetPathConstructorImpl
implements AssetPathConstructor {
    private final Request request;
    private final String prefix;
    private final BaseURLSource baseURLSource;
    private final boolean fullyQualified;

    public AssetPathConstructorImpl(Request request, BaseURLSource baseURLSource, @Symbol(value="tapestry.application-version") String applicationVersion, @Symbol(value="tapestry.application-folder") String applicationFolder, @Symbol(value="tapestry.asset-url-fully-qualified") boolean fullyQualified, @Symbol(value="tapestry.asset-path-prefix") String assetPathPrefix) {
        this.request = request;
        this.baseURLSource = baseURLSource;
        this.fullyQualified = fullyQualified;
        String folder = applicationFolder.equals("") ? "" : "/" + applicationFolder;
        this.prefix = folder + assetPathPrefix + applicationVersion + "/";
    }

    public String constructAssetPath(String virtualFolder, String path) {
        StringBuilder builder = new StringBuilder();
        if (this.fullyQualified) {
            builder.append(this.baseURLSource.getBaseURL(this.request.isSecure()));
        }
        builder.append(this.request.getContextPath());
        builder.append(this.prefix);
        builder.append(virtualFolder);
        builder.append('/');
        builder.append(path);
        return builder.toString();
    }
}

