/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.services.assets.StreamableResourceImpl;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

public class SRSCompressingInterceptor
implements StreamableResourceSource {
    private final int compressionCutoff;
    private final StreamableResourceSource delegate;

    public SRSCompressingInterceptor(int compressionCutoff, StreamableResourceSource delegate) {
        this.compressionCutoff = compressionCutoff;
        this.delegate = delegate;
    }

    public StreamableResource getStreamableResource(Resource baseResource, StreamableResourceProcessing processing, ResourceDependencies dependencies) throws IOException {
        StreamableResource streamable = this.delegate.getStreamableResource(baseResource, processing, dependencies);
        return processing == StreamableResourceProcessing.COMPRESSION_ENABLED ? this.compress(streamable) : streamable;
    }

    private StreamableResource compress(StreamableResource uncompressed) throws IOException {
        if (uncompressed.getCompression() != CompressionStatus.COMPRESSABLE) {
            return uncompressed;
        }
        int size = uncompressed.getSize();
        if (size < this.compressionCutoff) {
            return uncompressed;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
        GZIPOutputStream gos = new GZIPOutputStream(bos);
        BufferedOutputStream buffered = new BufferedOutputStream(gos);
        uncompressed.streamTo(buffered);
        buffered.close();
        BytestreamCache cache = new BytestreamCache(bos);
        return new StreamableResourceImpl(uncompressed.getDescription(), uncompressed.getContentType(), CompressionStatus.COMPRESSED, uncompressed.getLastModified(), cache);
    }
}

