/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.internal.IOOperation;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.services.assets.StreamableResourceImpl;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.services.InvalidationListener;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.services.assets.AssetRequestHandler;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ResourceMinimizer;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackAssetRequestHandler
implements AssetRequestHandler,
InvalidationListener {
    private static final String JAVASCRIPT_CONTENT_TYPE = "text/javascript";
    private final StreamableResourceSource streamableResourceSource;
    private final JavaScriptStackSource javascriptStackSource;
    private final LocalizationSetter localizationSetter;
    private final ResponseCompressionAnalyzer compressionAnalyzer;
    private final ResourceStreamer resourceStreamer;
    private final Pattern pathPattern = Pattern.compile("^(.+)/(.+)\\.js$");
    private final Map<String, StreamableResource> uncompressedCache = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, StreamableResource> compressedCache = CollectionFactory.newCaseInsensitiveMap();
    private final ResourceMinimizer resourceMinimizer;
    private final OperationTracker tracker;
    private final boolean minificationEnabled;
    private final ResourceChangeTracker resourceChangeTracker;

    public StackAssetRequestHandler(StreamableResourceSource streamableResourceSource, JavaScriptStackSource javascriptStackSource, LocalizationSetter localizationSetter, ResponseCompressionAnalyzer compressionAnalyzer, ResourceStreamer resourceStreamer, ResourceMinimizer resourceMinimizer, OperationTracker tracker, @Symbol(value="tapestry.enable-minification") boolean minificationEnabled, ResourceChangeTracker resourceChangeTracker) {
        this.streamableResourceSource = streamableResourceSource;
        this.javascriptStackSource = javascriptStackSource;
        this.localizationSetter = localizationSetter;
        this.compressionAnalyzer = compressionAnalyzer;
        this.resourceStreamer = resourceStreamer;
        this.resourceMinimizer = resourceMinimizer;
        this.tracker = tracker;
        this.minificationEnabled = minificationEnabled;
        this.resourceChangeTracker = resourceChangeTracker;
    }

    @PostInjection
    public void listenToInvalidations(ResourceChangeTracker resourceChangeTracker) {
        resourceChangeTracker.addInvalidationListener(this);
    }

    @Override
    public boolean handleAssetRequest(Request request, Response response, final String extraPath) throws IOException {
        TapestryInternalUtils.performIO(this.tracker, String.format("Streaming asset stack %s", extraPath), new IOOperation(){

            public void perform() throws IOException {
                boolean compress = StackAssetRequestHandler.this.compressionAnalyzer.isGZipSupported();
                StreamableResource resource = StackAssetRequestHandler.this.getResource(extraPath, compress);
                StackAssetRequestHandler.this.resourceStreamer.streamResource(resource);
            }
        });
        return true;
    }

    @Override
    public synchronized void objectWasInvalidated() {
        this.uncompressedCache.clear();
        this.compressedCache.clear();
    }

    private StreamableResource getResource(String extraPath, boolean compressed) throws IOException {
        return compressed ? this.getCompressedResource(extraPath) : this.getUncompressedResource(extraPath);
    }

    private synchronized StreamableResource getCompressedResource(String extraPath) throws IOException {
        StreamableResource result = this.compressedCache.get(extraPath);
        if (result == null) {
            StreamableResource uncompressed = this.getUncompressedResource(extraPath);
            result = this.compressStream(uncompressed);
            this.compressedCache.put(extraPath, result);
        }
        return result;
    }

    private synchronized StreamableResource getUncompressedResource(String extraPath) throws IOException {
        StreamableResource result = this.uncompressedCache.get(extraPath);
        if (result == null) {
            result = this.assembleStackContent(extraPath);
            this.uncompressedCache.put(extraPath, result);
        }
        return result;
    }

    private StreamableResource assembleStackContent(String extraPath) throws IOException {
        Matcher matcher = this.pathPattern.matcher(extraPath);
        if (!matcher.matches()) {
            throw new RuntimeException("Invalid path for a stack asset request.");
        }
        String localeName = matcher.group(1);
        String stackName = matcher.group(2);
        return this.assembleStackContent(localeName, stackName);
    }

    private StreamableResource assembleStackContent(String localeName, String stackName) throws IOException {
        this.localizationSetter.setNonPeristentLocaleFromLocaleName(localeName);
        JavaScriptStack stack = this.javascriptStackSource.getStack(stackName);
        List<Asset> libraries = stack.getJavaScriptLibraries();
        StreamableResource stackContent = this.assembleStackContent(localeName, stackName, libraries);
        return this.minificationEnabled ? this.resourceMinimizer.minimize(stackContent) : stackContent;
    }

    private StreamableResource assembleStackContent(String localeName, String stackName, List<Asset> libraries) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)stream, "UTF-8");
        PrintWriter writer = new PrintWriter((Writer)osw, true);
        long lastModified = 0L;
        StringBuilder description = new StringBuilder(String.format("'%s' JavaScript stack, for locale %s, resources=", stackName, localeName));
        String sep = "";
        JSONArray paths = new JSONArray();
        for (Asset library : libraries) {
            String path = library.toClientURL();
            paths.put((Object)path);
            writer.format("\n/* %s */;\n", path);
            Resource resource = library.getResource();
            description.append(sep).append(resource.toString());
            sep = ", ";
            StreamableResource streamable = this.streamableResourceSource.getStreamableResource(resource, StreamableResourceProcessing.FOR_AGGREGATION, this.resourceChangeTracker);
            streamable.streamTo(stream);
            lastModified = Math.max(lastModified, streamable.getLastModified());
        }
        writer.close();
        return new StreamableResourceImpl(description.toString(), JAVASCRIPT_CONTENT_TYPE, CompressionStatus.COMPRESSABLE, lastModified, new BytestreamCache(stream));
    }

    private StreamableResource compressStream(StreamableResource uncompressed) throws IOException {
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        BufferedOutputStream compressor = new BufferedOutputStream(new GZIPOutputStream(compressed));
        uncompressed.streamTo(compressor);
        ((OutputStream)compressor).close();
        BytestreamCache cache = new BytestreamCache(compressed);
        return new StreamableResourceImpl(uncompressed.getDescription(), JAVASCRIPT_CONTENT_TYPE, CompressionStatus.COMPRESSED, uncompressed.getLastModified(), cache);
    }
}

