/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.assets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.services.assets.StreamableResourceImpl;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.services.assets.CompressionAnalyzer;
import org.apache.tapestry5.services.assets.CompressionStatus;
import org.apache.tapestry5.services.assets.ContentTypeAnalyzer;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.ResourceTransformer;
import org.apache.tapestry5.services.assets.StreamableResource;
import org.apache.tapestry5.services.assets.StreamableResourceProcessing;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamableResourceSourceImpl
implements StreamableResourceSource {
    private final Map<String, ResourceTransformer> configuration;
    private final ContentTypeAnalyzer contentTypeAnalyzer;
    private final CompressionAnalyzer compressionAnalyzer;
    private final ResourceChangeTracker resourceChangeTracker;

    public StreamableResourceSourceImpl(Map<String, ResourceTransformer> configuration, ContentTypeAnalyzer contentTypeAnalyzer, CompressionAnalyzer compressionAnalyzer, ResourceChangeTracker resourceChangeTracker) {
        this.configuration = configuration;
        this.contentTypeAnalyzer = contentTypeAnalyzer;
        this.compressionAnalyzer = compressionAnalyzer;
        this.resourceChangeTracker = resourceChangeTracker;
    }

    @Override
    public StreamableResource getStreamableResource(Resource baseResource, StreamableResourceProcessing processing, ResourceDependencies dependencies) throws IOException {
        InputStream transformed;
        assert (baseResource != null);
        if (!baseResource.exists()) {
            throw new IOException(String.format("Resource %s does not exist.", baseResource));
        }
        String fileSuffix = TapestryInternalUtils.toFileSuffix(baseResource.getFile());
        ResourceTransformer rt = this.configuration.get(fileSuffix);
        InputStream inputStream = transformed = rt == null ? baseResource.openStream() : rt.transform(baseResource, dependencies);
        assert (transformed != null);
        BytestreamCache bytestreamCache = this.readStream(transformed);
        transformed.close();
        String contentType = this.contentTypeAnalyzer.getContentType(baseResource);
        boolean compressable = this.compressionAnalyzer.isCompressable(contentType);
        long lastModified = this.resourceChangeTracker.trackResource(baseResource);
        return new StreamableResourceImpl(baseResource.toString(), contentType, compressable ? CompressionStatus.COMPRESSABLE : CompressionStatus.NOT_COMPRESSABLE, lastModified, bytestreamCache);
    }

    private BytestreamCache readStream(InputStream stream) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TapestryInternalUtils.copy(stream, bos);
        stream.close();
        return new BytestreamCache(bos);
    }
}

