/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.javascript;

import java.util.List;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.internal.services.javascript.JavaScriptStackPathConstructor;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.services.assets.AssetPathConstructor;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptStackPathConstructorImpl
implements JavaScriptStackPathConstructor {
    private final ThreadLocale threadLocale;
    private final AssetPathConstructor assetPathConstructor;
    private final JavaScriptStackSource javascriptStackSource;
    private final boolean combineScripts;
    private final Mapper<Asset, String> toPath = new Mapper<Asset, String>(){

        public String map(Asset input) {
            return input.toClientURL();
        }
    };

    public JavaScriptStackPathConstructorImpl(ThreadLocale threadLocale, AssetPathConstructor assetPathConstructor, JavaScriptStackSource javascriptStackSource, @Symbol(value="tapestry.combine-scripts") boolean combineScripts) {
        this.threadLocale = threadLocale;
        this.assetPathConstructor = assetPathConstructor;
        this.javascriptStackSource = javascriptStackSource;
        this.combineScripts = combineScripts;
    }

    @Override
    public List<String> constructPathsForJavaScriptStack(String stackName) {
        JavaScriptStack stack = this.javascriptStackSource.getStack(stackName);
        List<Asset> assets = stack.getJavaScriptLibraries();
        if (assets.size() > 1 && this.combineScripts) {
            return this.combinedStackURL(stackName);
        }
        return this.toPaths(assets);
    }

    private List<String> toPaths(List<Asset> assets) {
        assert (assets != null);
        return F.flow(assets).map(this.toPath).toList();
    }

    private List<String> combinedStackURL(String stackName) {
        String path = String.format("%s/%s.js", this.threadLocale.getLocale().toString(), stackName);
        String stackURL = this.assetPathConstructor.constructAssetPath("stack", path);
        return CollectionFactory.newList((Object[])new String[]{stackURL});
    }
}

