/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.ioc.services.FieldValueConduit;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodHandle;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.MethodParameter;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.services.ClassTransformation;
import org.apache.tapestry5.services.ComponentEventHandler;
import org.apache.tapestry5.services.ComponentInstanceOperation;
import org.apache.tapestry5.services.ComponentMethodAdvice;
import org.apache.tapestry5.services.ComponentMethodInvocation;
import org.apache.tapestry5.services.ComponentValueProvider;
import org.apache.tapestry5.services.FieldAccess;
import org.apache.tapestry5.services.MethodAccess;
import org.apache.tapestry5.services.MethodInvocationResult;
import org.apache.tapestry5.services.TransformField;
import org.apache.tapestry5.services.TransformMethod;
import org.apache.tapestry5.services.TransformMethodSignature;
import org.apache.tapestry5.services.transform.TransformationSupport;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeClassTransformation
implements ClassTransformation {
    private final PlasticClass plasticClass;
    private final TransformationSupport support;
    private final MutableComponentModel model;
    private static Mapper<PlasticField, TransformField> TO_TRANSFORM_FIELD = new Mapper<PlasticField, TransformField>(){

        public TransformField map(PlasticField element) {
            return BridgeClassTransformation.toTransformField(element);
        }
    };
    private final Mapper<PlasticMethod, TransformMethod> toTransformMethod = new Mapper<PlasticMethod, TransformMethod>(){

        public TransformMethod map(PlasticMethod element) {
            return new BridgeTransformMethod(element);
        }
    };

    private static <T> ComputedValue<T> toComputedValue(final ComponentValueProvider<T> provider) {
        return new ComputedValue<T>(){

            public T get(InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                return provider.get(resources);
            }
        };
    }

    private static FieldConduit<Object> toFieldConduit(final FieldValueConduit fieldValueConduit) {
        return new FieldConduit<Object>(){

            public Object get(Object instance, InstanceContext context) {
                return fieldValueConduit.get();
            }

            public void set(Object instance, InstanceContext context, Object newValue) {
                fieldValueConduit.set(newValue);
            }
        };
    }

    private static TransformMethodSignature toMethodSignature(MethodDescription description) {
        return new TransformMethodSignature(description.modifiers, description.returnType, description.methodName, description.argumentTypes, description.checkedExceptionTypes);
    }

    private static MethodDescription toMethodDescription(TransformMethodSignature signature) {
        return new MethodDescription(signature.getModifiers(), signature.getReturnType(), signature.getMethodName(), signature.getParameterTypes(), signature.getSignature(), signature.getExceptionTypes());
    }

    private static BridgeTransformField toTransformField(PlasticField plasticField) {
        return new BridgeTransformField(plasticField);
    }

    public BridgeClassTransformation(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        this.plasticClass = plasticClass;
        this.support = support;
        this.model = model;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.plasticClass.getAnnotation(annotationClass);
    }

    @Override
    public String getClassName() {
        return this.plasticClass.getClassName();
    }

    @Override
    public String newMemberName(String suggested) {
        return this.newMemberName("_", PlasticInternalUtils.toPropertyName((String)suggested));
    }

    @Override
    public String newMemberName(String prefix, String baseName) {
        return prefix + PlasticUtils.nextUID() + baseName;
    }

    @Override
    public List<TransformField> matchFieldsWithAnnotation(Class<? extends Annotation> annotationClass) {
        return F.flow((Collection)this.plasticClass.getFieldsWithAnnotation(annotationClass)).map(TO_TRANSFORM_FIELD).toList();
    }

    @Override
    public List<TransformMethod> matchMethods(Predicate<TransformMethod> predicate) {
        return ((Flow)F.flow((Collection)this.plasticClass.getMethods()).map(this.toTransformMethod).filter(predicate)).toList();
    }

    @Override
    public List<TransformMethod> matchMethodsWithAnnotation(Class<? extends Annotation> annotationType) {
        return F.flow((Collection)this.plasticClass.getMethodsWithAnnotation(annotationType)).map(this.toTransformMethod).toList();
    }

    @Override
    public List<TransformField> matchFields(Predicate<TransformField> predicate) {
        return ((Flow)F.flow((Collection)this.plasticClass.getAllFields()).map(TO_TRANSFORM_FIELD).filter(predicate)).toList();
    }

    @Override
    public TransformField getField(String fieldName) {
        for (PlasticField f : this.plasticClass.getAllFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return BridgeClassTransformation.toTransformField(f);
        }
        throw new IllegalArgumentException(String.format("Class %s does not contain a field named '%s'.", this.plasticClass.getClassName(), fieldName));
    }

    @Override
    public List<TransformField> matchUnclaimedFields() {
        return F.flow((Collection)this.plasticClass.getUnclaimedFields()).map(TO_TRANSFORM_FIELD).toList();
    }

    @Override
    public boolean isField(String fieldName) {
        throw new IllegalArgumentException("isField() not yet implemented.");
    }

    @Override
    public TransformField createField(int modifiers, String type, String suggestedName) {
        PlasticField newField = this.plasticClass.introduceField(type, suggestedName);
        return BridgeClassTransformation.toTransformField(newField);
    }

    @Override
    public String addInjectedField(Class type, String suggestedName, Object value) {
        PlasticField field = this.plasticClass.introduceField(type, suggestedName).inject(value);
        return field.getName();
    }

    @Override
    public <T> TransformField addIndirectInjectedField(Class<T> type, String suggestedName, ComponentValueProvider<T> provider) {
        PlasticField field = this.plasticClass.introduceField(type, suggestedName).injectComputed(BridgeClassTransformation.toComputedValue(provider));
        return BridgeClassTransformation.toTransformField(field);
    }

    @Override
    public void addImplementedInterface(Class interfaceClass) {
        this.plasticClass.introduceInterface(interfaceClass);
    }

    @Override
    public Class toClass(String type) {
        return this.support.toClass(type);
    }

    @Override
    public Logger getLogger() {
        return this.model.getLogger();
    }

    @Override
    public boolean isRootTransformation() {
        return this.support.isRootTransformation();
    }

    @Override
    public TransformMethod getOrCreateMethod(TransformMethodSignature signature) {
        MethodDescription md = BridgeClassTransformation.toMethodDescription(signature);
        PlasticMethod plasticMethod = this.plasticClass.introduceMethod(md);
        return new BridgeTransformMethod(plasticMethod);
    }

    @Override
    public boolean isDeclaredMethod(TransformMethodSignature signature) {
        final MethodDescription md = BridgeClassTransformation.toMethodDescription(signature);
        return !((Flow)F.flow((Collection)this.plasticClass.getMethods()).filter((Predicate)new Predicate<PlasticMethod>(){

            public boolean accept(PlasticMethod element) {
                return element.getDescription().equals((Object)md);
            }
        })).isEmpty();
    }

    @Override
    public void addComponentEventHandler(String eventType, int minContextValues, String methodDescription, ComponentEventHandler handler) {
        this.support.addEventHandler(eventType, minContextValues, methodDescription, handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BridgeTransformMethod
    implements TransformMethod {
        private final PlasticMethod plasticMethod;
        private TransformMethodSignature signature;

        public BridgeTransformMethod(PlasticMethod plasticMethod) {
            this.plasticMethod = plasticMethod;
        }

        @Override
        public int compareTo(TransformMethod o) {
            throw new IllegalStateException("compareTo() not yet implemented.");
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.plasticMethod.getAnnotation(annotationClass);
        }

        @Override
        public TransformMethodSignature getSignature() {
            if (this.signature == null) {
                this.signature = BridgeClassTransformation.toMethodSignature(this.plasticMethod.getDescription());
            }
            return this.signature;
        }

        @Override
        public String getName() {
            return this.plasticMethod.getDescription().methodName;
        }

        @Override
        public MethodAccess getAccess() {
            MethodHandle handle = this.plasticMethod.getHandle();
            return new WrapMethodHandleAsMethodAccess(handle);
        }

        @Override
        public void addAdvice(ComponentMethodAdvice advice) {
            WrapMethodAdviceAsComponentMethodAdvice plasticAdvice = new WrapMethodAdviceAsComponentMethodAdvice(advice);
            this.plasticMethod.addAdvice((MethodAdvice)plasticAdvice);
        }

        @Override
        public void addOperationBefore(ComponentInstanceOperation operation) {
            this.plasticMethod.addAdvice((MethodAdvice)new WrapBeforeComponentInstanceOperationAsMethodAdvice(operation));
        }

        @Override
        public void addOperationAfter(ComponentInstanceOperation operation) {
            this.plasticMethod.addAdvice((MethodAdvice)new WrapAfterComponentInstanceOperationAsMethodAdvice(operation));
        }

        @Override
        public String getMethodIdentifier() {
            return String.format("%s.%s", BridgeClassTransformation.this.plasticClass.getClassName(), this.getSignature().getMediumDescription());
        }

        @Override
        public boolean isOverride() {
            return this.plasticMethod.isOverride();
        }

        @Override
        public <A extends Annotation> A getParameterAnnotation(int index, Class<A> annotationType) {
            return (A)((MethodParameter)this.plasticMethod.getParameters().get(index)).getAnnotation(annotationType);
        }
    }

    private static final class WrapBeforeComponentInstanceOperationAsMethodAdvice
    implements MethodAdvice {
        private final ComponentInstanceOperation operation;

        private WrapBeforeComponentInstanceOperationAsMethodAdvice(ComponentInstanceOperation operation) {
            this.operation = operation;
        }

        public void advise(MethodInvocation invocation) {
            this.operation.invoke((Component)invocation.getInstance());
            invocation.proceed();
        }
    }

    private static final class WrapAfterComponentInstanceOperationAsMethodAdvice
    implements MethodAdvice {
        private final ComponentInstanceOperation operation;

        private WrapAfterComponentInstanceOperationAsMethodAdvice(ComponentInstanceOperation operation) {
            this.operation = operation;
        }

        public void advise(MethodInvocation invocation) {
            invocation.proceed();
            this.operation.invoke((Component)invocation.getInstance());
        }
    }

    private static final class WrapMethodAdviceAsComponentMethodAdvice
    implements MethodAdvice {
        private final ComponentMethodAdvice advice;

        private WrapMethodAdviceAsComponentMethodAdvice(ComponentMethodAdvice advice) {
            this.advice = advice;
        }

        public void advise(final MethodInvocation invocation) {
            this.advice.advise(new ComponentMethodInvocation(){

                @Override
                public ComponentResources getComponentResources() {
                    return (ComponentResources)invocation.getInstanceContext().get(ComponentResources.class);
                }

                public void rethrow() {
                    invocation.rethrow();
                }

                public void proceed() {
                    invocation.proceed();
                }

                public void overrideThrown(Exception thrown) {
                    invocation.setCheckedException(thrown);
                }

                public void overrideResult(Object newResult) {
                    invocation.setReturnValue(newResult);
                }

                public void override(int index, Object newParameter) {
                    invocation.setParameter(index, newParameter);
                }

                public boolean isFail() {
                    return invocation.didThrowCheckedException();
                }

                public <T extends Throwable> T getThrown(Class<T> throwableClass) {
                    return (T)invocation.getCheckedException(throwableClass);
                }

                public Class getResultType() {
                    return this.method().getReturnType();
                }

                public Object getResult() {
                    return invocation.getReturnValue();
                }

                public Class getParameterType(int index) {
                    return this.method().getParameterTypes()[index];
                }

                public int getParameterCount() {
                    return this.method().getParameterTypes().length;
                }

                public Object getParameter(int index) {
                    return invocation.getParameter(index);
                }

                public String getMethodName() {
                    return this.method().getName();
                }

                private Method method() {
                    return invocation.getMethod();
                }

                public <T extends Annotation> T getMethodAnnotation(Class<T> annotationClass) {
                    return (T)invocation.getAnnotation(annotationClass);
                }

                @Override
                public Component getInstance() {
                    return (Component)invocation.getInstance();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BridgeTransformField
    implements TransformField {
        private final PlasticField plasticField;

        public BridgeTransformField(PlasticField plasticField) {
            this.plasticField = plasticField;
        }

        @Override
        public int compareTo(TransformField o) {
            throw new IllegalStateException("compareTo() not yet implemented.");
        }

        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.plasticField.getAnnotation(annotationClass);
        }

        @Override
        public String getName() {
            return this.plasticField.getName();
        }

        @Override
        public String getType() {
            return this.plasticField.getTypeName();
        }

        @Override
        public String getSignature() {
            return this.plasticField.getGenericSignature();
        }

        @Override
        public void claim(Object tag) {
            this.plasticField.claim(tag);
        }

        @Override
        public void replaceAccess(ComponentValueProvider<FieldValueConduit> conduitProvider) {
            this.plasticField.setComputedConduit((ComputedValue)new WrapCVP_FieldValueConduit_as_CV_FieldConduit(conduitProvider));
        }

        @Override
        public void replaceAccess(TransformField conduitField) {
            PlasticField conduitFieldPlastic = ((BridgeTransformField)conduitField).plasticField;
            FieldHandle conduitHandle = conduitFieldPlastic.getHandle();
            this.plasticField.setConduit((FieldConduit)new WrapFieldHandleForFieldValueConduitAsFieldConduit(conduitHandle));
        }

        @Override
        public void replaceAccess(FieldValueConduit conduit) {
            this.plasticField.setConduit((FieldConduit)new WrapFieldValueConduitAsFieldConduit(conduit));
        }

        @Override
        public int getModifiers() {
            return this.plasticField.getModifiers();
        }

        @Override
        public void inject(Object value) {
            this.plasticField.inject(value);
        }

        @Override
        public <T> void injectIndirect(ComponentValueProvider<T> provider) {
            this.plasticField.injectComputed(BridgeClassTransformation.toComputedValue(provider));
        }

        @Override
        public FieldAccess getAccess() {
            FieldHandle handle = this.plasticField.getHandle();
            return new WrapFieldHandleAsFieldAccess(handle);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class WrapCVP_FieldValueConduit_as_CV_FieldConduit
        implements ComputedValue<FieldConduit<Object>> {
            private final ComponentValueProvider<FieldValueConduit> conduitProvider;

            private WrapCVP_FieldValueConduit_as_CV_FieldConduit(ComponentValueProvider<FieldValueConduit> conduitProvider) {
                this.conduitProvider = conduitProvider;
            }

            public FieldConduit<Object> get(InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                FieldValueConduit fieldValueConduit = this.conduitProvider.get(resources);
                return BridgeClassTransformation.toFieldConduit(fieldValueConduit);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class WrapFieldHandleForFieldValueConduitAsFieldConduit
        implements FieldConduit<Object> {
            private final FieldHandle conduitHandle;

            private WrapFieldHandleForFieldValueConduitAsFieldConduit(FieldHandle conduitHandle) {
                this.conduitHandle = conduitHandle;
            }

            private FieldValueConduit conduit(Object instance) {
                return (FieldValueConduit)this.conduitHandle.get(instance);
            }

            public Object get(Object instance, InstanceContext context) {
                return this.conduit(instance).get();
            }

            public void set(Object instance, InstanceContext context, Object newValue) {
                this.conduit(instance).set(newValue);
            }
        }

        private static final class WrapFieldValueConduitAsFieldConduit
        implements FieldConduit {
            private final FieldValueConduit conduit;

            private WrapFieldValueConduitAsFieldConduit(FieldValueConduit conduit) {
                this.conduit = conduit;
            }

            public Object get(Object instance, InstanceContext context) {
                return this.conduit.get();
            }

            public void set(Object instance, InstanceContext context, Object newValue) {
                this.conduit.set(newValue);
            }
        }

        private static final class WrapFieldHandleAsFieldAccess
        implements FieldAccess {
            private final FieldHandle handle;

            private WrapFieldHandleAsFieldAccess(FieldHandle handle) {
                this.handle = handle;
            }

            public void write(Object instance, Object value) {
                this.handle.set(instance, value);
            }

            public Object read(Object instance) {
                return this.handle.get(instance);
            }
        }
    }

    private static final class WrapMethodHandleAsMethodAccess
    implements MethodAccess {
        private final MethodHandle handle;

        private WrapMethodHandleAsMethodAccess(MethodHandle handle) {
            this.handle = handle;
        }

        public MethodInvocationResult invoke(Object target, Object ... arguments) {
            final org.apache.tapestry5.plastic.MethodInvocationResult plasticResult = this.handle.invoke(target, arguments);
            return new MethodInvocationResult(){

                @Override
                public void rethrow() {
                    plasticResult.rethrow();
                }

                @Override
                public boolean isFail() {
                    return plasticResult.didThrowCheckedException();
                }

                @Override
                public <T extends Throwable> T getThrown(Class<T> throwableClass) {
                    return (T)plasticResult.getCheckedException(throwableClass);
                }

                @Override
                public Object getReturnValue() {
                    return plasticResult.getReturnValue();
                }
            };
        }
    }
}

