/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import java.util.Map;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.SelectModelVisitor;
import org.apache.tapestry5.ValueEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectModelRenderer
implements SelectModelVisitor {
    private final MarkupWriter writer;
    private final ValueEncoder encoder;

    public SelectModelRenderer(MarkupWriter writer, ValueEncoder encoder) {
        this.writer = writer;
        this.encoder = encoder;
    }

    @Override
    public void beginOptionGroup(OptionGroupModel groupModel) {
        this.writer.element("optgroup", "label", groupModel.getLabel());
        this.writeDisabled(groupModel.isDisabled());
        this.writeAttributes(groupModel.getAttributes());
    }

    @Override
    public void endOptionGroup(OptionGroupModel groupModel) {
        this.writer.end();
    }

    @Override
    public void option(OptionModel optionModel) {
        Object optionValue = optionModel.getValue();
        String clientValue = this.encoder.toClient(optionValue);
        this.writer.element("option", "value", clientValue);
        if (this.isOptionSelected(optionModel, clientValue)) {
            this.writer.attributes("selected", "selected");
        }
        this.writeDisabled(optionModel.isDisabled());
        this.writeAttributes(optionModel.getAttributes());
        this.writer.write(optionModel.getLabel());
        this.writer.end();
    }

    private void writeDisabled(boolean disabled) {
        if (disabled) {
            this.writer.attributes("disabled", "disabled");
        }
    }

    private void writeAttributes(Map<String, String> attributes) {
        if (attributes == null) {
            return;
        }
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            this.writer.attributes(e.getKey(), e.getValue());
        }
    }

    protected boolean isOptionSelected(OptionModel optionModel, String clientValue) {
        return false;
    }
}

