/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.assets;

import org.apache.tapestry5.SymbolConstants;
import org.apache.tapestry5.internal.services.assets.CompressionAnalyzerImpl;
import org.apache.tapestry5.internal.services.assets.ContentTypeAnalyzerImpl;
import org.apache.tapestry5.internal.services.assets.MasterResourceMinimizer;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTrackerImpl;
import org.apache.tapestry5.internal.services.assets.SRSCachingInterceptor;
import org.apache.tapestry5.internal.services.assets.SRSCompressedCachingInterceptor;
import org.apache.tapestry5.internal.services.assets.SRSCompressingInterceptor;
import org.apache.tapestry5.internal.services.assets.SRSMinimizingInterceptor;
import org.apache.tapestry5.internal.services.assets.StreamableResourceSourceImpl;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.Decorate;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Order;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.FactoryDefaults;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.services.Core;
import org.apache.tapestry5.services.assets.CompressionAnalyzer;
import org.apache.tapestry5.services.assets.ContentTypeAnalyzer;
import org.apache.tapestry5.services.assets.ResourceMinimizer;
import org.apache.tapestry5.services.assets.StreamableResourceSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Marker(value={Core.class})
public class AssetsModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(StreamableResourceSource.class, StreamableResourceSourceImpl.class);
        binder.bind(CompressionAnalyzer.class, CompressionAnalyzerImpl.class);
        binder.bind(ContentTypeAnalyzer.class, ContentTypeAnalyzerImpl.class);
        binder.bind(ResourceChangeTracker.class, ResourceChangeTrackerImpl.class);
        binder.bind(ResourceMinimizer.class, MasterResourceMinimizer.class);
    }

    @Contribute(value=SymbolProvider.class)
    @FactoryDefaults
    public static void setupSymbols(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"tapestry.enable-minification", (Object)SymbolConstants.PRODUCTION_MODE_VALUE);
        configuration.add((Object)"tapestry.gzip-compression-enabled", (Object)"true");
        configuration.add((Object)"tapestry.combine-scripts", (Object)SymbolConstants.PRODUCTION_MODE_VALUE);
        configuration.add((Object)"tapestry.asset-url-fully-qualified", (Object)"false");
    }

    @Decorate(id="GZipCompression", serviceInterface=StreamableResourceSource.class)
    public StreamableResourceSource enableCompression(StreamableResourceSource delegate, @Symbol(value="tapestry.gzip-compression-enabled") boolean gzipEnabled, @Symbol(value="tapestry.min-gzip-size") int compressionCutoff) {
        return gzipEnabled ? new SRSCompressingInterceptor(compressionCutoff, delegate) : null;
    }

    @Decorate(id="CacheCompressed", serviceInterface=StreamableResourceSource.class)
    @Order(value={"before:GZIpCompression"})
    public StreamableResourceSource enableCompressedCaching(StreamableResourceSource delegate, @Symbol(value="tapestry.gzip-compression-enabled") boolean gzipEnabled, ResourceChangeTracker tracker) {
        if (!gzipEnabled) {
            return null;
        }
        SRSCompressedCachingInterceptor interceptor = new SRSCompressedCachingInterceptor(delegate);
        tracker.addInvalidationListener(interceptor);
        return interceptor;
    }

    @Decorate(id="Cache", serviceInterface=StreamableResourceSource.class)
    @Order(value={"after:GZipCompression"})
    public StreamableResourceSource enableUncompressedCaching(StreamableResourceSource delegate, ResourceChangeTracker tracker) {
        SRSCachingInterceptor interceptor = new SRSCachingInterceptor(delegate);
        tracker.addInvalidationListener(interceptor);
        return interceptor;
    }

    @Decorate(id="Minification", serviceInterface=StreamableResourceSource.class)
    @Order(value={"after:Cache"})
    public StreamableResourceSource enableMinification(StreamableResourceSource delegate, ResourceMinimizer minimizer, @Symbol(value="tapestry.enable-minification") boolean enabled) {
        if (enabled) {
            return new SRSMinimizingInterceptor(delegate, minimizer);
        }
        return null;
    }

    @Contribute(value=ContentTypeAnalyzer.class)
    public void setupDefaultContentTypeMappings(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"css", (Object)"text/css");
        configuration.add((Object)"js", (Object)"text/javascript");
        configuration.add((Object)"gif", (Object)"image/gif");
        configuration.add((Object)"jpg", (Object)"image/jpeg");
        configuration.add((Object)"jpeg", (Object)"image/jpeg");
        configuration.add((Object)"png", (Object)"image/png");
        configuration.add((Object)"swf", (Object)"application/x-shockwave-flash");
        configuration.add((Object)"svg", (Object)"image/svg+xml");
    }

    @Contribute(value=CompressionAnalyzer.class)
    public void disableCompressionForImageTypes(MappedConfiguration<String, Boolean> configuration) {
        configuration.add((Object)"image/jpeg", (Object)false);
        configuration.add((Object)"image/gif", (Object)false);
        configuration.add((Object)"image/png", (Object)false);
        configuration.add((Object)"application/x-shockwave-flash", (Object)false);
    }
}

