/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.services.javascript;

import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.func.F;
import org.apache.tapestry5.func.Flow;
import org.apache.tapestry5.func.Mapper;
import org.apache.tapestry5.func.Predicate;
import org.apache.tapestry5.ioc.annotations.UsesOrderedConfiguration;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.javascript.JavaScriptStack;
import org.apache.tapestry5.services.javascript.StackExtension;
import org.apache.tapestry5.services.javascript.StackExtensionType;
import org.apache.tapestry5.services.javascript.StylesheetLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsesOrderedConfiguration(value=StackExtension.class)
public class ExtensibleJavaScriptStack
implements JavaScriptStack {
    private final AssetSource assetSource;
    private final List<Asset> libraries;
    private final List<StylesheetLink> stylesheets;
    private final String initialization;
    private final Mapper<StackExtension, String> extractValue = new Mapper<StackExtension, String>(){

        public String map(StackExtension element) {
            return element.value;
        }
    };
    private final Mapper<String, Asset> stringToAsset = new Mapper<String, Asset>(){

        public Asset map(String value) {
            return ExtensibleJavaScriptStack.this.assetSource.getExpandedAsset(value);
        }
    };
    private final Mapper<Asset, StylesheetLink> assetToStylesheetLink = new Mapper<Asset, StylesheetLink>(){

        public StylesheetLink map(Asset asset) {
            return new StylesheetLink(asset);
        }
    };

    private final Predicate<StackExtension> by(final StackExtensionType type) {
        return new Predicate<StackExtension>(){

            public boolean accept(StackExtension element) {
                return element.type == type;
            }
        };
    }

    public ExtensibleJavaScriptStack(AssetSource assetSource, List<StackExtension> configuration) {
        this.assetSource = assetSource;
        Flow extensions = F.flow(configuration);
        this.libraries = ((Flow)extensions.filter(this.by(StackExtensionType.LIBRARY))).map(this.extractValue).map(this.stringToAsset).toList();
        this.stylesheets = ((Flow)extensions.filter(this.by(StackExtensionType.STYLESHEET))).map(this.extractValue).map(this.stringToAsset).map(this.assetToStylesheetLink).toList();
        List initializations = ((Flow)extensions.filter(this.by(StackExtensionType.INITIALIZATION))).map(this.extractValue).toList();
        this.initialization = initializations.isEmpty() ? null : InternalUtils.join((List)initializations, (String)"\n");
    }

    @Override
    public List<String> getStacks() {
        return Collections.emptyList();
    }

    @Override
    public List<Asset> getJavaScriptLibraries() {
        return this.libraries;
    }

    @Override
    public List<StylesheetLink> getStylesheets() {
        return this.stylesheets;
    }

    @Override
    public String getInitialization() {
        return this.initialization;
    }
}

