package com.wy.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.jspsmart.upload.File;
import com.jspsmart.upload.Files;
import com.wy.dao.OperationData;
import com.wy.form.Photo;
import com.wy.form.UserInfo;

public class PhotoServlet extends HttpServlet {
	private String info = "";

	private OperationData data = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		info = request.getParameter("info");
		// ҳinfoĲִֵͬвͬĲ
		if (info.equals("userQueryPhoto")) {
			this.user_queryPhoto(request, response);
		}
		if (info.equals("userUploadPhoto")) {
			this.user_uploadPhoto(request, response);
		}
		if (info.equals("queryOnePhoto")) {

			this.queryOnePhoto(request, response);
		}
		if (info.equals("queryPhotoList")) {

			this.user_queryPhotoList(request, response);
		}
		if (info.equals("queryOnePhoto")) {

			this.queryOnePhoto(request, response);
		}
		if (info.equals("queryPhotoSlide")) {

			this.queryPhotoSlide(request, response);
		}
		if (info.equals("userDeletePhoto")) {

			this.user_deletePhoto(request, response);
		}
		if (info.equals("userprintPhoto")) {

			this.user_printPhoto(request, response);
		}
		if (info.equals("forward_index")) {

			this.forward_index(request, response);
		}

	}

	// תҳ
	public void forward_index(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		List list = new OperationData().queryPhotoList();
		request.setAttribute("list", list);
		request.getRequestDispatcher("photoIndex.jsp").forward(request,
				response);
	}

	// ˮӡͼƬ
	public void user_printPhoto(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		data = new OperationData();
		Integer id = Integer.valueOf(request.getParameter("id"));
		String condition = "id = '" + id + "'";
		List list = data.photo_queryList(condition);
		Photo photo1 = (Photo) list.get(0);
		String filePath = request.getRealPath(photo1.getPhotoAddress()); // ͼƬԴļ
		String print = "savePrint/" + System.currentTimeMillis() + ".JPG";
		String printPath = request.getRealPath(print); // ˮӡͼƬλ
		/** ******************************************************************************* */
		if (!photo1.getPrintAddress().equals("0")) {
			String path = request.getRealPath(photo1.getPrintAddress());
			java.io.File file1 = new java.io.File(path);
			if (file1.exists()) {
				file1.delete();
			}
		}
		/** ******************************************************************************* */
		String printInforamtion = com.wy.tools.Encrypt.toChinese(request
				.getParameter("information"));
		String information = "ˮӡЧʧܣ";
		if (com.wy.tools.ImageUtils.createMark(filePath, printPath,
				printInforamtion)) {
			Photo photo2 = new Photo();
			photo2.setId(photo1.getId());
			photo2.setPrintAddress(print);
			if (data.updatePhoto(photo2)) {
				information = "ˮӡЧɹ";
			}
		}

		request.setAttribute("information", information);
		List list1 = data.photo_queryList(condition);
		Photo photo3 = (Photo) list1.get(0);
		request.setAttribute("photo", photo3);
		request.getRequestDispatcher("photoShow.jsp")
				.forward(request, response);
	}

	// ɾͼƬ
	public void user_deletePhoto(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html;charset=GBK");
		PrintWriter out = response.getWriter();
		data = new OperationData();
		Integer id = Integer.valueOf(request.getParameter("id")); // ҳлȡҪɾƬid
		String condition = "id=" + id; // idΪòѯ
		List list = data.photo_queryList(condition); // idֵвѯƬһϢ
		String address = null; // ôŷ˵ַ
		String print = null;
		String type = null; // Ƭ
		if (list.size() == 1) { // жϲѯļǷʹһ
			Photo photo = (Photo) list.get(0);
			address = photo.getPhotoAddress(); // ȡݿƬŷ˵ĵַ
			print = photo.getPrintAddress();
			type = photo.getPhotoType(); // ȡƬ
		}
		String path = request.getRealPath("/" + address); // ȡļʵʵַ
		data.photo_delete(id); // ɾƬӦSQL
		// ĲǸļλýɾ
		java.io.File file1 = new java.io.File(path);
		if (file1.exists()) {
			file1.delete();
		}
		String printPath = request.getRealPath("/" + print);
		java.io.File file2 = new java.io.File(printPath);
		if (file2.exists()) {
			file2.delete();
		}
		// ļͱrequestΧ
		request.setAttribute("type", type);
		request.getRequestDispatcher("dealwith.jsp").forward(request, response);
	}

	// ʵûϴԼͼƬ
	public void user_uploadPhoto(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		data = new OperationData();
		com.jspsmart.upload.SmartUpload su = new com.jspsmart.upload.SmartUpload();
		String information = "Ƭʧܣ";
		try {
			su.initialize(this.getServletConfig(), request, response); // óĳʼ
			su.setMaxFileSize(2 * 1024 * 1024); // ϴļĴС
			su.upload();
			Files files = su.getFiles(); // ȡϴļ

			for (int i = 0; i < files.getCount(); i++) {
				File singleFile = files.getFile(i); // ȡϴļĵļ

				String fileType = singleFile.getFileExt(); // ȡϴļչ
				String[] type = { "JPG", "jpg", "gif", "bmp", "BMP" }; // ϴļչ
				int place = java.util.Arrays.binarySearch(type, fileType); // жϴļǷȷ

				String code = su.getRequest().getParameter("code"); // ȡ֤
				String codeSession = (String) request.getSession()
						.getAttribute("rand"); // ȡͻsessionֵ֤
				if (code.equals(codeSession)) { // ж֤Ƿȷ

					if (place != -1) { // жļչǷȷ
						if (!singleFile.isMissing()) { // жϸļǷѡ
							String photoName = su.getRequest().getParameter(
									"photoName")
									+ i; // ȡƬ
							String photoType = su.getRequest().getParameter(
									"photoType"); // ȡ
							String photoTime = su.getRequest().getParameter(
									"photoTime"); // ȡϴʱ
							String username = su.getRequest().getParameter(
									"username"); // ȡϴû
							String photoSize = String.valueOf(singleFile
									.getSize()); // ȡϴļĴС
							String filedir = "savefile/"
									+ System.currentTimeMillis() + "."
									+ singleFile.getFileExt(); // ϵͳʱΪϴļƣϴļ·

							String smalldir = "saveSmall/"
									+ System.currentTimeMillis() + "."
									+ singleFile.getFileExt();

							Photo photo = new Photo();
							/** ********photoеԽһһֵ*** */
							photo.setPhotoName(photoName);
							photo.setPhotoType(photoType);
							photo.setPhotoSize(photoSize);
							photo.setPhotoTime(photoTime);
							photo.setUsername(username);
							photo.setPhotoAddress(filedir);
							photo.setSmallPhoto(smalldir);
							/** ************************************ */
							if (data.photo_save(photo)) { // ʵϴSQL
								singleFile.saveAs(filedir, File.SAVEAS_VIRTUAL); // ִϴ
								com.wy.tools.ImageUtils.createSmallPhoto(
										request.getRealPath("/" + filedir),
										request.getRealPath("/" + smalldir));
								information = "Ƭɹ!";

							}

						}

					}

				}
			}

		} catch (Exception e) {
			System.out.println(e);
		}

		request.setAttribute("information", information);
		request.getRequestDispatcher("user_upLoadPhoto.jsp").forward(request,
				response);

	}

	// ûɹ¼ʵֵ¼ûѯĹ
	public void user_queryPhoto(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		data = new OperationData();
		UserInfo userInfo = (UserInfo) request.getSession().getAttribute(
				"userInfo"); // ȡͻ˴sessionе
		String username = userInfo.getUsername(); // ȡû
		String[] type = data.queryPhotoType(username); // ûѯûϴ
		request.setAttribute("type", type); // ʹrequestΧ
		String condition = "username = '" + username + "'";
		List list = data.photo_queryList(condition); // ûѯ
		request.setAttribute("list", list); // ѯĽrequestΧ
		request.getRequestDispatcher("user_queryPhoto.jsp").forward(request,
				response);
	}

	// û¼󣬶ÿеƬвѯ
	public void user_queryPhotoList(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		data = new OperationData();
		String type = com.wy.tools.Encrypt.toChinese(request
				.getParameter("type")); // ȡҳе
		String condition = "photoType = '" + type + "'";
		if (null != request.getSession().getAttribute("userInfo")) {
			UserInfo userInfo = (UserInfo) request.getSession().getAttribute(
					"userInfo"); // ȡͻsessionеĶ
			String username = userInfo.getUsername(); // ݿͻsessionеĶ󣬻ȡû
			condition = "username ='" + username + "' and photoType = '" + type
					+ "'"; // òѯֱûͽвѯ
		}
		List list = data.photo_queryList(condition); // ִвѯ
		if (list.size() == 0) {
			request.setCharacterEncoding("gb2312");
			PrintWriter out = response.getWriter();
			out.print("<script language=javascript>history.go(-1);</script>");
		} else {
			request.setAttribute("list", list); // ѯĽrequestΧ
			request.setAttribute("type", type); // ƱrequestΧ
			request.getRequestDispatcher("user_queryPhotoList.jsp").forward(
					request, response);
		}
	}

	// Ƭϸѯ
	public void queryOnePhoto(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		data = new OperationData();
		Integer id = Integer.valueOf(request.getParameter("id")); // ȡҳID
		String condition = "id = '" + id + "'"; // òѯidΪѯ
		List list = data.photo_queryList(condition); // ִвѯķ
		Photo photo = null;
		if (list.size() == 1) { // idŵֵݿΨһģֻһ
			photo = (Photo) list.get(0);
		}
		request.setAttribute("photo", photo); // ѯĽrequestΧ
		try {
			request.getRequestDispatcher("photoShow.jsp").forward(request,
					response);
			return;
		} catch (Exception e) {

		}

	}

	// õƬ
	public void queryPhotoSlide(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		data = new OperationData();
		UserInfo userInfo = (UserInfo) request.getSession().getAttribute(
				"userInfo"); // ȡͻsessionеָ
		String username = userInfo.getUsername(); // ȡû
		String type = com.wy.tools.Encrypt.toChinese(request
				.getParameter("type")); // ȡվ
		String condition = "username ='" + username + "' and photoType = '"
				+ type + "'"; // òѯûΪ
		List list = data.photo_queryList(condition); // ִвѯ
		String address[] = new String[list.size()]; // Ƭλõ
		for (int i = 0; i < list.size(); i++) {
			Photo photo = (Photo) list.get(i);
			address[i] = photo.getPhotoAddress(); // ѯĽУƬλýһһֵ
		}
		request.setAttribute("address", address); // ƬַrequestΧ
		request.getRequestDispatcher("photoShowSlide.jsp").forward(request,
				response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		this.doGet(request, response);
	}

}
