package com.wy.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.wy.dao.OperationData;
import com.wy.form.UserInfo;

public class UserInfoServlet extends HttpServlet {
	private String info = null; // StringͶinfoöִвͬķ

	private OperationData data = null; // OperationData

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		info = request.getParameter("info");
		// ݲͬĲƣִвͬķ
		if (info.equals("saveUser")) {
			this.user_save(request, response);
		}
		if (info.equals("checkUser")) {
			this.user_check(request, response);
		}
		if (info.equals("cannleUser")) {
			this.user_cannle(request, response);
		}
		if (info.equals("userLand")) {
			this.user_land(request, response);
		}
	}

	// ûעɹִи÷Զ¼Ĺ
	private void user_land(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		data = new OperationData(); // dataʵ
		String username = com.wy.tools.Encrypt.toChinese(request
				.getParameter("username")); // ҳлȡû
		UserInfo userInfo = data.user_query(username); // ûΪѯûϢһ
		request.getSession().setAttribute("userInfo", userInfo); // ûϢsession
		request.getRequestDispatcher("index.jsp").forward(request, response); // صҳ
	}

	// ûɲִи÷ʵûעĹ
	private void user_cannle(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		if (null != request.getSession().getAttribute("userInfo")) {
			request.getSession().invalidate(); // ʵsessionٵĲ
		}
		request.getRequestDispatcher("index.jsp").forward(request, response); // ҳ
	}

	// ʵû¼
	private void user_check(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		data = new OperationData();
		String username = com.wy.tools.Encrypt.toChinese(request
				.getParameter("username")); // ȡҳû
		String password = com.wy.tools.Encrypt.encode(request
				.getParameter("password")); // ȡҳе
		UserInfo userInfo = data.user_query(username); // ûΪвѯûϢһ
		String code = request.getParameter("code"); // ȡҳеУ
		String codeSession = (String) request.getSession().getAttribute("rand"); // ȡͻsessionеУ
		if (code.equals(codeSession)) {
			if (null != userInfo) {				
				if (userInfo.getPassword().equals(password)) {
					request.getSession().setAttribute("userInfo", userInfo);
				}
			}
		}

		request.getRequestDispatcher("index.jsp").forward(request, response);
	}

	// ʵûעṦ
	private void user_save(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		response.setContentType("text/html;charset=GBK");
		PrintWriter out = response.getWriter();
		data = new OperationData();
		UserInfo userInfo = new UserInfo();
		userInfo.setUsername(com.wy.tools.Encrypt.toChinese(request
				.getParameter("username"))); // ȡͻûϢı
		userInfo.setPassword(com.wy.tools.Encrypt.encode(request
				.getParameter("password"))); // ȡͻϢı
		userInfo.setRealname(com.wy.tools.Encrypt.toChinese(request
				.getParameter("realname"))); // ȡͻʵı
		userInfo.setEmail(request.getParameter("email")); // ȡͻemailַı
		userInfo.setQuestion(com.wy.tools.Encrypt.toChinese(request
				.getParameter("question"))); // ȡͻı
		userInfo.setResult(com.wy.tools.Encrypt.toChinese(request
				.getParameter("result"))); // ȡͻ˴𰸵ı
		String information = "";
		String code = request.getParameter("code"); // ȡͻ֤
		String codeSession = (String) request.getSession().getAttribute("rand"); // ȡͻsessionеУ
		if (code.equals(codeSession)) { // ж֤Ƿȷ
			if (!data.user_save(userInfo)) { // жûǷɹ
				information = "ûظעʧܣ";
			}
		} else {
			information = "У벻ȷעʧܣ";
		}
		if (information.equals("")) { // informationжûĵ¼
			information = "ûעɹ";
			String username = com.wy.tools.Encrypt.toChinese(request
					.getParameter("username"));
			request.setAttribute("information", information); // ûעrequestΧ
			request.setAttribute("username", username); // ûrequestΧ
			request.getRequestDispatcher("user_save.jsp").forward(request,
					response);
		}
		out.print("<script language=javascript>alert('" + information
				+ "');history.go(-1);</script>"); // ûעʧܣҳ潫תһҳ
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		this.doGet(request, response);

	}

}
