﻿using System;
using System.Data;
using System.Data.SqlClient;
using DBUtility;

namespace DAL
{
    //获得更有效最新技术源码看这里：http://www.51aspx.com/
    /// <summary>
    /// 数据访问类:Article
    /// </summary>
    public partial class Article
    {
        public Article()
        { }

        #region  Method
        /// <summary>
        ///  增加一条数据
        /// </summary>
        public static int Add(Model.Article model)
        {
            int rowsAffected;
            SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@Title", SqlDbType.NVarChar,128),
					new SqlParameter("@Con", SqlDbType.NText),
					new SqlParameter("@Source", SqlDbType.NVarChar,64),
					new SqlParameter("@Time", SqlDbType.DateTime),
					new SqlParameter("@Hits", SqlDbType.Int,4)};
            parameters[0].Direction = ParameterDirection.Output;
            parameters[1].Value = model.Title;
            parameters[2].Value = model.Con;
            parameters[3].Value = model.Source;
            parameters[4].Value = model.Time;
            parameters[5].Value = model.Hits;

            DbHelperSQL.RunProcedure(PubConstant.ConnectionString, "Article_ADD", parameters, out rowsAffected);
            return (int)parameters[0].Value;
        }

        /// <summary>
        ///  更新一条数据
        /// </summary>
        public static bool Update(Model.Article model)
        {
            int rowsAffected = 0;
            SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4),
					new SqlParameter("@Title", SqlDbType.NVarChar,128),
					new SqlParameter("@Con", SqlDbType.NText),
					new SqlParameter("@Source", SqlDbType.NVarChar,64),
					new SqlParameter("@Time", SqlDbType.DateTime),
					new SqlParameter("@Hits", SqlDbType.Int,4)};
            parameters[0].Value = model.Id;
            parameters[1].Value = model.Title;
            parameters[2].Value = model.Con;
            parameters[3].Value = model.Source;
            parameters[4].Value = model.Time;
            parameters[5].Value = model.Hits;

            DbHelperSQL.RunProcedure(PubConstant.ConnectionString, "Article_Update", parameters, out rowsAffected);
            if (rowsAffected > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public static bool Delete(int Id)
        {
            int rowsAffected = 0;
            SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)
			};
            parameters[0].Value = Id;

            DbHelperSQL.RunProcedure(PubConstant.ConnectionString, "Article_Delete", parameters, out rowsAffected);
            if (rowsAffected > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }
        //获得更有效最新技术源码看这里：http://www.51aspx.com/
        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public static Model.Article GetModel(int Id)
        {
            SqlParameter[] parameters = {
					new SqlParameter("@Id", SqlDbType.Int,4)
			};
            parameters[0].Value = Id;

            Model.Article model = new Model.Article();
            DataSet ds = DbHelperSQL.RunProcedure(PubConstant.ConnectionString, "Article_GetModel", parameters, "ds");
            if (ds.Tables[0].Rows.Count > 0)
            {
                return DataRowToModel(ds.Tables[0].Rows[0]);
            }
            else
            {
                return null;
            }
        }

        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        private static Model.Article DataRowToModel(DataRow row)
        {
            Model.Article model = new Model.Article();
            if (row != null)
            {
                if (row["Id"] != null && row["Id"].ToString() != "")
                {
                    model.Id = int.Parse(row["Id"].ToString());
                }
                if (row["Title"] != null)
                {
                    model.Title = row["Title"].ToString();
                }
                if (row["Con"] != null)
                {
                    model.Con = row["Con"].ToString();
                }
                if (row["Source"] != null)
                {
                    model.Source = row["Source"].ToString();
                }
                if (row["Time"] != null && row["Time"].ToString() != "")
                {
                    model.Time = DateTime.Parse(row["Time"].ToString());
                }
                if (row["Hits"] != null && row["Hits"].ToString() != "")
                {
                    model.Hits = int.Parse(row["Hits"].ToString());
                }
            }
            return model;
        }
        #endregion  MethodEx
    }
}
