﻿using System;
using System.Data;
using System.Data.SqlClient;
using DBUtility;

namespace DAL
{
    public class Pager
    {
        public Pager()
        {
        }
        //获得更有效最新技术源码看这里：http://www.51aspx.com/
        /// <summary>
        /// 获取数据列表
        /// </summary>
        /// <param name="cols">列名集合</param>
        /// <param name="table">表名</param>
        /// <param name="strWhere">条件</param>
        /// <returns></returns>
        public static DataTable GetPager(string cols, string table, string strWhere)
        {
            using (SqlDataAdapter sda = new SqlDataAdapter())
            {
                SqlParameter[] param = new SqlParameter[]
                {
                    new SqlParameter("@cols",cols),
                    new SqlParameter("@table",table),
                    new SqlParameter("@strWhere",strWhere)
                };

                sda.SelectCommand = DbHelperSQL.GetCommand(PubConstant.ConnectionString, "UP_T_GetTableByStrWhere", param);
                using (DataSet ds = new DataSet())
                {
                    sda.Fill(ds);
                    return ds.Tables[0];
                }
            }
        }
        //获得更有效最新技术源码看这里：http://www.51aspx.com/
        /// <summary>
        /// 获得数据列表
        /// </summary>
        /// <param name="PageSize">显示多少条</param>
        /// <param name="PageIndex">第几页</param>
        /// <param name="strWhere">条件</param>
        /// <param name="orderby">排序</param>
        /// <param name="tablename">表名</param>
        /// <param name="cols">列名集合</param>
        /// <returns></returns>
        public static DataTable GetPager(int PageSize, int PageIndex, string strWhere, string orderby, string tablename, string cols)
        {
            using (SqlDataAdapter sda = new SqlDataAdapter())
            {
                SqlParameter[] pa = new SqlParameter[6];
                pa[0] = new SqlParameter("@PageSize", PageSize);
                pa[1] = new SqlParameter("@PageIndex", PageIndex);
                pa[2] = new SqlParameter("@orderby", orderby);
                pa[3] = new SqlParameter("@strWhere", strWhere);
                pa[4] = new SqlParameter("@tablename", tablename);
                pa[5] = new SqlParameter("@cols", cols);
                sda.SelectCommand = DbHelperSQL.GetCommand(PubConstant.ConnectionString, "UP_T_GetPager", pa);
                using (DataSet ds = new DataSet())
                {
                    sda.Fill(ds);
                    return ds.Tables[0];
                }
            }
        }
    }
}
