﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="keywords" content="Asp.net数据抓取" />
    <meta name="description" content="Asp.net数据抓取" />
    <title>Asp.net数据抓取</title>
    <link href="CSS/style.css" rel="stylesheet" type="text/css" media="screen" charset="utf-8" />
    <script src="Scripts/jquery.js" type="text/javascript" charset="utf-8"></script>
    <script src="Scripts/global.js" type="text/javascript" charset="utf-8"></script>
    <script src="Scripts/modal.js" type="text/javascript" charset="utf-8"></script>
</head>
<body>
    <form id="form1" runat="server">
    <div id="wrapper">
        <div id="minwidth">
            <div id="holder">
                <div id="menu">
                    <div id="left">
                    </div>
                    <div id="right">
                    </div>
                    <ul>
                        <li><a href="Default.aspx" class="selected"><span>Index</span></a></li>
                    </ul>
                    <div class="clear">
                    </div>
                </div>
                <div id="submenu">
                    <div class="modules_left">
                        <div class="module buttons">
                            <a href="" class="dropdown_button"><small class="icon clipboard"></small><span>最新10条</span></a>
                            <div class="dropdown help_index">
                                <div class="arrow">
                                </div>
                                <div class="content">
                                    <div class="col w5">
                                        <asp:Repeater ID="repTop10" runat="server">
                                            <ItemTemplate>
                                                <a href="Detail.aspx?id=<%#DataBinder.Eval(Container.DataItem, "Id")%>" target="_blank">
                                                    <%#PageOperate.CutString(DataBinder.Eval(Container.DataItem, "Title"),30)%>
                                                </a>
                                                <hr />
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </div>
                                    <div class="clear">
                                    </div>
                                    <a class="button red right close"><small class="icon cross"></small><span>Close</span></a>
                                    <div class="clear">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="title">
                        数据抓取
                    </div>
                </div>
                <div id="desc">
                    <div class="body">
                        <div id="messages">
                        </div>
                        <div class="clear">
                        </div>
                        <div id="column" class="help">
                            <div class="demobg">
                                <div class="col w10 last">
                                    <div class="content">
                                        <p class="last" style="height: 28px;">
                                            <asp:DropDownList ID="ddlNewsSource" runat="server" Style="float: left;">
                                                <asp:ListItem Value="新浪">新浪</asp:ListItem>
                                                <asp:ListItem Value="搜狗">搜狗</asp:ListItem>
                                                <asp:ListItem Value="百度贴吧">百度贴吧</asp:ListItem>
                                            </asp:DropDownList>
                                            <asp:DropDownList ID="ddlNums" runat="server" Style="float: left; display: inline;">
                                                <asp:ListItem Value="10">10</asp:ListItem>
                                                <asp:ListItem Value="20">20</asp:ListItem>
                                                <asp:ListItem Value="30">30</asp:ListItem>
                                                <asp:ListItem Value="40">40</asp:ListItem>
                                            </asp:DropDownList>
                                            <asp:TextBox ID="txtWords" runat="server" Style="float: left;"></asp:TextBox>
                                            <asp:LinkButton ID="btnCrawl" runat="server" CssClass="button" Style="float: left;"
                                                OnClick="btnCrawl_Click">
                                            <span>Crawl Data</span></asp:LinkButton>
                                            <asp:Label ID="lblShow" runat="server" Text="" Style="float: left;"></asp:Label>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div id="table" class="help">
                            <h1>
                                列表:</h1>
                            <div class="col w10 last">
                                <div class="content">
                                    <table>
                                        <tr>
                                            <th>
                                                编号
                                            </th>
                                            <th>
                                                来源
                                            </th>
                                            <th>
                                                标题
                                            </th>
                                            <th>
                                                抓取内容
                                            </th>
                                            <th>
                                                点击率
                                            </th>
                                            <th>
                                                抓取时间
                                            </th>
                                        </tr>
                                        <asp:Repeater ID="repData" runat="server">
                                            <ItemTemplate>
                                                <tr id="id_1">
                                                    <td>
                                                        <%#DataBinder.Eval(Container.DataItem, "Id")%>
                                                    </td>
                                                    <td>
                                                        <%#DataBinder.Eval(Container.DataItem, "Source")%>
                                                    </td>
                                                    <td>
                                                        <%#PageOperate.CutString(DataBinder.Eval(Container.DataItem, "Title"),20)%>
                                                    </td>
                                                    <td>
                                                        <a href="Detail.aspx?id=<%#DataBinder.Eval(Container.DataItem, "Id")%>" target="_blank">
                                                            <%#Con(DataBinder.Eval(Container.DataItem, "Con").ToString(),30)%>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <%#DataBinder.Eval(Container.DataItem, "Hits")%>
                                                    </td>
                                                    <td>
                                                        <%#DataBinder.Eval(Container.DataItem, "Time","{0:yyyy-MM-dd HH:mm:ss}")%>
                                                    </td>
                                                </tr>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="body_footer">
                        <div id="bottom_left">
                            <div id="bottom_right">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="footer">
        <p class="last">
            Copyright 2009 - Asp.net Crawl Data
        </p>
    </div>
    </form>
</body>
</html>
