<%@ page language="java" import="java.util.*" pageEncoding="UTF-8"%>
<!DOCTYPE html>
<html> 
<head>
	<%@ include file="../../include/webLib.jsp" %>
</head>

<body>
	 <div title="网站信息修改">
	    <form id="WebEdit" method="post" enctype="multipart/form-data">
	    	<div class="content" >
	    		<div class="left">
		    		<ul class="font title">	
		    			<li class="name">网站标题:</li>
		    			<li><input class="easyui-validatebox" type="text" name="webTitle" data-options="field:'webTitle',missingMessage:'请输入标题',required:true"></input></li>
		    		</ul>
		    		<ul class="font">
		    			<li class="name">域名:</li>
		    			<li><input class="easyui-validatebox" type="text" name="webRealmName" data-options="field:'webRealmName',missingMessage:'请输入域名',required:true"></input></li>
		    		</ul>
		    		<ul class="font logo">
		    			<li class="name">Logo:</li>
		    			<li class="select"><input id="fileupload" style="width:68px; height:23px; _margin-left:5px;" type="file" name="files[]" data-options="required:true" multiple/></li>
		    			<li class="delete"><input id="del" class="select" name="deleteLogo" type="button" value="删除Logo" onclick="logo()"/></li>
		    		</ul>
					<ul class="font">
		    			<li class="name">关键字:</li>
		    			<li><input class="easyui-validatebox" type="text" name="webKeyword" data-options="field:'webKeyword',missingMessage:'请输入关键字',required:true"></input></li>
		    		</ul>
		    		<ul class="font">
		    			<li class="name">模板风格:</li>
		    			<li><input class="easyui-validatebox" type="text" name="webStyle" data-options="field:'webStyle',missingMessage:'请输入风格',required:true"></input></li>
		    		</ul> 
	    		</div>
	    		
	    		<!-- 显示所上传的LOGO -->
	    		<div id="right"><img class="img" src=""/></div>
	    		<div id="files" class="files"></div>
	    		
	    		<ul class="descrip">
	    			<li class="name area">描述:</li>
	    			<li><textarea name="webDescrip" data-options="field:'webDescrip'"></textarea></li>
	    		</ul>
    			<ul class="descrip">
	    			<li class="name area">版权:</li>
	    			<li><textarea name="webCopyright" data-options="field:'webCopyright'"></textarea></li>
    			</ul>
    			
    			<div class="footSpace"></div>
    			<div class="foot">
				    <div class="button">
				    	<a href="javascript:void(0)" class="easyui-linkbutton confirm" onclick="submitForm()">确定</a>
				    	<a href="javascript:void(0)" class="easyui-linkbutton reset" onclick="clearForm('#WebEdit')">重置</a>
				    </div>
				</div>
	    	</div>
	    </form>
	</div>
</body>

<script>  

	/*页面载入时就请求servlet，将Json数据显示到Jsp页面中*/
	$(function(){
		$.post("${base_url}/admin/webEdit",{t:new Date()},
		   function(data){
		    editWeb(data);
		   }, "json");
 	});
	//上传的图片路径	
	var test;	
	/*点击上传LOGO时请求UploadImgServlet,并将文件保存路径返回*/
	$('#fileupload').fileupload({
		url: "${base_url}/uploadImg",
		dataType: 'json',
    	done: function (e, data) {
    		test = data.result.files.url;
            $("#right img").attr("src",BASE_URL + data.result.files.url);
        }
	});
	    		
	

	function editWeb(data){
		$('#WebEdit').form('load',{
			webTitle:data.webTitle,
			webRealmName:data.webRealmName,
			files:data.webLogo,
			webKeyword:data.webKeyword,
			webStyle:data.webStyle,
			webDescrip:data.webDescrip,
			webCopyright:data.webCopyright
		}); 
			test = data.webLogo;
        	$("#right img").attr("src",BASE_URL + data.webLogo);
	}
	
	/*点击确定修改时执行保存修改信息的servlet，若修改成功，则弹出提示框*/
	function submitForm(){
		var temp = new Array();
		var index = new Array();
		var add = test;
		$(".content li input").each(function(i) {
			temp[i] = $(this).val();
		});
		$(".content li textarea").each(function(i) {
			index[i] = $(this).val();
		});
		$.ajax({
			type:"post",
			url:"${base_url}/webSave",
			dataType:"json",
			data:"webTitle=" + temp[0] + "&webRealmName=" + temp[1] + "&files[]=" 
					 + add + "&webKeyword=" + temp[4]+"&webStyle=" + temp[5]+"&webDescrip="
					+ index[0] + "&webCopyright=" + index[1],
		    success:function(data){
		    		switch(data.code){
		    			case 111:
		    				showFormMsg(SYSTEM_TITLE,"网站标题不能为空");
		    				break;
		    			case 120:
		    				showFormMsg(SYSTEM_TITLE,"标题长度为5—18个字符");
		    				break;
		    			case 112:
		    				showFormMsg(SYSTEM_TITLE,"网站域名不能为空");
		    				break;
		    			case 109:
		    				showFormMsg(SYSTEM_TITLE,"网站信息修改成功!");
		    				break;
		    		}	
		    	} 
		}); 
	}
	
	/*若不想要网站LOGO，可以按删除键进行删除，同时将Tomcat存放logo的文件夹清空，页面中的IMG框也消失*/
	function logo(){
		$('.img').addClass("remove");
		var add = test;
		$.ajax({
		   type: "POST",
		   url: "${base_url}/deleteLogo",
		   data: "deleteLogo="+add,
		   success: function(data){
		     	showFormMsg(SYSTEM_TITLE,"网站LOGO删除成功!若需要上传LOGO，请先刷新页面!");
		    }
		   });
		}
</script>
<style>
	.remove{ display:none;}
</style>

</html>
