﻿var easyUI = {//easyUI base support
	fpbind:function(){//function bind to object
		if(!Function.prototype.bind){
			Function.prototype.bind = function(obj){
				var owner = this,args = Array.prototype.slice.call(arguments),callobj = Array.prototype.shift.call(args);
				return function(e){e=e||top.window.event||window.event;owner.apply(callobj,args.concat([e]));};
			};
		}
	}(),
	IAHTML:function(){//insertAdjacentHTML by BlueDestiny ^_^
		if(document.documentElement.insertAdjacentHTML){return;}
		HTMLElement.prototype.insertAdjacentHTML = function(sWhere, sHTML){
			var df = null,r = this.ownerDocument.createRange();
			switch (String(sWhere).toLowerCase()) {
				case "beforebegin":
					r.setStartBefore(this);
					df = r.createContextualFragment(sHTML);
					this.parentNode.insertBefore(df, this);
					break;
				case "afterbegin":
					r.selectNodeContents(this);
					r.collapse(true);
					df = r.createContextualFragment(sHTML);
					this.insertBefore(df, this.firstChild);
					break;
				case "beforeend":
					r.selectNodeContents(this);
					r.collapse(false);
					df = r.createContextualFragment(sHTML);
					this.appendChild(df);
					break;
				case "afterend":
					r.setStartAfter(this);
					df = r.createContextualFragment(sHTML);
					this.parentNode.insertBefore(df, this.nextSibling);
					break;
			}
		};
	}(),
	ajax:{//xmlhttp request
		tryList:function(){
			var xhr = null;
			for(var i=0;i<arguments.length;i++){
				var lambda = arguments[i];
				try{xhr = lambda();}catch(e){}
				if(xhr){break;}
			}
			return xhr;
		},
		init:function(){
			return this.tryList(
				function(){try{return new ActiveXObject('MSXML2.XMLHttp.6.0');}catch(e){}},
				function(){try{return new ActiveXObject('MSXML2.XMLHttp.3.0');}catch(e){}},
				function(){try{return new XMLHttpRequest();}catch(e){}},
				function(){try{return new ActiveXObject('MSXML2.XMLHttp.5.0');}catch(e){}},
				function(){try{return new ActiveXObject('MSXML2.XMLHttp.4.0');}catch(e){}},
				function(){try{return new ActiveXObject('Msxml2.XMLHTTP');}catch(e){}},
				function(){try{return new ActiveXObject('MSXML.XMLHttp');}catch(e){}},
				function(){try{return new ActiveXObject('Microsoft.XMLHTTP');}catch(e){}}
				) || null;
		},
		post:function(sUrl,sArgs,bAsync,fCallBack,fFailure){
			var xhr = this.init();
			if(!xhr){alert('XmlHttp对象未就绪！');return;}
			xhr.onreadystatechange = function(){
				if(xhr.readyState == 4){
					if(xhr.status == 200){
						if(fCallBack&&fCallBack.constructor==Function){fCallBack(xhr);}
					}else{
						if(fFailure&&fFailure.constructor==Function){
							fFailure(xhr);
						}else{
							alert('服务器错误：'+xhr.status);
						}
						xhr = null;
					}
				}
			};
			xhr.open('POST',encodeURI(sUrl),bAsync);
			xhr.setRequestHeader('Content-Length',sArgs.length);
			xhr.setRequestHeader('Content-Type','application/x-www-form-urlencoded');
			xhr.send(sArgs);
		},
		get:function(sUrl,bAsync,fCallBack,fFailure){
			var xhr = this.init();
			if(!xhr){alert('XmlHttp对象未就绪！');return;}
			xhr.onreadystatechange = function(){
				if(xhr.readyState == 4){
					if(xhr.status == 200){
						if(fCallBack&&fCallBack.constructor==Function){fCallBack(xhr);}
					}else{
						if(fFailure&&fFailure.constructor==Function){
							fFailure(xhr);
						}else{
							alert('服务器错误：'+xhr.status);
						}
						xhr = null;
					}
				}
			};
			xhr.open('GET',encodeURI(sUrl),bAsync);
			xhr.send('Null');
		},
		xRequest:function(url,id){//取跨域数据，目标url,script标签id，省略则自动生成随机id
			id = id||'oscript'+Math.random().toString().replace(/\./g,'');
			var oScript = document.getElementById(id),head = document.getElementsByTagName("head").item(0);
			if (oScript){head.removeChild(oScript);}
			oScript = document.createElement("script");
			oScript.setAttribute("src", url);
			oScript.setAttribute("id",id);
			oScript.setAttribute("type","text/javascript");
			oScript.setAttribute("language","javascript");
			head.appendChild(oScript);
		}
	},
	contains:function(f,c){
		if(f==null){return false;}
		var bCB2F = false;
		if(f.contains){bCB2F = f.contains(c);}else{bCB2F = (f.compareDocumentPosition(c)==20)?true:false;}
		return bCB2F;
	},
	clearTxtNode:function(Elm){
		if(!Elm){return;}
		var dchilds = Elm.childNodes,dchild = null;
		for(var i=0;i<dchilds.length;i++){
			dchild = dchilds[i];
			if(dchild.nodeType==3&&!dchild.nodeValue.replace(/\s/g,'')){Elm.removeChild(dchild);}
		}
	},
	clearOutLine:function(sTag,dModule){
		if(!sTag||!dModule){return;}
		dModule = dModule||document;
		var da = dModule.getElementsByTagName(sTag),l = da.length,dtmp = null,fooFocus = function(){this.blur();};
		for(var i=0;i<l;i++){
			dtmp = da[i];
			dtmp.hideFocus = true;
			dtmp.style.outline = 'none';
			if(sTag.toLowerCase()==='input'&&/button|submit|reset/i.test(dtmp.type)){dtmp.onfocus=fooFocus;}
		}
	},
	checkForm:function(dForm,fooshowmsg,foosuccess){
		if(!dForm){return false;}
		var rules = {
			isFilled:function(s){return function($value){return $value.replace(/\s/g,"").length>0&&$value!=s;};},
			filter:function(s){return function($value){s = s?s.replace(/([\\,\^,\$,\*,\+,\?,\{,\},\.,\(,\),\[,\]])/g,'\\$1'):'(\\r\\n){1000}';var r = new RegExp('(?:'+s+')','i');return !r.test($value);};},
			isNaN:function(){return function($value){return (!$value)?true:isNaN($value);};},
			isNumber:function(){return function($value){return (!$value)?true:!isNaN($value);};},
			isInt:function(){return function($value){return (!$value)?true:parseInt($value,10)==$value;};},
			isEmail:function(){return function($value){return (!$value)?true:/^(?:\w[\w\-]*\.?)*\w+@(?:\w[\w\-]*\.{1})+\w+$/i.test($value);};},
			isEmailList:function(){return function($value){return (!$value)?true:/^(?!;)(?:(?:;|^)([^@.;])+@[^.@;]+(?:\.[^.@;]+)+)+$/i.test($value);};},
			fileType:function(list){return function($value){var r = new RegExp('\.(?:'+list+')$','i');return (!$value)?true:r.test($value);};},
			moreThan:function(n){return function($value){return (!$value)?true:$value*1>n;};},
			lessThan:function(n){return function($value){return (!$value)?true:$value*1<n;};},
			equalTo:function(n){return function($value){return (!$value)?true:$value*1==n;};},
			maxLength:function(n){return function($value){return (!$value)?true:!($value.length>n);};},
			minLength:function(n){return function($value){return (!$value)?true:!($value.length<n);};},
			sameValue:function(ids){return function(){var aos = ids.split(','),l = aos.length,dobj = null,iv = null,ret = true;for(var i=0;i<l;i++){dobj = document.getElementById(aos[i]);if(i==0){iv = dobj.value;}else{if(iv!=dobj.value){ret = false;break;}}}return ret;};}
		};
		var chkInput = function(dObj,fooshowmsg,foosuccess){
			for(var i=0,l=dObj.length;i<l;i++){
				var dT = dObj[i];
				var vr = dT.getAttribute('validate');//validate属性
				var vm = dT.getAttribute('msg');//msg 属性
				var $value = dT.value;//value
				if(vr){
					vr = vr.split(';');vm = vm.split(';');
					for(var n=0;n<vr.length;n++){
						var avr = vr[n].match(/^(\w+)\((.*)\)$/i);//匹配类似 fooName(xxx) 的字符串 
						var avrName = avr?avr[1]:vr[n];//fooName
						var avrArgs = avr?avr[2]:null;//xxx
						var msg = vm[n]?vm[n]:vm[vm.length-1];//alert message
						var EVR = (rules[avrName])?rules[avrName](avrArgs)($value):false;
						if(!EVR){
							if(fooshowmsg&&fooshowmsg.constructor==Function){
								fooshowmsg(dT,msg);
							}else{
								alert(msg);
							}
							dT.focus();
							return false;
						}
						if(foosuccess&&foosuccess.constructor==Function){foosuccess(dT);}
					}
				}
			}
			return true;
		};
		return chkInput(dForm.elements,fooshowmsg,foosuccess);
	},
	cssSelector:function(sSelector,dScope){
		if(!sSelector){return [];}
		dScope = dScope||document;
		var get = easyUI.getElementsBy;
		var getSB = function(node){
			if(!node){return false;}
			if(node.nodeType!=3){return node;}
			var d = node;
			while(d){
				d = d.nextSibling;
				if(!d){return false;}
				if(d.nodeType!=3){return d;}
			}
		};
		var each = function(dc,att){
			var l = dc.length,ret = [];
			if(l){
				if(att=='nextSibling'){
					for(var i=0;i<l;i++){ret.push(getSB(dc[i][att]));}
				}else{
					for(var i=0;i<l;i++){ret.push(dc[i][att]);}
				}
			}else{
				if(att=='nextSibling'){ret.push(getSB(dc[att]));}else{ret.push(dc[att]);}
			}
			return ret.slice(0);
		};
		var fooparse = function(s){
			//E[att^="val"],E[att$="val"],E[att*="val"],E[att~="val"],E[att|="val"],E[att!="val"],E[att="val"]
			var a = s.replace(/\[([^\=]*)\=?([^\]]*)\]/g,function(a,b,c){return c?';get("'+b+'","'+c.replace(/(?:0x20156)/g,' ')+'","*",dScope,1)':';get("'+b+'","","*",dScope,1)';});
			//E:enabled,E:disabled,E:checked,E:not(s)
			var b = a.replace(/:([^\s]*)/g,function(a,b){if(!b){return '';}switch(b){case 'enabled':return ';get("disabled","","*",dScope,1,1)';break;case 'disabled':return ';get("disabled","","*",dScope,1)';break;case 'checked':return ';get("checked","","*",dScope,1)';break;default:if(/not\(\.?([^\)]+)\)/i.test(b)){return ';get("class","'+RegExp.$1+'","*",dScope,1,1)';}return '';break;}});
			//+ E.class
			var c = b.replace(/\+([\w\-]*)(\.?)([\w\-]*)/g,function(a,b,c,d){return d?';get("class","'+d+'","'+b+'",each(dScope,"nextSibling"),1)':';get("","","'+b+'",each(dScope,"nextSibling"),1)';});
			//> E.class
			var d = c.replace(/\>([\w\-]*)(\.?)([\w\-]*)/g,function(a,b,c,d){return d?';get("class","'+d+'","'+b+'",each(dScope,"childNodes"),1)':';get("","","'+b+'",each(dScope,"childNodes"),1)';});
			//E.class
			var e = d.replace(/([\w\-]*)\.([\w\-]*)/g,function(a,b,c){return b?';get("class","'+c+'","'+b+'",dScope)':';get("class","'+c+'","*",dScope)';});
			//E#id
			var f = e.replace(/([\w\-]*)\#([\w\-]*)/g,function(a,b,c){return b?';get("id","'+c+'","'+b+'",dScope)':'document.getElementById("'+c+'")';});
			//E
			var g = f.replace(/^([\w\-]+)$/ig,';get("","","$1",dScope)');
			return g;
    		};
		var fooRun = function(list,dScope){
			var dScope = dScope,lScope = dScope?(dScope.length|0):0;
			while(list.length){
				var f = list.shift();
				if(!f){continue;}
				//alert('run: '+f+'\n\ndScope: '+dScope);
				dScope = eval(f);
				lScope = dScope.length;
				//alert('result:\n\n'+f+'\n\ndScope:'+dScope+'\n\ndScope.length:'+dScope.length);
			}
			return dScope.slice(0);
		};
		var aSelector = sSelector.split(','),args = [],ret = [];
		for(var i=0;i<aSelector.length;i++){
			aSelector[i] = aSelector[i].replace(/['"]/g,'').replace(/\s*\=\s*/g,'=').replace(/\[([^\=]*\=?)([^\]]*)\]/g,function(a,b,c){return c?'['+b+c.replace(/\s/g,'0x20156')+']':a;}).replace(/([\+\>\[\:])/g,' $1').replace(/([\#\.\+\:\]\>])\s*/g,'$1');
			args = aSelector[i].split(/\s/g);
			for(var n=0;n<args.length;n++){args[n] = fooparse(args[n]);}
			args = args.join('').split(';');
			ret = ret.concat(fooRun(args,dScope));
		}
		return ret.slice(0);
	},
	cross:{//跨模组交互事件注册及触发
		data:{},
		register:function(sTrigger,foo){
			if(!sTrigger||!foo){return;}
			if(!this.data[sTrigger]){this.data[sTrigger] = [];}
			this.data[sTrigger].push(foo);
		},
		trigger:function(sTrigger){
			if(!sTrigger){return;}
			var foolist = this.data[sTrigger];
			if(!foolist||!foolist.length){return;}
			var l = foolist.length,foo = null,args = Array.prototype.slice.call(arguments,1),ret = [];
			while(--l >= 0){
				foo = foolist[l];
				ret.push(foo.apply(null,args));
			}
			return ret.slice(0);
		}
	},
	deepClone:function(source){
		if(source===null){return null;}
		if(source===undefined){return undefined;}
		if(typeof(source)!='object'){return source;}
		if(source.constructor==Array){
			var ret = [];
			for(var i=0;i<source.length;i++){ret[i] = arguments.callee(source[i]);}
		}else{
			var ret = {};
			for(var d in source){ret[d] = arguments.callee(source[d]);}
		}
		return ret;
	},
	doWhileExist:function(smd,oFunction){
		if(smd==window||smd==document){oFunction(smd);return;}
		var d = (smd.constructor==String)?document.getElementById(smd):(smd.tagName)?smd:(smd.length)?smd:null;
		if(d){
			var l = d.length|0;
			if(!l){oFunction(d);}else{for(var i=0;i<l;i++){oFunction(d[i]);}}
		}
	},
	domEvent:function(){
		var swin = (this==window),stag = this.tagName,il = this.length;
		if(!swin&&!stag&&!il){return;}
		if(!swin&&il){for(var i=0;i<il;i++){arguments.callee.call(this[i]);}}
		this.eventList = {};
		this.bindEvent = function(sEvent,sFoo,cpt){
			if(!swin&&il){for(var i=0;i<il;i++){var di = this[i];di.bindEvent(sEvent,sFoo,cpt);}return;}
			var ael = this.eventList;if(!ael[sEvent]){ael[sEvent] = [];}
			var aels = ael[sEvent];for(var n=0;n<aels.length;n++){if(aels[n]==sFoo){return;}};aels.push(sFoo);
			if(document.attachEvent){this.attachEvent('on'+sEvent,sFoo);}else{this.addEventListener(sEvent,sFoo,cpt);}
		};
		this.removeEvent = function(sEvent,sFoo,cpt){
			if(!swin&&!stag&&il){for(var i=0;i<il;i++){var di = this[i];di.removeEvent(sEvent,sFoo,cpt);}return;}
			var aels = this.eventList[sEvent];for(var n=0;n<aels.length;n++){if(aels[n]==sFoo){aels.splice(n,1);break;}}
			if(document.attachEvent){this.detachEvent ('on'+sEvent,sFoo);}else{this.removeEventListener(sEvent,sFoo,cpt);}
		};
		var cleanup = function(){
			var ael = this.eventList;for(var evt in ael){this['on'+evt] = null;};
			this.eventList = null;this.bindEvent = null;this.removeEvent = null;
			if(document.attachEvent){window.detachEvent('onunload',cleanup);}else{window.removeEventListener('unload',cleanup,false);}
		};
		(function(){if(document.attachEvent){window.attachEvent('onunload',cleanup);}else{window.addEventListener('unload',cleanup,false);}})();
	},
	getArgs:function(){
		var sarg = document.location.search.substr(1),rv={};
		rv.filename = document.location.pathname.replace(/.*\//ig,'');
		if(!sarg){return rv;}
		var aarg = sarg.split('&'),atmp=[];
		for(var i=0;i<aarg.length;i++){
			atmp = aarg[i].split('=');
			rv[atmp[0]] = atmp[1];
		}
		return rv;
	},
	getElementsBy:function(att,svalue,stag,dmodule,bcollection,binverse){
		var rd = [],l = dmodule?dmodule.length:0;
		if(!stag){return rd;}
		if(l&&dmodule.tagName.toLowerCase()!=='form'){
			for(var n=0;n<l;n++){if(!dmodule[n]){continue;}rd = rd.concat(arguments.callee(att,svalue,stag,dmodule[n],bcollection,binverse));}
			return rd;
		}
		if(att){
			var latt = att.length-1,matt = att.charAt(latt),rxp = null;
			switch(matt){
			case '^':
				att = att.substr(0,latt);
				rxp = new RegExp("^"+svalue,"i");
				break;
			case '$':
				att = att.substr(0,latt);
				rxp = new RegExp(svalue+"$","i");
				break;
			case '*':
				att = att.substr(0,latt);
				rxp = new RegExp(svalue,"i");
				break;
			case '|':
				att = att.substr(0,latt);
				rxp = new RegExp("^"+svalue+"\\b","i");
				break;
			case '!':
				att = att.substr(0,latt);
				rxp = new RegExp("^(?!"+svalue+"$)","i");
				break;
			case '~':
				att = att.substr(0,latt);
			default:
				rxp = new RegExp("\\b"+svalue+"\\b","i");
				break;
			}
		}
		var atts = att,ctag = true,hasatt = false,satt = null,btrue = false;
		if(atts=='class'&&(/msie[67]/i).test(navigator.appVersion.replace(/\s/g,''))){atts='classname'}
		if(bcollection){
			if(!att){
				btrue = (stag=='*'||stag.toLowerCase()==dmodule.tagName.toLowerCase());
				if(!binverse&&btrue){rd.push(dmodule);return rd;}
				if(binverse&&!btrue){rd.push(dmodule);return rd;}
			}else{
				hasatt = dmodule.getAttributeNode(att),hasatt=(hasatt&&hasatt.value)?hasatt.value:hasatt,hasatt=(hasatt)?(/false/i.test(hasatt))?false:true:false;
				satt = dmodule.getAttribute(atts),ctag = (stag=='*')?true:(dmodule.tagName.toLowerCase()==stag.toLowerCase());
				btrue = svalue?(ctag&&hasatt&&satt&&rxp.test(satt)):(ctag&&hasatt);
				if(!binverse&&btrue){rd.push(dmodule);return rd;}
				if(binverse&&!btrue){rd.push(dmodule);return rd;}
			}
		}else{
			var tmpd = dmodule.getElementsByTagName(stag),tmpdl = tmpd.length,i = 0;
			if(!tmpdl){return rd;}
			if(!att){
				for(i=0;i<tmpdl;i++){
					btrue = (stag=='*'||stag.toLowerCase()==tmpd[i].tagName.toLowerCase());
					if(!binverse&&btrue){rd.push(tmpd[i]);}
					if(binverse&&!btrue){rd.push(tmpd[i]);}
				}
			}else{
				for(i=0;i<tmpdl;i++){
					hasatt = tmpd[i].getAttributeNode(att),hasatt=(hasatt&&hasatt.value)?hasatt.value:hasatt,hasatt=(hasatt)?(/false/i.test(hasatt))?false:true:false;
					satt = tmpd[i].getAttribute(atts);
					btrue = svalue?hasatt&&satt&&rxp.test(satt):hasatt;
					if(!binverse&&btrue){rd.push(tmpd[i]),rxp.lastIndex = -1;}
					if(binverse&&!btrue){rd.push(tmpd[i]),rxp.lastIndex = -1;}
				}
			}
		}
		return rd;
	},
	getPosition:function(o){//取元素坐标
		var x = 0, y = 0;
		do{x += o.offsetLeft;y += o.offsetTop;}while((o=o.offsetParent));
		return {'x':x,'y':y};
	},
	getStyle:function(dom,stylename){//获得元素当前样式
		if(dom.currentStyle){
			return dom.currentStyle[stylename];
		}else{
			return window.getComputedStyle(dom,null).getPropertyValue(stylename);
		}
	},
	getTarget:function(e){
		e = e||window.event;
		return e.srcElement||e.target;
	},
	getWindowSize:function(){
		var bout = /(?:msie|chrome)/i.test(navigator.appVersion);
		var dd = document.documentElement,db = document.body;
		var sw = Math.max(dd.scrollWidth,db.scrollWidth),sh = Math.max(dd.scrollHeight,db.scrollHeight);
		if(!bout){
			return {width:window.innerWidth,height:window.innerHeight,scrollWidth:sw,scrollHeight:sh};
		}else{
			if(dd.clientHeight>dd.offsetHeight){
				return {width:dd.clientWidth,height:dd.clientHeight,scrollWidth:sw,scrollHeight:sh};
			}else{
				return {width:dd.offsetWidth,height:dd.offsetHeight,scrollWidth:sw,scrollHeight:sh};
			}
		}
	},
	maxwin:function(){
		window.moveTo(0,0);
		window.resizeTo(screen.availwidth,screen.availheight);
		if(window.dialogWidth){
			window.dialogWidth = window.screen.availWidth+"px";
			window.dialogHeight = window.screen.availHeight+"px";
			window.dialogTop = "0px";
			window.dialogLeft = "0px";
		}
	},
	queue:function(list,delay){
		window.setTimeout(function(){
			if(list.length>0){
				var foo = list.shift();
				foo();
				if(list.length>0){
					window.setTimeout(arguments.callee,delay);
				}
			}
		},delay);
	},
	setPosition:function(obj,x,y){//设置元素坐标
		obj.style.left = x + "px";
		obj.style.top = y + "px";
	},
	stopEvent:function(e){//阻止事件
		e = e||window.event;
		if(e.stopPropagation){e.stopPropagation();}else{e.cancelBubble = true;}//阻止冒泡
		if(e.preventDefault){e.preventDefault();}else{e.returnValue = false;}//阻止Event返回值
	},
	style:{
		formatClass:function(sCls){//格式化样式名
			return sCls?sCls.replace(/(?:^\s+|\s+$|(\s+))/g,function(a,b){return b?' ':''}):'';
		},
		hasClass:function(dObj,sCls){//检测DOM节点是否存在指定的样式名
			var sClass = dObj.className,r = new RegExp('(?:\\s|^)'+sCls+'(?:\\s|$)');
			return dObj && sCls && sClass && r.test(sClass);
		},
		addClass:function(dObj,sCls){//为DOM节点添加一个新的CSS样式名
			if(!dObj||!sCls){return;}
			var sClass = easyUI.style.formatClass(dObj.className);
			if(!sClass){
				dObj.className = sCls;
				return;
			}
			if(!easyUI.style.hasClass(dObj,sCls)){
				dObj.className = sClass+' '+sCls;
			}
		},
		addRule:function(){//添加新的css规则
			var idx = 0;
			return function(d,s,v){
				if(d.addRule){d.addRule(s,v);}else{d.insertRule(s+'{'+v+'}',idx++);}
			};
		}(),
		getStyleSheet:function(n){//获取第n个styleSheet
			var ds = document.styleSheets,l = ds.length;
			if(n==null){n=l-1;}
			return l?ds[n]:undefined;
		},
		newStyleSheet:function(){//创建新的styleSheet
			if(document.createStyleSheet){return document.createStyleSheet();}
			var ds = document.createElement('style');
			ds.type='text/css';
			document.getElementsByTagName('head')[0].appendChild(ds);
			return document.styleSheets[document.styleSheets.length-1];
		},
		removeClass:function(dObj,sCls){//移除DOM节点指定的CSS样式名
			if(!dObj||!sCls){return;}
			var sClass = easyUI.style.formatClass(dObj.className),aClass;
			if(!sClass){return;}
			aClass = sClass.split(' ');
			for(var i in aClass){
				if(sCls===aClass[i]){aClass.splice(i,1);}
			}
			dObj.className = aClass.join(' ');
		}
	},
	toJSON:function(obj){
		var objco = (obj.constructor==Object),objca = (obj.constructor==Array),ret = [],sobj = null,acfoo = arguments.callee;
		if(!objco&&!objca){return obj.toString();}
		var toString = function(cobj,ot){
			if(!cobj){
				cobj = cobj===undefined?'undefined':(cobj===null?'null':(cobj===false?'false':(cobj===0?'0':(cobj===''?'\'\'':'NaN'))));
				if(ot){ret.push(d+':'+cobj)}else{ret.push(cobj);};return;
			}
			switch(cobj.constructor){
				case Array:
				case Object:if(ot){ret.push(d+':'+acfoo(cobj))}else{ret.push(acfoo(cobj))};break;
				case String:if(ot){ret.push(d+':\''+cobj.toString()+'\'')}else{ret.push('\''+cobj.toString()+'\'')};break;
				default:if(ot){ret.push(d+':'+cobj.toString())}else{ret.push(cobj.toString())};
			}
		};
		if(objco){for(var d in obj){sobj = obj[d];toString(sobj,true);}}
		if(objca){for(var i=0;i<obj.length;i++){sobj = obj[i];toString(sobj,false);}}
		obj = null;sobj = null;acfoo = null;
		return (objco)?'{'+ret.toString()+'}':(objca)?'['+ret.toString()+']':obj.toString();
	}
};