/*
MySQL Data Transfer
Source Host: localhost
Source Database: a
Target Host: localhost
Target Database: a
Date: 2013/11/21 20:59:33
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for ms_article
-- ----------------------------
DROP TABLE IF EXISTS `ms_article`;
CREATE TABLE `ms_article` (
  `article_id` int(11) NOT NULL AUTO_INCREMENT,
  `article_title` varchar(180) NOT NULL,
  `article_content` text NOT NULL COMMENT '最少30个字符',
  `article_author` varchar(120) DEFAULT NULL,
  `article_type` int(11) NOT NULL,
  `article_source` varchar(500) DEFAULT NULL COMMENT '文章的来源 ：可以是链接地址 可以为空',
  `article_date` date NOT NULL COMMENT '文章最后修改的时间为准  ',
  `article_img` varchar(500) DEFAULT NULL,
  `article_flag` int(1) DEFAULT NULL,
  PRIMARY KEY (`article_id`),
  KEY `FK_Reference_1` (`article_type`),
  CONSTRAINT `FK_Reference_1` FOREIGN KEY (`article_type`) REFERENCES `ms_articletype` (`articletype_id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ms_articletype
-- ----------------------------
DROP TABLE IF EXISTS `ms_articletype`;
CREATE TABLE `ms_articletype` (
  `articletype_id` int(11) NOT NULL AUTO_INCREMENT,
  `articletype_pid` int(11) NOT NULL COMMENT '0:根节点  大于0:代表子节点',
  `articletype_name` varchar(120) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `articletype_url` varchar(500) DEFAULT NULL,
  `articletype_keyword` varchar(500) DEFAULT NULL,
  `articletype_descrip` varchar(500) DEFAULT NULL COMMENT '对栏目关键字的扩展，吸引客户或引起浏览者的兴趣。',
  `articletype_cover_tem` varchar(500) DEFAULT NULL,
  `articletype_list_tem` varchar(500) DEFAULT NULL,
  `articletype_news_tem` varchar(500) DEFAULT NULL,
  `articletype_quality` int(11) DEFAULT NULL COMMENT '1:',
  `articletype_content` text,
  PRIMARY KEY (`articletype_id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ms_comment
-- ----------------------------
DROP TABLE IF EXISTS `ms_comment`;
CREATE TABLE `ms_comment` (
  `com_id` int(11) NOT NULL AUTO_INCREMENT,
  `com_user_id` int(11) NOT NULL,
  `com_user_ip` varbinary(30) NOT NULL,
  `com_news_id` int(11) NOT NULL,
  `com_content` text NOT NULL,
  `com_date` date NOT NULL,
  PRIMARY KEY (`com_id`),
  KEY `FK_Reference_2` (`com_news_id`),
  CONSTRAINT `FK_Reference_2` FOREIGN KEY (`com_news_id`) REFERENCES `ms_article` (`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ms_user
-- ----------------------------
DROP TABLE IF EXISTS `ms_user`;
CREATE TABLE `ms_user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varbinary(30) NOT NULL COMMENT '最少长度3个字符',
  `user_password` varbinary(30) NOT NULL COMMENT '长度6-12',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for ms_web
-- ----------------------------
DROP TABLE IF EXISTS `ms_web`;
CREATE TABLE `ms_web` (
  `web_id` int(11) NOT NULL AUTO_INCREMENT,
  `web_title` varchar(120) NOT NULL COMMENT '网站的标题 ：最小长度为4个字符',
  `web_realm_name` varchar(120) NOT NULL COMMENT '例如：www.',
  `web_logo` varchar(120) NOT NULL COMMENT '网站域名 链接地址。。。+图片名',
  `web_keyword` varchar(500) NOT NULL COMMENT '一个网站给首页设定的以便用户通过搜索引擎能搜到本网站的词汇，如：软件，科技，等等。',
  `web_descrip` varchar(500) NOT NULL COMMENT '根据公司的产品、联系方式写一些吸引客户的语句,最重要的要包含一些关键词。',
  `web_copyright` varchar(500) NOT NULL COMMENT '版权信息：图片的所有权、版权和著作权归作者',
  `web_style` varbinary(300) NOT NULL COMMENT '网站风格 ： 链接地址指向网站风格的模版',
  PRIMARY KEY (`web_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='系统设置';

-- ----------------------------
-- Records 
-- ----------------------------
INSERT INTO `ms_article` VALUES ('1', '中国国家博物馆 中国当代工艺美术双年展  ', '<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">&nbsp;&nbsp; 为了弘扬中华民族文化，推动社会主义文化大发展大繁荣，展示中国工艺美术事业发展成果，宣传和表彰在当代工艺美术创作领域中取得卓越成就的工艺美术工作者。数字虚拟技术将此次展览记录并永久保存，成为珍贵的历史档案。360度全方位的展示展馆，立体、生动、光影效果强烈。实现各展厅、展品之间漫游观看。并配以地图，使用帮助和菜单，易于快速使用操作。</span> \r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\"><img src=\"http://www.ming-soft.com/uploads/allimg/121014/1H62J132-0.jpg\" /><br />\r\n</span> \r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\"><span style=\"color:#FF0000;font-family:Arial;line-height:normal;background-color:#F8F9FB;\">展厅加载中...</span><br />\r\n</span> \r\n</p>', 'CYX', '14', '', '2013-11-21', '/upload/1385017174498.jpg', '0');
INSERT INTO `ms_article` VALUES ('3', '中国美术馆 大器“玩”成——中国美术馆藏民间', '<p>\r\n	<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">&nbsp; 每年6月是我国“文化遗产日”活动举办的时间，也正值儿童节和暑假来临的日子。为向广大观众，特别是少年儿童宣扬非物质文化遗产的保护与传承意识，加强对自身文化的认知，我馆特策划“大器‘玩’成——中国美术馆藏民间玩具精品陈列”，作为隆重的节日献礼。</span> \r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\"><img src=\"http://ming-soft.com/uploads/allimg/121014/1JR924G-0.jpg\" /><br />\r\n</span> \r\n</p>\r\n<p>\r\n	<span style=\"color:#FF0000;font-family:Arial;line-height:normal;background-color:#F8F9FB;\">展厅加载中...</span> \r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\"><br />\r\n</span> \r\n</p>', 'cyx', '14', '', '2013-11-21', '/upload/1385017220676.jpg', '0');
INSERT INTO `ms_article` VALUES ('5', '陶瓷展示', '<p>\r\n	<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\"><img src=\"http://www.ming-soft.com/uploads/allimg/121015/1-1210150U9590-L.jpg\" alt=\"让艺术品360自动旋转，同时用户也可以用鼠标来左右进行控制的看作品的各个细节，方便使用放大功能。更细致的观看作品画\" /><br />\r\n</span> \r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">让艺术品360自动旋转，同时用户也可以用鼠标来左右进行控制的看作品的各个细节，方便实用的放大功能。更细致的观看作品画面的线条。同时作品的照片经过加密处理用户不能轻易的进行复制。</span> \r\n</p>', 'cyx', '14', '', '2013-11-21', '/upload/1385017243244.jpg', '0');
INSERT INTO `ms_article` VALUES ('6', '中南集团企业ERP', '<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	景德镇中南担保投资集团公司是在原景德镇中南担保投资公司部分单位的基础上组建而成的大型集团企业，注册号：36020210007428。主要经营范围：新能源开发、货款担保、工程招投标担保、履约担保；房地产投资、开发、经营；实业投资；企业资产管理、财务咨询、融资中介服务等。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	　　景德镇中南担保投资集团公司实施以集团公司、分（子）公司、基层企业三级责任主体为基础的集团化管理体制和运作模式。集团公司相继成立了景德镇中南置业有限公司、景德镇景禹新能源开发有限公司、景德镇富锦动力物资有限公司、景德镇得力财务咨询有限公司等专业公司。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	集团公司下设理财部、综合部、投资部、资金管理部、业务拓展部及风险监控审核部。集团公司的经营宗旨是：以担保和投资为手段，促进企业技术进步和科技成果转化，推进中小企业的创立与发展；提升企业信用，促进资产融通和商品流通，提高资源配置效率，推进社会信用体系建设，为市场经济和社会发展服务。公司初步形成了以担保、投资为主导，涵盖资产管理、咨询、投资顾问、风险投资、基金管理、证券、环保、软件等多个领域的集约经营模式。集团公司的成立使中小企业通过担保公司向银行争取宝贵的生产流动资产成为可能，同时也使银行在经营传统信贷业务中大大降低了风险，简化了贷款发放过程在繁杂环节，从而使企业、银行、担保公司三者相互依靠、共同发展，开创新的融资担保形式。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	本公司领导层均具有资深企业管理实践经验和丰富的企业资产管理经验，且拥有一支在国内投融资行业运作多年的精英团队，具备健全的内部管理制度，对受保项目具有完善的保前评估、保中监控、保后服务与处置机制。籍以自身强大的团队实力和在国内资本市场丰富的运作经验，不但熟悉资本运作的每一过程，而且了解全国地区企业的需求，拥有雄厚的融资实力，是广大中小企业、投资者迈向资本市场不可多得的桥梁。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	发展目标：力争成为一个拥有雄厚资本实力、优秀管理团队、独特企业文化和国内一流品牌的专业化风险投资基金管理公司。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	运作模式：遵循“专家管理、科学决策、组合投资、分散风险”原则，按风险投资基金的模式进行运作。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	第一、 拥有一批高素质、具有丰富投资管理经验和创新意识的风险投资专业人才队伍。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	第二、 由公司的投资部门按照项目投资的规范要求具体负责项目的规范要求具体负责负责项目的初选、投资分析、投资计划、投资实施、跟踪投资进程以及投资退出的工作。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	第三、 聘请国内各行业知名专家组成专家委员会，负责对投资项目的技术前景及市场前景进行评审。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	第四、 投资决策委员会及公司董事会根据专家委员会的评审意见及投资部门所作的投资建议书进行集体决策。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	第五、 与各大商业银行保持着良好的融资业务关系，借助资金和项目的有效融通帮银行降低货款风险，替企业分担信用责任，增加企业融资渠道，沟通项目建设信息，密切社会投资关系为增强社会信用、规范借贷关系贡献力量。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	扶持方式：公司对所投资的企业除提供资金支持外，还协助企业提高管理水平，全方位扶持企业成长。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	投资战略：在规模投资、精品投资和科学投资理念的指导下，重点投资于景德镇周边的具有巨大成长潜力、市场前景良好的创业项目。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	管理战略：强化已投项目的资源整合和产品链条构造，为企业提高管理咨询和财务顾问服务，打通资本市场业务通道，实现风险资本多种形式的退出。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	人才战略：探索具有中国特色的人力资本激励与约束机制，吸引一批优秀专业人才加盟，通过多种形式的业务培训与学习，培养一支高素质的人才队伍。\r\n</div>\r\n<div style=\"margin:0px;padding:0px;font-size:14px;font-family:Verdana, Arial, Tahoma;color:#666666;background-color:#F8F9FB;\">\r\n	集团公司秉承“与客户共发展、与员工共进取”的经营理念，愿为有志之士成就精彩人生，与谋大事者共创辉煌伟业！\r\n</div>\r\n<p>\r\n	集团公司子公司：　中南置业 &nbsp; 景禹新能源 &nbsp; 文通矿业 &nbsp;富锦动\r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1GF0O51-0.gif\" /> \r\n</p>', '', '15', '', '2013-11-21', '/upload/1385017253143.jpg', '0');
INSERT INTO `ms_article` VALUES ('7', '浙江日报', '<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">资料整理中...</span>', '', '16', '', '2013-11-21', '/upload/1385017262683.jpg', '0');
INSERT INTO `ms_article` VALUES ('8', '袁世文', '<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/130408/1-13040PZ93EZ.jpg\" width=\"592\" height=\"323\" alt=\"\" /> \r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">网站地址：www.yswds.com</span><br />\r\n<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">上线时间：2013年4月5日</span> \r\n</p>', '', '17', '', '2013-11-21', '/upload/1385017270918.jpg', '0');
INSERT INTO `ms_article` VALUES ('9', '宁钢艺术博物馆', '<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121128/1-12112PU4280-L.jpg\" width=\"592\" height=\"328\" alt=\"\" /> \r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	网站地址：www.ninggangart.com\r\n</p>\r\n<p>\r\n	上线时间：2012年5月1日\r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '', '17', '', '2013-11-21', '/upload/1385017281759.jpg', '0');
INSERT INTO `ms_article` VALUES ('10', '冯林华', '<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/130408/1-13040PZ441602.jpg\" width=\"592\" height=\"328\" alt=\"\" /> \r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">网站地址：www.jdzflh.com</span><br />\r\n<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">上线时间：2013年3月30日</span> \r\n</p>', '', '17', '', '2013-11-21', '/upload/1385017289804.jpg', '0');
INSERT INTO `ms_article` VALUES ('11', '品米无线传媒', '<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">项目名称:品米无线传媒开发</span><br />\r\n<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">工具:dreamweaver</span><br />\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">网站访问地址:</span><a href=\"http://pinmiad.ming-soft.net/\">http://pinmiad.ming-soft.net/</a> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121027/1-12102G05244147.jpg\" /> \r\n</p>', 'cyx', '17', '', '2013-11-21', '/upload/1385017301675.gif', '0');
INSERT INTO `ms_article` VALUES ('12', '华贵门业', '<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:14px;\"><a href=\"http://304door.com/\">项目名称:华贵门业<br />\r\n开发工具:dreamweaver<br />\r\n</a></span> \r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:14px;\"><a href=\"http://304door.com/\">网站访问地址:http://304door.com/</a></span> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-1210141I01X45.gif\" /> \r\n</p>', 'cyx', '17', '', '2013-11-21', '/upload/1385017309480.gif', '0');
INSERT INTO `ms_article` VALUES ('13', '朱彬-学院派青年陶艺家', '<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">项目名称:朱彬学院派青年陶艺家</span><br />\r\n<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">开发工具:dreamweaver</span><br />\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">网站访问地址:</span><u><span><a href=\"http://zhubinart.com/cn_zhubinart/\">http://zhubinart.com/cn_zhubinart/</a><br />\r\n</span></u> \r\n</p>\r\n<p>\r\n	<u><img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-1210141HF05O.gif\" /><br />\r\n</u> \r\n</p>', 'cyx', '17', '', '2013-11-21', '/upload/1385017319796.gif', '0');
INSERT INTO `ms_article` VALUES ('14', '景德镇近现代陶瓷研究所', '<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-1210141335534V.jpg\" /> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-12101413361a02.jpg\" /> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-12101413363Q41.jpg\" /> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-121014133A2E5.jpg\" /> \r\n</p>', 'cyx', '17', '', '2013-11-21', '/upload/1385017363531.gif', '0');
INSERT INTO `ms_article` VALUES ('15', '景德镇谷神陶瓷', '<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">项目名称:景德镇谷神陶瓷</span><br />\r\n<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">开发工具:dreamweaver</span><br />\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">网站访问地址:</span><a href=\"http://www.jdzgushen.com/\" target=\"_blank\">http://www.jdzgushen.com/</a> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1330025943-0.png\" width=\"592\" height=\"356\" alt=\"\" /> \r\n</p>', 'cyx', '17', '', '2013-11-21', '/upload/1385017376533.gif', '0');
INSERT INTO `ms_article` VALUES ('16', '潮州市艺之莲古瓷', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	项目名称:潮州市艺之莲古瓷\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	开发工具:dreamweaver\r\n</p>\r\n<p>\r\n	网站访问地址:<a href=\"http://www.yzlgc.com/\" target=\"_blank\">http://www.yzlgc.com</a> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/132T03261-0.png\" width=\"592\" height=\"273\" alt=\"\" /> \r\n</p>\r\n<p>\r\n	<br />\r\n</p>', 'cyx', '17', '', '2013-11-21', '/upload/1385017389988.gif', '0');
INSERT INTO `ms_article` VALUES ('17', '景德镇市美术协会', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	项目名称:景德镇市美术协会<br />\r\n开发工具:dreamweaver<br />\r\n网站访问地址:<a href=\"http://www.jdzmx.com/\" target=\"_blank\">www.jdzmx.com</a> \r\n</p>\r\n<div>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1326362B4-0.png\" alt=\"江西省软件外包，江西软件开发培训，江西软件开发实训中心，江西软件开发，江西软件公司，江西软件外包开发\" /><br />\r\n</div>', 'cyx', '17', '', '2013-11-21', '/upload/1385017404186.gif', '0');
INSERT INTO `ms_article` VALUES ('19', '镇尚三宝', '<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">项目名称:镇尚三宝</span><br />\r\n<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">开发工具:dreamweaver</span><br />\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\">网站访问地址:</span><a href=\"http://www.zhenshangsanbao.com/\" target=\"_blank\">http://www.zhenshangsanbao.com</a> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-1210141322404V.jpg\" width=\"592\" height=\"357\" alt=\"\" /> \r\n</p>', 'cyx', '17', '', '2013-11-21', '/upload/1385017417000.gif', '0');
INSERT INTO `ms_article` VALUES ('21', '温州市百超精密钣金有限公司网站', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	项目名称:温州市百超精密钣金有限公司网站\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	开发工具:dreamweaver\r\n</p>\r\n<p>\r\n	网站访问地址:<a href=\"http://www.wzbcbj.com/\" target=\"_blank\">www.wzbcbj.com</a> \r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/121014/131U5OP-0.png\" width=\"592\" height=\"381\" alt=\"\" /> \r\n</p>\r\n<p>\r\n	<br />\r\n</p>', 'cyx', '17', '', '2013-11-21', '/upload/1385017431177.gif', '0');
INSERT INTO `ms_article` VALUES ('23', '铭飞与中国通信服务江西景德镇分公司签订合同', '<span style=\"font-family:Arial;font-size:medium;line-height:25px;background-color:#F8F9FB;\">《景德镇铭飞科技有限公司》于2013年1月4日已和《中国通信服务江西景德镇分公司》达成合作并签定合同，合作内容：景德镇铭飞科技有限公司负责为</span><span style=\"background-color:#F8F9FB;\">中国通信服务江西景德镇分公司</span><span style=\"font-family:Arial;font-size:medium;line-height:25px;background-color:#F8F9FB;\">开发景通服数据表系统软件。</span><br />\r\n<br />\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:medium;line-height:25px;background-color:#F8F9FB;\">以下图片为景通服数据表系统首页：</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:medium;line-height:25px;background-color:#F8F9FB;\"><img src=\"http://www.ming-soft.com/uploads/allimg/130105/1-130105132I4212.jpg\" /><br />\r\n</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:medium;line-height:25px;background-color:#F8F9FB;\"><span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;font-size:16px;\">中国通信服务股份有限公司简介：<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;中国通信服务股份有限公司是经国务院同意、国务院国有资产管理委员会批准，在国家工商行政管理总局登记注册成立的大型企业，由中国电信集团公司控股。在全国范围内为通信运营商、设备制造商、专用通信网及社会公众客户提供通信网络建设服务、外包服务、内容应用及其他服务，并积极拓展海外市场。</span><span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;\"></span>\r\n	<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n		<span style=\"font-size:16px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2006年8月30日，中国电信集团在重组上海、广东、浙江、福建、湖北和海南6省实业重点业务资产的基础上发起设立中国通信服务股份有限公司，并于同年12月8日在香港成功上市，成为国内通信行业第一家在香港上市的生产性服务类企业。2007年8月31日，中国通信服务收购江苏、安徽、江西、四川、重庆、湖南、贵州、云南、广西、陕西、甘肃、青海、新疆等13省（区、市）的实业重点业务资产，实现中国电信实业重点业务资产的整体上市。</span>\r\n	</p>\r\n	<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n		<span style=\"font-size:16px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;中国通信服务股份有限公司拥有先进的技术、齐全的业务、良好的业绩、完备的资质、广泛的本地化服务网络和独具特色的一体化服务模式，以及具有丰富经验和良好执行能力的管理团队。作为国内主导的“通信运营商的服务商”，中国通信服务股份有限公司将以上市为契机，抓住当前难得的发展机遇，牢牢把握竞争的主动权，进一步提高服务水平，实现客户价值与企业价值的共同成长，成为运营商转型的最佳战略合作伙伴，成为股东满意、社会认可、出资人放心的优秀企业，成为服务于社会信息化的重要力量。</span>\r\n	</p>\r\n<img src=\"http://www.ming-soft.com/uploads/allimg/130105/1-13010514225QB.jpg\" /><br />\r\n</span>\r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '', '19', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('24', '祝贺景德镇铭飞科技与中南置业集团达成合作', '<span style=\"font-family:Arial;font-size:16px;line-height:normal;background-color:#F8F9FB;\">&nbsp; 《景德镇铭飞科技有限公司》于2012年6月26日已和《中南置业集团》达成合作并签定合同，合作内容：景德镇铭飞科技有限公司负责为中南置业集团旗下子公司景德镇景禹新能源有限公司开发一套企业ERP系统。</span><br />\r\n<br />\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:16px;line-height:normal;background-color:#F8F9FB;\">以下图片为铭飞企业ERP系统首页：</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:16px;line-height:normal;background-color:#F8F9FB;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<img src=\"http://www.ming-soft.com/uploads/allimg/120924/1-1209241619133B.jpg\" /><br />\r\n</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:16px;line-height:normal;background-color:#F8F9FB;\">\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		以下为景德镇中南担保投资集团公司简介：<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 景德镇中南担保投资集团公司是在原景德镇中南担保投资公司部分单位的基础上组建而成的大型集团企业，注册号：36020210007428。主要经营范围：新能源开发、货款担保、工程招投标担保、履约担保；房地产投资、开发、经营；实业投资；企业资产管理、财务咨询、融资中介服务等。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		　　景德镇中南担保投资集团公司实施以集团公司、分（子）公司、基层企业三级责任主体为基础的集团化管理体制和运作模式。集团公司相继成立了景德镇中南置业有限公司、景德镇景禹新能源开发有限公司、景德镇富锦动力物资有限公司、景德镇得力财务咨询有限公司等专业公司。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		集团公司下设理财部、综合部、投资部、资金管理部、业务拓展部及风险监控审核部。集团公司的经营宗旨是：以担保和投资为手段，促进企业技术进步和科技成果转化，推进中小企业的创立与发展；提升企业信用，促进资产融通和商品流通，提高资源配置效率，推进社会信用体系建设，为市场经济和社会发展服务。公司初步形成了以担保、投资为主导，涵盖资产管理、咨询、投资顾问、风险投资、基金管理、证券、环保、软件等多个领域的集约经营模式。集团公司的成立使中小企业通过担保公司向银行争取宝贵的生产流动资产成为可能，同时也使银行在经营传统信贷业务中大大降低了风险，简化了贷款发放过程在繁杂环节，从而使企业、银行、担保公司三者相互依靠、共同发展，开创新的融资担保形式。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 本公司领导层均具有资深企业管理实践经验和丰富的企业资产管理经验，且拥有一支在国内投融资行业运作多年的精英团队，具备健全的内部管理制度，对受保项目具有完善的保前评估、保中监控、保后服务与处置机制。籍以自身强大的团队实力和在国内资本市场丰富的运作经验，不但熟悉资本运作的每一过程，而且了解全国地区企业的需求，拥有雄厚的融资实力，是广大中小企业、投资者迈向资本市场不可多得的桥梁。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 发展目标：力争成为一个拥有雄厚资本实力、优秀管理团队、独特企业文化和国内一流品牌的专业化风险投资基金管理公司。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 运作模式：遵循“专家管理、科学决策、组合投资、分散风险”原则，按风险投资基金的模式进行运作。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 第一、 拥有一批高素质、具有丰富投资管理经验和创新意识的风险投资专业人才队伍。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 第二、 由公司的投资部门按照项目投资的规范要求具体负责项目的规范要求具体负责负责项目的初选、投资分析、投资计划、投资实施、跟踪投资进程以及投资退出的工作。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 第三、 聘请国内各行业知名专家组成专家委员会，负责对投资项目的技术前景及市场前景进行评审。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;第四、 投资决策委员会及公司董事会根据专家委员会的评审意见及投资部门所作的投资建议书进行集体决策。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 第五、 与各大商业银行保持着良好的融资业务关系，借助资金和项目的有效融通帮银行降低货款风险，替企业分担信用责任，增加企业融资渠道，沟通项目建设信息，密切社会投资关系为增强社会信用、规范借贷关系贡献力量。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 扶持方式：公司对所投资的企业除提供资金支持外，还协助企业提高管理水平，全方位扶持企业成长。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 投资战略：在规模投资、精品投资和科学投资理念的指导下，重点投资于景德镇周边的具有巨大成长潜力、市场前景良好的创业项目。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 管理战略：强化已投项目的资源整合和产品链条构造，为企业提高管理咨询和财务顾问服务，打通资本市场业务通道，实现风险资本多种形式的退出。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 人才战略：探索具有中国特色的人力资本激励与约束机制，吸引一批优秀专业人才加盟，通过多种形式的业务培训与学习，培养一支高素质的人才队伍。\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 集团公司秉承“与客户共发展、与员工共进取”的经营理念，愿为有志之士成就精彩人生，与谋大事者共创辉煌伟业！\r\n	</div>\r\n	<div style=\"margin:0px;padding:0px;font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 集团公司子公司：　中南置业 &nbsp; 景禹新能源 &nbsp; 文通矿业 &nbsp;富锦动\r\n	</div>\r\n<br />\r\n</span>\r\n</p>', 'cyx', '19', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('25', '铭飞科技与景德镇市镇尚瓷厂签定合同', '<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:16px;\">铭飞科技于2012年9月8日与景德镇市镇尚瓷厂正式签定合作合同</span><br />\r\n<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:18px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br />\r\n&nbsp;&nbsp;&nbsp;&nbsp; 合同内容：景德镇铭飞科技有限公司负责景德镇市镇尚瓷厂的信息化管理平台建设。<br />\r\n<span>景德镇市镇尚瓷厂</span>网址：<a href=\"http://www.zhenshangsanbao.com/index.html\">http://www.zhenshangsanbao.com///index.html</a><br />\r\n</span>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:18px;\">以下为<span>景德镇市镇尚瓷厂</span>简介：</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:18px;\"><img src=\"http://www.ming-soft.com/uploads/allimg/120924/1-1209241F951H5.jpg\" /><br />\r\n</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:18px;\"><br />\r\n</span>\r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '', '19', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('26', '铭飞与景德镇进现代陶瓷发展有限公司达成合作', '<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:25px;background-color:#F8F9FB;\">景德镇铭飞科技有限公司于2012年8月15日与景德镇进现代陶瓷发展有限公司达成合作意向并签定合同</span><br />\r\n<br />\r\n<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:25px;background-color:#F8F9FB;\">&nbsp;&nbsp;&nbsp;&nbsp; 合同内容：景德镇铭飞科技有限公司负责景德镇进现代陶瓷发展有限公司门户网站建设和公司的信息化管理平台建设。</span><br />\r\n<br />\r\n<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:25px;background-color:#F8F9FB;\">景德镇进现代陶瓷发展有限公司门户网站网址：</span><a href=\"http://www.chinacccn.com/\">http://www.chinacccn.com/</a><br />\r\n<br />\r\n<br />\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:25px;background-color:#F8F9FB;\">以下为景德镇进现代陶瓷发展有限公司简介：</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:25px;background-color:#F8F9FB;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <img src=\"http://www.ming-soft.com/uploads/allimg/120924/1-12092416314R30.jpg\" /><br />\r\n</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:25px;background-color:#F8F9FB;\">&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<img src=\"http://www.ming-soft.com/uploads/allimg/120924/1-120924163413S8.jpg\" /><br />\r\n</span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:25px;background-color:#F8F9FB;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; &nbsp;<img src=\"http://www.ming-soft.com/uploads/allimg/120924/1-12092416344E02.jpg\" /><br />\r\n</span>\r\n</p>', '', '19', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('27', '铭飞科技公司正式成立', '<span style=\"background-color:#F8F9FB;\">公司于</span><span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:normal;background-color:#F8F9FB;\">2012年3月8日，已正式向</span><span style=\"font-family:Arial;line-height:normal;background-color:#F8F9FB;font-size:22px;\"><strong>《</strong></span><span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:normal;background-color:#F8F9FB;\">景德镇市工商行政管理局</span><strong><span>》</span></strong><span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:normal;background-color:#F8F9FB;\">领取营业执照。</span><br />\r\n<br />\r\n<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:normal;background-color:#F8F9FB;\">公司名称：景德镇铭飞科技有限公司</span><br />\r\n<br />\r\n<span style=\"font-family:Arial;font-size:17.77777862548828px;line-height:normal;background-color:#F8F9FB;\">经营范围：计算机系统服务及技术开发、培训、咨询服务，软件外包服务</span>', '', '19', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('28', '铭飞科技公司确定办公地址', '<p>\r\n	<span style=\"background-color:#FFFFFF;line-height:normal;font-family:Arial, Verdana, sans-serif;\"><span style=\"font-size:16px;\">景德镇铭飞科技有限公司于2012.3.5日将办公地址选在海慧花园主楼（34栋）1208室，建筑面积达150平方米。</span></span><span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:16px;\"><span style=\"line-height:normal;background-color:#FFFFFF;font-family:Arial, Verdana, sans-serif;\">箭头所指的位置</span></span>\r\n</p>\r\n<p>\r\n	<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;font-size:16px;\"><span style=\"line-height:normal;background-color:#FFFFFF;font-family:Arial, Verdana, sans-serif;\">&nbsp; &nbsp; &nbsp;&nbsp;<img src=\"http://www.ming-soft.com/uploads/allimg/120924/1-12092415542V26.jpg\" /><br />\r\n</span></span>\r\n</p>', '', '19', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('29', '东博会打造软件服务外包园区', '<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	8月26日，从吉林高新区了解到，借助第九届东博会良机高新区今年提出用三到五年的时间，创建“中国服务”新兴内陆城市，打造“省内最优环境，国内最具特色”软件服务外包园区。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	在去年成功举办第一届吉林（松花湖）服务外包发展论坛后，今年高新区将再借助东北亚投资贸易博览会的良机邀请美国斯蒂芬尼公司、日本东忠集团等世界500强企业和香港中讯软件集团股份有限公司等国内知名软件外包企业的高层管理人员参加即将在吉林市举行的第二届吉林（松花湖）服务外包发展论坛。吉林高新区软件服务外包产业发展局副局长孙宇华告诉记者：“我们一共邀请了欧洲客商十几户，日本客商20几户，国内企业30几户。他们的首席信息官都来参会，并在会上做精彩发言。这次盛会主要有17位嘉宾发言主要探讨服务外包企业发展的策略等一些问题。”\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	作为，本届论坛的承办单位之一，吉林大仝数码科技股份有限公司副总经理王福斌告诉记者，仅2012年公司软件服务外包业务收入为4980万元，今年预计达到8000万元。王福斌说：“第二届服务外包我们做为承办单位我们和高新区密切配合我们想把国内外的一些企业特别是一些高端软件企业世界500强企业争取多多的落户到吉林市来。”\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	据了解，今年总投资3.5亿元，占地10251平方米，建筑面积8.5万平方米的吉林软件服务外包产业孵化基地项目一期工程在高新南区开工。项目建成后,将承接瑞典、日本、美国等跨国公司离岸外包,及国电公司等国内大型企业的在岸外包项目。项目投产后，业务总额将突破2亿元。\r\n</p>', '', '26', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('30', '成都市政府代表团来武汉考察招商 实现共赢发展', '<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	10日至11日，成都市市长葛红林率团到武汉考察招商。省委常委、市委书记阮成发，市长唐良智会见了葛红林一行。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	阮成发说，成都经济总量靠前，城乡一体化走出了一条特色道路，刚刚举行的财富论坛极大提升了成都在全球的影响力，给城市带来了无形财富和潜在发展机遇。唐良智曾于5月份率政府代表团赴蓉考察，他表示，成都在软件业、IT业的成就非常值得武汉学习。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	葛红林说，近年来，武汉在发展实体经济、汽车产业、城市建设管理相关领域创造了大量鲜活经验，值得成都借鉴。希望两市进一步增进交流、扩大共识，不断强化在更宽领域更深层面的全方位务实合作，实现共赢发展。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	成都市(武汉)投资说明会于7月11日举行。共有85家武汉工业百强企业、重点装备制造企业及世界500强武汉分公司到会，寻觅在蓉发展商机。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	近年来，武汉市与成都经贸往来频繁。今年5月，市政府代表团赴蓉举行投资说明会；2008年以来，成都在汉注册企业已达200多家，汉企在蓉投资项目资金额达27亿元。未来，两市有望在汽车及零部件、电子信息、装备制造、生物医药、能源环保、服务外包、会展等领域加强合作。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	成都市领导李昆学、苟正礼、毛志雄、韩春林，市政府秘书长门生等参与考察。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	市领导龙正才、邵为民，市政府秘书长郭胜伟参加会见或投资说明会。\r\n</p>', '', '26', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('31', '常州代表团赴英国、瑞典开展经贸合作交流活动', '<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	为进一步扩大常州与欧洲服务外包业界合作交流，7月3日-10日，由市商务局带队的一行6人赴英国、瑞典开展服务外包合作交流活动。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	代表团一行先后考察走访了英国思泰克（CETEC）、瑞典Sfinx太阳能等公司。其中，英国思泰克欧洲有限公司是由常州长青交通科技股份有限公司投资500万美元设立，2011年成功并购英国TrainFX公司作为其全资子公司，主要经营轨道交通电子产品、乘客信息系统、综合交通系统、车组通讯设备和其他交通运输相关技术研发、技术培训及服务。公司总经理Phil Campbell对公司轨道交通技术设备研发产品进行了详细介绍并做现场演示，双方就交通信息系统技术研发外包项目作了深入交流。\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('32', '1-6月北京市离岸服务外包执行额20.65亿美元', '<span style=\"font-family:Arial;font-size:13.333333969116211px;line-height:25px;background-color:#F8F9FB;\">&nbsp;2013年1-6月份，北京市在商务部“服务外包业务管理和统计系统”上登记的离岸服务外包合同执行金额达20.65亿美元，同比增长35.7%。其中，信息技术外包（12.24亿美元）、业务流程外包（4.17亿美元）和知识流程外包（4.24亿美元）执行金额占离岸服务外包执行总额的比重分别为59.3%、20.2%和20.5%。发包额位居前5位的国家为美国、芬兰、日本、新加坡与爱尔兰。</span>', '', '26', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('33', '湖南省软件信息服务企业与中小微企业“牵手行', '<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	7月10日，“湖南省软件信息服务企业与中小微企业‘牵手行动’走进株洲”在株洲市中小微企业窗口服务平台隆重举行。省经济和信息化委员会副巡视员杨宪法、省中小企业局局长黄学工等出席，省经信委软件和信息服务业处、省中小企业服务中心以及长沙、株洲、湘潭、衡阳经信委相关负责人参加，80多家中小微企业进行了交流对接活动。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	这次“牵手行动——走进株洲”活动是践行群众路线，务实推进“两化融合”，贴身扶助中小微企业的实际行动，是省经信委去年启动的“软件信息服务业与中小企业牵手行动”的进一步深化，进一步推动软件和信息服务进企业、进市场、进园区。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	杨宪法在会上指出，要把‘牵手行动’作为两化深度融合的战略举措来抓，把中小微企业信息化的现实需求作为“牵手行动”的立足点来抓，把“走进株洲”作为深入推进“牵手行动”的重要典范来抓，并推而广之，持续深入地开展下去，最终将信息化和工业化的融合落实到信息产业特别是软件信息服务业与各个产业的融合上来。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	此次活动特邀中国电子信息产业发展研究院中小企业研究所副所长赵卫东博士作了题为《信息化助力中小企业发展》的主题演讲，向在场的企业家们生动讲解了两化融合背景下的中小企业信息化，以及如何运用云计算促进中小企业发展。主题活动阶段，围绕“云服务”和“电子商务与网络营销”两大主题，以湖南裕邦智能科技股份有限公司、湖南竞网科技有限公司、湖南天骄物流信息科技有限公司等为代表的7家软件信息服务企业进行了现场演示与交流对接，向参加活动的中小微企业分别展示了湖南省小微企业云管理服务平台、设计研发管理云服务平台、产学研和知识产权经营平台等一批企业用得着、用得起的软件信息服务产品与解决方案。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	在主题活动的基础上，还将对芦淞市场开展电子商务对接，对醴陵市陶瓷特色产业的小企业开展对接，真正的把“促进软件和信息服务进企业、进市场、进园区”这一目标落到了实处，对全省加快推进中小企业信息化，促进中小企业特别是小微企业健康发展具有重要的典型示范作用。\r\n</p>\r\n<div>\r\n	<br />\r\n</div>', '', '26', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('34', '苏州打造服务外包创新强市未来重点开拓十大领', '<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;7月5日，2013中国（苏州）服务外包创新发展投资促进年会在苏州工业园区正式举行。苏州市市委副书记、市长周乃翔在会议上表示，苏州有着独具吸引力的服务外包发展环境，未来将围绕打造“中国服务 苏州创新”服务外包品牌，培育高端业态，提升创新能力，优化产业结构，并在十大领域更加广泛地开展国际合作与投资，力争成为中国服务外包创新强市。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	本届年会由江苏省商务厅和苏州市人民政府联合主办，苏州市商务局和中国服务外包研究中心共同承办，北京博思商通资讯有限公司策划执行。年会以“转型与聚合——企业变革与技术创新之道”为主题，由开幕式暨主题大会、高端对话、中外CIO峰会、国际生物医药研发外包与协同生产高峰论坛和商务洽谈等环节组成。中国政府主管部委和江苏省、苏州市政府的主要领导，国际知名服务外包公司、国内领先服务外包企业以及世界500强企业的高管，专业咨询与投资合作机构的专家等400余位嘉宾共同出席了本次会议。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	本次国际考察团团长、戴姆勒东北亚投资有限公司总裁西格马尔·哈西斯在会上表示，考察团希望通过此次苏州行，感受更加友善的投资环境，加强与当地企业的交流，并寻找在商业交流以及市场发展方面的良好商业平台。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	据悉，在本届年会期间，苏州市共有15个服务外包项目签约，涉及服务外包投资项目、服务外包实训基地、公共平台建设、发包业务等多个领域，总投资达5亿元。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	近年来，苏州市委、市政府将发展服务外包作为实现经济转型升级、创新发展的重要抓手，实现了快速发展。2009年，苏州被国务院确定为中国服务外包示范城市。近三年来，该市全面实施服务外包产业新三年跨越发展计划，加大对服务外包产业的推动力度，引进一批服务外包龙头企业，在产业集聚、层次提升、市场开拓、人才培养等方面取得了显著成效。数据显示，近年苏州服务外包产业规模不断扩大。2012年，苏州市全市接包合同额达到55.9亿美元，较上年增长56%；服务外包离岸执行额达到30.5亿美元，较上年增长52%，业务总量占江苏省的31%、中国大陆的9.1%，位居全国第一方阵；服务外包企业数从2007年底的412家增至2012年的2000余家。该市服务外包各项指标均居全国21个服务外包示范城市前列。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	苏州服务外包的飞速发展离不开该市得天独厚的投资环境。据市长周乃翔介绍，苏州的服务外包发展环境优势明显、独具吸引力。首先，处于中国最活跃的两条经济带——沿海经济带和沿长江经济带的交汇点上使苏州具有优越的区位条件。其次，众多跨国公司在产业转移过程中产生了巨大外包需求，而作为长期以来国际资本投资中国的首选地之一苏州更是得益于此。再次是丰富的人才资源，到2012年底，苏州服务外包从业人数近20万人。全市市级以上服务外包人才培训基地已达60家，每年培训服务外包人才2万人次。除此之外，该市还具有有力的政策支持、众多的外包载体、严格的知识产权保护等多方面优势。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	周乃翔透露，未来苏州市将加快构建层次分明、重点突出特色鲜明、优势明显的服务外包产业体系，并将在以下十大服务外包领域，更加广泛地开展国际合作与投资，力求取得更大的发展。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	一是软件外包。重点对用户运营、人力资源和财务管理等业务进行软件开发。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	二是研发设计外包。重点发展汽车工业设计、新能源和新材料研发设计以及电子产品设计等外包。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	三是生物医药研发外包。重点发展动物实验服务、药物非临床研究和评价、生物技术服务以及新药临床实验等外包。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	四是金融后台服务外包。重点发展金融数据挖掘与分析、信用分析与评级金融理财咨询等金融外包业务。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	五是动漫创意外包。重点承接国际动画加工、原创动画开发、漫画数字化应用、影视特效制作、版权推广等外包业务。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	六是物流与供应链管理外包。重点发展电子通信物流、化工物流、医药物流等专业物流，积极为客户提供采购、物流的整体解决方案和数据库服务。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	七是检验检测外包。重点引进国际知名的检验检测服务外包企业，积极提供软件评测服务、质量检验测试等专业外包服务。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	八是云计算领域外包。重点发展在线系统维护、IT基础设施管理、数据中心等业务。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	九是物联网领域外包。重点发展智能楼宇相关设备开发以及传感网络、智慧交通等业务领域。\r\n</p>\r\n<p style=\"font-size:13.333333969116211px;font-family:Arial;background-color:#F8F9FB;\">\r\n	十是跨国公司共享服务中心。对已在苏落户的跨国制造公司，鼓励其将服务类业务独立出来，设立共享服务中心。同时，大力引进世界500强企业的“共享服务中心”。\r\n</p>', '', '26', '', '2013-11-08', '', '0');
INSERT INTO `ms_article` VALUES ('35', '成都市11家企业跻身四川省生产性服务业示范企业', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;7月10日，2012年度四川省生产性服务业功能示范区和示范企业（机构）授牌仪式，在成都市举行。其中8家单位被授牌四川省生产性服务业功能示范区，成都市3家单位位列其中；全省38户企业（机构）被授牌四川省生产性服务业示范企业（机构），成都天河中西医科技保育有限公司等成都市11户企业（企业）位列其中。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	据悉，成都市被授牌四川省生产性服务业功能示范区的3家单位分别是西部智谷、天府生命科技园以及东创建国汽车产业文化园区。而西部智谷项目，作为加快武侯新城产业提档升级、促进园区企业发展转型的重要载体，带动园区周边经济发展。根据西部智谷的发展产业定位，将集中力量打造知名企业区域总部聚集区、技术研发及服务外包中心、IT动漫创意产业园、中小企业创业基地等四大类产业。天府生命科技园是四川省、成都市和高新区重点打造的中国重要的生物医药研发创新中心和产业孵化中心。目前园区已经引进的企业类别有抗体药物及蛋白质药物类、重大疾病诊断及检测类技术、基因治疗、细胞治疗等生物治疗技术类、创仿化药类、CRO和医疗器械类等企业，共计50余家企业已经入驻园区。而东创建国汽车产业文化园区，则是东创建国的一种经营模式的创新。\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('36', '今年长春投资478个亿元以上服务业项目', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;7月9日，长春市政府召开全市现代服务业重点项目(企业)座谈会，会上透露，今年长春投资亿元以上服务业项目478个，比上年增加244个，年度投资规模高居三次产业之首。长春市要坚定不移地实施工业、服务业“双拉动”战略，重点瞄准“两新四高”领域的现代服务业，加快产业结构优化转型升级步伐。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	会上，长春市发改委通报了上半年全市服务业发展情况。近年来，长春市委、市政府提出工业、服务业“双拉动”战略，制定出台一系列扶持服务业发展的政策措施，全市服务业发展速度明显加快，连续跃居副省级城市前列；项目明显增多；高端服务业发展势头强劲，商业综合体、软件及服务外包、电子商务等新兴业态发展迅猛；现代服务业带动作用明显增强。\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('37', '成都市11家企业跻身四川省生产性服务业示范企业', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;7月10日，2012年度四川省生产性服务业功能示范区和示范企业（机构）授牌仪式，在成都市举行。其中8家单位被授牌四川省生产性服务业功能示范区，成都市3家单位位列其中；全省38户企业（机构）被授牌四川省生产性服务业示范企业（机构），成都天河中西医科技保育有限公司等成都市11户企业（企业）位列其中。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	据悉，成都市被授牌四川省生产性服务业功能示范区的3家单位分别是西部智谷、天府生命科技园以及东创建国汽车产业文化园区。而西部智谷项目，作为加快武侯新城产业提档升级、促进园区企业发展转型的重要载体，带动园区周边经济发展。根据西部智谷的发展产业定位，将集中力量打造知名企业区域总部聚集区、技术研发及服务外包中心、IT动漫创意产业园、中小企业创业基地等四大类产业。天府生命科技园是四川省、成都市和高新区重点打造的中国重要的生物医药研发创新中心和产业孵化中心。目前园区已经引进的企业类别有抗体药物及蛋白质药物类、重大疾病诊断及检测类技术、基因治疗、细胞治疗等生物治疗技术类、创仿化药类、CRO和医疗器械类等企业，共计50余家企业已经入驻园区。而东创建国汽车产业文化园区，则是东创建国的一种经营模式的创新。\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('38', '前5月软件业出口141亿美元', '<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">受国际经济形势和人民币汇率调整的影响，软件业出口连续超过20个月处于低增长态势。今年1-5月，软件业实现出口141亿美元，同比增长10.1%，增速比1-4月回落0.1个百分点，比去年同期低1.4个百分点。</span><br />\r\n<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">　　</span><br />\r\n<span style=\"font-family:Arial;line-height:25px;background-color:#F8F9FB;\">数据显示，今年前5月，我国外包服务出口33.6亿美元，同比增长16.5%，增速比1-4月回落1.3个百分点，低于去年同期9.9个百分点。</span>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('39', '佛山欲打造省首批服务外包示范市', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;近日，记者从佛山市服务外包行业协会获悉，目前，佛山服务外包产业的GDP、人均生产总值已位居省二线城市首位，并在近期有望成为省首批服务外包示范市。而为进一步推进佛山服务外包行业的发展，佛山还将积极展开校企合作，培养定向型人才。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	佛山市服务外包行业协会秘书长郝泽林表示，虽然佛山的服务外包行业发展形势看好，但人才流失也成为制约其发展的问题。为此，佛山服务外包协会成立了首批服务外包人才联盟。“首批服务外包人才联盟将为外包企业提供定向人才。”郝泽林介绍，首批服务外包人才联盟的功能包括举办服务外包专题招聘会、帮助服务外包企业进行人才培训基地筹备、进行人才需求调研等。此外，联盟还将在企业和校园之间积极开展订单班等合作，从而为服务外包行业提供优质人才，为服务外包企业提供发展的动力。\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('40', '王岐山:加快发展服务外包产业 增加大学生就业', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;中共中央政治局委员、国务院副总理王岐山7月9日至10日在辽宁大连考察服务外包工作。他强调，服务外包作为异军突起的新兴产业，对于保增长、调结构、稳外需、促就业特别是增加大学生就业，具有重要意义。要按照科学发展观的要求，立足当前，着眼未来，努力做好服务外包这篇大文章。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	大连是国务院批准设立的20个服务外包示范城市之一，今年以来服务外包产业逆势增长，1—10月份服务外包执行金额同比增长158％。王岐山来到大连腾飞软件园和大连华信计算机技术股份有限公司等企业，仔细询问企业承接订单、产品研发、吸纳就业等情况。他说，发展服务外包产业，根本上要靠人才、靠科技、靠创新。要解放思想，扩大开放，把人才优势、技术优势与市场优势充分结合起来。在大连东软信息技术学院图书馆，王岐山与自习的学生亲切交谈，鼓励他们刻苦学习，增强自信，敢于创新。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	在服务外包企业座谈会上，王岐山指出，我国服务外包产业发展潜力很大，大有希望。要以改革创新的精神深入了解新情况，解决新问题，充分发挥市场配置资源的基础性作用，推动外贸发展方式转变。在大力发展离岸服务外包的同时，通过体制改革和组织制度创新，积极培育在岸服务外包市场，促进国际国内服务外包业务协调发展。企业家要有雄心，开阔眼界，抓管理、促创新、创品牌，心无旁骛地把服务外包企业不断做大做强。各示范城市要加强规划，突出特色，强化服务，营造环境，增强集聚效应，推动服务外包产业实现量的扩张和质的提升。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	考察期间，王岐山对辽宁省及大连市经济社会发展取得的成绩给予充分肯定。他强调，商务、金融等部门要加强与地方政府的协调配合，寓管理于服务之中，努力促进东北老工业基地振兴和发展。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	辽宁省和国务院有关部门负责同志参加了座谈会和考察。\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('41', '王岐山:加快发展服务外包产业 增加大学生就业', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;中共中央政治局委员、国务院副总理王岐山7月9日至10日在辽宁大连考察服务外包工作。他强调，服务外包作为异军突起的新兴产业，对于保增长、调结构、稳外需、促就业特别是增加大学生就业，具有重要意义。要按照科学发展观的要求，立足当前，着眼未来，努力做好服务外包这篇大文章。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	大连是国务院批准设立的20个服务外包示范城市之一，今年以来服务外包产业逆势增长，1—10月份服务外包执行金额同比增长158％。王岐山来到大连腾飞软件园和大连华信计算机技术股份有限公司等企业，仔细询问企业承接订单、产品研发、吸纳就业等情况。他说，发展服务外包产业，根本上要靠人才、靠科技、靠创新。要解放思想，扩大开放，把人才优势、技术优势与市场优势充分结合起来。在大连东软信息技术学院图书馆，王岐山与自习的学生亲切交谈，鼓励他们刻苦学习，增强自信，敢于创新。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	在服务外包企业座谈会上，王岐山指出，我国服务外包产业发展潜力很大，大有希望。要以改革创新的精神深入了解新情况，解决新问题，充分发挥市场配置资源的基础性作用，推动外贸发展方式转变。在大力发展离岸服务外包的同时，通过体制改革和组织制度创新，积极培育在岸服务外包市场，促进国际国内服务外包业务协调发展。企业家要有雄心，开阔眼界，抓管理、促创新、创品牌，心无旁骛地把服务外包企业不断做大做强。各示范城市要加强规划，突出特色，强化服务，营造环境，增强集聚效应，推动服务外包产业实现量的扩张和质的提升。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	考察期间，王岐山对辽宁省及大连市经济社会发展取得的成绩给予充分肯定。他强调，商务、金融等部门要加强与地方政府的协调配合，寓管理于服务之中，努力促进东北老工业基地振兴和发展。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	辽宁省和国务院有关部门负责同志参加了座谈会和考察。\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('42', '东博会打造软件服务外包园区', '<div id=\"Div1\" style=\"margin:0px;padding:0px;font-family:Arial;background-color:#F8F9FB;\">\r\n	<div id=\"page_div1\" style=\"margin:0px;padding:0px;\">\r\n		<p>\r\n			8月26日，从吉林高新区了解到，借助第九届东博会良机高新区今年提出用三到五年的时间，创建“中国服务”新兴内陆城市，打造“省内最优环境，国内最具特色”软件服务外包园区。\r\n		</p>\r\n		<p>\r\n			在去年成功举办第一届吉林（松花湖）服务外包发展论坛后，今年高新区将再借助东北亚投资贸易博览会的良机邀请美国斯蒂芬尼公司、日本东忠集团等世界500强企业和香港中讯软件集团股份有限公司等国内知名软件外包企业的高层管理人员参加即将在吉林市举行的第二届吉林（松花湖）服务外包发展论坛。吉林高新区软件服务外包产业发展局副局长孙宇华告诉记者：“我们一共邀请了欧洲客商十几户，日本客商20几户，国内企业30几户。他们的首席信息官都来参会，并在会上做精彩发言。这次盛会主要有17位嘉宾发言主要探讨服务外包企业发展的策略等一些问题。”\r\n		</p>\r\n		<p>\r\n			作为，本届论坛的承办单位之一，吉林大仝数码科技股份有限公司副总经理王福斌告诉记者，仅2012年公司软件服务外包业务收入为4980万元，今年预计达到8000万元。王福斌说：“第二届服务外包我们做为承办单位我们和高新区密切配合我们想把国内外的一些企业特别是一些高端软件企业世界500强企业争取多多的落户到吉林市来。”\r\n		</p>\r\n		<p>\r\n			据了解，今年总投资3.5亿元，占地10251平方米，建筑面积8.5万平方米的吉林软件服务外包产业孵化基地项目一期工程在高新南区开工。项目建成后,将承接瑞典、日本、美国等跨国公司离岸外包,及国电公司等国内大型企业的在岸外包项目。项目投产后，业务总额将突破2亿元。\r\n		</p>\r\n		<div>\r\n			<br />\r\n		</div>\r\n	</div>\r\n</div>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('43', '绵阳市与浪潮集团举行座谈会', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;7月5日，绵阳市与浪潮集团举行座谈会，就绵阳信息化建设、智慧城市建设、云计算和大数据产业发展，以及前期合作项目推进情况进行交流。双方表示，将进一步深度合作，加强智慧城市的研究和规划，开发拉长产业链条，让老百姓享受到科技带来的方便和实惠。市委书记罗强、浪潮集团董事长兼CEO孙丕恕出席座谈会。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	罗强感谢浪潮集团对绵阳发展和科技城建设的关注支持，对浪潮集团取得的良好发展业绩表示祝贺。他说，随着全球对信息安全的要求越来越高，为浪潮发展提供了广阔空间。省委、省政府近日出台多项政策措施支持科技城建设，绵阳发展迎来了新的春天。以长虹、九洲、艾默生等为代表的一批电子信息企业，在发展传统主业、巩固优势地位的基础上，正稳步向三网融合、云计算、物联网等新兴产业进军，为浪潮集团与绵阳的深度合作奠定了良好基础。希望浪潮加大在绵阳的项目、资金及科研人员投入，与绵阳深化合作，与绵阳优势企业强强联合，实现互利互惠、共赢发展，让老百姓享受到科技带来的方便和实惠。我们将一如既往地支持浪潮集团在绵发展，竭诚为企业在绵发展提供优质高效服务。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	孙丕恕感谢绵阳市委、市政府对浪潮集团四川公司的大力支持。这次又与绵阳有关方面签署合作协议，合力在绵打造立足四川、覆盖全国的云计算产、学、研示范性基地，将有力推动绵阳信息产业发展、“智慧绵阳”建设，通过科技给广大群众带来更多方便和实惠。下一步，浪潮集团将在四川公司积极探索从生产型企业向生产服务型企业转变的新路子，加强与绵阳优势企业合作，加强智慧城市的研究和规划，开发拉长产业链条，吸引带动一批科技型中小企业来绵创业发展。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	市委常委、科技城党工委副书记、管委会常务副主任颜超主持座谈会。市人大常委会副主任、市委秘书长王黎，副市长郑蕾，浪潮集团软件总裁兼CEO王洪添、智慧城市事业部总经理张峰、云服务事业部总经理颜亮、四川公司总经理孙业志等出席座谈会。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('44', '齐鲁软件园上半年服务外包离岸执行额达2.45亿美', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;记者近日从济南高新区了解到，今年上半年齐鲁软件园完成服务外包离岸执行额达到2.45亿美元，同比增长40%，继续保持强势增长势头。其中，ITO(信息技术外包）类业务占软件出口的81%、BPO（技术性业务流程外包）类占10%、KPO（技术性知识流程外包）类占9%，整体呈现出外包业务多元化、技术含量高端化的发展趋势。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	据了解，今年上半年齐鲁软件园新增认定服务外包企业13家，园区经商务部备案的服务外包企业累计达190家，其中离岸执行额过千万的企业12家，从业人员2万余人，服务对象涉及日本、美国、加拿大、澳大利亚等国家和地区。园区企业主要承接微软、IBM、NEC、日立等20余家世界500强企业的一手包业务，并有多家世界500强企业研发中心入驻园区，如NEC、日立系统、大和综研、沃尔沃、瑞穗综研等。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('45', '北京昌平区召开服务外包政策宣讲会', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;7月4日，北京昌平区商务委组织召开区服务外包发展资金政策服务宣讲会。会上，传达了关于促进服务外包产业发展有关文件精神，并对昌平服务外包政策信息进行详细解读，让企业在实际申报时能够更好的操作。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	此次政策宣讲会举办，让企业更深入的领会了政策的精神，为政府与企业之间搭建沟通的桥梁，让政策能够更好的服务于企业。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('46', '大连“软交会”廊坊签6793万美元大单', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	近日，廊坊市组织重点软件行业企业赴大连参加第十一届中国国际软件和信息服务交易会，初步达成合作意向12个，签订贸易合同6793万美元。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	会上，廊坊代表团积极宣传推介廊坊市投资环境，多角度展示廊坊市服务外包发展成果及远景规划，得到了与会客商的广泛关注，特别是三河超星数字技术有限责任公司建成的中国最大数字图书馆备受好评。代表团还与知名软件信息公司、服务外包企业进行了对接洽谈，拜访了中北软件、大连毅信软件、创梦科技等一批实力强、投资意向明确的软件行业重点客户。其中，中北软件、创梦科技两家企业均表示近期将来廊进行实地考察。会议期间，廊坊代表团还参观了大连软件园及新加坡腾飞园区，学习借鉴新时期软件业和服务外包业的发展经验。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('47', '渝中区正在筹建服务外包产业聚集区', '<div class=\"newsintrocontent\" style=\"margin:0px auto;padding:25px;font-family:Arial;\">\r\n	<p>\r\n		&nbsp;依托国家服务业综合改革试点区的金字招牌，渝中区正成为重庆市发展服务外包产业的领头羊。昨日，渝中区政府发布消息，今年上半年，该区实现服务外包执行额7644万美元，位居全市第一。\r\n	</p>\r\n	<p>\r\n		“渝中区上半年的服务外包产业，主要涉及商贸流通、金融后台等现代服务业。”昨日，渝中区信息服务外包发展中心相关负责人告诉记者，一直以来，渝中区政府积极搭建平台，邀请国际知名服务外包企业高管来渝现场对接项目，并扶持龙头企业做大做强。\r\n	</p>\r\n	<p>\r\n		“今年1月，通用电气、世界互联网数据公司等7家国际知名企业高管携10个服务外包项目出现在2013渝中国际服务外包项目对接会上，20多家重庆服务外包企业报团现场参与项目对接。目前，渝中区服务外包企业有近50家，主要业务集中在软件开发、技术服务等方面，大龙网、软岛科技、祥维科技等主要服务外包企业发展势头较好。”该负责人表示，渝中区正筹备一个服务外包产业聚集区，欲在今年内建成。该聚集区将整合中小企业抱团向大企业接包，获得更广阔的发展空间。\r\n	</p>\r\n	<p>\r\n		&nbsp;\r\n	</p>\r\n	<div>\r\n		<br />\r\n	</div>\r\n</div>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('48', '第十一届中国国际软件和信息服务交易会圆满落', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;6月23日，以“智能改变未来”为主题的第十一届中国国际软件和信息服务交易会圆满落幕。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	作为国内规格最高、规模最大、最具实效性和最具国际影响力的IT行业年度盛会，第十一届中国软交会展览面积达到35000平方米，中外参展厂商806家，国内省市团组45个，同期举行会议活动58项，涉及30多个行业领域，来自66个国家和地区的海外客商超过2000人，其中高端演讲嘉宾达到500余位，专业会议及行业用户代表超过20000人次，参观观众32800余人次，累计合同意向交易额过千亿。本届中国软交会充分发挥了传播高端声音、凝聚精英智慧、引领行业发展、推动产业融合、促进国际合作、打造交易平台的作用。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	一、海内外嘉宾齐聚滨城，高度关注，体现国家级全球化的高端水平。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	商务部原副部长刘向东、国家旅游局副局长王志发、中国贸促会副会长王锦珍、中国驻日本大使馆经济商务公使吕克俭、中国电子信息产业发展研究院院长罗文、国家外专局培训中心主任白继讯、商务部服贸司副司长万连坡、科技部高新司副司长杨咸武、国家旅游局规划财务司副司长胡书仁、工业和信息化部软件服务业司副巡视员谢渡婴、教育部职业教育与成人教育司副巡视员周为、中国服贸协会执行副会长赵中屹、中国安全应急救援产业联盟秘书长常枋等国家部委领导莅临本届中国软交会。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	江苏省人大副主任刘永忠、甘肃省人大副主任李慧、银川市人民政府常务副市长王久彬、江苏省人民政府副秘书长王志忠、山西省商务厅厅长孙跃进、内蒙古自治区商务厅厅长李万忠、江西省商务厅副厅长刘翠兰、宁夏回族自治区经信委副主任张宏年、河北省商务厅巡视员崔怀平等省市领导亲自率团参会，体现了国内各省市对本届中国软交会的高度关注。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	辽宁省人民政府副省长潘利国、辽宁省经信委主任李兵、辽宁省外经贸厅厅长王力威、辽宁省旅游局局长姚非、辽宁省外经贸厅副厅长曾晓非、辽宁省经信委副主任孟继民、辽宁省科技厅副厅长孟庆海、辽宁省旅游局副局长应中元、辽宁省旅游局副局长王利印、辽宁省服务业委副主任王广利、辽宁省贸促会副会长朱琳等辽宁省人民政府和省直相关单位领导，以及辽宁省委常委、大连市委书记唐军，大连市人民政府市长李万才、大连市人大常委会主任里景瑞、大连市政协主席肖盛峰、大连市委副书记宋善云，大连市委常委、副市长曲晓飞，大连市委常委、市委秘书长张世坤，大连市人大常委会副主任姚家凯、大连市人民政府副市长刘岩、大连市政协副主席徐国臣、大连高新园区管委会主任董呈发、大连市人民政府秘书长骆东升等大连市领导出席同期举办的会议活动。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	法国滨海夏朗德省议会副主席、副省长让克洛德?波利尤，法国滨海夏朗德省副省长西尔维?马尔西里、台北世贸中心副董事长单骥、香港特区政府商务及经济发展局常任秘书长何淑儿、香港特别行政区资讯科技总监赖锡璋、印度通信制造商协会会长高耀等海外政府及行业协会高官应邀参会。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	英特尔亚太研发总经理何京翔、微软大中华区副总裁谢恩伟、IBM Corporation CTO贾姆希德.沃恩、NTT数据中国区总裁神田文男、维布络高级副总裁斯里尼瓦斯?劳、EPALS CEO 迈尔斯?吉尔伯恩、Tradeshift创始人克里斯蒂安?朗格、马丁沃夫并购顾问公司创始人兼总裁马丁?沃尔夫、文思海辉CEO卢哲群、浙大网新执行总裁钟明博、软通动力信息技术（集团）有限公司CTO方发和、赛迪顾问副总裁赫建营等一大批IT领军人物成为本届中国软交会的座上嘉宾。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	中外新闻媒体对本届中国软交会倾注了极大的热情，全方位、多角度地报道了大会盛况。来自新华社、中新社、中央一套、中央二套、中央人民广播电台、中国国际广播电台、人民日报、中国日报、国际商报、大公报、香港商报、香港文汇报、香港亚太第一卫视、辽宁日报、辽宁电视台、人民网、新浪网、比特网、腾讯、网易、赛迪网、金融时报、华尔街日报、韩国每日新闻等百余家国内外权威媒体的300多位记者进行了采访报道，并给予高度评价。在网络搜索引擎中搜索关于“第十一届中国软交会”的结果均超过百万条；多家门户网站、IT专业网站、财经媒体对开幕式、高峰论坛、主题论坛进行了20多场次的直播报道，百余位新闻媒体记者对30余位高端嘉宾进行专题采访；央视一套《新闻联播》栏目特别在开幕首日报道大会盛况，央视经济频道《财经连线》、《第一时间》等栏目也及时报道开幕式和展览亮点；大连广播电视台全面直播本届中国软交会盛况，用最详实的画面、最贴近现场的采访手段呈现了筹备邀请、布展彩排、盛大开幕、产品展示、会议解析等全过程；大连日报特别策划了系列跟踪报道，以通版专栏的方式持续报道专题展览、会议论坛和重点活动。据不完全统计，本届中国软交会期间，媒体发布稿件千余篇。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	二、高端声音反馈专业意见，更多肯定与期待，助中国软交会再创辉煌。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	通过中国软交会这一平台，国内外高端人士更深刻地了解了中国的软件产业、了解了中国，通过这一沟通内外的窗口，让世界对中国软件产业发展信心满满。同时，也为中国业界在新一代信息技术下更近地参与国际竞争提供了不可或缺的平台。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	辽宁省副省长潘利国在开幕致辞中讲到：本届中国软交会汇集了众多海内外嘉宾朋友，共同探讨未来IT产业的发展方向，分享最前沿的科技成果，我们将充分利用这个平台，积极鼓励政府和企业请进来、走出去，加强合作交流，同时也真诚期待更多的海内外朋友来辽宁投资创业，希望与会嘉宾更多地关注辽宁软件产业的发展，不断提高合作的层次和水平，努力实现合作共赢，共同发展。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	中国贸促会副会长王锦珍在讲话中提到：根据国际权威机构发布的软件和服务外包交付指数，大连名列中国第一，全球前五，同时也是全球十大最具吸引力的外包目的地城市。在这当中，中国软交会对产业发展起到极大的推动作用，已经成为中外软件和信息技术交流合作的平台，为软件和信息技术蓬勃发展作出了积极贡献。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	大连市人民政府市长李万才在致辞中提及：中国软交会作为国家级软件交易活动的盛会，此前已经在大连成功举办了10届，10年来，中国软交会规模与范围不断拓展，国际化特色日益浓厚，为海内外业界合作交流发挥了重要的引领作用。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	印度通信制造商协会会长高耀在高峰论坛的演讲中说：非常感谢大连市人民政府提供了这样的一个机会，在过去三年的时间里面，我一直都来参加中国软交会，这一次，要和大家分享的是，未来十年的IT的状况，创新在全球每天都在发生，尤其是在中国，这种创新的速度非常迅速。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	香港特区政府商务及经济发展局常任秘书长何淑儿在接受记者采访时描绘香港特别行政区政府首次组团参加中国软交会的感受：“我们是第一次组团来大连参加中国软交会，大连市人民政府对我们支持非常大，随团来的企业也感到非常满意。”\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	NTT数据中国区总裁神田文男已经是第二次参加中国软交会，在接受记者采访时，他表示，对本届中国软交会的规模和内容都非常满意。他告诉记者，今年的软交会对比去年更有活力，这说明中国市场对IT有更高的期待。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	谈到此次参加中国软交会，维布络高级副总裁斯里尼瓦斯?劳告诉记者，此次会议参展规模及参观人数都超出了他的预期，对于如何扩大中国市场的规模，他表示，要想在中国执行战略，还需要认真的去学习。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	北京展团的负责人表示：本届中国软交会的整体服务比以往有所提高，特别是专门开设的交易洽谈区，为展商的交流沟通提供了很多的便利，更加注重成交，更具时效性，此外，技术论坛也更专业，以后可以多举办。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	浙江展团的工作人员在四天的展览中深刻感受到本届中国软交会的变化：更重视成交了，每天都会有专人统计成交量并公布成交额，成交是中国软交会可持续发展的生命力。本届大会更注重为买家和卖家提供专业服务，开辟了更多的商务洽谈区。此外国际化水平和省市整体布展水平也在不断提升。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	《中国软件和服务外包》主编萧亚平作为多年报道中国软交会的资深记者，他表示：中国软交会在同类的软件展会中仍然是最专业的，为参会者提供的服务也是最优质的。并且，十多年来软交会一直持续创新，不断改进办会水平，提升服务质量，相信中国软交会一定会越办越好，越走越远。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	三、国际化水平大幅提升，首设专题馆，中外领军企业展现国际领先水平。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	世界500强企业再聚首，本届中国软交会再次成为业界领军企业汇集的场所。英特尔、SAP、IBM、FIL、索尼、戴尔、丰田通商、NEC、NTT DATA、日本财产保险、日冲信息、安永、新日铁软件、住电软件、野村信息、恩梯梯、阿尔卑斯、川崎重工、柯尼卡美能达、软银芘爱思、松下电器、思迪软件、阿自倍尔、慧搜网络、赉卡睦、欧姆龙、博涵英电、捷太格特、盟世热线、富士通、通世泰等30家世界知名的跨国企业汇聚展览现场。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	来自日本、韩国、美国、新加坡、印度、德国、意大利、香港、台湾等共计20多个国家和地区的参展团、观摩团汇聚本届中国软交会。香港馆、日本馆、韩国馆重磅推出，展现产业特色。香港馆共有15家香港企业，展出面积196平方米，开幕当日举行了盛大的开馆仪式，现场展商观众反响热烈。韩国展团7家企业带来最新的技术产品, 包括用于旅游的电子地图服务、造船业管理系统、医疗3D立体映射技术、移动业务卡等产品，并与中国企业举办一对一的对接洽谈会，促进中韩企业之间的交流与合作。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	国内参展企业参展团组再现中国“软实力”。国内30余家软件百强企业，全面展现软件产业的软环境和硬实力。包括东软、用友、中软、中科红旗、方正国际、清华同方、浙大网新、海辉、华信、中创、浪潮、瑞星等国内领军企业；以及中国移动、中国联通、中国电信等运营商。近百家大连软件和信息服务企业，以及中关村软件园、中国（南京）软件谷、大连软件园、腾飞软件园、东营软件园、沈阳国际软件园、杭州北部软件园、黑大科技园、吉林省东北亚文化创意科技园、济南齐鲁软件园、嘉兴创意创新软件园、江西慧谷红谷创意产业园、昆山软件园发展有限公司、宁波市软件与服务外包产业园、齐鲁软件园、深圳市高新科技园等45个软件园齐聚展览。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	今年，国内地方省市展团出现许多新的面孔。据统计，本届中国软交会参展参会省市团组数量达到45个。其中北京、上海、辽宁、黑龙江、吉林、浙江、广东、江苏、山东、山西、安徽、河南、河北、内蒙古、新疆、甘肃、云南、广西、湖北、江西、宁夏、深圳、宁波、厦门、苏州的25个省市设立了展台，带来最新的软件产品、解决方案、对接项目，全面呈现各地产业发展水平。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	四、现场交易性显著提升，硕果累累，合同意向成交额过千亿。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	本届中国软交会取得了较为丰硕的成果。据不完全统计， 806家参展商洽谈及签订交易项目987笔，合同意向成交额1002.89亿元人民币，其中离岸意向成交额56.61亿美元。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	本届中国软交会期间，组委会与长春市商务局、吉林省商务厅、日经BP、大韩贸易振兴公社和香港特区政府资讯科技总监办公室分别组织了长春市与大连服务外包企业座谈会、吉林省对日本服务外包推介会、日本BPO发包商商务配对专场、内地与香港信息技术发展交流论坛及中韩IT企业对接会、中日IT企业交流会等对接会，汇集国内外软件产品开发商、软件产品代理商、系统集成商的平台，为IT需求双方提供了有效的交易平台。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	2013中国软件交易渠道年会汇集了来自全国各地的软件开发商、软件代理商、系统集成商、服务提供商以及部分省市的软件协会、软件园区的代表共180多人，共有20多家企业达成合作意向，意向金额5000多万。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	朝阳市加华电子有限公司的光纤传感器项目，与大庆油田合达成合作，交易金额2000万；北方金融后台服务基地的档案处理项目，与辽宁建行达成合作，交易金额2300万；康泰医学信息系统有限公司的远程医疗系统项目，与河南元丰科技网络有限公司达成合作交易，交易金额5000万；苏州朗昇通信科技有限公司的流媒体平台项目，与无锡黑盒科技有限公司签达成合作，交易金额1000万；哈尔滨工业大学光学目标仿真与测试技术研究所的旅游电商平台项目，与国家智慧旅游服务中心达成合作项目，交易金额3000万；香港某传媒集团现场就3D打印项目与参展企业达成合作意向，意向金额1200万。东软国际与阜新市海洋科贸有限责任公司的数据处理项目达成合作意向，意向金额 3000万；鞍山联山矿公司与辽宁聚进科技有限公司的数字矿山项目达成2000万的成交意向额；电力行业针对调度自动化技术支持系统升级、智能电表自动采集系统、ERP系统深化应用等需求意向成交额逾30亿元。<br />\r\n此外，英特尔中国软件与服务事业部带来了从终端到云计算全面的计算解决方案，尤其是大数据技术平台，瞄准当前智能城镇建设中的关键需求揭示全新机遇，助推大数据生态系统在中国的成功实施和应用；香港展团展出的听障人士寻求听障突破的助听产品、跨平台电子书出版系统、智能互动广告展示及分析平台、东南亚最大3G流动网络增值服务等新产品广受关注。中国科学院自动化研究所研发的3D打印机让参展者大开眼界，吸引了众多3D发烧友的关注。本届中国软交会展览现场利用全新的声光电等高科技手段，使软件展览更直观好看，展示效果更形象生动，互动体验更加娱乐友好，让观众通过体验和活动，感受融入到日常工作和社会生活方方面面的智能应用。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	五、专业论坛汇聚高端演讲嘉宾，共话产业趋势，探寻IT未来十年的智能发展。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	本届中国软交会共有58场专题会议论坛活动。其中1场高峰论坛是诠释全球产业热点和软交会主题的重要会议；8场主题论坛包括自主创新论坛、外包年会、人才教育论坛、政策趋势发布会、投融资论坛、项目管理论坛、保税政策与应用论坛和版权保护论坛，围绕中国IT未来十年、创新驱动经济发展、技术商业时代的服务外包变革、新形势下创新性就业人才培养、智能时代新趋势、中小企业融资新路径、新法律环境下电子证据与软件企业知识产权保护、项目管理提升组织绩效等话题进行讨论。42场行业应用会议和专业技术会议，内容包括供热、零售、物流、制造业、建筑、医疗、电力、金融、旅游、企业管理等十几个行业，专业技术论坛涉及大数据、云计算、物联网、移动互联、电子商务、信息安全等众多专业领域；此外，还有7场中外区域合作对接会，以及英特尔等企业举办的技术讲座和专题会议。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	演讲嘉宾共有来自英特尔、IBM、微软、ePals、日经BP、东软、文思海辉、NTTDATA、Wipro、Tradeshift、赛迪顾问、马丁沃夫、浙大网新、软通动力、徐工集团、普华永道、CA创投、云辰科技、Stefanini、科锐国际、讯和创新等国内外业界著名企业的知名人士、专家学者、企业高层约500余人，深度诠释了“智能改变未来”的主题，深入探讨了大数据、云计算、物联网在信息化发展中的广泛应用，物联网、云计算在安全、通信、存储、能源、智能制造等方面的发展现状与趋势。来自66个国家、30多个行业领域的参会听众共同感受IT科技的创新带来的智能应用。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	主题论坛中产业趋势、行业报告集中发布，进一步深化融合应用。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	《2013中国企业信息化及软件需求报告》，对全国29个省市自治区进行深入调研，针对近年来企业软件需求总体状况、企业信息化进展总体状况以及各国内社会经济各主要行业的信息化投入、采购意向作了较为详尽的分析。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	《2013中国软件自主创新报告》，对2012年国内外软件产业的发展情况及热点做全面研究，掌握中国软件企业的发展特点，评价企业自主创新能力，对中国23个软件行业发展较具规模的省市自治区内的企业，在基本经营范围、创新规划、研发投入能力、人力资源情况等多个方面进行调研。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	业界资深人士、专家、分析师纷纷发布关于云计算、大数据以及商业智能领域的最新产业趋势。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	赛迪顾问副总裁赫建营说，国际电子信息产业虽然还在增长，但已进入低速增长阶段，中国也是如此。2012年中国软件产业工实现软件业务收入2.5万亿元。工信部统计行业增速仍然保持2%增长，但现在从28%下降到25%；中国软件产业运行态势在多重因素推动下会持续缓中求稳，进入相对比较稳定阶段。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	英特尔亚太研发集团总经理何京翔说，为适应当前云计算与大数据高速发展的趋势，英特尔将不仅是一个硬件公司，在软件方面投入将越来越多。英特尔现已成为最大的开源公司，英特尔和解决方案合作伙伴密切合作在英特尔架构方面开展一些产品，以获得双赢结局。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	Tradeshift公司CEO克里斯蒂安?朗格介绍了商务软件的发展现状和趋势。朗格认为，社交化，将为未来的商务软件带来机遇。此外，商务软件的开放性也非常重要。下一代商务软件应该是免费的，而且每一个企业都可以借助它塑造自己的形象。商务软件云端化，是未来非常重要的趋势。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	马丁沃夫并购顾问公司创始人兼总裁马丁?沃尔夫表示，跟美国同行相比，中国IT巨头还有很长的路要走。中国公司需要更多资本，需要提升利润率，此外，知识产权作为外部环境，也是非常重要的因素。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	微软大中华区副总裁兼市场战略部总经理、微软大中华区首席云计算战略官谢恩伟在主题演讲中谈到了社交、大数据两大IT趋势，他说，社交作为协同工具，能让公司生产力达到一个新的高度。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	日经BP社亚洲业务总监大和田尚孝介绍了日本大数据领域的趋势。他说，日本大数据市场规模每年都在增加，到2016年会达到700多亿日元的规模。大数据的运行需要服务器储存、网络、软件、服务等环节。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	通动力信息技术（集团）有限公司CTO方发和说，大数据有四大发展特征：海量、速度、数据和价值。从2012年起，全球大数据市场规模由6.3亿元涨到43亿元。各行各业都有很大发展空间利用大数据更有效开展业务、销售等。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	六、重点活动开启炫彩篇章，融合科技与艺术，汇集软件领域各项赛事。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	“2012-2013中国软件和信息服务业年度发布会”作为软交会贯穿年度的盛事之一，发布了2012-2013中国软件和信息服务业领军人物奖、突出贡献企业奖、创新影响力企业奖、最具潜力企业奖、最具竞争力产品奖、最佳解决方案奖和最佳服务园区奖等年度奖项，对本年度产业发展和产业新动态、新业态进行了梳理，全面展示获奖企业特色，展望未来产业发展规模、趋势及前景。有近百家企业入选，400余位企业家出席。发布会上，由组委会策划制作的《信息的故事》沙画首次播出。《信息的故事》是国内首次用艺术的形式，以简洁的画面展现了数字产生到大数据应用的IT技术的变迁，赢得了全场热烈的掌声。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	同期举办的每年一度的“中国?大连2013国际IT暨夏季人才招聘洽谈会”，邀请了阿尔派、简伯特、FIL、东软、文思海辉、捷太格特、华锐重工、联邦教育等120家国内外知名企业参会，提供岗位3500个，为各类人才和高校毕业生就业提供了服务平台。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	“大连IT产业游”活动自举办起就颇受欢迎。组委会带领200多位参展客商、行业媒体考察大连软件产业和重点企业，参观访问大连高新园区软件产业带。各位参展客商通过产业游活动更好地了解中国IT企业发展的情况及大连的产业环境。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	克莱斯勒杯第三届黑马大赛—“软件行业”专场在本届中国软交会上开赛，大赛吸引了国内100余家软件领域的创新型企业参赛，上千家软件企业现场观摩，数十家知名风投机构强烈关注。大连菜易家、新锐天地、君德文化等5家创业黑马入围红牛创业榜样，22家创业黑马晋级7月5日举办的黑马大赛南京软件行业决赛。大赛得到数十家知名风投机构及东软、高德、畅捷通、万兴软件等多家软件企业的关注。&nbsp;&nbsp;&nbsp;\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	“全国职业院校技能大赛移动互联网应用软件开发大赛”展现了高职学生创意和开发技能，培养创新意识和自主创业能力，合计45家企业就50个项目表示合作意向，意向金额773.5万。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	“豪之英杯”高尔夫球邀请赛第十一届中国软交会专场，奉上了IT行业的高尔夫球盛会，邀请了50余位大连IT企业高层，展现业界领袖的别样风采。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	七、注重完善细节服务，关注展商需求，搭建更切实的交流平台。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	参加本届中国软交会的业内人士和媒体普遍认为，本届中国软交会的组织工作，较往届有明显的改变和提升，展前开通的网上交易平台，为中外企业商务配对的网上预约洽谈服务。专门搭建洽谈区和服务区，现场配对交易为展商和客商交流提供便利。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	组委会为本届中国软交会特别组织的“千人买家团”主题活动，优选近千名买家与国内外软件服务外包参展商进行一对一洽谈对接。自报名开始就受到参展参会企业的关注，纷纷报名参加现场对接，组委会为活动设置的网站报名系统也非常清晰详实呈现了24个行业类别，方便企业进行选择。活动期间，来自金融行业、制造业、医疗业、电力、外包等行业的1011家买家企业，在现场进行对接洽谈、交流交易，达成诸多成交合作意向，意向成交金额63.2亿。其中电厂及电网调度自动化技术支持系统升级、智能电表自动采集系统、ERP系统深化应用等整体需求意向交易额预计在30亿左右。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	为了便于参展企业、参会观众及新闻媒体更深入了解本届中国软交会，更便利的参与每个会议活动，组委会专门开设了手机wap页面、二维码网站信息、手机APP等多个电子信息平台，方便查询会议信息、活动地点、服务信息等多项内容，为参会者提供了便捷了服务平台。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	中国软交会肩负发展与繁荣中国软件和信息服务产业的责任，承载促进中国贸易转型的时代使命，见证了中国软件业发展的辉煌历程，中国软交会将力求进一步创新，在权威性、专业性、国际性、实效性上有更大的突破，专注于高品质的客户需求服务，进一步推进市场化和提升交易性，确保在新一轮的挑战和竞争中，继续保持领先地位。\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('49', '上半年山东省服务外包合同额31.99亿美元', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;今年上半年，山东省服务外包持续保持良好发展态势。登记承接服务外包合同5602份，同比增长37.4%；合同金额31.99亿美元，增长167.5%；执行金额17.56亿美元，增长122.5%。其中，离岸服务外包合同4403份，同比增长38.6%；合同金额27.51亿美元，增长139.5%；执行金额17.26亿美元，增长131.7%。主要呈现以下特点：\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	一、企业主体建设成效显著。一是主体队伍不断壮大。1-6月份，全省12个市439家企业登记开展业务，较上年同期增加105家。二是骨干企业大幅增加。全省离岸执行额过百万美元企业达到227家，过五百万美元企业78家，过千万美元企业36家，较上年同期分别增加99家、43家和16家，增幅分别为77.3%、122.9%和80%。三是“三个十”工程稳步推进。IBM、微软、简伯特、日立系统等4家全球知名发包企业和东软集团、软通动力、海辉软件、大连华信等4家国内服务外包领军企业落户山东省。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	二、重点城区发挥领军作用。一是济南、青岛迅猛发展。1-6月份，济南、青岛两市离岸执行额分别为6.96亿美元、6.79亿美元，较去年同期均实现倍增，占全省比重分别达到40.3%和39.3%。二是示范基地健康发展。全省19各示范基地离岸执行额11.63亿美元，占全省67.4%。其中，8个示范基地离岸执行额实现倍增。17个示范基地离岸执行额过千万美元，济南高新区、青岛崂山区、济南市中区、青岛开发区示范基地离岸执行额过亿美元。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	三、海外市场呈现新格局。1-6月份，山东省承接离岸服务外包来源地达到137个国家和地区，较上年同期增加30个，有31个国家和地区执行额超过千万美元，较上年同期增加14个。其中，对美加执行额3.47亿美元，同比增长146.8%，对日执行额3.45亿美元，同比增长64.4%，受日元贬值影响，对日服务外包增速减小，占全省比重较去年同期大幅下降，美加超越日本成为山东省最大服务外包来源地。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	四、三大类型业务同步发展。1-6月份，全省信息技术外包（ITO）对外接包能力不断增强，离岸执行额达到7.41亿美元，同比增长84.2%，占全省42.9%。技术型业务流程外包（BPO）及知识流程外包（KPO）保持高速增长，离岸执行额分别达到3.12亿美元、6.73亿美元，同比增长111.5%、245%。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	上半年，全省服务外包虽然保持了高速增长，但是发展中还存在对骨干龙头企业缺乏、市场过于集中、载体建设缺口大、高端人才不足等问题。同时，在对服务外包的认识、工作组织开展及全年目标任务完成情况等方面，各地间也存有一定差距。下半年，各市要继续按照“巩固、发展、创新、提高”的工作思路，进一步加强载体建设、人才培训、对外招商，加大政策扶持力度，提高认识，增强信心，开拓创新，重点做好以下几项工作：\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	一是各市要对照时间进度和全年任务目标，认真查找存在的问题、研究有效的工作措施，坚持按照 “大力开拓、合理认定、稳健统计”的原则，深入挖掘服务外包企业，科学认定业务类型，切实提高服务外包统计工作水平，推动服务外包工作健康快速发展。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	二是坚持多元化开拓市场。深入开拓欧美市场，稳定拓展日本市场，坚持离岸、在岸业务同步发展，支持企业与客户协商实行人民币跨境结算、美元结算等方式，规避日元贬值汇率风险。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	三是按照《山东省服务外包绩效评价管理办法（试行）》和《山东省服务外包示范基地考核评价管理办法》，下半年，省厅将对19个省级服务外包基地进行评估考核，强化指导监督，对评估不达标的挂黄牌警告，请认真做好服务外包示范基地评估考核准备工作。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('50', '上半年大连高新区软件和信息技术服务业收入4', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;记者7月9日获悉，大连高新区主要经济指标成功实现“时间过半、任务过半”，第三次创业实现了良好开局。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	全区经济继续保持平稳发展，转型升级步伐明显加快，经济质量稳步提升，呈现出以创新能力驱动、新兴业态引领和产业优化升级为主要特征的良好态势。招商引资在开拓新兴市场、培育新兴产业、推进重大项目落地等方面取得突破性进展，印度、巴西等软件企业项目引进工作加速推进，多家科技金融投资公司完成注册或计划设立金融总部。韩国三星物产、美国哥伦比亚亚洲医院和大连中心医院三方计划投资两亿美元设立合资医院及医疗产业投资总部。上半年，已累计引进东芝医疗系统、富士施乐嵌入式软件研发中心等6家世界500强企业项目。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	以软件和信息服务业为核心的特色主导产业高速发展，产业高端化和集聚效应明显。上半年，软件和信息技术服务业销售收入达到486亿元，增长30.2%；出口创汇超过6亿美元，增长24%。软件和信息技术服务快速向嵌入式软件、系统集成、行业解决方案等高端服务挺进。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	高新区转型升级步伐加快。上半年，第三产业占GDP比重继续上升，转型升级速度明显加快，结构调整战略取得显著成效。初步核算，高新区上半年完成GDP120.3亿元，可比增长9.8%。其中，第三产业完成增加值96.3亿元，可比增长17%，占GDP的比重已由2012年的71.3%增加到当前的80%。在第三产业中，计算机服务和软件业上半年实现增加值56.6亿元，占第三产业比重明显上升，主导地位更加突出。目前，高新区已进入产业转型升级的加速发展阶段。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('51', '绵阳商务局赴成都考察服务外包知名企业', '<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;7月5日，绵阳市商务局副局长潘大钦、外经贸科科长周玲在区招商局相关人员的陪同下赴成都考察服务外包知名企业——成都聚思力信息技术有限公司。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	成都聚思力负责人首先向潘局长介绍了公司概况，其中重点介绍了公司市场分布、优势业务和发展规划。潘局长表示，绵阳是中国唯一的科技城，政策优势明显，服务外包产业是绵阳重点发展方向，科创区发展服务外包产业的软硬件环境相对比较成熟，希望双方进一步加强交流与沟通，务实推进项目合作进程。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	区招商局局长陈劲松也就聚思力公司入驻科创区的一些具体愿望进行了简要回答，双方同意尽快起草合作文本，待区党工委、管委会审批通过后，启动投资合作程序。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	美国聚思力公司简介\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	SYNNEX于1980年成立于美国加州，是全球知名的跨国IT供应链服务提供商，于2003年在纽约成功上市，目前是全球第三大IT分销商、美国财富500强以及《福布斯》杂志白金级企业400强、硅谷15强企业之一。SYNNEX在全球共有16处分公司及办事处、分别分布于美国、中国、加拿大等国家。SYNNEX在电脑、存储设备、网络产品、通讯产品、系统软件、配件和外围设备的生产、物流及供应链管理上处于领先地位，拥有功能强大的全球ERP系统和国际化的经营管理团队，在全球占有巨大的分销及外包市场份额。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	SYNNEX于2000年登陆中国，经过多年的发展，SYNNEX（中国）已在北京、成都、上海、广州、香港设立多家分公司及办事处，拥有员工近千名，并计划于2007年在更多沿海及内陆城市成立分支机构，以进一步促进在中国地区的业务开展。SYNNEX中国地区总部--北京新聚思信息技术有限公司，于2005年通过CMMI 3 认证，目前已是北京市高新技术企业和北京市2005年软件出口十强企业之一。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	成都聚思力信息技术有限公司，是SYNNEX在2006年斥资700万美元，在成都高新区天府软件园设立其独资子公司，并计划在未来三年内增加投资额到4200万美金，并在今年内发展成为2000人规模的上市公司。成都聚思力信息技术有限公司将作为SYNNEX在中国华西地区的客户服务的研发运营中心，为SYNNEX全球客户提供完善的BPO、ITO、IT技术支持、业务流程管理，以及全方位的电子商务支持服务。\r\n</p>\r\n<p style=\"font-family:Arial;background-color:#F8F9FB;\">\r\n	&nbsp;\r\n</p>', '', '26', '', '2013-11-10', '', '0');
INSERT INTO `ms_article` VALUES ('53', '陶展', '<pre> 陶瓷数字展厅系统是目前最流行的一种数字虚拟展厅技术，能给参观者带来全新的真实现场感受和良好的交互操作体验。\r\n    铭飞陶瓷数字展厅系统采用最新的云技术，展厅中的每件艺术作品都能发布到各大论坛、空间、微博、淘宝等平台进行展示，帮助艺术家和企业快速通过网络营销的方式推广陶瓷艺术作品，提升艺术家、企业的知名度和品牌价值。</pre>', '', '13', '', '2013-11-21', '/upload/1385017157565.jpg', '2');
INSERT INTO `ms_article` VALUES ('55', '报表', '<p>\r\n	&nbsp;铭科技开源excel报表系统，支持多用户在线编辑报表。灵活的查看权限和单元格权限方便管理人员对用户编辑单元格时很好的控制。\r\n</p>\r\n<p>\r\n	&nbsp;铭科技开源excel报表系统，支持多用户在线编辑报表。灵活的查看权限和单元格权限方便管理人员对用户编辑单元格时很好的控制。\r\n</p>\r\n<p>\r\n	&nbsp;铭科技开源excel报表系统，支持多用户在线编辑报表。灵活的查看权限和单元格权限方便管理人员对用户编辑单元格时很好的控制。\r\n</p>\r\n<p>\r\n	&nbsp;铭科技开源excel报表系统，支持多用户在线编辑报表。灵活的查看权限和单元格权限方便管理人员对用户编辑单元格时很好的控制。\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>', '', '13', '', '2013-11-21', '/upload/1385017119616.jpg', '2');
INSERT INTO `ms_articletype` VALUES ('1', '0', '关于铭飞', null, '', '', 'about_ms.htm', null, null, '2', '<pre>    铭飞科技有限公司是专注于传统互联网、移动互联网、物联网相关软件产品的研发，为企业提供IT外包、(手机)软件开发、网站建设等服务。\r\n    公司成立于2012年年初，由业内拥有多年软件产品研发、团队管理、移动增值业务运营经验的精英团队创办。其核心成员既有在软件生产领域多年浸染的技术能手，又有青春活力、富于激情的行业新秀。他们掌握着目前最新的软件研发技术和最前沿的行业需求，保障铭飞科技有限公司在行业中强大的核心竞争力。  </pre>\r\n<pre>    公司在贸易、报业、商旅、团购、教育、银联支付等行业领域拥有成功的合作案例。 \r\n</pre>\r\n<div>\r\n	<br />\r\n</div>');
INSERT INTO `ms_articletype` VALUES ('2', '1', '公司简介', null, '', '', 'about_ms.htm', null, null, '2', '<pre>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 铭飞科技有限公司是专注于传统互联网、移动互联网、物联网相关软件产品的研发，为企业提供IT外包、(手机)软件开发、网站建设等服务。\r\n    &nbsp;&nbsp;&nbsp;&nbsp;公司成立于2012年年初，由业内拥有多年软件产品研发、团队管理、移动增值业务运营经验的精英团队创办。其核心成员既有在软件生产领域多年浸染的技术能手，又有青春活力、富于激情的行业新秀。他们掌握着目前最新的软件研发技术和最前沿的行业需求，保障铭飞科技有限公司在行业中强大的核心竞争力。  </pre>\r\n<a href=\"\"></a> \r\n<pre></pre>\r\n<pre>    &nbsp;&nbsp;&nbsp;&nbsp;公司在贸易、报业、商旅、团购、教育、银联支付等行业领域拥有成功的合作案例。 \r\n</pre>\r\n<div>\r\n	<br />\r\n</div>');
INSERT INTO `ms_articletype` VALUES ('3', '1', '公司理念', null, '', '', 'about_ms.htm', null, null, '2', '<p>\r\n	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 铭飞科技有限公司以“专业化、标准化、统一化”模式为企业提供“方便、安全、快捷、舒心”的服务。\r\n</p>\r\n<p>\r\n	　　铭飞科技有限公司作为江西地区一家具有技术研发领导力的软件公司，主要体现在3个方面：\r\n</p>\r\n<p>\r\n	　　1. 一流的研发队伍：我们对软件服务工程师进行严格的4级技术水平认证（助理—中级—高级—资深），确保过硬的产品服务品质；\r\n</p>\r\n<p>\r\n	　　2. 一流的服务管理：我们在总结10年软件产品研发实践的基础上，能够对软件服务进行“标准化、规范化、精细化、数字化、动态化”管理；\r\n</p>\r\n<p>\r\n	　　3. 一流的服务保障：为客户提供全天候（7天*24小时）、快捷（市区范围内最快1小时响应）的上门服务。\r\n</p>\r\n<p>\r\n	　　让客户从工作中体验到信息化服务所带来的帮助，让客户从生活中体验到信息化所带来的乐趣。\r\n</p>\r\n<p>\r\n	　 &nbsp;——这，就是铭飞永恒不变的工作使命！ &nbsp;\r\n</p>');
INSERT INTO `ms_articletype` VALUES ('4', '1', '公司图文', null, '', '', 'about_ms.htm', null, null, '2', '<img src=\"http://www.ming-soft.com/uploads/allimg/121015/1-12101509100D03.gif\" />');
INSERT INTO `ms_articletype` VALUES ('5', '0', '首页', null, '', '', null, 'index.htm', 'index.htm', '1', null);
INSERT INTO `ms_articletype` VALUES ('6', '0', '产品介绍', null, '', '', 'product_introduce.htm', null, null, '2', '<pre> &nbsp;  陶瓷数字展厅系统是目前最流行的一种数字虚拟展厅技术，能给参观者带来全新的真实现场感受和良好的交互操作体验。\r\n    铭飞陶瓷数字展厅系统采用最新的云技术，展厅中的每件艺术作品都能发布到各大论坛、空间、微博、淘宝等平台进行展示，帮助艺术家和企业快速通过网络营销的方式推广陶瓷艺术作品，提升艺术家、企业的知名度和品牌价值。</pre>\r\n<pre><img src=\"http://www.ming-soft.com/uploads/121014/1-1210140T921927.jpg\" alt=\"铭飞陶瓷数字展厅与传统陶瓷展示方式比较\" /></pre>\r\n<pre><img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-1210140U102c8.jpg\" alt=\"铭飞陶瓷数字展厅应用场景\" /></pre>\r\n<pre><img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-1210140U1464a.jpg\" alt=\"铭飞陶瓷数字展厅说明\" /> </pre>');
INSERT INTO `ms_articletype` VALUES ('7', '6', '陶瓷数字展厅', null, '', '', 'product_introduce.htm', null, null, '2', '<pre> 陶瓷数字展厅系统是目前最流行的一种数字虚拟展厅技术，能给参观者带来全新的真实现场感受和良好的交互操作体验。\r\n    铭飞陶瓷数字展厅系统采用最新的云技术，展厅中的每件艺术作品都能发布到各大论坛、空间、微博、淘宝等平台进行展示，帮助艺术家和企业快速通过网络营销的方式推广陶瓷艺术作品，提升艺术家、企业的知名度和品牌价值。</pre>\r\n<pre><img src=\"http://www.ming-soft.com/uploads/121014/1-1210140T921927.jpg\" alt=\"铭飞陶瓷数字展厅与传统陶瓷展示方式比较\" /></pre>\r\n<pre><img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-1210140U102c8.jpg\" alt=\"铭飞陶瓷数字展厅应用场景\" /></pre>\r\n<pre><img src=\"http://www.ming-soft.com/uploads/allimg/121014/1-1210140U1464a.jpg\" alt=\"铭飞陶瓷数字展厅说明\" /></pre>\r\n<pre>\r\n</pre>');
INSERT INTO `ms_articletype` VALUES ('8', '6', 'Excel在线报表系统', null, '', '', 'product_introduce.htm', null, null, '2', '<p>\r\n	一、简介\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; 铭科技开源excel报表系统，支持多用户在线编辑报表。灵活的查看权限和单元格权限方便管理人员对用户编辑单元格时很好的控制。\r\n</p>\r\n<p>\r\n	二、功能介绍\r\n</p>\r\n<p>\r\n	1、 &nbsp;登陆\r\n</p>\r\n<p>\r\n	2、 &nbsp;退出\r\n</p>\r\n<p>\r\n	3、 &nbsp;修改基本信息\r\n</p>\r\n<p>\r\n	4、 &nbsp;数据维护用户管理\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; &nbsp;a) &nbsp; &nbsp; &nbsp; &nbsp; 添加数据维护用户\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; &nbsp;b) &nbsp; &nbsp; &nbsp; &nbsp;修改数据维护用户\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; c) &nbsp; &nbsp; &nbsp; &nbsp; 删除数据维护用户\r\n</p>\r\n<p>\r\n	5、 &nbsp;资源共享\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; a) &nbsp; &nbsp; &nbsp; &nbsp; 发布共享资源\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; b) &nbsp; &nbsp; &nbsp; &nbsp;共享资源查看权限分配\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; c) &nbsp; &nbsp; &nbsp; &nbsp; 删除共享资源\r\n</p>\r\n<p>\r\n	6、 &nbsp;Excel模版管理\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; a) &nbsp; &nbsp; &nbsp; &nbsp; 新建excel模版\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; b) &nbsp; &nbsp; &nbsp; &nbsp;修改excel模版\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; c) &nbsp; &nbsp; &nbsp; &nbsp; 删除excel模版\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; d) &nbsp; &nbsp; &nbsp; &nbsp;管理excel查看权限\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; e) &nbsp; &nbsp; &nbsp; &nbsp; 管理excel单元格修改权限\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; f) &nbsp; &nbsp; &nbsp; &nbsp; 导入本地excel数据模版\r\n</p>\r\n<p>\r\n	7、 &nbsp;Excel表格数据管理\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; a) &nbsp; &nbsp; &nbsp; &nbsp; 查找excel表格数据\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; b) &nbsp; &nbsp; &nbsp; &nbsp;修改excel表格数据\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; c) &nbsp; &nbsp; &nbsp; &nbsp; 导出excel数据到本地\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<p>\r\n		三、软件截图\r\n	</p>\r\n<img src=\"http://www.ming-soft.com/uploads/allimg/130123/1-130123141111443.jpg\" />\r\n</p>\r\n<p>\r\n	<img src=\"http://www.ming-soft.com/uploads/allimg/130123/1-130123141214432.jpg\" />\r\n</p>');
INSERT INTO `ms_articletype` VALUES ('9', '6', '企业ERP', null, '', '', 'product_introduce.htm', null, null, '2', '<h2 class=\"headline-1 first bk-sidecatalog-title\">\r\n	一、简介\r\n</h2>\r\n<h2 class=\"headline-1 first bk-sidecatalog-title\">\r\n	&nbsp; &nbsp; &nbsp;企业ERP系统标准的定义来自于其英文原意，即企业资源规划(Enterprise Resource Planning)。企业ERP系统是一个对企业资源进行有效共享与利用的系统，通过信息系统对信息进行充分整理、有效传递，使企业的资源在购、存、产、销、人、财、物等各个方面能够得到合理地配置与利用，从而实现企业经营效率的提高。从本质上讲，企业ERP系统是一套信息系统，是一种工具。系统设计中可集成某些管理思想与内容，可帮助企业提升管理水平。\r\n</h2>\r\n<p>\r\n	<br />\r\n</p>\r\n<h2 class=\"headline-1 bk-sidecatalog-title\">\r\n	二、系统特点\r\n</h2>\r\n&nbsp; &nbsp; &nbsp; 1.一体化管理的特点<br />\r\n　　在传统的企业管理中，采购、生产、销售、财务、人力资源等几个关键的企业行为相对独立，各有各的管理方式与系统，相互之间的信息用人工的方式进行传递，这就造成了信息的重复处理，甚至人为造成信息的不一致性，降低了效率，浪费了资源。而企业ERP系统提供了一个统一的平台，有效整合了企业行为中的各环节，其信息的传递是线性的，从订单到利润的实现，形成了一体化管理，从而有效地调动了企业资源，提高了管理效率。\r\n<div class=\"spctrl\" style=\"margin:0px;padding:0px;\">\r\n	&nbsp;\r\n</div>\r\n　　2.适应企业多种生产方式的特点\r\n<p>\r\n	　　企业的生产方式是多种多样、富有个性的。一套好的管理软件不仅体现先进的管理理念，还能适应企业多种生产方式，引导企业适应市场变化。企业ERP系统支持对混合型生产方式的管理，其管理思想主要表现在两个方面：其一是“精益生产”的思想。即企业按大批量生产方式组织常规生产，通过流程再造，消除不合理的环节，提高企业常规生产效益；其二是“敏捷制造”的思想。是指特定情况下非常规生产，通过特定的流程，有效调集企业资源，体现企业对市场的反应速度。\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; 3.充分体现了事先计划与事中控制的特点<br />\r\n　　企业ERP系统通过一体化管理，使企业管理者能实时了解生产各环节资源使用情况，通过计划管理进行事先计划与事中控制。系统中的计划体系主要包括生产计划、物料需求计划、能力计划、采购计划、销售执行计划、利润计划、财务预算和人才交流计划等，这些计划功能与价值控制功能已完全集成到整个供应链系统中，并通过定义事务处理相关的会计核算科目与核算方式，在事务处理发生的同时自动生成会计核算分录，保证了资金流与物流的同步记录和数据的一致性，从而实现了可根据财务资金现状，追溯资金的来龙去脉，并进一步追溯所发生的相关业务活动，改变了资金信息滞后于物料信息的状况，便于实现事中控制和实时做出决策。\r\n</p>\r\n<div class=\"spctrl\" style=\"margin:0px;padding:0px;\">\r\n	&nbsp;\r\n</div>\r\n　　4.强调管理环节中协调作用的特点<br />\r\n　　企业ERP系统的计划、事务处理、控制与决策等功能都是在整个供应链的业务处理流程中实现的，它要求在每个流程业务处理过程中最大限度地发挥每个人的工作潜能与责任心，流程与流程之间则强调人与人之间的合作精神，以便在有机组织中充分发挥每个人的主观能动性与潜能，进而有效实现企业管理中信息的横向传递，减少信息传递的中间环节。使企业管理由层层管理的“高耸式”组织结构向管理者直接面对作业层的“扁平式”组织机构转变，提高企业对市场动态变化的响应速度。\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<h2 class=\"headline-1 bk-sidecatalog-title\">\r\n		三、对企业的影响\r\n	</h2>\r\n　　1.整合企业供应、生产、销售价值链<br />\r\n　　伴随企业竞争范围的扩大，企业为了应对竞争，不但需要对自身资源信息的掌握，同时需要将供应商和销售商信息进行整合形成相对完整的供销体系信息，以共同应对变化的市场和竞争对手的多变的竞争手段，力争实现集体的竞争优势，达到共赢的目的。由于有了先进的信息技术和ERP，使企业有了实现整合价值链信息的技术平台，解决了手段的问题。\r\n	<div class=\"spctrl\" style=\"margin:0px;padding:0px;\">\r\n		&nbsp;\r\n	</div>\r\n　　2.管理思想的改变<br />\r\n　　传统的管理模式强调事前预计、事中控制、事后审核，业务的发生人为分为几个环节，而企业ERP系统的思想则是实时的跟踪，管理者可以跟踪到业务的每一步操作，随时发现存在的问题。甚至通过专门的软件设计，让系统自动通报问题。公司的管理成了一个动态的系统，一个环环相扣的过程。而且部分原有的业务流程要重新调整，减少随意性，加强规范性。管理信息越来越精细和集成。例如在传统信息流体系下，要想得到实时的销售信息几乎是不可能的，只有每天或每一规定的时段由销售统计人员将一定时间的销售信息进行汇总后才能提供完整的销售信息。而在企业ERP系统下，物流和信息流是同时进行的，管理者可随时得到任何时间和任何时段的销售信息。\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp;3.信息来源的变化<br />\r\n　　在原有的管理系统中，物流、资金流、信息流是相互分离的，信息来源于对物流、资金流的综合处理，如月底综合处理全部的验收、领料、销售。在日常的运转中信息流是与其他流动相分离的，他们之间的关系只有月度结算后才明朗，而企业ERP系统则把三者和而为一，每一种流动都连带其他流动，而且同时分不同的渠道各自集中，信息的来源已不是业务部门出物流信息，财务部门出资金流和信息流，而是，三流同时、即时流动。信息的来源向业务的源头延伸，特别是涉及物流的信息都要由物流人员在物流业务处理同时生成信息流，并定期或随时传递到整个系统。\r\n</p>\r\n<p>\r\n	&nbsp; &nbsp; &nbsp; 信息不必在规定的时间集中处理，财务人员的汇总各种信息载体的功能将向业务部门转变，财务更多的是监督信息的形成、分析信息、提出建议。业务与财务已经真正连为一体，信息共享。传统的企业财务信息处理系统，基本可以分为一级核算和二级核算两种模式，在一级核算模式下，企业的财务信息全部由财务会计部门根据各业务部门提供的原始单据集中处理，形成财务信息，出具各种会计报表。在二级核算体制下，企业财务信息处理由两层组成，第一层次的成本归集、核算由各生产车间设立的成本核算员完成，企业财务会计部门负责形成其他会计信息，出具财务报表。在这两种模式下，企业都可以使用手工处理，也可以利用一些简单的会计软件。但最终的财务信息、会计凭证、会计分录都是由财务部门制做。但在企业ERP系统处理背景下，企业财务信息的来源发生了一些变化，由于各业务模块分散在各业务环节中，比如采购模块由采购部门使用、库存模块由仓储部门使用，销售模块由销售部门使用，总帐、往来帐模块由财务部门使用，各模块使用者通过一种环环相扣的方式形成最终的集成信息，而某些财务信息是在业务操作时就已形成，比如：采购流程中，发出订单时不产生会计信息，验收入库时则通过对采购信息的匹配自动生成标准成本会计分录。<br />\r\n	<div style=\"margin:0px;padding:0px;\">\r\n		&nbsp;\r\n	</div>\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>\r\n<p>\r\n	<br />\r\n</p>');
INSERT INTO `ms_articletype` VALUES ('10', '6', '媒体大管家', null, '', '', 'product_introduce.htm', null, null, '2', '<p>\r\n	<h2 class=\"headline-1 first bk-sidecatalog-title\">\r\n		一、简介\r\n	</h2>\r\n&nbsp; &nbsp; &nbsp;媒体体大管家广告业务管理系统是针对广告行业用户开发研制的办公业务管理系统。本系统操作简便工作流程清晰，系统具有媒介资源管理、客户关系管理、业务合同管理、发布排期管理、财务收付管理、行政办公管理、部门经理管理、总经理查询等模块具有领先的技术，强大的功能和简单方便的操作更深受用户喜爱。<br />\r\n	<h2 class=\"headline-1 first bk-sidecatalog-title\">\r\n		二、特点\r\n	</h2>\r\n&nbsp; &nbsp; 跟踪媒体业务的全部发布执行流程，充分体现了电子信息化的优势，实现业务和信息综合管理。全面提升企业的管理能力和竞争能力。系统自动生成相关数据，避免了烦杂的手工统计过程，杜绝人为疏忽造成错误的发生，实现了数据的完整性，精确性、唯一性。为用户节省大量的办公费用，提高工作效率，且全面提升企业的核心竞争力。<br />\r\n&nbsp; &nbsp; 媒体大管家广告业务管理系统总结了大、中、小广告公司的实际需求,采用模型组件方式,具有强大的功能,广泛的适用性、可靠安全性和可扩展性。\r\n</p>');
INSERT INTO `ms_articletype` VALUES ('11', '6', '物业管理系统', null, '', '', 'product_introduce.htm', null, null, '2', '<p>\r\n	<h2 class=\"headline-1 first bk-sidecatalog-title\">\r\n		一、简介\r\n	</h2>\r\n	<h2 class=\"headline-1 first bk-sidecatalog-title\">\r\n		&nbsp; &nbsp; &nbsp;<span style=\"font-size:12px;font-weight:normal;line-height:1.5;\"> &nbsp;用于小区的物业管理、写字楼的物业管理和商铺的物业管理。物业的字段和报表可以根据管理不同的物业定义不同的字段，比如对于写字楼和商铺可以有合同签定日期和合同到期提醒，可以查找未交费用的住户，也可以查找住户未交的收费项目，对于小区物业可以有入住日期等，收费项目也可以自己定义，还有收费提醒功能。有固定费用收取，也有临时费用收取，还有应收费用和欠款收取管理。收费单据打印格式可以自己定义，也可以将数据导出到Excel中。可以到我们的网站下载软件演示录象，也可到我们的网站下载网络版软件需要的微软免费的数据库软件。</span><span style=\"font-size:12px;font-weight:normal;line-height:1.5;\"></span>\r\n	</h2>\r\n</p>');
INSERT INTO `ms_articletype` VALUES ('12', '6', '网站建设', null, '', '', 'product_introduce.htm', null, null, '2', '<p>\r\n	&nbsp;网站建设包括网站策划、网页设计、网站功能、网站优化技术、网站内容整理、网站推广、网站评估、网站运营、网站整体优化、网站改版等。网站建设的前期准备包括了前期网站定位、内容差异化、页面沟通等战略性调研，这些确立后，再去注册域名、租用空间、网站风格设计、网站代码制作五个部分，这个过程需要网站策划人员、美术设计人员、WEB程序员共同完成。网站是企业展示自身形象、发布产品信息、联系网上客户的新平台、新天地，进而可以通过电子商务开拓新的市场，以极少的投入获得极大的收益和利润。<br />\r\n	<p>\r\n		企业商务做网站价格套餐：<br />\r\n1. 成立型：国际域名+高端空间500M+首页设计+4大块程序开发+后期维护。企业网站基本功能类型网站建设方案，适合产品数量和服务类型不是非常多的企业网站建设方案适合中小型企业和新企业网上宣传自己的产品。 优惠价格：2880 元<br />\r\n2. 企业型：国际域名+高端空间1G+品牌企业邮箱+首页设计+banner宣传+6大板块程序开发+免费在线客服系统+后期维护。企业首选的做网站方案：适合企业通过网络进行企业形象和产品展示，方便进行电子商务合作和业务联系等，推荐使用。 优惠价格：3680 元<br />\r\n3. 商务型：国际域名+高端空间1G+品牌企业邮箱+精美Flash引导页、内页、首页设计+8大板块程序开发+banner宣传+搜索引擎站内优化，免费在线客服系统+后期维护。以产品宣传为重点，多功能网站开发，配合网站Flash，诉求企业形象适用于中、大型企业建立网站等应用及后台管理系统。<br />\r\n优惠价格：4680 元&nbsp;\r\n	</p>\r\n	<p>\r\n		企业网站维护价格：<br />\r\n1. 入门型：100元/月；<br />\r\n2. 标准型：300元/月；<br />\r\n3. 经济型：600元/月；<br />\r\n4. 商务型：900元/月；<br />\r\n5. 豪华型：1500元/月；<br />\r\n6. 专业型：3000元/月。\r\n	</p>\r\n</p>');
INSERT INTO `ms_articletype` VALUES ('13', '0', '案例展示', null, '', '', null, 'case_show.htm', 'case_show.htm', '1', null);
INSERT INTO `ms_articletype` VALUES ('14', '13', '陶瓷数字展厅', null, '', '', null, 'case_template.htm', 'news.htm', '1', null);
INSERT INTO `ms_articletype` VALUES ('15', '13', '企业应用', null, '', '', null, 'case_template.htm', 'news.htm', '1', null);
INSERT INTO `ms_articletype` VALUES ('16', '13', '媒体大管家', null, '', '', null, 'case_template.htm', 'news.htm', '1', null);
INSERT INTO `ms_articletype` VALUES ('17', '13', '网站建设', null, '', '', null, 'case_template.htm', 'news.htm', '1', null);
INSERT INTO `ms_articletype` VALUES ('18', '0', '联系方式', null, '', '', 'contact_way.htm', null, null, '2', null);
INSERT INTO `ms_articletype` VALUES ('19', '0', '公司新闻', null, '', '', null, 'news_more.htm', 'news.htm', '1', null);
INSERT INTO `ms_articletype` VALUES ('26', '0', '相关资讯', null, '', '', null, 'news_more.htm', 'news.htm', '1', null);
INSERT INTO `ms_articletype` VALUES ('27', '0', '陶瓷数字展厅', null, '', '', null, 'ceramicshall.htm', 'ceramicshall.htm', '1', null);
INSERT INTO `ms_user` VALUES ('1', 'admin', 'admin');
INSERT INTO `ms_web` VALUES ('1', '铭飞科技CMS', 'http://cms.ming-soft.com', 'http://cms.ming-soft.com/upload/', '江西软件公司,上饶软件开发,景德镇软件开发,鄱阳软件开发,九江软件开发,铭飞科技有限公司,江西铭飞软件有限公司,江西省软件外包,软件开发培训,江西软件开发实训中心,软件开发,软件公司,软件外包开发,铭飞科技,江西手机软件开发,手机软件,景德镇软件公司,江西景德镇电脑培训学校,景德镇计算机培训,江西上饶电脑培训学校,上饶计算机培训', '江西铭飞软件公司是专业的★江西软件开发公司★江西软件外包公司★江西景德镇电脑培训学校★江西软件公司★电脑培训公司★景德镇软件公司|上饶软件公司|南昌软件公司|九江软件公司|赣州软件公司★江西景德镇电脑培训学校,景德镇计算机培训,江西上饶电脑培训学校★上饶计算机培训提供学员免费实训计划,江西首家在linux和java平台下开发软件的公司，商务合作热线13397980163', '网站版权测试', 'ming-soft');
