package com.mingsoft.biz;

import java.util.List;
import java.util.Map;

import com.mingsoft.entity.ArticleEntity;

/**
 * 接口类
 * 文章管理的业务控制基类
 * 主要功能是文章的增删改查
 * @author 荣繁奎
 * QQ:1096199590
 * 铭飞科技
 * 官网www.ming-soft.com
 * 
 */
public interface IArticleBiz extends IBaseBiz {

	 
	/**
	 * * 查询文章列表总数
	 * @param pageNum
	 * @param pageSize
	 * @return 返回记录集合
	 */
	public List<ArticleEntity> queryForList(int pageNum,int pageSize);
	
	/**
	 * 向数据库添加文章
	 * @param article
	 * @return
	 */
	public boolean save(ArticleEntity article);
	
	/**
	 * 根据article 的id进行查询
	 * @param base artcile 类
	 * @return 集合列表
	 */
	public List<ArticleEntity> selectEntityList(ArticleEntity base);
	
	/**
	 * 根据标题模糊查询
	 * @param base实体类
	 * @return list列表
	 */
	public List<ArticleEntity> searchEntityList(ArticleEntity base);
	
	/**
	 * 通过id 查找文章信息
	 * @param base
	 * @return 实体类
	 */
	public  ArticleEntity selectEntity(ArticleEntity base);
	
	/**
	 * 根据文章类型 和 标题进行查询
	 * @param article 
	 * @return list
	 */
	public List<ArticleEntity> searchArtList(ArticleEntity base);
	
	/**
	 * 通过栏目ID查找文章的相关信息，如果该栏目下存在文章则返回list
	 * @param ArticleTypeID
	 * @return list
	 */
	public List<ArticleEntity> searchArticleType(int ArticleTypeID);

	/**
	 * 查询总记录数
	 * @return int
	 */
	public int queryArtcTotal();
	
	/**
	 * 查询特定文章类型下的文章总记录数
	 * 
	 * @return int
	 */
	public int queryArtcTotal(int articleTypeId,int flag,int noFlag);
	
	/**
	 * 解析HTML模版时根据文章的ID,flag,等属性取值
	 * @param articleId 文章ID属性
	 * @param flag属性
	 * @param noflag属性
	 * @param begin 光标开始位置
	 * @param count 每页显示的条数
	 */
	public List<ArticleEntity> queryListPrase(List<Integer> articleId, int flag, int noFlag,int begin, int count);
	
	
	/**
	 *  查询所有的文章
	 * @return list 
	 */
	public List<ArticleEntity> queryListForAll();
	
	/**
	 * 根据文章所在栏目与文章id进行查询文章的上一篇 与下一篇
	 * @param typeId 文章所属栏目
	 * @param articleId 文章id
	 * @return Map集合
	 */
	public Map<String, ArticleEntity> queryArticleMap(int typeId,int articleId);
}
