package com.mingsoft.biz;

import java.util.List;

import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.entity.ArticleTypeTreeEntity;
/**
 * 栏目具体的业务控制基类（接口）
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public interface IArticleTypeBiz extends IBaseBiz {
	
	/**
	 * 从数据库中取出栏目信息，并形成JOSN格式
	 * @return
	 */
	public List<ArticleTypeEntity> queryForList();
	
	/**
	 * 添加修改栏目内容
	 * @param base 实体类ArticleTypeEntity
	 */
	public void articleTypeConSave(ArticleTypeEntity base);
	
	/**
	 * 从数据库中取出栏目名和ID(文章管理用)
	 * 并形成框架规定的格式
	 * Text:表示栏目的名称
	 * id:表示栏目的ID
	 * @return
	 */
	public List<ArticleTypeTreeEntity> articleForList();
	
	/**
	 * 从数据库中取出栏目名和ID(栏目修改用)
	 * 并形成框架规定的格式
	 * Text:表示栏目的名称
	 * id:表示栏目的ID
	 * @return
	 */
	public List<ArticleTypeTreeEntity> articleTypeForList();
	
	/**
	 * 根据栏目id查找该栏目下的所有的子栏目 
	 * @param articleTypeId 栏目id
	 * @return list 所有的该栏目下的子栏目的列表
	 */
	public List<ArticleTypeEntity> searchTreeSon(int articleTypeId);
	
	/**
	 * 根据栏目id查找该栏目下的所有的父栏目 
	 * @param articleTypeId 栏目id
	 * @return list 所有的该栏目下的父栏目的列表
	 */
	public List<ArticleTypeEntity> searchTreeTop(int articleTypeId);
	
	/**
	 * 根据栏目的pid查询该栏目信息
	 * @param pid 栏目pid
	 * @return ArticleTypeEntity该栏目的实体类
	 */
	public List<ArticleTypeEntity> articleTypeSearch(int pid);
	
	/**
	 * 根据栏目的id查询该栏目信息
	 * @param id 栏目id
	 * @return ArticleTypeEntity该栏目的实体类
	 */
	public ArticleTypeEntity articleTypeSearchWithId(int id);
	
	/**
	 * 根据栏目id查找该栏目下的所有的子栏目的ID
	 * @param articleTypeId 栏目id
	 * @return list 所有的该栏目下的父栏目的列表
	 */
	public List<Integer> searchTreeSonId(int articleTypeId);
	
	/**
	 * 根据栏目的属性封面或者最终栏目  一键生成封面的静态页面
	 * @param num 1代表 最终栏目 2代表封面
	 * @return list 
	 */
	 
	public List<ArticleTypeEntity> queryListForCover(int num);
}
