package com.mingsoft.biz;

import java.util.List;

import com.mingsoft.entity.BaseEntity;

/**
 * 具体的业务控制基类（接口）
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public interface IBaseBiz {
	/**
	 * 添加Base信息,方法过期推荐使用saveEntity(entity);
	 * 
	 * @param base
	 *            基本属性类
	 * @return true
	 */
	@Deprecated
	public boolean addEntity(BaseEntity base);

	/**
	 * 添加Base信息
	 * 
	 * @param base
	 *            基本属性类
	 */
	public void saveEntity(BaseEntity base);

	/**
	 * 通过ID，删除数据库中的Base信息
	 * 
	 * @param base
	 *            基本属性类
	 * @return true
	 */
	public void delEntity(BaseEntity base);

	/**
	 * 通过ID，对数据库中的的信息进行修改
	 * 
	 * @param base
	 *            基本属性类
	 * @return true
	 */
	public void editEntity(BaseEntity base);

	/**
	 * 通过ID，查找数据库中的Base信息,并将查找到的信息储存到Base中
	 * 
	 * @param base
	 *            基本属性类
	 * @return Base
	 */
	public BaseEntity selectEntity(BaseEntity base);

	/**
	 *查询指定数据库中Base数据的数量
	 * 
	 * @param base
	 *            基本属性类
	 * @return count
	 */
	public int countEntity(BaseEntity base);

	/**
	 * 返回数据库Base信息，并对每次返回的数据数量进行限制 可用于分类等，分段从数据库取信息
	 * 
	 * @param base
	 *            基本属性类
	 * @param begin
	 *            返回信息的开始位置
	 * @param count
	 *            返回信息的结束位置
	 * @return List<Base>
	 */
	public List<BaseEntity> queryForEntity(BaseEntity base, int begin, int count);

	/**
	 * 返回数据表中最大id值
	 * @param type 表类型名
	 * @return
	 */
	public int findMaxId(String type);
}
