package com.mingsoft.biz;
/**
 * 用户的基本业务（接口）
 * @author 张敏
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
public interface IUserBiz extends IBaseBiz {
	
	/**
	 * 根据用户的用户名查找用户信息
	 * @param userName 用户存在数据库中的用户名
	 * @return 用户信息
	 */
	public String queryName (String userName); 
	
	/**
	 * 根据用户名修改用户密码 
	 * @param userName 用户名
	 */
	public void editPassword(String userName,String newPassword);
	
	/**
	 * 更改当前管理员用户名及密码
	 * @param newName 用户名 
     * @param newPassword 用户名 
	 */
	public void updataRoot(String newName,String newPassword);
	
	
}
