package com.mingsoft.biz.impl;


import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.mingsoft.biz.IArticleBiz;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.dao.IArticleDao;
import com.mingsoft.dao.IArticleTypeDao;
import com.mingsoft.dao.impl.ArticleDaoImpl;
import com.mingsoft.dao.impl.ArticleTypeDaoImpl;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeTreeEntity;
 
/**
 * 实现类
 * 文章管理的实现接口
 * 主要功能是进行文章的增删改查
 * @author 荣繁奎
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */

public class ArticleBizImpl extends BaseBizImpl implements IArticleBiz {

  
	private IArticleDao articleDao = new ArticleDaoImpl();
	
	public ArticleBizImpl(){
		setBaseDao(articleDao);
	}
	
	public int queryArtcTotal(){
		ResultSet rs = articleDao.queryArtcTotal();
		int total=0;
		try {
			while(rs.next()){
				total=rs.getInt(1);
				//total++;
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return total;
		
	}
	
	public int queryArtcTotal(int articleTypeId,int flag,int noFlag){
		ResultSet rs = articleDao.queryArtcTotal(articleTypeId,flag,noFlag);
		int total=0;
		try {
			while(rs.next()){
				total=rs.getInt(1);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return total;
	}
	
	public List<ArticleEntity> queryForList(int pageNum,int pageSize){
		List<ArticleEntity> list = new ArrayList<ArticleEntity>();
		ResultSet rs = articleDao.queryForList(pageNum,pageSize);
		try {
			while(rs.next()){
				ArticleEntity article = new ArticleEntity();
				ArticleTypeTreeEntity articleType = new ArticleTypeTreeEntity();
				articleType.setId(rs.getInt("articletype_id"));
				articleType.setText(rs.getString("articletype_name"));
				article.setArticleTypes(articleType);
				article.setArticleId(rs.getInt("article_id"));
				article.setArticleTitle(rs.getString("article_title"));
				article.setArticleContent(rs.getString("article_content"));
				article.setArticleSource(rs.getString("article_source"));
				article.setArticleAuthor(rs.getString("article_author"));
				article.setArticleType(rs.getInt("article_type"));
				article.setArticleDate(rs.getDate("article_date"));
				article.setArticleImg(rs.getString("article_img"));
				article.setArticleFlag(rs.getInt("article_flag"));
				list.add(article);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return list;
	}
	
	public boolean save(ArticleEntity article){
		IArticleTypeDao articleTypeDao = new ArticleTypeDaoImpl();
		articleTypeDao.save(article);
		return true;
	}
	
	public List<ArticleEntity> selectEntityList(ArticleEntity base) {
		// TODO Auto-generated method stub
		List<ArticleEntity> list = new ArrayList<ArticleEntity>();
		ResultSet rs =	articleDao.select(base);
		try {
			while(rs.next()){
				ArticleEntity article = new ArticleEntity();
				article.setArticleId(rs.getInt("article_id"));
				article.setArticleTitle(rs.getString("article_title"));
				article.setArticleContent(rs.getString("article_content"));
				article.setArticleSource(rs.getString("article_source"));
				article.setArticleAuthor(rs.getString("article_author"));
				article.setArticleType(rs.getInt("article_type"));
				article.setArticleDate(rs.getDate("article_date"));
				article.setArticleImg(rs.getString("article_img"));
				article.setArticleFlag(rs.getInt("article_flag"));
				list.add(article);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return list;
	}
	
	
	public List<ArticleEntity> searchEntityList(ArticleEntity base) {
		// TODO Auto-generated method stub
		List<ArticleEntity> list = new ArrayList<ArticleEntity>();
		ResultSet rs =	articleDao.searchArticle(base);
		try {
			while(rs.next()){
				ArticleEntity article = new ArticleEntity();
				ArticleTypeTreeEntity articleType = new ArticleTypeTreeEntity();
				articleType.setId(rs.getInt("articletype_id"));
				articleType.setText(rs.getString("articletype_name"));
				article.setArticleTypes(articleType);
				article.setArticleId(rs.getInt("article_id"));
				article.setArticleTitle(rs.getString("article_title"));
				article.setArticleContent(rs.getString("article_content"));
				article.setArticleSource(rs.getString("article_source"));
				article.setArticleAuthor(rs.getString("article_author"));
				article.setArticleType(rs.getInt("article_type"));
				article.setArticleDate(rs.getDate("article_date"));
				article.setArticleImg(rs.getString("article_img"));
				article.setArticleFlag(rs.getInt("article_flag"));
				list.add(article);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	
		return list;
	}
	
	public List<ArticleEntity> searchArtList(ArticleEntity base) {
		// TODO Auto-generated method stub
		List<ArticleEntity> list = new ArrayList<ArticleEntity>();
		ResultSet rs =	articleDao.searchArtList(base);
		try {
			while(rs.next()){
				ArticleEntity article = new ArticleEntity();
				ArticleTypeTreeEntity articleType = new ArticleTypeTreeEntity();
				articleType.setId(rs.getInt("articletype_id"));
				articleType.setText(rs.getString("articletype_name"));
				article.setArticleTypes(articleType);
				article.setArticleId(rs.getInt("article_id"));
				article.setArticleTitle(rs.getString("article_title"));
				article.setArticleContent(rs.getString("article_content"));
				article.setArticleSource(rs.getString("article_source"));
				article.setArticleAuthor(rs.getString("article_author"));
				article.setArticleType(rs.getInt("article_type"));
				article.setArticleDate(rs.getDate("article_date"));
				article.setArticleImg(rs.getString("article_img"));
				article.setArticleFlag(rs.getInt("article_flag"));
				list.add(article);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	
		return list;
	}
	
	public  ArticleEntity selectEntity(ArticleEntity base) {
		// TODO Auto-generated method stub
		ArticleEntity article = new ArticleEntity();
		ResultSet rs =	articleDao.selectArt(base);
		try {
			while(rs.next()){
				ArticleTypeTreeEntity articleType = new ArticleTypeTreeEntity();
				articleType.setId(rs.getInt("articletype_id"));
				articleType.setText(rs.getString("articletype_name"));
				article.setArticleTypes(articleType);
				article.setArticleId(rs.getInt("article_id"));
				article.setArticleTitle(rs.getString("article_title"));
				article.setArticleContent(rs.getString("article_content"));
				article.setArticleSource(rs.getString("article_source"));
				article.setArticleAuthor(rs.getString("article_author"));
				article.setArticleType(rs.getInt("article_type"));
				article.setArticleDate(rs.getDate("article_date"));
				article.setArticleImg(rs.getString("article_img"));
				article.setArticleFlag(rs.getInt("article_flag"));
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	
		return article;
	}
	
	public List<ArticleEntity> searchArticleType(int ArticleTypeID) {
		// TODO Auto-generated method stub
		List<ArticleEntity> list = new ArrayList<ArticleEntity>();
		ResultSet rs =	articleDao.searchArticleType(ArticleTypeID);
		try {
			while(rs.next()){
				ArticleEntity article = new ArticleEntity();
				ArticleTypeTreeEntity articleType = new ArticleTypeTreeEntity();
				articleType.setId(rs.getInt("articletype_id"));
				articleType.setText(rs.getString("articletype_name"));
				article.setArticleTypes(articleType);
				article.setArticleId(rs.getInt("article_id"));
				article.setArticleTitle(rs.getString("article_title"));
				article.setArticleContent(rs.getString("article_content"));
				article.setArticleSource(rs.getString("article_source"));
				article.setArticleAuthor(rs.getString("article_author"));
				article.setArticleType(rs.getInt("article_type"));
				article.setArticleDate(rs.getDate("article_date"));
				article.setArticleImg(rs.getString("article_img"));
				article.setArticleFlag(rs.getInt("article_flag"));
				list.add(article);
			}
		}catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return list;
	}
	
	
	
	public List<ArticleEntity> queryListPrase(List<Integer> articleId, int flag,int noFlag, int begin, int count) {
		// TODO Auto-generated method stub
		List<ArticleEntity> list = new ArrayList<ArticleEntity>();
		ResultSet rs =	articleDao.queryListPrase(articleId, flag, noFlag, begin, count);
		try {
			while(rs.next()){
				ArticleEntity articles = new ArticleEntity();
				articles.setArticleId(rs.getInt("article_id"));
				articles.setArticleTitle(rs.getString("article_title"));
				articles.setArticleContent(rs.getString("article_content"));
				articles.setArticleSource(rs.getString("article_source"));
				articles.setArticleAuthor(rs.getString("article_author"));
				articles.setArticleType(rs.getInt("article_type"));
				articles.setArticleDate(rs.getDate("article_date"));
				articles.setArticleImg(rs.getString("article_img"));
				articles.setArticleFlag(rs.getInt("article_flag"));
				list.add(articles);
			}
		}catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		return list;
	}
	
	public List<ArticleEntity> queryListForAll(){
		List<ArticleEntity> list = new ArrayList<ArticleEntity>();
		ResultSet rs =	articleDao.queryListForAll();
		try {
			while(rs.next()){
				ArticleEntity articles = new ArticleEntity();
				articles.setArticleId(rs.getInt("article_id"));
				articles.setArticleTitle(rs.getString("article_title"));
				articles.setArticleContent(rs.getString("article_content"));
				articles.setArticleSource(rs.getString("article_source"));
				articles.setArticleAuthor(rs.getString("article_author"));
				articles.setArticleType(rs.getInt("article_type"));
				articles.setArticleDate(rs.getDate("article_date"));
				articles.setArticleImg(rs.getString("article_img"));
				articles.setArticleFlag(rs.getInt("article_flag"));
				list.add(articles);
			}
		}catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		return list;
	}

	public Map<String, ArticleEntity> queryArticleMap(int typeId,int articleId){
		List<ArticleEntity> list = new ArrayList<ArticleEntity>();
		ResultSet rs =	articleDao.searchArticleType(typeId);
		try {
			while(rs.next()){
				ArticleEntity article = new ArticleEntity();
				ArticleTypeTreeEntity articleType = new ArticleTypeTreeEntity();
				articleType.setId(rs.getInt("articletype_id"));
				articleType.setText(rs.getString("articletype_name"));
				article.setArticleTypes(articleType);
				article.setArticleId(rs.getInt("article_id"));
				article.setArticleTitle(rs.getString("article_title"));
				article.setArticleContent(rs.getString("article_content"));
				article.setArticleSource(rs.getString("article_source"));
				article.setArticleAuthor(rs.getString("article_author"));
				article.setArticleType(rs.getInt("article_type"));
				article.setArticleDate(rs.getDate("article_date"));
				article.setArticleImg(rs.getString("article_img"));
				article.setArticleFlag(rs.getInt("article_flag"));
				list.add(article);
			}
		}catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
		}
		/**
		 * 进行对文章所在的list 中的位置进行判断
		 */
		int j = 0;
		for(int i=0;i<list.size();i++){
			ArticleEntity art = (ArticleEntity)list.get(i); 
			int id = art.getArticleId();
			j++;
			//当找出文章所在list的位置 跳出
			if(id==articleId){
				break;
			}
			
		}
		Map<String, ArticleEntity> map = new HashMap<String, ArticleEntity>();
		/**
		 * 判断文章是否是在list的顶部或尾部
		 * 如果文章的位置在顶部则当前文章为上一篇 否则取上一个光标的对象作为上一篇
		 * 如果文章的位置在尾部则当前文章为下一篇 否则取下一个光标的对象作为下一篇
		 */
		if(j==1){
			map.put(RegexConstant.ARTICLE_PRE, list.get(j-1));
		}else{
			map.put(RegexConstant.ARTICLE_PRE, list.get(j-2));
		}
		if(j+1<=list.size()){
			map.put(RegexConstant.ARTICLE_NEXT,list.get(j));
		}else{
			map.put(RegexConstant.ARTICLE_NEXT,list.get(j-1));
		}
		return map;
	}
}
