package com.mingsoft.biz.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.mingsoft.biz.IArticleTypeBiz;
import com.mingsoft.constant.ArticleTypeConstant;
import com.mingsoft.constant.RegexConstant;
import com.mingsoft.dao.IArticleTypeDao;
import com.mingsoft.dao.impl.ArticleTypeDaoImpl;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.entity.ArticleTypeTreeEntity;
import com.mingsoft.io.CreateHtmlFile;

/**
 * 栏目具体业务实现类
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class ArticleTypeBizImpl extends BaseBizImpl implements IArticleTypeBiz {
	/**
	 * 默认数据库链接
	 */
	private IArticleTypeDao articleTypeDao = new ArticleTypeDaoImpl();
	/**
	 * 栏目属性
	 */
	ArticleTypeEntity articleType = new ArticleTypeEntity();
	
	public ArticleTypeBizImpl(){
		setBaseDao(articleTypeDao);
	}
	
	public List<ArticleTypeEntity> queryForList() {
		// TODO Auto-generated method stub
		// 创建储存articleType对象的数组list
		List<ArticleTypeEntity> listTem = new ArrayList<ArticleTypeEntity>();
		List<ArticleTypeEntity> list = new ArrayList<ArticleTypeEntity>();
		ResultSet set = articleTypeDao.queryForList(articleType, 0, 0);
		try {
			// 将数据库中的栏目信息从数据库中遍历出来
			while (set.next()) {
				ArticleTypeEntity articleTypeSet = new ArticleTypeEntity();
				articleTypeSet.setArticleTypeDescrip(set
						.getString("articletype_descrip"));
				// 将栏目名称存入数组中，并带上栏目ID
				articleTypeSet.setArticleTypeName(set
						.getString("articletype_name"));
				articleTypeSet.setArticleTypeKeyword(set
						.getString("articletype_keyword"));
				// articleTypeSet.setArticleTypeUrl(set.getString("articletype_url"));
				articleTypeSet.setArticleTypePid(set.getInt("articletype_pid"));
				articleTypeSet.setArticleTypeId(set.getInt("articletype_id"));
				articleTypeSet.setArticleTypeContent(set
						.getString("articletype_content"));
				// 改变JSON中栏目属性的值，使其在页面中正常显示
				int quality = set.getInt("articletype_quality");
				articleTypeSet.setArticleTypeQuality(quality);
				if (quality == 1) {
					// 显示概列表栏目的链接地址
					articleTypeSet
							.setArticleTypeUrl(RegexConstant.REGEX_ARETICLETYPE_URL
									+ set.getInt("articletype_id"));
					articleTypeSet.setArticleTypeNewsTem(set
							.getString("articletype_news_tem"));
					articleTypeSet.setArticleTypeListTem(set
							.getString("articletype_list_tem"));
					articleTypeSet.setArticleTypeCoverTem(" ");
				} else if (quality == 2) {
					// 当前封面栏目ID
					int articleTypeId = set.getInt("articletype_id");
					// 显示封面的栏目地址
					String coverTemUrl = RegexConstant.HTML_TAG
							+ CreateHtmlFile.pathBulid(0, articleTypeId)
							+ articleTypeId + "." + RegexConstant.HTML_TAG;
					articleTypeSet
							.setArticleTypeUrl(RegexConstant.REGEX_COVER_URL
									+ coverTemUrl);
					articleTypeSet.setArticleTypeNewsTem(" ");
					articleTypeSet.setArticleTypeListTem(" ");
					articleTypeSet.setArticleTypeCoverTem(set
							.getString("articletype_cover_tem"));
				}
				listTem.add(articleTypeSet);
			}

			// 将子栏目关联到父栏目
			for (int i = 0; i < listTem.size(); i++) {
				ArticleTypeEntity articleTypeOne = listTem.get(i);
				// 将相应的子栏目关联起来
				if (articleTypeOne.getArticleTypePid() != 0) {
					for (int n = 0; n < listTem.size(); n++) {
						ArticleTypeEntity articleTypeTwo = listTem.get(n);
						if (articleTypeOne.getArticleTypePid() == articleTypeTwo
								.getArticleTypeId()) {
							// 判断父栏目的属性
							articleTypeOne.setText(articleTypeTwo
									.getArticleTypeName());
							articleTypeTwo.getChildren().add(articleTypeOne);
							break;
						}
					}
				}
				// 将遍历出来的父栏目存到新的数组中
				if (articleTypeOne.getArticleTypePid() == 0) {
					list.add(articleTypeOne);
				}

			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		listTem = null;
		return list;
	}

	public List<ArticleTypeTreeEntity> articleForList() {
		// TODO Auto-generated method stub
		// 创建储存articleType对象的数组list
		List<ArticleTypeTreeEntity> listTem = new ArrayList<ArticleTypeTreeEntity>();
		List<ArticleTypeTreeEntity> list = new ArrayList<ArticleTypeTreeEntity>();
		ResultSet set = articleTypeDao.queryForList(articleType, 0, 0);

		try {
			// 将数据库中的栏目信息从数据库中遍历出来
			while (set.next()) {
				ArticleTypeTreeEntity articleTypeTreeSet = new ArticleTypeTreeEntity();
				int quality = set.getInt("articletype_quality");
				String articleTypeTem = "";
				int id = set.getInt("articletype_id");
				// 取出和文章有关的栏目并重新存在数组中,当栏目为最终栏目列表，
				// 或者为：封面栏目和频道栏目链接并且其下有子栏目时
				// 才加到文章管理的JOSN中
				if (quality == 2) {
					articleTypeTem = "("
							+ ArticleTypeConstant.ARTICLETYPE_QUALITY_TWO + ")";
				} else {
					articleTypeTem = "("
							+ ArticleTypeConstant.ARTICLETYPE_QUALITY_ONE + ")";
				}
				articleTypeTreeSet.setText(set.getString("articletype_name")
						+ articleTypeTem);
				articleTypeTreeSet.setIdTem(id);
				articleTypeTreeSet.setId(set.getInt("articletype_id"));
				articleTypeTreeSet.setPid(set.getInt("articletype_pid"));
				articleTypeTreeSet.setQuality(quality);
				listTem.add(articleTypeTreeSet);
			}
			// 将子栏目关联到父栏目
			for (int i = 0; i < listTem.size(); i++) {
				ArticleTypeTreeEntity articleTypeOne = listTem.get(i);
				// 将相应的子栏目和父栏目关联起来
				if (articleTypeOne.getPid() != 0) {

					for (int n = 0; n < listTem.size(); n++) {
						ArticleTypeTreeEntity articleTypeTwo = listTem.get(n);
						if (articleTypeOne.getPid() == articleTypeTwo
								.getIdTem()) {
							articleTypeTwo.getChildren().add(articleTypeOne);
							break;
						}
					}
				} else {
					list.add(articleTypeOne);
				}
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		listTem = null;
		return list;
	}

	public List<ArticleTypeTreeEntity> articleTypeForList() {
		// TODO Auto-generated method stub
		// 创建储存articleType对象的数组list
		List<ArticleTypeTreeEntity> listTem = new ArrayList<ArticleTypeTreeEntity>();
		List<ArticleTypeTreeEntity> list = new ArrayList<ArticleTypeTreeEntity>();
		ResultSet set = articleTypeDao.queryForList(articleType, 0, 0);
		ArticleTypeTreeEntity articleTypeTreeTopSet = new ArticleTypeTreeEntity();
		// 在JOSN中假如默认值
		articleTypeTreeTopSet.setId(0);
		articleTypeTreeTopSet.setText("顶级栏目");
		list.add(articleTypeTreeTopSet);
		try {
			// 将数据库中的栏目信息从数据库中遍历出来
			while (set.next()) {
				ArticleTypeTreeEntity articleTypeTreeSet = new ArticleTypeTreeEntity();
				int quality = set.getInt("articletype_quality");
				String articleTypeTem = "";
				if (quality == 2) {
					articleTypeTem = "("
							+ ArticleTypeConstant.ARTICLETYPE_QUALITY_TWO + ")";
				} else {
					articleTypeTem = "("
							+ ArticleTypeConstant.ARTICLETYPE_QUALITY_ONE + ")";
				}
				articleTypeTreeSet.setText(set.getString("articletype_name")
						+ articleTypeTem);
				articleTypeTreeSet.setIdTem(set.getInt("articletype_id"));
				articleTypeTreeSet.setPid(set.getInt("articletype_pid"));
				articleTypeTreeSet.setId(set.getInt("articletype_id"));
				listTem.add(articleTypeTreeSet);
			}

			// 将子栏目关联到父栏目
			for (int i = 0; i < listTem.size(); i++) {
				ArticleTypeTreeEntity articleTypeOne = listTem.get(i);
				// 将相应的子栏目关联起来
				if (articleTypeOne.getPid() != 0) {
					for (int n = 0; n < listTem.size(); n++) {
						ArticleTypeTreeEntity articleTypeTwo = listTem.get(n);
						if (articleTypeOne.getPid() == articleTypeTwo
								.getIdTem()) {
							articleTypeTwo.getChildren().add(articleTypeOne);
							break;
						}
					}
				} else {
					// 将遍历出来的父栏目存到新的数组中
					list.add(articleTypeOne);
				}
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		listTem = null;
		return list;
	}

	public void articleTypeConSave(ArticleTypeEntity base) {
		// 关联到文章管理模块添加封面模块内容
		IArticleTypeDao articleTypeDao = new ArticleTypeDaoImpl();
		articleTypeDao.articleTypeContentSave(base);

	}

	// 根据id查找该栏目下的所有的子栏目
	public List<ArticleTypeEntity> searchTreeSon(int articleTypeId) {
		List<ArticleTypeEntity> listTem = new ArrayList<ArticleTypeEntity>();
		ResultSet rs = articleTypeDao.pidSelect(articleTypeId);
		try {
			while (rs.next()) {
				ArticleTypeEntity articleType = new ArticleTypeEntity();
				articleType.setArticleTypeDescrip(rs
						.getString("articletype_descrip"));
				articleType
						.setArticleTypeName(rs.getString("articletype_name"));
				articleType.setArticleTypeKeyword(rs
						.getString("articletype_keyword"));
				articleType.setArticleTypeUrl(rs.getString("articletype_url"));
				articleType.setArticleTypeNewsTem(rs
						.getString("articletype_news_tem"));
				articleType.setArticleTypeListTem(rs
						.getString("articletype_list_tem"));
				articleType.setArticleTypeCoverTem(rs
						.getString("articletype_cover_tem"));
				articleType.setArticleTypePid(rs.getInt("articletype_pid"));
				articleType.setArticleTypeId(rs.getInt("articletype_id"));
				articleType.setArticleTypeContent(rs
						.getString("articletype_content"));
				articleType.setArticleTypeQuality(rs
						.getInt("articletype_quality"));
				listTem.add(articleType);
			}
			for (int i = 0; i < listTem.size(); i++) {
				ResultSet set = articleTypeDao.pidSelect(listTem.get(i)
						.getArticleTypeId());
				while (set.next()) {
					ArticleTypeEntity articleTypes = new ArticleTypeEntity();
					articleTypes.setArticleTypeDescrip(set
							.getString("articletype_descrip"));
					articleTypes.setArticleTypeName(set
							.getString("articletype_name"));
					articleTypes.setArticleTypeKeyword(set
							.getString("articletype_keyword"));
					articleTypes.setArticleTypeUrl(set
							.getString("articletype_url"));
					articleTypes.setArticleTypeNewsTem(set
							.getString("articletype_news_tem"));
					articleTypes.setArticleTypeListTem(set
							.getString("articletype_list_tem"));
					articleTypes.setArticleTypeCoverTem(set
							.getString("articletype_cover_tem"));
					articleTypes.setArticleTypePid(set
							.getInt("articletype_pid"));
					articleTypes.setArticleTypeId(set.getInt("articletype_id"));
					articleTypes.setArticleTypeContent(set
							.getString("articletype_content"));
					articleTypes.setArticleTypeQuality(set
							.getInt("articletype_quality"));
					listTem.add(articleTypes);
				}
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listTem;
	}

	// 根据id查找该栏目的所有的父栏目
	public List<ArticleTypeEntity> searchTreeTop(int articleTypeId) {
		List<ArticleTypeEntity> list = new ArrayList<ArticleTypeEntity>();
		// 根据id进行数据库查询
		ResultSet rs = articleTypeDao.articleIdSelect(articleTypeId);
		int articleTypePid = 0;
		ArticleTypeEntity articleType = new ArticleTypeEntity();
		articleType = convert(rs);
		articleTypePid = articleType.getArticleTypePid();
		// 如果查询的栏目的pid不为0则证明此栏目不是顶级栏目 根据此栏目的pid作为查询上一级的id进行查询 直到找到栏目的pid为0结束
		while (articleTypePid != 0) {
			ResultSet set = articleTypeDao.articleIdSelect(articleTypePid);
			ArticleTypeEntity articleTypes = new ArticleTypeEntity();
			articleTypes = convert(set);
			articleTypePid = articleTypes.getArticleTypePid();
			list.add(articleTypes);
		}

		return list;
	}

	/**
	 * 根据栏目的id查询该栏目信息
	 * 
	 * @param pid
	 *            栏目pid
	 * @return ArticleTypeEntity该栏目的实体类
	 */
	public List<ArticleTypeEntity> articleTypeSearch(int pid) {
		// 根据id进行数据库查询查询PID
		ResultSet rs = articleTypeDao.articleIdSelect(pid);
		int articleTypePid = 0;
		ArticleTypeEntity articleType = new ArticleTypeEntity();
		articleType = convert(rs);
		articleTypePid = articleType.getArticleTypePid();

		ResultSet set = articleTypeDao.pidSelect(articleTypePid);
		List<ArticleTypeEntity> listTem = new ArrayList<ArticleTypeEntity>();
		try {
			while (set.next()) {
				ArticleTypeEntity articleTypes = new ArticleTypeEntity();
				articleTypes.setArticleTypeDescrip(set
						.getString("articletype_descrip"));
				articleTypes.setArticleTypeName(set
						.getString("articletype_name"));
				articleTypes.setArticleTypeKeyword(set
						.getString("articletype_keyword"));
				articleTypes
						.setArticleTypeUrl(set.getString("articletype_url"));
				articleTypes.setArticleTypeNewsTem(set
						.getString("articletype_news_tem"));
				articleTypes.setArticleTypeListTem(set
						.getString("articletype_list_tem"));
				articleTypes.setArticleTypeCoverTem(set
						.getString("articletype_cover_tem"));
				articleTypes.setArticleTypePid(set.getInt("articletype_pid"));
				articleTypes.setArticleTypeId(set.getInt("articletype_id"));
				articleTypes.setArticleTypeContent(set
						.getString("articletype_content"));
				articleTypes.setArticleTypeQuality(set
						.getInt("articletype_quality"));
				listTem.add(articleTypes);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listTem;
	}

	/**
	 * 根据栏目的id查询该栏目信息
	 * 
	 * @param id
	 *            栏目id
	 * @return ArticleTypeEntity该栏目的实体类
	 */
	public ArticleTypeEntity articleTypeSearchWithId(int id) {
		ResultSet rs = articleTypeDao.articleIdSelect(id);
		ArticleTypeEntity articleType = new ArticleTypeEntity();
		articleType = convert(rs);
		return articleType;
	}

	/**
	 * 将栏目的属性转换成实体类
	 * 
	 * @return
	 */
	private ArticleTypeEntity convert(ResultSet rs) {
		try {
			if (rs.next()) {
				ArticleTypeEntity articleType = new ArticleTypeEntity();
				articleType.setArticleTypeDescrip(rs.getString("articletype_descrip"));
				articleType.setArticleTypeName(rs.getString("articletype_name"));
				articleType.setArticleTypeKeyword(rs.getString("articletype_keyword"));
				articleType.setArticleTypeUrl(rs.getString("articletype_url"));
				articleType.setArticleTypeNewsTem(rs.getString("articletype_news_tem"));
				articleType.setArticleTypeListTem(rs.getString("articletype_list_tem"));
				articleType.setArticleTypeCoverTem(rs.getString("articletype_cover_tem"));
				articleType.setArticleTypePid(rs.getInt("articletype_pid"));
				articleType.setArticleTypeId(rs.getInt("articletype_id"));
				articleType.setArticleTypeContent(rs.getString("articletype_content"));
				articleType.setArticleTypeQuality(rs.getInt("articletype_quality"));
				return articleType;				
			}

		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	public List<Integer> searchTreeSonId(int articleTypeId) {
		// TODO Auto-generated method stub
		List<Integer> listId = new ArrayList<Integer>();
		List<ArticleTypeEntity> listTem = searchTreeSon(articleTypeId);
		listId.add(articleTypeId);
		for (int i = 0; i < listTem.size(); i++) {
			listId.add(listTem.get(i).getArticleTypeId());
		}
		return listId;
	}

	public List<ArticleTypeEntity> queryListForCover(int num) {
		List<ArticleTypeEntity> listTem = new ArrayList<ArticleTypeEntity>();
		ResultSet rs = articleTypeDao.queryListForCover(num);
		try {
			while (rs.next()) {
				ArticleTypeEntity articleType = new ArticleTypeEntity();
				articleType.setArticleTypeDescrip(rs
						.getString("articletype_descrip"));
				articleType
						.setArticleTypeName(rs.getString("articletype_name"));
				articleType.setArticleTypeKeyword(rs
						.getString("articletype_keyword"));
				articleType.setArticleTypeUrl(rs.getString("articletype_url"));
				articleType.setArticleTypeNewsTem(rs
						.getString("articletype_news_tem"));
				articleType.setArticleTypeListTem(rs
						.getString("articletype_list_tem"));
				articleType.setArticleTypeCoverTem(rs
						.getString("articletype_cover_tem"));
				articleType.setArticleTypePid(rs.getInt("articletype_pid"));
				articleType.setArticleTypeId(rs.getInt("articletype_id"));
				articleType.setArticleTypeContent(rs
						.getString("articletype_content"));
				articleType.setArticleTypeQuality(rs
						.getInt("articletype_quality"));
				listTem.add(articleType);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return listTem;
	}


}
