package com.mingsoft.biz.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import com.mingsoft.biz.IBaseBiz;
import com.mingsoft.dao.IBaseDao;
import com.mingsoft.entity.BaseEntity;
/**
 * 具体的业务控制基类 
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public abstract class BaseBizImpl implements IBaseBiz {
	/**
	 * 控制IBaseDao类实现业务中数据的交互
	 */
	protected IBaseDao baseDao;
	
	public void setBaseDao(IBaseDao baseDao){
		this.baseDao = baseDao;
	}
	
	public void saveEntity(BaseEntity base) {
		// TODO Auto-generated method stub
		baseDao.save(base);
	}
	
	@Deprecated
	public boolean addEntity(BaseEntity base) {
		// TODO Auto-generated method stub
		baseDao.add(base);
		return false;
	}

	public int countEntity(BaseEntity base) {
		// TODO Auto-generated method stub
		ResultSet set = baseDao.count(base);
		int countBase = 0;
		try {
			while(set.next()){
			countBase = set.getInt(1);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return countBase;
	}

	public void delEntity(BaseEntity base) {
		// TODO Auto-generated method stub
		baseDao.del(base);
	}

	public void editEntity(BaseEntity base) {
		// TODO Auto-generated method stub
		baseDao.edit(base);
	}
	
	public List<BaseEntity> queryForEntity(BaseEntity base, int begin, int count) {
		// TODO Auto-generated method stub
		return null;
	}
	
	public BaseEntity selectEntity(BaseEntity base) {
		// TODO Auto-generated method stub
		ResultSet set =	baseDao.select(base);
		try {
			while(set.next()){
				System.out.println("aaa");
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	public int findMaxId(String type){
		int id = 0;
		ResultSet set = baseDao.findMaxId(type);
		try {
			if(set.next()){
				id = set.getInt(1);
			}
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return id;
	}
}
