package com.mingsoft.biz.impl;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.mingsoft.biz.IUserBiz;
import com.mingsoft.dao.IUserDao;
import com.mingsoft.dao.impl.UserDaoImpl;

/**
 * 用户的业务层 实现接口
 * @author 张敏
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com*
 */
public class UserBizImpl extends BaseBizImpl implements IUserBiz {
	private IUserDao userDao = new UserDaoImpl();
	 
	public UserBizImpl(){
		setBaseDao(userDao);
	}
	
	/** 
	 * 根据用户的用户名查找用户信息
	 * @param userName 用户存在数据库中的用户名
	 * @return 用户信息
	 */
	public String queryName(String userName) {
		String passWord = "";
		ResultSet rs = userDao.queryUserName(userName);
		try {
			while(rs.next()){
				passWord= rs.getString("user_password");
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return passWord;
	}

	/**
	 * 根据用户名修改用户密码
	 * @param userName 用户名
	 */
	public void editPassword(String userName,String newPassword) {
		userDao.editPassword(userName, newPassword);
	}


	/**
	 * 更改当前管理员用户名及密码
	 * @param newName 用户名 
     * @param newPassword 用户名 
	 */
	public void updataRoot(String newName, String newPassword) {
		userDao.updataRoot(newName, newPassword);
	}



}
