package com.mingsoft.biz.impl;
 
import java.sql.ResultSet;
import java.sql.SQLException;
import com.mingsoft.biz.IWebBiz;
import com.mingsoft.dao.IWebDao;
import com.mingsoft.dao.impl.WebDaoImpl;
import com.mingsoft.entity.WebEntity;

/**
 * 网站的业务层 实现接口类
 * @author 张敏
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
public class WebBizImpl extends BaseBizImpl implements IWebBiz {
	private IWebDao webDao = new WebDaoImpl();
	
	public WebBizImpl(){
		setBaseDao(webDao);
	}

	/**
	 * 查询网站信息
	 * @param webId 网站id
	 * @return 网站信息
	 */
	public WebEntity queryWebInfo(int webId) {
		WebEntity web = new WebEntity();
		ResultSet rs = webDao.queryWebInfo(webId);
		try {
			while(rs.next()){
				web.setWebId(rs.getInt("web_id"));
				web.setWebTitle(rs.getString("web_title"));
				web.setWebRealmName(rs.getString("web_realm_name"));
				web.setWebLogo(rs.getString("web_logo"));
				web.setWebKeyword(rs.getString("web_keyword"));
				web.setWebDescrip(rs.getString("web_descrip"));
				web.setWebCopyright(rs.getString("web_copyright"));
				web.setWebStyle(rs.getString("web_style"));
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return web;
	}

	/**
	 * 修改网站信息
	 */
	public void editWebInfo(WebEntity webentity) {
		webDao.editWebInfo(webentity);
	}

	/**
	 * 删除网站LOGO信息
	 */
	public void deleteLogo(String webLogo) {
		webDao.deleteLogo(webLogo);
	}
}
