package com.mingsoft.dao;

 
import java.sql.ResultSet;
import java.util.List;

import com.mingsoft.entity.ArticleEntity;

/**
 * 接口类
 * 数据层 进行数据库操作的控制类
 * 查询返回记录集合
 * @author 荣繁奎
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
public interface IArticleDao extends IBaseDao {

	/**
	 * 查询文章总数 
	 */
	public ResultSet queryArtcTotal();
	
	/**
	 * 查询特定文章类型下的文章总记录数
	 * @param articleTypeId 栏目的Id
	 * @param flag 文章的属性 falg
	 * @param onflag 文章属性 onflag
	 * @return rs 记录集合
	 */
	public ResultSet queryArtcTotal(int articleTypeId,int flag,int noFlag);
	
	/**
	 * 分页文章总数
	 * @return 返回记录集合
	 */
	public ResultSet queryForList(int pageNum,int pageSize);
	/**
	 * 通过标题模糊查询
	 * @param article 实体类
	 * @return 记录集合
	 */
	public ResultSet searchArticle(ArticleEntity article);
	

	/**
	 * 通过文章类型进行查询 进行修改 
	 * @param base
	 * @return rs
	 */
	public ResultSet selectArt(ArticleEntity base);
	
	/**
	 * 根据文章类型 和 标题进行查询
	 * @param article 
	 * @return rs记录集合
	 */
	public ResultSet searchArtList(ArticleEntity article);

	/**
	 * 通过栏目ID查找文章
	 * @param ArticleTypeId 栏目ID
	 * @return 在数据库中找到的文章
	 */
	public ResultSet searchArticleType(int ArticleTypeId);
	
	/**
	 * 解析HTML模版时根据文章的ID,flag,等属性取值
	 * @param articleId 文章ID属性
	 * @param flag属性
	 * @param noflag属性
	 * @param begin 光标开始位置
	 * @param count 每页显示的条数
	 */
	public ResultSet queryListPrase(List<Integer> articleId,int flag,int noFlag,int begin,int count);
	
	/**
	 * 查询所有的文章信息
	 * @return rs 记录集合
	 */
	public ResultSet queryListForAll();
	
}
