package com.mingsoft.dao;

import java.sql.ResultSet;

import com.mingsoft.entity.ArticleTypeEntity;

/**
 * 栏目操作数据(接口)
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public interface IArticleTypeDao extends IBaseDao{
	/**
	 * 通过PID查找数据库中的栏目信息
	 * @param pid 栏目的pid
	 * @return 查找到到信息
	 */
	public ResultSet pidSelect(int pid);
	
	/**
	 * 通过id对封面属性的栏目进行添加内容
	 * @param base 实体类
	 */
	public void articleTypeContentSave(ArticleTypeEntity base);
	
	/**
	 * 根据id查实体类
	 * @param id
	 * @return rs 记录集合
	 */
	public ResultSet articleIdSelect(int id);

	/**
	 * 根据栏目的属性封面或者最终栏目  一键生成封面的静态页面
	 * @param num 1代表 最终栏目 2代表封面
	 * @return rs 
	 */
	public ResultSet queryListForCover(int num);
}
