package com.mingsoft.dao;

import java.sql.ResultSet;

import com.mingsoft.entity.BaseEntity;

/**
 * 操作数据中数据（接口类）
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public interface IBaseDao {
	/**
	 * 向数据库添加信息
	 * @param base 基本属性类
	 */
	@Deprecated
	public void add(BaseEntity base);
	
	/**
	 * 向数据库添加信息
	 * @param base 基本属性类
	 */
	public void save(BaseEntity base);
	
	/**
	 * 通过ID，删除数据库中的信息
	 * @param base 基本属性类
	 */
	public void del(BaseEntity base);
	
	/**
	 * 通过ID，对数据库中的的信息进行修改
	 * @param base 基本属性类
	 */
	public void edit(BaseEntity base);
	
	/**
	 * 通过ID，查找数据库中的相关信息
	 * @param base 基本属性类
	 * @return 查找到的相关信息
	 */
	public ResultSet select(BaseEntity base);
	
	/**
	 *根据数据库中数据表的ID查询指定数据库中数据的数量 
	 * @param base 基本属性类
	 * @return 信息的数量
	 */
	public ResultSet count(BaseEntity base);
	
	/**
	 * 返回数据库信息，并对每次返回的数据数量进行限制
	 * 可用于分类等，分段从数据库取信息
	 * @param base 基本属性类
	 * @param begin 返回信息的开始位置
	 * @param count 返回信息的结束位置
	 * @return 查询到的信息
	 */
	public ResultSet queryForList(BaseEntity base,int begin,int count);
	
	/**
	 * 返回数据表中最大id值
	 * 
	 * @param type 表类型名
	 * @return
	 */
	public ResultSet findMaxId(String type);
}
