package com.mingsoft.dao;
import java.sql.ResultSet;
/**
 * 操作用户数据的接口
 * @author 张敏
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
public interface IUserDao extends IBaseDao {

	/**
	 * 根据用户名查找该用户在数据库中的 信息
	 * @param userName 用户名
	 * @return
	 */
	public ResultSet queryUserName(String userName);
	
	/** 
	 * 根据用户名修改用户密码
	 * @param userName 用户名
	 */
	public void editPassword(String userName,String newPassword);
	
	/**
	 * 更改当前管理员用户名及密码
	 * @param newName 用户名 
     * @param newPassword 用户名 
	 */
	public void updataRoot(String newName,String newPassword);
	
}

 