package com.mingsoft.dao;
import java.sql.ResultSet;

import com.mingsoft.entity.WebEntity;
 /**
  * 操作网站信息的数据接口
  * @author 张敏
  * 技术支持：铭飞科技
  * 官网：www.ming-soft.com
  */
public interface IWebDao extends IBaseDao {

	/**
	 * 根据网站id查询网站信息
	 * @param webId 网站id
	 */
	public ResultSet queryWebInfo(int webId);
	
	/**
	 * 根据网站id修改网站信息
	 * @param webId 网站id
	 */
	public void editWebInfo(WebEntity webentity);
	
	/**
	 * 删除网站LOGO信息
	 */
	public void deleteLogo(String webLogo);
}
