package com.mingsoft.dao.impl;

 
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import com.mingsoft.dao.IArticleDao;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.util.StringUtil;

/**
 * 数据层
 * 实现接口 数据库操作
 * 主要功能是实现查询的返回记录集合
 * @author 荣繁奎
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
public class ArticleDaoImpl extends BaseDaoImpl implements IArticleDao {
	public ResultSet queryArtcTotal(){
		ResultSet rs = null;
		try {
			String sql = "select count(*) from ms_article ";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}
	
	public ResultSet queryArtcTotal(int articleTypeId,int flag,int noFlag){
		ResultSet rs = null;
		String sql = "";
		String articleIdSql = "article_type ="+articleTypeId;
		String flagSql = "article_flag="+flag;
		String noFlagSql = "article_flag!="+noFlag;
		String groupSql = "";
		//根据不同条件组合SQL语句
		if(articleTypeId != 0 && flag != 0 && noFlag != 0){
			groupSql = articleIdSql + " and " + noFlagSql +" and "+ flagSql;
		}else if(articleTypeId == 0){
			groupSql = StringUtil.restrictGroup(flag, noFlag, flagSql, noFlagSql);
		}else if(flag == 0){
			groupSql = StringUtil.restrictGroup(articleTypeId, noFlag, articleIdSql, noFlagSql);
		}else if(noFlag == 0){
			groupSql = StringUtil.restrictGroup(flag, articleTypeId, flagSql, articleIdSql);
		}
		
		try {
			sql = "Select count(*) from ms_article where " + groupSql;
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}
	
	public ResultSet queryForList(int pageNum,int pageSize) {
		ResultSet rs = null;
		try {
			String sql = "select * from ms_article,ms_articletype where article_type=articletype_id and articletype_quality="+1+" order by article_id desc limit "+pageNum+","+pageSize+" ";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}

	public ResultSet searchArticle(ArticleEntity article){
		ResultSet rs = null;
		ArticleEntity articleEntity = (ArticleEntity)article;
		try {
			String sql = "select * from ms_article,ms_articletype where article_type=articletype_id and article_title like '"+articleEntity.getArticleTitle()+"' order by article_date desc";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}

	/**
	 * 根据文章类型 和 标题进行查询
	 * @param article 
	 * @return rs记录集合
	 */
	public ResultSet searchArtList(ArticleEntity article){
		ResultSet rs = null;
		ArticleEntity articleEntity = (ArticleEntity)article;
		try {
			String sql = "select * from ms_article,ms_articletype where article_type='"+articleEntity.getArticleType()+"' and articletype_id='"+articleEntity.getArticleType()+"' and article_title like '"+articleEntity.getArticleTitle()+"' order by article_date desc ";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}
	
	public ResultSet selectArt(ArticleEntity base) {
		ResultSet rs = null;
		String sql = "";
		int number = 0;
		try {
			ArticleEntity article = (ArticleEntity) base;
			number = article.getArticleId();
			sql = "Select * from ms_article,ms_articletype where article_id='"+number+"' and article_type=articletype_id";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}
	
	public ResultSet searchArticleType(int ArticleTypeId) {
		// TODO Auto-generated method stub
		ResultSet rs = null;
		try {
			String sql = "select * from ms_article,ms_articletype where articletype_id='"+ArticleTypeId+"' and article_type=articletype_id";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}

	
	public ResultSet queryListPrase(List<Integer> articleId, int flag, int noFlag,int begin, int count) {
		// TODO Auto-generated method stub
		ResultSet rs = null;
		String sql = "";
		
		String articleIdStr = "";
		for(int i = 0; i< articleId.size();i++){
			if(i == (articleId.size()-1)){
				articleIdStr += articleId.get(i).toString();
			}else{
				articleIdStr += articleId.get(i).toString()+",";
			}
		}
		
		String articleIdSql = "article_type in("+articleIdStr+")";
		String flagSql = "article_flag="+flag;
		String noFlagSql = "article_flag!="+noFlag;
		String groupSql = "";
		//根据不同条件组合SQL语句
		if(articleId.size() != 0 && flag != 0 && noFlag != 0){
			groupSql = articleIdSql + " and " + noFlagSql +" and "+ flagSql;
		}else if(articleId.size() == 0){
			groupSql = StringUtil.restrictGroup(flag, noFlag, flagSql, noFlagSql);
		}else if(flag == 0){
			groupSql = StringUtil.restrictGroup(articleId.size(), noFlag, articleIdSql, noFlagSql);
		}else if(noFlag == 0){
			groupSql = StringUtil.restrictGroup(flag, articleId.size(), flagSql, articleIdSql);
		}
		
		try {
			sql = "Select * from ms_article where "+groupSql+" order by article_date desc limit "+begin+","+count;
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}
	
	public ResultSet queryListForAll(){
		ResultSet rs = null;
		String sql = "";
		try {
			sql = "Select * from ms_article";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}
}
