package com.mingsoft.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import com.mingsoft.dao.IArticleTypeDao;
import com.mingsoft.entity.ArticleTypeEntity;
/**
 * 操作栏目数据
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class ArticleTypeDaoImpl extends BaseDaoImpl implements IArticleTypeDao {
	public ResultSet pidSelect(int pid) {
		ResultSet rs;
		String sql = "Select * from ms_articletype where articletype_pid = ?";
		try {
			// 执行通过ID查询指定表中的一个对象的SQL语句的方法
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, pid);
			rs = pstmt.executeQuery();
			return rs;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	
	public void articleTypeContentSave(ArticleTypeEntity base){
		ArticleTypeEntity articleType = (ArticleTypeEntity)base;
		String sql = "Update ms_articletype set articletype_content=? where articletype_id=?";
		try {
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,articleType.getArticleTypeContent());
			pstmt.setInt(2, articleType.getArticleTypeId());
			pstmt.executeUpdate();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	//新增根据id查实体类
	public ResultSet articleIdSelect(int id) {
		ResultSet rs;
		String sql = "Select * from ms_articletype where articletype_id = ?";
		try {
			// 执行通过ID查询指定表中的一个对象的SQL语句的方法
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, id);
			rs = pstmt.executeQuery();
			return rs;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	
	//新增根据id查实体类
	public ResultSet queryListForCover(int num) {
		ResultSet rs;
		String sql = "Select * from ms_articletype where articletype_quality = ?";
		try {
			// 执行通过ID查询指定表中的一个对象的SQL语句的方法
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, num);
			rs = pstmt.executeQuery();
			return rs;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
}
