package com.mingsoft.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;

import com.mingsoft.dao.IBaseDao;
import com.mingsoft.entity.ArticleEntity;
import com.mingsoft.entity.ArticleTypeEntity;
import com.mingsoft.entity.BaseEntity;
import com.mingsoft.entity.CommentEntity;
import com.mingsoft.entity.UserEntity;
import com.mingsoft.entity.WebEntity;
import com.mingsoft.jdbc.C3p0Connection;

/**
 * 操作整个数据库数据(抽象类) 实现操作整个数据的接口类
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public abstract class BaseDaoImpl implements IBaseDao {
	

	/**
	 * 发送SQL语句
	 */
	protected Statement stmt = null;
	protected PreparedStatement pstmt = null;
	
	protected static Connection conn = C3p0Connection.getConnection();


	@Deprecated
	public void add(BaseEntity base) {
		// TODO Auto-generated method stub
		String sql = "";
		try {
			if (base instanceof ArticleEntity) {
				ArticleEntity article = (ArticleEntity) base;
				sql = "insert ms_article(article_title,article_content,article_author,article_type,article_source,article_date,article_flag) values(?,?,?,?,?,?,?)";
				try {
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, article.getArticleTitle());
					pstmt.setString(2, article.getArticleContent());
					pstmt.setString(3, article.getArticleAuthor());
					pstmt.setInt(4, article.getArticleType());
					pstmt.setString(5, article.getArticleSource());
					pstmt.setDate(6, article.getArticleDate());
					pstmt.setInt(7, article.getArticleFlag());

				} catch (SQLException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

			} else if (base instanceof ArticleTypeEntity) {
				ArticleTypeEntity articleType = (ArticleTypeEntity) base;
				sql = "insert ms_articletype(articletype_pid,articletype_name,articletype_url,articletype_keyword,articletype_descrip,articletype_cover_tem,articletype_news_tem,articletype_list_tem,articletype_quality) "
						+ "values('"
						+ articleType.getArticleTypePid()
						+ "','"
						+ articleType.getArticleTypeName()
						+ "','"
						+ articleType.getArticleTypeUrl()
						+ "','"
						+ articleType.getArticleTypeKeyword()
						+ "','"
						+ articleType.getArticleTypeCoverTem()
						+ "','"
						+ articleType.getArticleTypeCoverTem()
						+ "','"
						+ articleType.getArticleTypeNewsTem()
						+ "','"
						+ articleType.getArticleTypeListTem()
						+ "','"
						+ articleType.getArticleTypeQuality() + "')";

			} else if (base instanceof CommentEntity) {
				CommentEntity comment = (CommentEntity) base;
				// 自动添加时间,此类型为String需要修改
				SimpleDateFormat mate = new SimpleDateFormat("yyyy-MM-dd-");
				String time = mate.format(new java.util.Date());
				sql = "insert ms_comment(com_user_id,com_user_ip,com_news_id,com_content,com_date) "
						+ "values('"
						+ comment.getCommenUserId()
						+ "','"
						+ comment.getCommenUserIp()
						+ "','"
						+ comment.getCommenNewsId()
						+ "','"
						+ comment.getCommenContent() + "','" + time + "')";

			} else if (base instanceof WebEntity) {
				WebEntity web = (WebEntity) base;
				sql = "insert ms_web(web_title,web_realm_name,web_logo,web_keyword,web_descrip,web_copyright) "
						+ "values('"
						+ web.getWebTitle()
						+ "','"
						+ web.getWebRealmName()
						+ "','"
						+ web.getWebLogo()
						+ "','"
						+ web.getWebKeyword()
						+ "','"
						+ web.getWebDescrip()
						+ "','"
						+ web.getWebCopyright()
						+ "')";

			} else if (base instanceof UserEntity) {
				UserEntity user = (UserEntity) base;
				sql = "insert user(user_name,user_password) " + "values('"
						+ user.getUserName() + "','" + user.getUserPassWord()
						+ "')";
			}
			// 对数据库信息进行添加
			pstmt = conn.prepareStatement(sql);
			pstmt.execute();
		} catch (SQLException e) {
			e.printStackTrace();
		}

	}

	public void save(BaseEntity base) {
		// TODO Auto-generated method stub
		String sql = "";
		try {
			if (base instanceof ArticleEntity) {
				// 添加文章
				ArticleEntity article = (ArticleEntity) base;
				sql = "insert ms_article(article_title,article_content,article_author,article_type,article_source,article_date,article_img,article_flag) values(?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, article.getArticleTitle());
				pstmt.setString(2, article.getArticleContent());
				pstmt.setString(3, article.getArticleAuthor());
				pstmt.setInt(4, article.getArticleType());
				pstmt.setString(5, article.getArticleSource());
				pstmt.setDate(6, article.getArticleDate());
				pstmt.setString(7, article.getArticleImg());
				pstmt.setInt(8, article.getArticleFlag());

			} else if (base instanceof ArticleTypeEntity) {
				// 添加栏目
				ArticleTypeEntity articleType = (ArticleTypeEntity) base;
				sql = "insert ms_articletype(articletype_pid,articletype_name,articletype_url,articletype_keyword,articletype_descrip,articletype_cover_tem,articletype_news_tem,articletype_list_tem,articletype_quality) "
						+ "values(?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setInt(1, articleType.getArticleTypePid());
				pstmt.setString(2, articleType.getArticleTypeName());
				pstmt.setString(3, articleType.getArticleTypeUrl());
				pstmt.setString(4, articleType.getArticleTypeKeyword());
				pstmt.setString(5, articleType.getArticleTypeDescrip());
				pstmt.setString(6, articleType.getArticleTypeCoverTem());
				pstmt.setString(7, articleType.getArticleTypeNewsTem());
				pstmt.setString(8, articleType.getArticleTypeListTem());
				pstmt.setInt(9, articleType.getArticleTypeQuality());
			} else if (base instanceof CommentEntity) {
				// 添加评论
				CommentEntity comment = (CommentEntity) base;
				sql = "insert ms_comment(com_user_id,com_user_ip,com_news_id,com_content,com_date) "
						+ "values(?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setInt(1, comment.getCommenUserId());
				pstmt.setString(2, comment.getCommenUserIp());
				pstmt.setInt(3, comment.getCommenNewsId());
				pstmt.setString(4, comment.getCommenContent());
				pstmt.setDate(5, comment.getCommenDate());

			} else if (base instanceof WebEntity) {
				// 添加网站信息
				WebEntity web = (WebEntity) base;
				sql = "insert ms_web(web_title,web_realm_name,web_logo,web_keyword,web_descrip,web_copyright) "
						+ "values(?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, web.getWebTitle());
				pstmt.setString(2, web.getWebRealmName());
				pstmt.setString(3, web.getWebLogo());
				pstmt.setString(4, web.getWebKeyword());
				pstmt.setString(5, web.getWebDescrip());
				pstmt.setString(6, web.getWebCopyright());

			} else if (base instanceof UserEntity) {
				// 添加用户信息
				UserEntity user = (UserEntity) base;
				sql = "insert user(user_name,user_password) " + "values(?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, user.getUserName());
				pstmt.setString(2, user.getUserPassWord());
			}

			// 执行添加SQL语句的方法
			pstmt.execute();
		} catch (SQLException e) {
			e.printStackTrace();
		}

	}

	public ResultSet count(BaseEntity base) {
		// TODO Auto-generated method stub
		String sql = "";
		ResultSet rs = null;
		if (base instanceof ArticleEntity) {
			// 通过ID查询数据库中文章的数量
			ArticleEntity article = (ArticleEntity) base;
			sql = "Select count(*) from ms_article where article_type="
					+ article.getArticleType() + "";
		} else if (base instanceof ArticleTypeEntity) {
			// 通过ID查询数据库中栏目的数量
			sql = "Select count(*) from ms_articletype";

		} else if (base instanceof CommentEntity) {
			// 通过ID查询评论的数量
			sql = "Select count(*) from ms_comment";

		} else if (base instanceof WebEntity) {
			// 通过ID查询网站信息的数量
			sql = "Select count(*) from ms_web";

		} else if (base instanceof UserEntity) {
			// 通过ID查询用户的数量
			sql = "Select count(*) from user";

		}

		try {
			// 执行查询数量的SQL语句的方法
			stmt = conn.createStatement();
			rs = pstmt.executeQuery(sql);
//			C3p0Connection.closeConnection();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rs;
	}

	public void del(BaseEntity base) {
		// TODO Auto-generated method stub
		String sql = "";
		if (base instanceof ArticleEntity) {
			// 通过ID删除数据库中与该ID有关的所有的文章信息
			ArticleEntity article = (ArticleEntity) base;
			sql = " Delete from ms_article where article_id='"
					+ article.getArticleId() + "'";

		} else if (base instanceof ArticleTypeEntity) {
			// 通过ID删除数据库中与该ID有关的所有的栏目信息
			ArticleTypeEntity articleType = (ArticleTypeEntity) base;
			sql = " Delete from ms_articletype where articletype_id='"
					+ articleType.getArticleTypeId() + "'";

		} else if (base instanceof CommentEntity) {
			// 通过ID删除数据库中与该ID有关的所有的评论信息
			CommentEntity comment = (CommentEntity) base;
			sql = " Delete from ms_comment where com_id='"
					+ comment.getCommenId() + "'";

		} else if (base instanceof WebEntity) {
			// 通过ID删除数据库中与该ID有关的所有的网站信息
			WebEntity web = (WebEntity) base;
			sql = " Delete from ms_web where web_id='" + web.getWebId() + "'";

		} else if (base instanceof UserEntity) {
			// 通过ID删除数据库中与该ID有关的所有的用户信息
			UserEntity user = (UserEntity) base;
			sql = " Delete from user where user_id='" + user.getUserId() + "'";
		}

		// 执行删除的SQL语句的方法
		try {
			stmt = conn.createStatement();
			stmt.executeUpdate(sql);
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	public void edit(BaseEntity base) {
		// TODO Auto-generated method stub
		String sql = "";
		try {
			if (base instanceof ArticleEntity) {
				// 通过ID定位修改文章信息
				ArticleEntity article = (ArticleEntity) base;
				sql = "Update ms_article set article_title=?,article_content=?,article_date=?,article_type =?,"
						+ "article_author =?,article_source =?,article_img=?,article_flag=? where article_id=?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, article.getArticleTitle());
				pstmt.setString(2, article.getArticleContent());
				pstmt.setDate(3, article.getArticleDate());
				pstmt.setInt(4, article.getArticleType());
				pstmt.setString(5, article.getArticleAuthor());
				pstmt.setString(6, article.getArticleSource());
				pstmt.setString(7, article.getArticleImg());
				pstmt.setInt(8, article.getArticleFlag());
				pstmt.setInt(9, article.getArticleId());
				

			} else if (base instanceof ArticleTypeEntity) {
				// 通过ID定位修改栏目信息
				ArticleTypeEntity articleType = (ArticleTypeEntity) base;
				sql = "Update ms_articletype set articletype_pid=?,articletype_name=?,articletype_url=?,"
						+ "articletype_keyword =?,articletype_descrip =?,articletype_cover_tem =?,articletype_news_tem =?,"
						+ "articletype_list_tem =?,articletype_quality =?  where articletype_id=?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setInt(1, articleType.getArticleTypePid());
				pstmt.setString(2, articleType.getArticleTypeName());
				pstmt.setString(3, articleType.getArticleTypeUrl());
				pstmt.setString(4, articleType.getArticleTypeKeyword());
				pstmt.setString(5, articleType.getArticleTypeDescrip());
				pstmt.setString(6, articleType.getArticleTypeCoverTem());
				pstmt.setString(7, articleType.getArticleTypeNewsTem());
				pstmt.setString(8, articleType.getArticleTypeListTem());
				pstmt.setInt(9, articleType.getArticleTypeQuality());
				pstmt.setInt(10, articleType.getArticleTypeId());

			} else if (base instanceof CommentEntity) {
				// 通过ID定位修改评论信息
				CommentEntity comment = (CommentEntity) base;
				sql = "Update ms_comment set com_user_id=?,com_user_ip=?,com_news_id=?,com_content =?,"
						+ "com_date =?  where com_id=?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setInt(1, comment.getCommenUserId());
				pstmt.setString(2, comment.getCommenUserIp());
				pstmt.setInt(3, comment.getCommenNewsId());
				pstmt.setString(4, comment.getCommenContent());
				pstmt.setDate(5, comment.getCommenDate());
				pstmt.setInt(6, comment.getCommenId());

			} else if (base instanceof WebEntity) {
				// 通过ID定位修改网站信息
				WebEntity web = (WebEntity) base;
				sql = "Update ms_web set web_title=?,web_realm_name=?,web_logo=?,web_keyword =?,web_descrip =?,"
						+ "web_copyright=? where " + "web_id=?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, web.getWebTitle());
				pstmt.setString(2, web.getWebRealmName());
				pstmt.setString(3, web.getWebLogo());
				pstmt.setString(4, web.getWebKeyword());
				pstmt.setString(5, web.getWebDescrip());
				pstmt.setString(6, web.getWebCopyright());
				pstmt.setInt(7, web.getWebId());

			} else if (base instanceof UserEntity) {
				UserEntity user = (UserEntity) base;

				sql = "Update user set user_name=?,user_password=? where user_id=?";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, user.getUserName());
				pstmt.setString(2, user.getUserPassWord());
				pstmt.setInt(3, user.getUserId());

			}

			// 对数据库中的信息进行修改（通过ID锁定要修改信息的位置）
			pstmt.executeUpdate();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public ResultSet queryForList(BaseEntity base, int begin, int count) {
		ResultSet rs = null;
		String sql = "";
		if (base instanceof ArticleEntity) {
			ArticleEntity artic = (ArticleEntity) base;
			// 返回数据库中文章的信息
			sql = "Select * from ms_article where article_type='"
					+ artic.getArticleType()
					+ "' order by article_date desc limit '" + begin + "','"
					+ count + "'";

		} else if (base instanceof ArticleTypeEntity) {
			// 返回数据库中栏目的信息
			sql = "Select * from ms_articletype order by articletype_id asc";

		} else if (base instanceof CommentEntity) {
			// 返回数据库中评论的信息
			sql = "Select * from ms_comment order by com_id desc limit "
					+ begin + "," + count;

		} else if (base instanceof WebEntity) {
			// 返回数据库中网站的信息
			sql = "Select * from ms_web order by web_id desc limit " + begin
					+ "," + count;

		} else if (base instanceof UserEntity) {
			// 返回数据库中用户的信息
			sql = "Select * from user order by user_id desc limit " + begin
					+ "," + count;
		}

		// 执行返回数据库性息SQL语句的方法
		try {
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return rs;
	}

	public ResultSet select(BaseEntity base) {
		// TODO Auto-generated method stub
		ResultSet rs;
		String sql = "";
		int number = 0;
		if (base instanceof ArticleEntity) {
			// 通过ID，查找数据库中文章的相关信息
			ArticleEntity article = (ArticleEntity) base;
			number = article.getArticleId();
			sql = "Select * from ms_article where article_id=?";
		} else if (base instanceof ArticleTypeEntity) {
			// 通过ID，查找数据库中栏目的相关信息
			ArticleTypeEntity articleType = (ArticleTypeEntity) base;
			number = articleType.getArticleTypeId();
			sql = "Select * from ms_articletype where articletype_id=?";

		} else if (base instanceof CommentEntity) {
			// 通过ID，查找数据库中评论的相关信息
			CommentEntity comment = (CommentEntity) base;
			number = comment.getCommenId();
			sql = "Select * from ms_comment where com_id=?";

		} else if (base instanceof WebEntity) {
			// 通过ID，查找数据库中网站的相关信息
			WebEntity web = (WebEntity) base;
			number = web.getWebId();
			sql = "Select * from ms_web where web_id=?";

		} else if (base instanceof UserEntity) {
			// 通过ID，查找数据库中用户的相关信息
			UserEntity user = (UserEntity) base;
			number = user.getUserId();
			sql = "Select * from user where user_id=?";
		}

		try {
			// 执行通过ID查询指定表中的一个对象的SQL语句的方法
			pstmt = conn.prepareStatement(sql);
			pstmt.setInt(1, number);
			rs = pstmt.executeQuery();
			return rs;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 查询表中最大id值
	 * 
	 * @param type 表类型
	 * @return
	 */
	public ResultSet findMaxId(String type) {
		ResultSet rs = null;
		try {
			stmt = conn.createStatement();
			String sql = "select max(" + type + "_id) from ms_" + type;
			rs = stmt.executeQuery(sql);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return rs;
	}
}
