package com.mingsoft.dao.impl;
import java.sql.ResultSet;
import java.sql.SQLException;

import com.mingsoft.dao.IWebDao;
import com.mingsoft.entity.WebEntity;
 /**
  * 操作网站信息的基本数据
  * @author 张敏
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
  */
public class WebDaoImpl extends BaseDaoImpl implements IWebDao {

	/**
	 * 根据网站id查询网站信息
	 * @param webId 网站id
	 */
	public ResultSet queryWebInfo(int webId){
		ResultSet rs = null;
		try {
			pstmt = conn.prepareStatement("select * from ms_web where web_id = '"+webId+"' ");
			rs = pstmt.executeQuery();
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return rs;
	}
	
	/**
	 * 根据网站id修改网站信息
	 * @param webId 网站id
	 */
	public void editWebInfo(WebEntity webentity){
		try {
			String sql = "Update ms_web set web_title=?,web_realm_name=?,web_logo=?,web_keyword =?,web_descrip =?,"
				+ "web_copyright=? where " + "web_id=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, webentity.getWebTitle());
			pstmt.setString(2, webentity.getWebRealmName());
			pstmt.setString(3, webentity.getWebLogo());
			pstmt.setString(4, webentity.getWebKeyword());
			pstmt.setString(5, webentity.getWebDescrip());
			pstmt.setString(6, webentity.getWebCopyright());
			pstmt.setInt(7, webentity.getWebId());
			pstmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * 删除网站LOGO信息
	 * @param webLogo	LOGO名
	 */
	public void deleteLogo(String webLogo) {
		try {
			pstmt = conn.prepareStatement("update ms_web set web_logo='null' where web_logo = ?");
			pstmt.setString(1, webLogo);
			pstmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		}
	}
}
