package com.mingsoft.entity;

import java.sql.Date;

/**
 * 文章的实体类 定义文章具有的属性
 * @author 荣繁奎
 * QQ:1096199590
 * 技术支持：铭飞科技
 * 官网：www.ming-soft.com
 */
public class ArticleEntity extends BaseEntity {
	
	
	/**
	 * 文章id
	 */
	private int articleId;
	
	/**
	 * 标记文章类型 
	 * 比如：普通、推荐、幻灯
	 */
	private int articleFlag;
	
	/**
	 * 文章标题(最大长度500个字符)
	 */
	private String articleTitle;
	
	/**
	 * 文章内容
	 */
	private String articleContent;
	
	/**
	 * 文章作者(最大长度120个字符)
	 */
	private String articleAuthor;
	
	/**
	 * 文章类型
	 */
	private ArticleTypeTreeEntity articleTypes;
	
	/**
	 * 文章所属栏目的id
	 */
	private int articleType;
	
	/**
	 * 文章来源(最大长度500个字符)
	 */
	private String articleSource;
	
	/**
	 * 发布时间
	 */
	private Date articleDate;
	
	/**
	 * 文章缩略图
	 */
	private String articleImg;

	
	public int getArticleFlag() {
		return articleFlag;
	}

	public void setArticleFlag(int articleFlag) {
		this.articleFlag = articleFlag;
	}

	public String getArticleImg() {
		return this.articleImg;
	}

	public void setArticleImg(String articleImg) {
		this.articleImg = articleImg;
	}

	public int getArticleId() {
		return articleId;
	}

	public void setArticleId(int articleId) {
		this.articleId = articleId;
	}

	public String getArticleTitle() {
		return articleTitle;
	}

	public void setArticleTitle(String articleTitle) {
		this.articleTitle = articleTitle;
	}

	public String getArticleContent() {
		return articleContent;
	}

	public void setArticleContent(String articleContent) {
		this.articleContent = articleContent;
	}

	public String getArticleAuthor() {
		return articleAuthor;
	}

	public void setArticleAuthor(String articleAuthor) {
		this.articleAuthor = articleAuthor;
	}

	public String getArticleSource() {
		return articleSource;
	}

	public void setArticleSource(String articleSource) {
		this.articleSource = articleSource;
	}

	public Date getArticleDate() {
		return articleDate;
	}

	public void setArticleDate(Date articleDate) {
		this.articleDate = articleDate;
	}
	
	public void setArticleDate() {
		//java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		Date date = new Date(new java.util.Date().getTime());
		this.articleDate = date;
	}



	public ArticleTypeTreeEntity getArticleTypes() {
		return articleTypes;
	}

	public void setArticleTypes(ArticleTypeTreeEntity articleTypes) {
		this.articleTypes = articleTypes;
	}
	/**
	 * 文章所属栏目的id
	 * @return
	 */
	public int getArticleType() {
		return articleType;
	}

	public void setArticleType(int articleType) {
		this.articleType = articleType;
	}
}
