package com.mingsoft.entity;

import java.util.ArrayList;
import java.util.List;


/**
 * 栏目信息（系统设置）属性
 * @author 成卫雄
 * QQ:330216230
 * 技术支持：景德镇铭飞科技
 * 官网：www.ming-soft.com
 */
public class ArticleTypeEntity extends BaseEntity {

	
	/**
	 * 栏目id
	 */
	private int articleTypeId;
	
	/**
	 * 封面内容
	 */
	private String articleTypeContent;
	
	/**
	 * 栏目父节点编号
	 */
	private int articleTypePid;
	
	/**
	 * 栏目名称(最大长度120个字符)
	 */
	private String articleTypeName;
	
	/**
	 * 栏目链接地址(最大长度500个字符)
	 */
	private String articleTypeUrl;
	
	/**
	 * 栏目关键字(最大长度500个字符)
	 */
	private String articleTypeKeyword;
	
	/**
	 * 栏目描述(最大长度500个字符)
	 */
	private String articleTypeDescrip;
	
	/**
	 * 封面链接地址(最大长度500个字符)
	 */
	private String articleTypeCoverTem;
	
	/**
	 * 列模版表链接地址(最大长度500个字符)
	 */
	private String articleTypeListTem;
	
	/**
	 * 新闻模版链接地址(最大长度500个字符)
	 */
	private String articleTypeNewsTem;
	
	/**
	 * 栏目属性
	 */
	private int articleTypeQuality;
	
	/**
	 * 显示JOSN中的栏目属性
	 */
	private String articleTypeQualityShow;
	
	/**
	 * 显示JOSN中的栏目属性(该栏目的父栏目)
	 */
	private String text;

	
	/**
	 * JOSN中栏目的结构
	 */
	private List<ArticleTypeEntity> children = new ArrayList<ArticleTypeEntity>();
	
	public void setText(String text) {
		this.text = text;
	}

	public String getText() {
		return text;
	}
	
	public int getArticleTypeId() {
		return articleTypeId;
	}

	public List<ArticleTypeEntity> getChildren() {
		return children;
	}

	public void setChildren(List<ArticleTypeEntity> children) {
		this.children = children;
	}

	public void setArticleTypeId(int articleTypeId) {
		this.articleTypeId = articleTypeId;
	}

	public String getArticleTypeContent() {
		return articleTypeContent;
	}

	public void setArticleTypeContent(String articleTypeContent) {
		this.articleTypeContent = articleTypeContent;
	}

	
	public int getArticleTypePid() {
		return articleTypePid;
	}

	public void setArticleTypePid(int articleTypePid) {
		this.articleTypePid = articleTypePid;
	}

	public String getArticleTypeName() {
		return articleTypeName;
	}

	public void setArticleTypeName(String articleTypeName) {
		this.articleTypeName = articleTypeName;
	}

	public String getArticleTypeUrl() {
		return articleTypeUrl;
	}

	public void setArticleTypeUrl(String articleTypeUrl) {
		this.articleTypeUrl = articleTypeUrl;
	}

	public String getArticleTypeKeyword() {
		return articleTypeKeyword;
	}

	public void setArticleTypeKeyword(String articleTypeKeyword) {
		this.articleTypeKeyword = articleTypeKeyword;
	}

	public String getArticleTypeDescrip() {
		return articleTypeDescrip;
	}

	public void setArticleTypeDescrip(String articleTypeDescrip) {
		this.articleTypeDescrip = articleTypeDescrip;
	}

	public String getArticleTypeCoverTem() {
		return articleTypeCoverTem;
	}

	public void setArticleTypeCoverTem(String articleTypeCoverTem) {
		this.articleTypeCoverTem = articleTypeCoverTem;
	}

	public String getArticleTypeListTem() {
		return articleTypeListTem;
	}

	public void setArticleTypeListTem(String articleTypeListTem) {
		this.articleTypeListTem = articleTypeListTem;
	}

	public String getArticleTypeNewsTem() {
		return articleTypeNewsTem;
	}

	public void setArticleTypeNewsTem(String articleTypeNewsTem) {
		this.articleTypeNewsTem = articleTypeNewsTem;
	}

	public int getArticleTypeQuality() {
		return articleTypeQuality;
	}

	public void setArticleTypeQuality(int articleTypeQuality) {
		this.articleTypeQuality = articleTypeQuality;
	}
	
	public String getArticleTypeQualityShow() {
		return articleTypeQualityShow;
	}

	public void setArticleTypeQualityShow(String articleTypeQualityShow) {
		this.articleTypeQualityShow = articleTypeQualityShow;
	}

}
